<?php

/**
 * CodeIgniter
 *
 * An open source application development framework for PHP
 *
 * This content is released under the MIT License (MIT)
 *
 * Copyright (c) 2014 - 2015, British Columbia Institute of Technology
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * @package	CodeIgniter
 * @author	EllisLab Dev Team
 * @copyright	Copyright (c) 2008 - 2014, EllisLab, Inc. (http://ellislab.com/)
 * @copyright	Copyright (c) 2014 - 2015, British Columbia Institute of Technology (http://bcit.ca/)
 * @license	http://opensource.org/licenses/MIT	MIT License
 * @link	http://codeigniter.com
 * @since	Version 1.0.0
 * @filesource
 */
defined('BASEPATH') OR exit('No direct script access allowed');

class Ajax_loader extends CI_Controller {

    /**
     * General contents
     *
     * @var Array
     */
    var $gen_contents = array();

       function activate_account() {
        // First check user is logged
        $this->load->helper('email_helper');
        if (!$this->authentication->check_logged_in("normal", false)) {
            $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'login_error', 'content' => 'Please login to do this action.'))));
            return;
        }

        // Checked for user id thriugh uri segment
        $user_id = intval($this->uri->segment(3));
        $type_id = intval($this->uri->segment(4));
        if (empty($user_id) || empty($type_id)) {
            $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'This is invalid request.'))));
            return;
        }
        // Try to update the status of the user
        $status = false;
        if ($type_id == 3) {
            $admin_approved_date = get_cur_date_time();
            $status = $this->db->update('user_details', array('admin_approved' => '2', 'status' => '1', 'admin_approved_date' => $admin_approved_date), array('id' => $user_id));
            if ($status) {
                $email_data = $this->common_model->get_data('user_details', array('email', 'first_name', 'activation_code'), array('id' => $user_id));
                if (!empty($email_data)) {
                    if ($email_data[0]['activation_code'] != NULL) {
                        $send = process_and_send_mail($email_data[0]['email'], array('first_name' => $email_data[0]['first_name'],
                            'activation_link' => '<a target="_blank" href="' . base_url() . 'activate/' . $email_data[0]['activation_code'] . '" >' . base_url() . 'activate/' . $email_data[0]['activation_code'] . '</a>',
                            'regards_name' => c('regards_name'),
                            'email_bottom_instruction' => c('email_bottom_instruction'),
                            'activation_form' => '<a target="_blank" href="' . base_url() . 'activate' . '" >' . 'here' . '</a>',
                            'code' => $email_data[0]['activation_code']
                                ), 'trainer_admin_approved_activate', array(), array(), '', '');
                        if ($send) {
                            $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'success', 'content' => 'Updated successfully. Approval notification mail send', 'type' => 'account_activated'))));
                            return;
                        }
                        else {
                            $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'Approval notification mail sending failed.', 'type' => ''))));
                            return;
                        }
                    }else {
                        $send = process_and_send_mail($email_data[0]['email'], array('first_name' => $email_data[0]['first_name'],
                            'login_link' => '<a target="_blank" href="' . base_url() . 'login' . '" >' . base_url() . 'login' . '</a>',
                            'regards_name' => c('regards_name'),
                            'email_bottom_instruction' => c('email_bottom_instruction'),
                                ), 'trainer_admin_approved', array(), array(), '', '');
                        if ($send) {
                            $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'success', 'content' => 'Updated successfully. Approval notification mail send', 'type' => 'account_activated'))));
                            return;
                        }
                        else {
                            $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'Approval notification mail sending failed.', 'type' => ''))));
                            return;
                        }
                    }
                }
            }
        }
        else {
            $status = $this->db->query("UPDATE `user_details` SET `status` = CASE
                        WHEN `status` =1
                            THEN '2'
                        WHEN `status` =2
                            THEN '1'
                        ELSE `status` END WHERE id ='$user_id'");
        }

        if ($status) {
            $current_status = '';
            if ($type_id == 3) {
                $current_status = 'account_activated';
            }
            else {
                $current_status = $this->common_model->get_data('user_details', 'status', array('id' => $user_id));
                $current_status = $current_status[0]['status'];
            }
            $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'success', 'content' => 'Activated the user.', 'type' => $current_status))));
            return;
        }

        $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'There is a problem to update.'))));
        return;
    }


    function delete_admin_account($user_id = '') {
        // First check user is logged 
        
        if (!$this->authentication->check_logged_in("normal", false) || !(admin_has_permission(4))) {
            $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'login_error', 'content' => 'Please login to do this action.'))));
            return;
        }

        if (empty($user_id) || $user_id == '1') { // 1 is super admin
            $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'This is invalid request.'))));
            return;
        }

        
            $update = $this->db->delete('user', array('id' => $user_id));
            if ($update) {
            	$this->db->delete('admin_permissions', array('admin_id' => $user_id));
                $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'success', 'content' => 'Deleted successfully.'))));
                return;
            }
        

        $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'There is a problem to update.'))));
        return;
    }
    function delete_package($user_id = '') {

        // First check user is logged 
        

        
            $update = $this->db->delete('packages', array('package_id' => $user_id));
            if ($update) {
                $this->db->delete('admin_permissions', array('admin_id' => $user_id));
                $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'success', 'content' => 'Deleted successfully.'))));
                return;
            }
        

        $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'There is a problem to update.'))));
        return;
    }

    function upload_and_crop($type=''){ 
        if(!$this->authentication->check_logged_in("normal", false)){
           $response = array(
            'state'  => 200,
            'message' => 'You login session has been expired. Please re-login.'
            );
            echo json_encode($response);
            return;
        }
        //$crop = $this->load->library('Lib_crop', $_POST['avatar_src'], $_POST['avatar_data'], $_FILES['avatar_file']);
        $this->load->library('Lib_crop');
        
        $crop_dimentions = c('crop_image_size_big'); // Get the crop dimention from config for workout image crop
        if($type == 'workout'){
            $crop_dimentions = $crop_dimentions['workout'];
        }else if($type == 'profile'){
            $crop_dimentions = $crop_dimentions['profile'];
        }else{
            $response = array(
            'state'  => 200,
            'message' => 'Invalid access'
            );
            echo json_encode($response);
            return;
        }
        $this->lib_crop->crop_dimention['width'] = $crop_dimentions['width'];
        $this->lib_crop->crop_dimention['height'] = $crop_dimentions['height'];
        
        $this->lib_crop->construct($_POST['avatar_src'], $_POST['avatar_data'], $_FILES['avatar_file']);
        $img_name = '';
        $file_url = $this->lib_crop->getResult();
        $file_url = explode('/', $file_url);
        $file_url = @$file_url[count($file_url) - 1];
        if(!empty($file_url)) {
            $img_name = $file_url;
            $file_url = c('file_upload_url').'temp_crop/'.$file_url;
        }
        $response = array(
        'state'  => 200,
        'message' => $this->lib_crop->getMsg(),
        'result' => $file_url, 
        'img_name' => $img_name
        );
        $this->lib_crop->unlink_original();
        echo json_encode($response);
    }
    
    function upload_order_file(){
    	if(!$this->authentication->check_logged_in("normal", false)){
           $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'Please login to access this page.'))));
           return; 
        }
       	$upload_status = array();
       	$this->load->helper('string_helper');
          if(!empty($_FILES)){
 			
            if (!empty($_FILES['file_data'])) {
                
                
                if ($_FILES['file_data']['name'] != '') {
                	
                	$quote_id = $this->input->post('txtQuoteId', true); 
					$customer_id = $this->input->post('txtCustomerId', true);
					
					if(empty($quote_id)){
						$this->db->insert('quote', array('user_id' => s('USER_ID'), 'is_in_shopping_cart' => 'Y', 'date_created' => get_cur_date_time()));
						$quote_id = $this->db->insert_id();
					}else{
						$quote_id = decrypt_url_string($quote_id);
					}
                	//$query = "INSERT INTO quote (user_id) VALUES ('$id')";
                	
					$part_id = 0;
					
					$this->db->insert('part', array('user_id' => s('USER_ID'), 'quote_id' => $quote_id  ));
					$part_id = $this->db->insert_id();
					
                 	$ch = curl_init();
 	
					$file_name = $_FILES['file_data']['name'];
				 	$file_name = str_replace(' ', '-' , $file_name);
					$file_name = str_replace(",", "-", $file_name);
					$file_name3 = $_FILES['file_data']['name'];
					$time = time();
					
					$error_no = 0;
					// OLD - $file_name = $time.'_'.$file_name;
					$file_name = $part_id.'-'.$file_name;
					
					$file_name2 = $part_id.'_'.random_string('md5').'.stl';
					
					$localfile = $_FILES['file_data']['tmp_name'];
					
					$uploaddir = c('file_upload_path').'STL/';
    				$uploadfile = $uploaddir . $file_name2;
    				$file_location_url = c('file_upload_url').'STL/'.$file_name2;
                	if (move_uploaded_file($_FILES['file_data']['tmp_name'], $uploadfile)) {
				      //echo "File is valid, and was successfully uploaded.\n";
				    } else {
				       $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'There is a problem to uplaod. Please try again later.' ))));
                        return;
				    }
		 
				    //--------> this will calculate the different dimensions of the file. x-y-z   
					include_once APPPATH . 'third_party/STL_xyz_calc.php';
					$mystlpath = $uploadfile;
					$obj = new STLStats($mystlpath);
                   // p($obj);                    
					$unit = "inch";
					$bbox = $obj->getBBox($unit);
                                 //    echo "<pre>";
                                 //        print_r($bbox);    
					//echo "Bounding Box (unit: ".$unit."): \n<BR>X: " . $bbox["length"] . "\n<BR>Y: " . $bbox["width"] . "\n<BR>Z: " . $bbox["height"] ." <BR>\n"; die("debugging");

					$bbv = $obj->getBBoxVolume($unit);
					//echo "Bounding Box Volume: " . $bbv . " cubic " . $unit ." <BR>";
					 		//------------------> End of dimensions XYZ
					
					// -----> Calculate total cubic inches in the part <----------------
					include_once APPPATH . 'third_party/STL_cu_in_calc.php';
				 	
					$obj = new STLStats2($mystlpath);
					$vol = $obj->getVolume($unit);
                                        // echo "<pre>";
                                        // print_r($bbv);
                                        // die();
                                        
				    $image = ''; 
				        if ($error_no == 0) { 
								$x = $bbox["width"];
								$y = $bbox["length"];
								$z = $bbox["height"];
                                                                
                                                                //old code commented
                                                                /*$x = $bbox["length"];
								$y = $bbox["width"];
								$z = $bbox["height"];
                                                                
                                                                 */
								$volume = $vol;
							 	
								$multiplier = 1;
								$price = 99;
								$v_size = 0;
								
								$largest_dimension = 0;
							 
								//This code will find which dimension is the largest X Y or Z
								
								if ($x >= $y && $x >= $z) {
									$largest_dimension = "x";
								}
								
								if ($y >= $x && $y >= $z) {
									$largest_dimension = "y";
								}
								
								if ($z >= $y && $z >= $x) {
									$largest_dimension = "z";
								}
								// --end--
								
								// This next segment of code will find the 2nd and 3rd largest dimension.
								if ($largest_dimension == "z") {
								   $largest_dimension1 = $z;
								   if($x >= $y) {
									   $largest_dimension2 = $x;
									   $largest_dimension3 = $y;
								   }  else {
									   $largest_dimension2 = $y;
									   $largest_dimension3 = $x;
								   }
								   
								}
								if ($largest_dimension == "y") {
								   $largest_dimension1 = $y;
								   if($x >= $z) {
									   $largest_dimension2 = $x;
									   $largest_dimension3 = $z;
								   } else {
									   $largest_dimension2 = $z;
									   $largest_dimension3 = $x;
								   }
								}
								if ($largest_dimension == "x") {
								   $largest_dimension1 = $x;
								   if($z >= $y) {
									   $largest_dimension2 = $z;
									   $largest_dimension3 = $y;
								   } else {
									   $largest_dimension2 = $y;
									   $largest_dimension3 = $z;
								   }
								}
								
								// find price by finding out how many 4x3x3 zones it will take to print part...
								
								$v_size = $largest_dimension1 * $largest_dimension2 * $largest_dimension3;
								 
								$total_price = 0; 
								$total_price = (($v_size * .05) + ($volume * 15 * 1.2) + 2); 
								// old code - delete soon - $total_price = (($v_size * 7) + ($volume * 40 * 1.15))/2;
								 
								if($total_price < 10) {
									$total_price = 10.00;	
								}
								
								$extra_part = $total_price * .932;
								
								$ajax_result = array(
									'x_o' => $x,
									'y_o' => $y,
									'z_o' => $z,
									'volume_o' => $volume,
									'x' => $x,
									'y' => $y,
									'z' => $z,
									'volume' => $volume,
									'support_material' => '',
									'support_multiplier' => '',
									'total_price' => '0',
									'original_total_price' => 0,
									'image' =>  $image,
									'file_location' => $file_name2,
									'file_location_url' => $file_location_url,
									'description' => $file_name3,
									'part_id' => $part_id,
									'q_2A4M2L2A2M5L23' => encrypt_url_string($quote_id) , //
									'C2A4M2L2A2M5L23A' => $customer_id,
									'commission_rate' => get_user_commission(s('USER_ID'))  
								);
								
								// Shipping biiling address to shipping_billing table
								
								 $exists = $this->common_model->get_data('shipping_billing_address', 'quote_id', array( 'quote_id' => $quote_id ));
				         		if(empty($exists)){ // Insert
				         			$user3  = $this->common_model->get_data('user', '*', array( 'id' => decrypt_url_string($customer_id) ));
    	 							$user3 = @$user3[0];
				         			$data = array(
						        		'quote_id' => $quote_id,
						        		'user_id' => decrypt_url_string($customer_id), 
						        		'billing_name' => $user3['fname'].' '.$user3['lname'] ,
						        		'billing_address' => $user3['address'],
						        		'billing_address1' => $user3['address2'],
						        		'billing_country' => $user3['country'],
						        		'billing_state' =>  $user3['state'],
						        		'billing_city' =>  $user3['city'],
						        		'billing_zipcode' =>  $user3['pin'],
						        		'billing_phone' =>  $user3['phone'],
						        		'shipping_name' => $user3['fname'].' '.$user3['lname'],
						        		'shipping_address' => $user3['address'],
						        		'shipping_address2' => $user3['address2'],
						        		'shipping_country' => $user3['country'],
						        		'shipping_state' => $user3['state'],
						        		'shipping_city' => $user3['city'],
						        		'shipping_zipcode' => $user3['pin'],
						        		'shipping_phone' => $user3['phone'],
						        		'date_time' => get_cur_date_time()	
				         			);
				         			
						        	$this->db->insert('shipping_billing_address', $data);
						        }
								$from = "From: \"InventAPart.com\" <support@inventapart.com>\nX-Mailer: PHP/" . phpversion();
					
								$subject = "New Part uploaded";
								$u_id = s('USER_ID');
								$message3 = "User ID: $u_id \n Part Volume: $volume\n";
								
								@mail("michael@inventapart.com", $subject, $message3, $from);
								
								$this->load->view('ajax_view', array('ajax_response' => json_encode(
									array('status' => 'success', 
										 'content' =>  'Successfully uploaded ', 
										'details' => $ajax_result
									))));
                        		return;
							 
 				        } else {
				        	  $upload_status['upload_error'] = "There was an error uploading the file, please try again! " ;
							  
				        }
 				 }else{
                 	$upload_status['upload_error'] = 'Please choose a file to upload.';
                 }
                
                if (!empty($upload_status['upload_error'])) {
                    $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' =>   $upload_status['upload_error'] ))));
                        return;
                }
                
                
            }
          
        }
        
        $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'Please make sure that you have uploaded valid file.' ))));
        return;
    }
    
    function save_order_part(){
    	if(!$this->authentication->check_logged_in("normal", false)){
           $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'login_error', 'content' => 'Please login to do this action.'))));
            return;
        }
		$x = $this->input->post('x', true);
		$y = $this->input->post('y', true);
		$z = $this->input->post('z', true);
		$volume = $this->input->post('volume', true);
		$x_o = $this->input->post('x_o', true);
		$y_o = $this->input->post('y_o', true);
		$z_o = $this->input->post('z_o', true);
		$volume_o = $this->input->post('volume_o', true);
		$material = $this->input->post('material', true);
		$auto_unit = $this->input->post('auto_unit', true);
		$units_last_set_as = $this->input->post('units_last_set_as', true);
		
		$support_material = $this->input->post('support_material', true);
		$support_multiplier = $this->input->post('support_multiplier', true);
		
		//$image = $this->input->post('image', true);
		$image = '';
		$update_image = '';
		if( $this->input->post('canvas_image', true) && $this->input->post('is_edit_part', true) != 'Y'){
			 
			$image = md5(uniqid(rand(), true)).'.png';
			canvas_to_image($this->input->post('canvas_image', false), $image);
			$update_image = "image = '{$image}', ";
		}
    	//var_dump($update_image);exit;
		$description = $this->input->post('description', true);
		$total_price = $this->input->post('total_price', true);
		$file_location = $this->input->post('file_location', true);
		$part_id = $this->input->post('part_id', true);
		$quote_id = decrypt_url_string( $this->input->post('q_2A4M2L2A2M5L23', true));
		$customer_id = decrypt_url_string( $this->input->post('C2A4M2L2A2M5L23A', true));
		
    	$original_total_price = $this->input->post('new_total_price', true);
		
		if(!empty($original_total_price)){ // THIS MEANS ADMIN ENTERED NEW PRICE
			$tmp_price = $total_price;
			$total_price = $original_total_price;
			$original_total_price = $tmp_price;
		}
		//  $note = addslashes(  $this->input->post('txtNotes', true));
		//  $on_behalf_of = $this->input->post('txtOnBehalfOf', true); 
		
		$query  = "UPDATE part SET 
		
		quote_id = '{$quote_id}', 
		x = '{$x}',
		y = '{$y}',
		z = '{$z}',
		volume = '{$volume}',
		
		
		x_o = '{$x_o}',
		y_o = '{$y_o}',
		z_o = '{$z_o}',
		volume_o = '{$volume_o}',
		
		$update_image
		total_price = '{$total_price}',
		description = '{$description}',
		file_location = '{$file_location}',
		original_total_price = '{$original_total_price}',
		material = '{$material}',
		units_last_set_as = '{$units_last_set_as}',
		auto_unit = '{$auto_unit}',
		support_material = '{$support_material}',
		support_multiplier = '{$support_multiplier}' 
		
		
		WHERE id = '$part_id'";
		
		//, notes = '{$note}',
		//on_behalf_of  = '{$on_behalf_of}'
		  //echo $query;exit;
			if($this->db->query($query)){
				$this->load->model('admin/orders_model');
				
				// UPDATE bonus_part based on updation
				
						$list_parts = $this->orders_model->get_all_parts($quote_id);
			 $length_array = count($list_parts);
                                                for($i=0; $i< $length_array; $i++ ){
                                                    
                                                    if($list_parts[$i]['id'] == $part_id){
                                                        $list_parts = $list_parts[$i];
                                                        break;
                                                    }
                                                    //echo "test<br/>";
                                                    
                                                }
	 					//$list_parts = $list_parts[0]; 
	 					$image 		= $list_parts['image'];
						$description = $list_parts['description'];
						$x 			= $list_parts['x'];
						$y 			= $list_parts['y'];
						$z 			= $list_parts['z'];
						$volume 	= $list_parts['volume'];
						$x2 		= number_format($x,3);
						$y2 		= number_format($y,3);
						$z2 		= number_format($z,3);
						$file_location = $list_parts['file_location'];
						$total_price = $list_parts['total_price'];
	 					
						$data = array();
						 
							$data =  array(
							      	'user_id' 	=> s('USER_ID'),
							    	'quote_id' 	=> $quote_id, 
							    	'part_id'	=> $part_id, 
							    	'x'			=> $x, 
							    	'y'			=> $y, 
							    	'z'			=> $y, 
							    	'volume'	=> $volume, 
							    	'image'		=> $image, 
							    	'extra_part'=> $total_price, 
							    	'description'=> $description, 
							    	'file_location' => $file_location
									// ,'notes'	=> $note, 
									//'on_behalf_of' => $on_behalf_of
							 );
						 
	 					if(!empty($data)){
							$this->db->update('bonus_part', $data, array('part_id' => $part_id ));
						}
				
				
				$this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'success', 
				'content' => 'There is a problem to update details. Please try again later.',
				'details' => array(
					'part_id' => encrypt_url_string($part_id),
					'customer_id' => encrypt_url_string($customer_id),
					'quote_id' => encrypt_url_string($quote_id)
				)
				))));
           		return; 
				
			}else{
				 $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'There is a problem to update details. Please try again later.'))));
           		return; 
			}
		
	    }
   
	    function remove_part(){
		    if(!$this->authentication->check_logged_in("normal", false)){
	           $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'login_error', 'content' => 'Please login to do this action.'))));
	            return;
	        }
	        
	        $part_type = $this->input->post('part_type', true);
			$part_id = $this->input->post('part_id', true);
			$quote_id = $this->input->post('quote_id', true);
			$customer_id = $this->input->post('customer_id', true);
	    	//p($_POST);exit;
			if($part_type == 1)
			{
				delete_part_stl_file($part_id); 
				$this->db->query("DELETE FROM part WHERE id = '$part_id' ");
				
				$this->db->query("DELETE FROM bonus_part WHERE part_id = '$part_id' ");
			 			 
			}
			if($part_type == 2)
			{
				 
				$this->db->query("DELETE FROM bonus_part WHERE part_id = '$part_id' ");
			}
			
			$this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'success', 
				'content' => 'Part details deleted.',
				'details' => array( 
					'customer_id' =>  ($customer_id),
					'quote_id' => encrypt_url_string($quote_id)
				)
			))));
           		return; 
	    }
	    
	    function update_quantity(){
	    	if(!$this->authentication->check_logged_in("normal", false)){
	           $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'login_error', 'content' => 'Please login to do this action.'))));
	            return;
	        }
	        
	        $new_part_quantity = $this->input->post('new_part_quantity', true);
			$part_id = $this->input->post('part_id', true);
			$quote_id = $this->input->post('quote_id', true);
			$customer_id = $this->input->post('customer_id', true); // ENCRYPTED
			$new_part_quantity = intval($new_part_quantity);
			 
			if($new_part_quantity <= 0){ // REMOVE FROM BOTH 
				$this->db->query("DELETE FROM part WHERE id = '$part_id' ");
				
				$this->db->query("DELETE FROM bonus_part WHERE part_id = '$part_id' ");
			}else if($new_part_quantity == 1){ // REMOVE FROM bonus_part
				$this->db->query("DELETE FROM bonus_part WHERE part_id = '$part_id' ");
			}else{
				$current_bonus_part_count = get_bonus_parts_count($part_id); 
				
				$difference = $new_part_quantity - $current_bonus_part_count; 
				 //p($current_bonus_part_count.'===='.$new_part_quantity.'====='.$difference); 
				if($difference < 0){ // REMOVE SOME ENTRIES FROM bonus_part
					//echo "DELETE FROM bonus_part WHERE part_id = '$part_id' ORDER BY id DESC LIMIT ".abs($difference);exit;
					$num_record_delete = abs($difference) + 1; // ONE ENTRY IS IN part table
 					$this->db->query("DELETE FROM bonus_part WHERE part_id = '$part_id' ORDER BY id DESC LIMIT $num_record_delete" );
 				}else if($difference > 0){
 					$difference = $difference - 1; // ONE PART IS ALREDAY IN PART TABLE
					if($difference > 0){
	 					$this->load->model('admin/orders_model');
	 					$list_parts = $this->orders_model->get_all_parts($quote_id);
					 	$length_array = count($list_parts);
                  		 for($i=0; $i< $length_array; $i++ ){
                                                    
                          	if($list_parts[$i]['id'] == $part_id){
                             	$list_parts = $list_parts[$i];
                                      break;                  
                                	 }
                                                    //echo "test<br/>";
                                                    
                                                }
	 					//$list_parts = $list_parts[0]; 
	 					$image 		= $list_parts['image'];
						$description = $list_parts['description'];
						$x 			= $list_parts['x'];
						$y 			= $list_parts['y'];
						$z 			= $list_parts['z'];
						$volume 	= $list_parts['volume'];
						$x2 		= number_format($x,3);
						$y2 		= number_format($y,3);
						$z2 		= number_format($z,3);
						$file_location = $list_parts['file_location'];
						$total_price = $list_parts['total_price'];
	 					$note = $list_parts['notes'];
	 					$on_behalf_of = $list_parts['on_behalf_of'];
						$data = array();
						
					
						for($i = 0; $i < $difference; $i++){
							$data[] = 
							   array(
							      	'user_id' 	=> s('USER_ID'),
							    	'quote_id' 	=> $quote_id, 
							    	'part_id'	=> $part_id, 
							    	'x'			=> $x, 
							    	'y'			=> $y, 
							    	'z'			=> $y, 
							    	'volume'	=> $volume, 
							    	'image'		=> $image, 
							    	'extra_part'=> $total_price, 
							    	'description'=> $description, 
							    	'file_location' => $file_location,
							   		'on_behalf_of' => $on_behalf_of,
							   		'notes'	=> $note
							 );
						}
	 					if(!empty($data)){
							$this->db->insert_batch('bonus_part', $data);
						}
					}
  				}
 			}
			
			$this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'success', 
				'content' => 'Part details deleted.',
				'details' => array( 
					'customer_id' =>  ($customer_id),
					'quote_id' => encrypt_url_string($quote_id)
				)
			))));
           		return;
	    }
	    
	    function promo_code(){
	    	if(!$this->authentication->check_logged_in("normal", false)){
	           $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'login_error', 'content' => 'Please login to do this action.'))));
	            return;
	        }
	        
	        $quote_id 	= $this->input->post('quote_id', true);
			$code 		= strtoupper( $this->input->post('code', true) );
			$customer_id = $this->input->post('customer_id', true); // ENCRYPTED
			
			$promo_details 	= get_promo($code, 'A');
			$promo_details 	= @$promo_details[0];
			$promo_id		= @$promo_details['id'];
			$description 	= @$promo_details['description'];
			
			if(empty($promo_details)){
			  	$this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'The promo code you entered is not valid one.'))));
            	return;
			}else{
				$already_used = is_promo_used($quote_id);
				if(!empty($already_used)){
					$this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'A Promo Code has already been used.'))));
            		return;	
				}
				$user_id = s('USER_ID');
				$date_created = get_cur_date_time();
				$query = "INSERT INTO promo_user (user_id, quote_id, promo_id, date_created) 
							VALUES ('$user_id', '$quote_id', '$promo_id', '$date_created' )";
				$this->db->query($query);
				if( $this->db->insert_id() <= 0){
					$this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'There is a problem to update. Please try again later.'))));
            		return;	
				} 
			}

			$this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'success', 
				'content' => 'Type of Code: '.$description,
				'details' => array( 
					'customer_id' =>  ($customer_id),
					'quote_id' => encrypt_url_string($quote_id)
				)
			))));
           		return;
	    }
	    
	    function remove_promo(){
	    	if(!$this->authentication->check_logged_in("normal", false)){
	           $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'login_error', 'content' => 'Please login to do this action.'))));
	            return;
	        }
	        
	        $quote_id 	= $this->input->post('quote_id', true);
			$part_type  = strtoupper( $this->input->post('part_type', true) );
			$customer_id = $this->input->post('customer_id', true); // ENCRYPTED
			$promo_id 	= $this->input->post('promo_id', true);  
			
			$this->db->query("DELETE FROM promo_user WHERE id = '$promo_id' AND quote_id = '$quote_id' ");
			
			$this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'success', 
				'content' => 'Promo code deleted successfully' ,
				'details' => array( 
					'customer_id' =>  ($customer_id),
					'quote_id' => encrypt_url_string($quote_id)
				)
			))));
           		return;
	    }
	    
	    function update_additional_description(){
	    	if(!$this->authentication->check_logged_in("normal", false)){
	           $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'login_error', 'content' => 'Please login to do this action.'))));
	            return;
	        }
	        
	        $part_id =  $this->input->post('part_id', true) ;
	        
	        $addl_notes =  $this->input->post('notes', true) ;
	        
	        $this->db->update('part', array('description_note' => $addl_notes), array('id' => $part_id));
	        $this->db->update('bonus_part', array('description_note' => $addl_notes), array('part_id' => $part_id));
	        
	        $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'success', 
				'content' => 'Promo code deleted successfully' ))));
           		return;
	    }
	    
	    function export_to_pdf(){
	    	if(!$this->authentication->check_logged_in("normal", false)){
	           $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'login_error', 'content' => 'Please login to do this action.'))));
	            return;
	        }
	        
	        $this->load->model('admin/orders_model');
	    	$quote_id = decrypt_url_string($this->input->get('quote_id'));
	    	
	    	$this->gen_contents['quote_details'] = $this->orders_model->list_orders(0, 0, array('q.id' => $quote_id), array(), false);
	    	if(empty($this->gen_contents['quote_details'])) {
	        	$this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'Please make sure that your are accessing valid page.'))));
	            return;
	        }
	        $this->gen_contents['quote_user'] = $this->orders_model->get_quote_user(@$this->gen_contents['quote_details'][0]['user_id']);
	        $this->gen_contents['parts'] = $this->orders_model->get_all_parts($quote_id);
	    	
	    	$data = $this->load->view('admin/orders/print_order_report', $this->gen_contents, true);
	    	
	    	$this->load->helper('file');
			$temp_path = c('file_upload_path').'temp_files/';
		 	$file_name  = $temp_path.md5(uniqid(rand(), true)).'.html'; 
		    if ( write_file( $file_name, $data)) {
				$wkhtmltopdf_path = c('wkhtmltopdf_path');
				$pdf_name = md5(uniqid(rand(), true)).'pdf';
		    	$done = shell_exec("$wkhtmltopdf_path $file_name $temp_path.$pdf_name");
		    	if($done){
		    		 $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'success', 'pdf_link' => c('file_upload_url').'temp_files/'.$pdf_name, 'content' => 'PDF created.'))));
	           		 return;
		    	}else{
		    		 $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'Unable to convert your file to PDF. Please try again later.'))));
	            	return;
		    	}
 		    }  else {
		            $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'Not able to create PDF. Please try again later.'))));
	            	return;
		    }
	    	
	    }
	function newsletter(){
	 	if(!$this->input->is_ajax_request()){
        	$this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error',  'message' => 'Invalid request.'))));
        	return;
        }
        
	 	if( !($this->input->post('txtNewsLetterEmail'))){
        	$this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error',  'message' => 'You must enter your email address.'))));
        	return;
        }
        
         $this->form_validation->set_rules('txtNewsLetterEmail', 'email', 'required|trim|valid_email|max_length[100]|callback_email_exists_validate');
         
         if ($this->form_validation->run() == TRUE) {
         	$n_data = array(
         		'email' => $this->input->post('txtNewsLetterEmail', true),
         		'ip' => $this->input->ip_address(),
         		'date_created' => get_cur_date_time()
         	);
         	$this->db->insert('newsletter', $n_data);
         	$this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'success',  'message' => 'Thank you for subscribing our newsletter' ))));
        	return;
         }else{
         	$this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error',  'message' => validation_errors()))));
        	return;
 		}
	}	    
	
	function email_exists_validate($email){
	////load user model
            $this->load->model('user_model');
            //pass data to model
            $status = $this->user_model->email_exists_validate($email);
            if ($status)
            {
                $this->form_validation->set_message('email_exists_validate', 'You have already subscribed to get our newsletters.');
                return FALSE;
            }else{
                return TRUE;
            }
	}
}


