<?php
/**
 * CodeIgniter
 *
 * An open source application development framework for PHP
 *
 * This content is released under the MIT License (MIT)
 *
 * Copyright (c) 2014 - 2015, British Columbia Institute of Technology
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * @package CodeIgniter
 * @author  EllisLab Dev Team
 * @copyright Copyright (c) 2008 - 2014, EllisLab, Inc. (http://ellislab.com/)
 * @copyright Copyright (c) 2014 - 2015, British Columbia Institute of Technology (http://bcit.ca/)
 * @license http://opensource.org/licenses/MIT  MIT License
 * @link  http://codeigniter.com
 * @since Version 1.0.0
 * @filesource
 */
defined('BASEPATH') OR exit('No direct script access allowed');
class Package extends CI_Controller {
	var $gen_contents = array();
	 
	 function index(){
        //die("tttt");
	 	//$this->customers();

	 }
	 
	 public function package_list() {

	 		(!$this->authentication->check_logged_in("admin", false)) ? redirect('admin/sales/my_customers') : '';
	 	if(!admin_has_permission(7)){

			redirect('admin/dashboard');
		}
        $id = $this->input->get('cid', true);
        if($id != ''){
            $this->db->where('package_id', $id);
            $sts=$this->db->delete('packages'); 
            if($sts){
                       // $first_groupname_1      = $this->input->post("txtg11", true); 
                     
                       
                          sf('success_message', "Package has been deleted.");
                       }else{
                          sf('error_message', 'Error! There is an issue with deletion. Please try again later.');
                       }
                       redirect('admin/package/package_list');
           
        }
	 	$this->gen_contents['script_load_page'] = 'users';
        $this->gen_contents['js_files'] = array('global/plugins/datatables/media/js/jquery.dataTables.min.js', 
        'global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js',
        'global/plugins/jquery-validation/js/jquery.validate.min.js', 'global/scripts/datatable.js',
		'global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js',
        'admin/layout/scripts/packages.js');
        $this->template->set_template('admin');
       	
		$lnk = 'package/package_list';
		$lbl = 'Packages';
		$this->gen_contents['active_main_menu'] = array('Manage Packages', 'customers');
		
        $this->gen_contents['page_heading'] = 'Manage Packages';
        //$this->gen_contents['sales_type'] = '2';
        $this->gen_contents['js_script_initial'] = "Packages.init();";
        //$this->gen_contents['customers_list'] = $this->common_model->get_data('packages','package_id','package_code','package_name','package_registered_time','1package_last_updated_time', array('package_status' => '1' ));
        $this->template->write_view('content', 'admin/packages/package_list', $this->gen_contents);
        $this->template->render();
	 }


 
	 
	 function list_packages($type = 1){ // 1 = my customers 

	  if (!$this->authentication->check_logged_in("admin", false) ) { // If there is no login exists just return the error

            $iTotalRecords = 1;
            $iDisplayLength = 1;
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = 0;
            $sEcho = 0;

            $records = array();
            $records["data"] = array();

            $end = 1;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;

            $status_list = array(
                array("success" => "Pending"),
                array("info" => "Closed"),
                array("danger" => "On Hold"),
                array("warning" => "Fraud")
            );

            for ($i = $iDisplayStart; $i < $end; $i++) {
                $status = $status_list[rand(0, 2)];
                $id = ($i + 1);
                $records["data"][] = array(
                    '<script>window.location=\'' . admin_url() . 'login\'</script>',
                    '', '', '', '', '', '', '', '',
                );
            }

            

            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;
            $this->load->view('ajax_view', array('ajax_response' => json_encode($records)));
            return;
        }
        else {
            
            $this->load->model('admin/packages_model');
            $list_packages = array();
            $like_search = array();
            $where = array();
			
			
			
			if($this->input->post('txtpackagecode', true)){
				$like_search['p.package_code'] = $this->db->escape_like_str($this->input->post('txtpackagecode', true));
			}
        	if($this->input->post('txtpackagename', true)){
				$like_search['p.package_name'] = $this->db->escape_like_str($this->input->post('txtpackagename', true));
			}
        	if($this->input->post('txtpackagestatus', true)){
				$like_search['p.package_status'] = $this->db->escape_like_str($this->input->post('txtpackagestatus', true));
			}
        	if($this->input->post('txtpackagectime', true)){
				$like_search['p.package_registered_time'] = $this->db->escape_like_str($this->input->post('txtpackagectime', true));
			}
        	if($this->input->post('txtpackageltime', true)){
				 $like_search['p.package_last_updated_time'] = $this->db->escape_like_str($this->input->post('txtpackageltime', true));
			}
        	
			//$where = array('q.payment_received' => '1', 'q.activated' => '3');
			
           
            $iTotalRecords = $this->packages_model->list_packages_count($where, $like_search);
            //$iTotalRecords = 6;
            $iDisplayLength = intval($this->input->post('length'));
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = intval($this->input->post('start'));
            $sEcho = intval($this->input->post('draw'));

            $records = array();
            $records["data"] = array();

            $end = $iDisplayStart + $iDisplayLength;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;
			if($iTotalRecords > 0){
            	$list_packages = $this->packages_model->list_packages($iDisplayStart, $end, $where, $like_search);
            	//echo "<pre>";
            	///print_r($list_users);
            	//die();


			}
            $id = $iDisplayStart;
            for ($i = 0; $i < count($list_packages); $i++) {
                $id++;
                $status = '';
                $status_css = '';
                $q_id = $list_packages[$i]['package_id'];
                //die($q_id);
                $actn_buttons = '';
					
				//$actn_buttons .= '<a href="' . admin_url() . 'sales/view_order/?quote_id=' . $q_id . '" title="View Customer" class="btn btn-icon-only green margin-bottom-5"><i class="glyphicon glyphicon-eye-open"></i></a>' ;
				$actn_buttons .= '<a href="' . admin_url() . 'package/edit_package/?cid='.$q_id.'" title="Edit package" class="btn btn-icon-only green margin-bottom-5"><i class="glyphicon glyphicon-edit"></i></a>' ;
				
					 $actn_buttons .= '<a href="' . admin_url() . 'package/package_list/?cid='.$q_id.'" title="delete package" class="btn btn-icon-only red margin-bottom-5"><i class="fa fa-times"></i></span>';
         
				
				//$actn_buttons .= '<span class="btn btn-icon-only blue margin-bottom-5 customer-settings" id="cus-cid'.$list_packages[$i]['id'].'" data-cid="'.$list_packages[$i]['id'].'" data-sales-rep="'. ($list_packages[$i]['sales_rep']).'" data-id="' . $q_id . '" title="Settings" data-toggle="modal" data-cus-info="<b>'.$list_packages[$i]['fname'].' '.$list_packages[$i]['lname']. '</b><br>'.$list_packages[$i]['email'].'<br>'.$list_packages[$i]['company_name'] .'"  data-target="#MdlCustomerSettings"><i class="icon-key"></i></span>';
				$list_array =  array(
                    $id, 
                   // $list_users[$i]['id'],
                    $list_packages[$i]['package_code'],
                    $list_packages[$i]['package_name'],
                    $list_packages[$i]['package_status'],
                    $list_packages[$i]['package_registered_time'],
                    $list_packages[$i]['package_last_updated_time'],
                    $actn_buttons
                );
				
                $records["data"][] = $list_array;
            }
            

            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;

            $this->load->view('ajax_view', array('ajax_response' => json_encode($records)));
            return;
        }
	 }
	 
	
	 
	 function new_package(){
	 	(!$this->authentication->check_logged_in("admin", false)) ? redirect('admin') : '';
	 	if(!admin_has_permission(13)){
			redirect('admin/dashboard');
		}
	 	if (!empty($_POST)) {

	 		$this->form_validation->set_rules('txtpackageName', 'Package name', 'required|trim|max_length[100]');
            $this->form_validation->set_rules('txtpackagecode', 'Package code', 'required|trim|max_length[100]');
			 if ($this->form_validation->run() == TRUE) {  //form validation
			 	
               	$data = array(
               			'package_code'      => $this->input->post("txtpackagecode", true), 
                        'package_name'       => $this->input->post("txtpackageName", true),
                        'package_status'      => '1', 
                         'package_registered_time'	=>date('Y-m-d h:i:s'), 
               			'package_last_updated_time'   => date('Y-m-d h:i:s')
               			 
                       );
                       
                       $this->db->insert('packages', $data);
                       $insert_id = $this->db->insert_id();
                       
                       if($insert_id > 0){
                       	
                       		sf('success_message', "Package added successfully.");
                       }else{
                       		sf('error_message', 'Error! There is an issue with creating new customer. Please try again later.');
                       }
                       redirect('admin/package/new_package');
               }else{
               	 $this->gen_contents['form_validation_error'] = validation_errors();
               }
	 	}
	 	
	 	$this->gen_contents['script_load_page'] = 'users';
        $this->gen_contents['js_files'] = array('global/plugins/datatables/media/js/jquery.dataTables.min.js', 
        'global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js',
        'global/plugins/jquery-validation/js/jquery.validate.min.js', 'global/scripts/datatable.js',
		'global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js',
        'admin/layout/scripts/packages.js');
        $this->template->set_template('admin');
       	
		$lnk = 'package/Create package';
		$lbl = 'Create New Package';
		$this->gen_contents['active_main_menu'] = array('Manage package', 'customers');
		
         $this->gen_contents['page_heading'] = 'Manage Packages - '.$lbl;
         $this->gen_contents['sales_type'] = '2';
        $this->gen_contents['page_breadcrumb'] = array(array('link' => '#', 'label' => 'Manage Package'), array('link' => $lnk, 'label' => $lbl));
        $this->gen_contents['js_script_initial'] = "packages.init();";
        $this->template->write_view('content', 'admin/packages/new_package', $this->gen_contents);
        $this->template->render();
	 }
	 
	 function edit_package(){
        if(!admin_has_permission(7)){
			redirect('admin/dashboard');
		}
 		(!$this->authentication->check_logged_in("admin", false)) ? redirect('admin') : '';
 		$id = $this->input->get('cid', true);
        $where = array('package_id' => $id);
        //print_r($where);
        //die("test");
	 	if(s('ADMIN_TYPE') != 'Y'){
 			//$where['sales_rep'] = s('ADMIN_USERID');
 		}
 		
 		if (!empty($_POST)) {
            $this->form_validation->set_rules('txtpackageName', 'Package name', 'required|trim|max_length[100]');
            $this->form_validation->set_rules('txtpackagecode', 'Package code', 'required|trim|max_length[100]');
			 if ($this->form_validation->run() == TRUE) {  //form validation
			 	
               	$data = array(
               			
                        'package_name'       => $this->input->post("txtpackageName", true), 
                        'package_code'       => $this->input->post("txtpackagecode", true),
                        'package_last_updated_time'   => date('Y-m-d h:i:s') 
                        
                       );
                       
                      $sts = $this->db->update('packages', $data, $where);
                      
                       
                       if($sts){
                       	$package_name = $this->input->post("txtpackageName", true);
                        $package_code = $this->input->post("txtpackagecode", true);
                       
                       		sf('success_message', "Package has been updated.");
                       }else{
                       		sf('error_message', 'Error! There is an issue with update. Please try again later.');
                       }
                       redirect('admin/package/edit_package/?cid='.$id);
               }else{
               	 $this->gen_contents['form_validation_error'] = validation_errors();
               }
	 	}
	 	
	 	
	 	
 		$this->gen_contents['package'] = $this->common_model->get_data('packages', '*', $where);

	 	$this->gen_contents['package'] = @$this->gen_contents['package'][0];
       // echo $this->gen_contents['package'];
        //die("test");
	 	if(empty($this->gen_contents['package'])){
	 		sf('error_message', 'Error! Please ensure that you have enough permission to edit such information.');
	 		redirect('admin/dashboard');
	 	}
	 	$this->gen_contents['script_load_page'] = 'users';
        $this->gen_contents['js_files'] = array('global/plugins/datatables/media/js/jquery.dataTables.min.js', 
        'global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js',
        'global/plugins/jquery-validation/js/jquery.validate.min.js', 'global/scripts/datatable.js',
		'global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js',
        'admin/layout/scripts/packages.js');
        $this->template->set_template('admin');
       	
		$lnk = 'Manage package/package';
		$lbl = 'Edit package';
		$this->gen_contents['active_main_menu'] = array('Manage package', 'customers');
		
        $this->gen_contents['page_heading'] = 'Manage package - '.$lbl;
        $this->gen_contents['sales_type'] = '2';
        $this->gen_contents['page_breadcrumb'] = array(array('link' => '#', 'label' => 'Manage package'), array('link' => $lnk, 'label' => $lbl));
        $this->gen_contents['js_script_initial'] = "packages.init();";
        $this->template->write_view('content', 'admin/packages/edit_package', $this->gen_contents);
        $this->template->render();
 		
	 }
	 
	 function email_validate($email){
	 	$id =  decrypt_url_string($this->input->get('cid', true));
	 	$where = array('email' => $email);
	 	if(!empty($id)){
	 		$where['id !='] = $id;
	 	}
	 	
	 	$email_exists = $this->common_model->get_data('user', 'email', $where);
	 	//p($where);exit;
   		if (!empty($email_exists)) {
   				$sales_fname = s('ADMIN_NAME');
   				$message = "$sales_fname, $email is already in our database and has already been assigned to another sales rep, or is already assigned to you.<br />";
            	$this->form_validation->set_message('email_validate', $message);
            	return FALSE;
            }
            else {
                return TRUE;
            }
	 	
	 }
	 function _send_welcome_email($user_details = array()){
            $this->load->helper('email_helper');
            process_and_send_mail($user_details[0]['email'],
                            array('first_name' => $user_details[0]['fname'], 
                            'login_link' => '<a target="_blank" href="' . base_url(). 'login'.'" >'.base_url().'login'.'</a>',
                            'regards_name' => c('regards_name'),
                            'email_bottom_instruction' => c('email_bottom_instruction')
                            ),
                                   'send_welcome_email', 
                                   array(), 
                                   array(), 
                                   '', 
                                   '');
        }
      


}