<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class User extends CI_Controller {

    /**
     * Admin username
     *
     * @var string
     */
    var $username = "";

    /**
     * Admin password
     *
     * @var string
     */
    var $password = "";

    /**
     * Page title
     *
     * @var string
     */
    var $title = '';

    /**
     * General contents
     *
     * @var Array
     */
    var $gen_contents = array();
    var $mcontents;
    var $merror;
    var $msuccess;
    /**
     * Admin constructor
     *
     */

   
    public function index() {
        $this->template->set_template('adminlogin');
        if (s('ADMIN_USERID')) {
            redirect('admin/dashboard');
        }
        else {
            $this->gen_contents['user_id'] = $this->authentication->admin_logged_in();
            if (!empty($_POST)) {
                $this->load->library('form_validation');
                $this->_init_adminlogin_validation_rules(); //server side validation of input values
                if ($this->form_validation->run() == TRUE) {// form validation
                    $this->_init_adminlogin_details();
                    $login_details['username'] = $this->username;
                    $login_details['password'] = $this->password;
                    $msg = $this->authentication->process_admin_login($login_details);
                    if ($msg == 'success'){
                        remove_temp_images(); // We will remove old temp files 
                        redirect("admin/dashboard");
                    }
                    else if ($msg == 'inactive') {
                        sf('error_message', 'Your account has not been activated');
                        redirect("admin");
                    }
                    else {
                        sf('error_message', 'Invalid username or password');
                        redirect("admin");
                    }
                }
                else {
                    sf('error_message', validation_errors());
                    redirect("admin");
                }
            }
            $this->template->render();
        }
    }

    /**
     * validating the form elemnets
     */
    function _init_adminlogin_validation_rules() {
        $this->form_validation->set_rules('admin_username', 'username', 'required|max_length[50]');
        $this->form_validation->set_rules('admin_password', 'password', 'required|max_length[20]');
    }

    /**
     * Initialising the data
     *
     */
    function _init_adminlogin_details() {
        $this->username = $this->input->post("admin_username", true);
        $this->password = $this->input->post("admin_password", true);
    }

    function forgot_password(){
        $this->load->library('form_validation');
        $this->template->set_template('adminlogin');
        if (s('ADMIN_USERID')) {
            redirect('admin/dashboard');
        }
        else { 
            ($this->authentication->check_logged_in("admin", false)) ? redirect('admin/user/dashboard') : '';
            if (!empty($_POST)) { 
                 $this->load->model('admin/admin_model');
               //  $this->load->helper('email_helper');
                 $this->load->helper('string_helper');
                 $this->form_validation->set_rules('fgtEmail', 'email', 'required|trim|valid_email|max_length[30]');
                 if($this->form_validation->run() == TRUE) {
                     
                    $forgot_email = $this->input->post('fgtEmail', true);
                    $forgot_check = $this->common_model->get_data( 'user', 'fname as first_name, email',array('email'=>$forgot_email, 'active'=> '1'));
                    if(!empty($forgot_check)){
                        $data = $forgot_check[0];
                        $firstname=$data['first_name'];
                        $email=$data['email'];
                         $new_pass=random_string('numeric', 6);
                        $data['password'] = sha1($new_pass);
                        $status = $this->admin_model->update_admin_fgt_code($data);
                        
                        if($status){
                            $this->load->library('email');


                        $this->email->from('Sportboard@gmail.com', 'Sportboard');
                        $this->email->to($email);
                        $this->email->subject('Forgot password - Reset');
                        $this->email->message("Hi $firstname, your successfully reseted your password. your new password is $new_pass");
                        $this->email->send();

                               sf('success_message', 'Your  new password  send to you mail.');
                            }else{ 
                                sf('error_message', 'There is a problem in password change');
                            }
                        }else{
                           sf('error_message', 'Email does not exist');
                       }
                       redirect('admin/forgot_password');
                }
            }
            $this->template->render();
        }
    }
    
    function resetpass($forgot_code = ''){
            $this->load->model('admin/admin_model');
            if(!empty($forgot_code)){ 
                $status = $this->admin_model->get_forgot_code($forgot_code);
                if(!empty($status)){
                    //redirect('admin/resetpass');
                }else{
                    sf('error_message', 'Invalid forgot code');
                    redirect('admin');
                }
            }
            if(!empty($_POST)){
                //Server validation
                $this->form_validation->set_rules('resetPass', 'Enter New Password', 'required|trim|max_length[10]');
                $this->form_validation->set_rules('retypePass', 'Enter Retype Password', 'required|trim|max_length[10]|callback_password_match');
                if ($this->form_validation->run() == TRUE) {
                    $data = array(
                            'password' => $this->input->post("resetPass", true),
                            'activation_code'=> $forgot_code
                        ); 
                    $status = $this->admin_model->update_fgt_password($data);
                    if($status){
                        redirect('admin');
                    }else{
                        sf('error_message', 'Password change failed');
                    }  
                    
                }else{
                   $this->gen_contents['form_validation_error'] = validation_errors();
               } 
            }
            $this->template->write_view('content', 'admin/resetpass', $this->gen_contents);
            $this->template->render();
    }
    function change_password(){
        if (!empty($_POST)) {
            if (!$this->authentication->check_logged_in("admin", false)) { // If there is no login exists just return the error
                $this->load->view('ajax_view', array('ajax_response' => json_encode(array('login_error' => 1))));
                return;
            }
            else {
                $this->load->model('admin/admin_model'); 
                /* Code here: loading the validation library */
                $this->load->library('form_validation');
                //Codeigniter form validation for changepassword fields
                $this->form_validation->set_rules('current_password', 'current password', 'required|trim|max_length[20]');
                $this->form_validation->set_rules('new_password', 'new password', 'required|trim|max_length[20]');
                $this->form_validation->set_rules('new_password_confirm', 'confirm password', 'required|trim|max_length[20]|callback_password_match');

                if ($this->form_validation->run() == TRUE) {
                    $status = $this->admin_model->update_admin_password($this->input->post("current_password", true), $this->input->post("new_password", true), s('ADMIN_USERID'));
                    if (!empty($status['invalid_old_password'])) {
                        $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'message' => 'Old password you entered is wrong.'))));
                        return;
                    }
                    else if ($status) {
                        $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'success', 'message' => 'Your password has been updated successfully.'))));
                        return;
                    }
                    else {
                        $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'message' => 'There is a problem with update. Please try later'))));
                        return;
                    }
                }
                else {
                    $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'message' => validation_errors()))));
                    return;
                }
            }
        }
        (!$this->authentication->check_logged_in("admin", false)) ? redirect('admin') : '';
        $this->gen_contents['script_load_page'] = 'users';
        $this->gen_contents['js_files'] = array('global/plugins/jquery-validation/js/jquery.validate.min.js', 'admin/layout/scripts/user.js');
        $this->template->set_template('admin');
        $this->gen_contents['page_heading'] = 'Change Password';
        $this->gen_contents['active_main_menu'] = array('settings', 'change_password');
        $this->gen_contents['page_breadcrumb'] = array(array('link' => '#', 'label' => 'Settings'), array('link' => 'change_password', 'label' => 'Change Password'));
        $this->gen_contents['js_script_initial'] = "User.init();";
        
        $this->template->write_view('content', 'admin/change_password', $this->gen_contents);
        $this->template->render();
    }

    function profile() {
        (!$this->authentication->check_logged_in("admin", false)) ? redirect('admin') : '';
        if (!empty($_POST)) {
            $this->load->model('admin/admin_model');
            $this->load->library('form_validation');

            //Codeigniter validation
            $this->form_validation->set_rules('txtFirstName', 'first name', 'required|trim|max_length[20]');
            $this->form_validation->set_rules('txtLastName', 'last name', 'required|trim|max_length[20]');
            $this->form_validation->set_rules('txtEmail', 'email', 'required|trim|valid_email|max_length[40]|callback_check_email_exists');

            if ($this->form_validation->run() == TRUE) {// form validation
                $data = array(
                    'fname' => $this->input->post("txtFirstName", true),
                    'lname' => $this->input->post("txtLastName", true),
                    'email' => $this->input->post("txtEmail", true)
                );

                if (!empty($_FILES['flProfielImage'])) {
                    $this->load->helper('image_helper');
                    if ($_FILES['flProfielImage']['name'] != '') {
                        $upload_status = upload_image('admin_profile', 'flProfielImage');
                    }
                }
                if (!empty($upload_status['file_name'])) {
                    // Remove the existing image if the file upload is success
                    $old_image_name = $this->common_model->get_data('user', 'profile_image');
                    $data['profile_image'] = $upload_status['file_name'];
                }

                if (!empty($upload_status['upload_error'])) {
                    $this->gen_contents['form_validation_error'] = $upload_status['upload_error'];
                }
                else {
                    $status = $this->admin_model->update_admin_profile($data, s('ADMIN_USERID'));
                    if ($status) {
                        if (!empty($upload_status['file_name']))
                            $this->session->set_userdata(array('ADMIN_PROFILE_IMAGE' => $data['profile_image'], 'ADMIN_NAME' => $data['fname'])); // Just keep this name for printing at the top header
                        if (!empty($old_image_name[0]['profile_image'])) {
                            // Remove old images
                            delete_image('admin_profile', $old_image_name[0]['profile_image']);
                        }
                        sf('success_message', 'Your profile has been updated.');
                    }
                    else {
                        sf('error_message', 'There is a problem with update.');
                    }
                }
            }
            else {
                $this->gen_contents['form_validation_error'] = validation_errors();
            }
        }
        $this->gen_contents['script_load_page'] = 'users';
        $this->gen_contents['js_files'] = array('global/plugins/jquery-validation/js/jquery.validate.min.js', 'admin/layout/scripts/user.js');
        $this->template->set_template('admin');
        $this->gen_contents['page_heading'] = 'Profile';
        $this->gen_contents['profile_data'] = $this->common_model->get_data('user', 'fname as first_name, lname as last_name, email, profile_image',array('id' => s('ADMIN_USERID')));
        $this->gen_contents['active_main_menu'] = array('settings', 'profile');
        $this->gen_contents['page_breadcrumb'] = array(array('link' => '#', 'label' => 'Settings'), array('link' => 'profile', 'label' => 'Profile'));
        $this->gen_contents['js_script_initial'] = "User.init();";
        $this->template->write_view('content', 'admin/profile', $this->gen_contents);
        $this->template->render();
    }
	function check_email_exists($email){
		$this->load->library('form_validation');
        $sts = $this->common_model->get_data('user', 'email', array('id !=' => s('ADMIN_USERID'), 'email' => $email ));
        if(!empty($sts)){
        	$this->form_validation->set_message('check_email_exists', 'Already user with same email exists.');
            return FALSE;
           
         }
            else {
                return TRUE;
            }
	}
    function password_match($conf_pwd) {
        $this->load->library('form_validation');
        $new_pwd = $this->input->post("new_password", true);
        if(!empty($new_pwd)){
            if ($new_pwd != $conf_pwd) {
            $this->form_validation->set_message('password_match', 'New and confirm password does not match');
            return FALSE;
            }
            else {
                return TRUE;
            }
            
        }else{
            $retype_pwd = $this->input->post("resetPass", true);
            if ($retype_pwd != $conf_pwd) {
                $this->form_validation->set_message('password_match', 'Reset and Retype password does not match');
                return FALSE;
            }
            else {
                return TRUE;
            }
        }
        
    }

    function logout() {
        $this->authentication->admin_logout();
        redirect('admin');
    }
    
	function admins() { 
		(!$this->authentication->check_logged_in("admin", false)) ? redirect('admin') : '';
		//if(s('ADMIN_TYPE') != 'Y') redirect('admin');
                     if(!admin_has_permission(1)){ redirect('admin');}
        $this->gen_contents['script_load_page'] = 'users';
        $this->gen_contents['js_files'] = array('global/plugins/datatables/media/js/jquery.dataTables.min.js', 
        'global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js',
        'global/plugins/jquery-validation/js/jquery.validate.min.js', 'global/scripts/datatable.js', 'admin/layout/scripts/admins.js');
        $this->template->set_template('admin');
        $this->gen_contents['page_heading'] = 'Administrators';
        $this->gen_contents['active_main_menu'] = array('users', 'admins');
        $this->gen_contents['page_breadcrumb'] = array(array('link' => '#', 'label' => 'Administrators'));

        $this->gen_contents['js_script_initial'] = "Admins.init();";

        $this->gen_contents['admin_reset_password_form'] = true;
        $this->template->write_view('content', 'admin/admins/admins_list', $this->gen_contents);
        $this->template->render();
    }
    
    function new_admin(){
    	(!$this->authentication->check_logged_in("admin", false) || !(admin_has_permission(2))) ? redirect('admin') : '';
        if (!empty($_POST)) {

        	
        	$this->form_validation->set_rules('txtFirstName', 'first name', 'required|trim|max_length[50]');
               $this->form_validation->set_rules('txtLastName', 'last name', 'required|trim|max_length[50]');
               $this->form_validation->set_rules('txtEmail', 'email', 'required|trim|valid_email|max_length[50]|callback_email_validate');
             //  $this->form_validation->set_rules('txtUsername', 'username', 'required|trim|min_length[5]|max_length[12]|callback_username_validate');
               $this->form_validation->set_rules('new_password', 'new password', 'required|trim|max_length[20]');
                $this->form_validation->set_rules('selectpackage', 'select Package', 'required|trim|max_length[50]');
                 if(in_array($this->input->post("selectpackage", true), array(5,6))){        
                $this->form_validation->set_rules('selectscoring', 'Select scoring', 'required|trim|max_length[50]');
               }  
               $this->form_validation->set_rules('new_password_confirm', 'confirm password', 'required|trim|max_length[20]|callback_password_match_admin');
               $this->form_validation->set_rules('txtdomain', 'Domain name', 'required|trim|max_length[50]|callback_domain_validate');
              
               
               if ($this->form_validation->run() == TRUE) {  //form validation
               		  //$encrypt_time = strtotime(get_cur_date_time());
	                  $password     = sha1(trim($this->input->post("new_password", true)));
	                 // $password     = create_secure_password($password.$encrypt_time);
                    $logo = $this->input->post("logo", true);
                    $scoring_double = $this->input->post("scoring_double", true);
                    
                    if($logo =='')
                    {
                    $logo=0;
                    }
                    if($scoring_double =='')
                    {
                    $scoring_double=0;
                    }
                  	$this->load->library('user_agent');

	                  $data = array(
                       'fname'      => $this->input->post("txtFirstName", true), 
                       'lname'       => $this->input->post("txtLastName", true),
                       'email'           => $this->input->post("txtEmail", true),
                       'domian'           => $this->input->post("txtdomain", true),
                       'package'           => $this->input->post("selectpackage", true), 
                       'design_id'     => $this->input->post("selectdesign", true),
                       'scoring_cat_id' =>$this->input->post("selectscoring", true),
                       'tournament_cat_id' =>$this->input->post("selecttournament", true),
                       'phone'           => $this->input->post("txtPhone", true), 
                       'password'        => $password,
                       'date_created'    => get_cur_date_time(),
                       'active'          => '1',
                       'logo' => $logo,
                       'scoring_double_status' => $scoring_double,
                       'admin'	=> '1' 
                     
                       );
                       
                       
                       if (!empty($_FILES['flProfielImage'])) {
		                    $this->load->helper('image_helper');
		                    if ($_FILES['flProfielImage']['name'] != '') {
		                        $upload_status = upload_image('admin_profile', 'flProfielImage');
		                    }
		                } 
		                if (!empty($upload_status['file_name'])) {
		                    // Remove the existing image if the file upload is success
		                    //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
		                    $data['profile_image'] = $upload_status['file_name'];
		                }
						
		                if (!empty($upload_status['upload_error'])) {
		                    $this->gen_contents['form_validation_error'] = $upload_status['upload_error'];
		                }
		                else {
			               $this->db->insert('user', $data);
	                       $id = $this->db->insert_id();
	                       if($id){


	                       	
	                       //$id_array = array();
						        $chkPermissions = $this->input->post('selectpackage', true);

                    switch($chkPermissions){
                      case 1:
                      //$id_array=array(5,8);
                      $sql="insert into admin_permissions(permission_id,admin_id)
                        values('5','$id')";
                      $this->db->query($sql);
                      $sql1="insert into admin_permissions(permission_id,admin_id)
                        values('8','$id')";
                      $this->db->query($sql1);

                      $data=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('four_lanes',$data);
                      $this->db->insert('four_lanes_double',$data);
                      $data1=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('scroll_news',$data1);
                    break;
                    case 2:
                    $sql="insert into admin_permissions(permission_id,admin_id)
                        values('5','$id')";
                      $this->db->query($sql);
                      $sql1="insert into admin_permissions(permission_id,admin_id)
                        values('9','$id')";
                      $this->db->query($sql1);
                      $data=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('six_lane',$data);
                      $this->db->insert('six_lane_double',$data);
                        $data1=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('scroll_news',$data1);
                    break;
                    case 3:
                     $sql="insert into admin_permissions(permission_id,admin_id)
                        values('5','$id')";
                      $this->db->query($sql);
                      $sql1="insert into admin_permissions(permission_id,admin_id)
                        values('8','$id')";
                      $this->db->query($sql1);
                      $sql2="insert into admin_permissions(permission_id,admin_id)
                        values('10','$id')";
                      $this->db->query($sql2);
                      $dataf=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('four_lanes',$dataf);
                      $this->db->insert('four_lanes_double',$dataf);
                      $data=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('tournament',$data);
                        $data1=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('scroll_news',$data1);
                       $data2=array(
                        'user_id' => $id,
                        'setting_value' => 'IT',
                           't_interval' => 20
                        );
                      $this->db->insert('setting',$data2);
                    break;
                    case 4:
                     $sql="insert into admin_permissions(permission_id,admin_id)
                        values('5','$id')";
                      $this->db->query($sql);
                      $sql1="insert into admin_permissions(permission_id,admin_id)
                        values('9','$id')";
                      $this->db->query($sql1);
                      $sql2="insert into admin_permissions(permission_id,admin_id)
                        values('10','$id')";
                      $this->db->query($sql2);
                      $dataf=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('six_lane',$dataf);
                      $this->db->insert('six_lane_double',$dataf);
                      $data=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('tournament',$data);
                        $data1=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('scroll_news',$data1);
                       $data2=array(
                        'user_id' => $id,
                           't_interval' => 20,
                        'setting_value' => 'IT'
                        );
                      $this->db->insert('setting',$data2);
                    break;
                    case 5:
                     $sql="insert into admin_permissions(permission_id,admin_id)
                        values('5','$id')";
                      $this->db->query($sql);
                      $sql1="insert into admin_permissions(permission_id,admin_id)
                        values('10','$id')";
                      $this->db->query($sql1);
                      $sql2="insert into admin_permissions(permission_id,admin_id)
                        values('11','$id')";
                      $this->db->query($sql2);
                      $sql3="insert into admin_permissions(permission_id,admin_id)
                        values('8','$id')";
                      $this->db->query($sql3);
                       $dataf=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('four_lanes',$dataf);
                      $this->db->insert('four_lanes_double',$dataf);
                      $data=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('tournament',$data);

                      $data1=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('scroll_news',$data1);
                       $data2=array(
                        'user_id' => $id,
                           't_interval' => 20,
                        'setting_value' => "ITS"
                        );
                      $this->db->insert('setting',$data2);
                     
                    break;
                    case 6:
                     $sql="insert into admin_permissions(permission_id,admin_id)
                        values('5','$id')";
                      $this->db->query($sql);
                      $sql1="insert into admin_permissions(permission_id,admin_id)
                        values('10','$id')";
                      $this->db->query($sql1);
                      $sql2="insert into admin_permissions(permission_id,admin_id)
                        values('11','$id')";
                      $this->db->query($sql2);
                      $sql3="insert into admin_permissions(permission_id,admin_id)
                        values('9','$id')";
                      $this->db->query($sql3);
                       $dataf=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('six_lane',$dataf);
                      $this->db->insert('six_lane_double',$dataf);
                      $data=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('tournament',$data);

                      $data1=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('scroll_news',$data1);
                       $data2=array(
                        'user_id' => $id,
                           't_interval' => 20,
                        'setting_value' => "ITS"
                        );
                      $this->db->insert('setting',$data2);
                    break;
                    case 7:
                     $sql="insert into admin_permissions(permission_id,admin_id)
                        values('5','$id')";
                      $this->db->query($sql);
                      $sql2="insert into admin_permissions(permission_id,admin_id)
                        values('11','$id')";
                      $this->db->query($sql2);
                      $sql3="insert into admin_permissions(permission_id,admin_id)
                        values('8','$id')";
                      $this->db->query($sql3);
                       $dataf=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('four_lanes',$dataf);
                      $data1=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('scroll_news',$data1);
                       $data2=array(
                        'user_id' => $id,
                           't_interval' => 20,
                        'setting_value' => A
                        );
                      $this->db->insert('setting',$data2);
                    break;
                    case 8:
                     $sql="insert into admin_permissions(permission_id,admin_id)
                        values('5','$id')";
                      $this->db->query($sql);
                      $sql2="insert into admin_permissions(permission_id,admin_id)
                        values('11','$id')";
                      $this->db->query($sql2);
                      $sql3="insert into admin_permissions(permission_id,admin_id)
                        values('9','$id')";
                      $this->db->query($sql3);
                       $dataf=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('six_lane',$dataf);
                      $data1=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('scroll_news',$data1);
                       $data2=array(
                        'user_id' => $id,
                        'setting_value' => A
                        );
                      $this->db->insert('setting',$data2);
                    break;
                    

                    }



                    
						        //$sql="insert into admin_permissions(permission_id,admin_id)
                    //values('$chkPermissions','$id')";
                    //die($sql);  
                    //$this->db->query($sql);
                 	
	                       	
	                       		sf('success_message', 'New admministrator account has been created.');
	                       }else{
	                       		sf('error_message', 'Sorry, there is a problem to create new administrator. Please try again later.');
	                       }
	                       redirect('admin/user/new_admin');
		                }
                       
               }else{
               		 $this->gen_contents['form_validation_error'] = validation_errors();
               }
        }
        $this->gen_contents['admin_permissions'] = $this->common_model->get_data('admin_permissions_master', '*');
          
        $this->gen_contents['script_load_page'] = 'users';
        $this->gen_contents['js_files'] = array('global/plugins/jquery-inputmask/jquery.inputmask.bundle.min.js', 'global/plugins/datatables/media/js/jquery.dataTables.min.js', 
        'global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js',
        'global/plugins/jquery-validation/js/jquery.validate.min.js', 'global/scripts/datatable.js', 'admin/layout/scripts/admins.js');
        $this->template->set_template('admin');
        $this->gen_contents['page_heading'] = 'Administrators';
        $this->gen_contents['packages_list'] = $this->common_model->get_data('packages', '*',array('package_status'=>1 ));
        $this->gen_contents['design_list'] = $this->common_model->get_data('design', '*');
        $this->gen_contents['tournament_list'] = $this->common_model->get_data('tournament_category', '*');
        $this->gen_contents['category_list'] = $this->common_model->get_data('scoring_category', '*');
        $this->gen_contents['active_main_menu'] = array('users', 'admins');
        $this->gen_contents['js_script_initial'] = "Admins.init();";
        $this->template->write_view('content', 'admin/admins/new_admin', $this->gen_contents);
        $this->template->render();
    }
    
	function password_match_admin($conf_pwd) {
        $new_pwd = $this->input->post("new_password", true);

            if ($new_pwd != $conf_pwd) {
            	$this->form_validation->set_message('password_match_admin', 'Password and confirm password does not match');
            	return FALSE;
            }
            else {
                return TRUE;
            }
    }

    function edit_admin($id=''){
        
    	(!$this->authentication->check_logged_in("admin", false) || !(admin_has_permission(3))) ? redirect('admin') : '';
    	if(empty($id)) redirect('admin/user/admins');
         $results = $this->common_model->get_data('user', '*', array('id' => $id));
         $current_package=$results[0]['package'];
         $current_design=$results[0]['design_id'];
         $current_tournament_id=$results[0]['tournament_cat_id'];
         $current_scoring_id=$results[0]['scoring_cat_id'];
         
        if (!empty($_POST)) {
        	$this->form_validation->set_rules('txtFirstName', 'first name', 'required|trim|max_length[50]');
               $this->form_validation->set_rules('txtLastName', 'last name', 'required|trim|max_length[50]');
               $this->form_validation->set_rules('txtEmail', 'email', 'required|trim|valid_email|max_length[50]|callback_email_validate');
               
               
               if(in_array($this->input->post("selectpackage", true), array(5,6))){        
                $this->form_validation->set_rules('selectscoring', 'Select scoring', 'required|trim|max_length[50]');
               }       
              if ($this->form_validation->run() == TRUE) {  //form validation
               	$logo = $this->input->post("logo", true);
                $scoring_double = $this->input->post("scoring_double", true);
                if($scoring_double =='')
                    {
                    $scoring_double=0;
                    }
                if($logo =='')
                    {
                      $logo=0;
                    }
               	$user_status = array('1', '2');
               		$this->load->library('user_agent');
                        if(($this->input->post("selectpackage")== 1) || ($this->input->post("selectpackage")== 2) ){
	                  $data = array(
                       'fname'      => $this->input->post("txtFirstName", true), 
                       'lname'       => $this->input->post("txtLastName", true),
                       'email'           => $this->input->post("txtEmail", true), 
                       'phone'           => $this->input->post("txtPhone", true), 
                       'package' => $this->input->post("selectpackage", true),
                       'design_id' => $this->input->post("selectdesign", true),
                       'logo' => $logo,
                       'scoring_double_status' => $scoring_double,
	               //'ip_address' => $this->input->ip_address(),
	               'admin'	=> '1' 
                       );
              }else{
                   $data = array(
                       'fname'      => $this->input->post("txtFirstName", true), 
                       'lname'       => $this->input->post("txtLastName", true),
                       'email'           => $this->input->post("txtEmail", true), 
                       'phone'           => $this->input->post("txtPhone", true), 
                       'package' => $this->input->post("selectpackage", true),
                       'design_id' => $this->input->post("selectdesign", true),
                       'scoring_cat_id' => $this->input->post("selectscoring", true),
                       'tournament_cat_id' => $this->input->post("selecttournament", true),
                       'logo' => $logo,
                       'scoring_double_status' => $scoring_double,
	               //'ip_address' => $this->input->ip_address(),
	               'admin'	=> '1' 
                       );
              }
                    // checking profile pic change
                       if (!empty($_FILES['flProfielImage'])) {
		                    $this->load->helper('image_helper');
		                    if ($_FILES['flProfielImage']['name'] != '') {
		                        $upload_status = upload_image('admin_profile', 'flProfielImage');
		                    }
		                } 
		                if (!empty($upload_status['file_name'])) {
		                    $old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
		                    $data['profile_image'] = $upload_status['file_name'];
		                }
						
		                if (!empty($upload_status['upload_error'])) {
		                    $this->gen_contents['form_validation_error'] = $upload_status['upload_error'];
		                }
		                else {
			        $status = $this->db->update('user', $data, array('id' => $id));
	                       if($status){
	                       	 $batch_array = array();
                    // checking tournament category change
                        $tournament_new_id = $this->input->post('selecttournament', true);   	   
                    if($tournament_new_id != $current_tournament_id){
                          $content=array(
                            'all_data'=> ''
                        );
                        $update_user=$this->db->update('tournament',$content,array('user_id' => $id));
                      }
                    // checking scoring category change
                        $scoring_new_id = $this->input->post('selectscoring', true);   	   
                    if($scoring_new_id != $current_scoring_id){
                          $content=array(
                            'all_data'=> ''
                        );
                        $update_user=$this->db->update('scoring',$content,array('user_id' => $id));
                      }
                    // checking package change
                    $chkPermissions = $this->input->post('selectpackage', true);
                    if($chkPermissions != $current_package){
                        //die("testing");
                        $premission=$this->db->delete('admin_permissions', array('admin_id' => $id));
                        $fourlane = $this->db->delete('four_lanes', array('user_id' => $id));
                        $sixlane = $this->db->delete('six_lane', array('user_id' => $id));
                        $fourlane_double = $this->db->delete('four_lanes_double', array('user_id' => $id));
                        $sixlane_double = $this->db->delete('six_lane_double', array('user_id' => $id));
                        $tournament = $this->db->delete('tournament', array('user_id' => $id));
                        $scoring = $this->db->delete('scoring', array('user_id' => $id));
                        $scoring_double = $this->db->delete('scoring_double', array('user_id' => $id));
                        $scrollnews = $this->db->delete('scroll_news', array('user_id' => $id));
                        $setting = $this->db->delete('setting', array('user_id' => $id));
                        $status_user=array(
                            'fourlane_double_status'=>0,
                            'sixlane_double_status'=>0,
                            'scoring_double_status'=>0,
                            'scoring_cat_id' =>0,
                            'tournament_cat_id' =>0
                        );
                        $update_user=$this->db->update('user',$status_user,array('id' => $id));
                    switch($chkPermissions){
                        case 1:
                    $sql="insert into admin_permissions(permission_id,admin_id)
                        values('5','$id')";
                      $this->db->query($sql);
                      $sql1="insert into admin_permissions(permission_id,admin_id)
                        values('8','$id')";
                      $this->db->query($sql1);

                      $data=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('four_lanes',$data);
                      $this->db->insert('four_lanes_double',$data);
                      $data1=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('scroll_news',$data1);
                    break;
                    case 2:
                    $sql="insert into admin_permissions(permission_id,admin_id)
                        values('5','$id')";
                      $this->db->query($sql);
                      $sql1="insert into admin_permissions(permission_id,admin_id)
                        values('9','$id')";
                      $this->db->query($sql1);
                      $data=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('six_lane',$data);
                      $this->db->insert('six_lane_double',$data);
                        $data1=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('scroll_news',$data1);
                    break;
                    case 3:
                     $sql="insert into admin_permissions(permission_id,admin_id)
                        values('5','$id')";
                      $this->db->query($sql);
                      $sql1="insert into admin_permissions(permission_id,admin_id)
                        values('8','$id')";
                      $this->db->query($sql1);
                      $sql2="insert into admin_permissions(permission_id,admin_id)
                        values('10','$id')";
                      $this->db->query($sql2);
                      $dataf=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('four_lanes',$dataf);
                      $this->db->insert('four_lanes_double',$dataf);
                      $data=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('tournament',$data);
                        $data1=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('scroll_news',$data1);
                       $data2=array(
                        'user_id' => $id,
                           't_interval' => 20,
                        'setting_value' => 'IT'
                        );
                      $this->db->insert('setting',$data2);
                    break;
                    case 4:
                     $sql="insert into admin_permissions(permission_id,admin_id)
                        values('5','$id')";
                      $this->db->query($sql);
                      $sql1="insert into admin_permissions(permission_id,admin_id)
                        values('9','$id')";
                      $this->db->query($sql1);
                      $sql2="insert into admin_permissions(permission_id,admin_id)
                        values('10','$id')";
                      $this->db->query($sql2);
                      $dataf=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('six_lane',$dataf);
                      $this->db->insert('six_lane_double',$dataf);
                      $data=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('tournament',$data);
                        $data1=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('scroll_news',$data1);
                       $data2=array(
                        'user_id' => $id,
                           't_interval' => 20,
                        'setting_value' => 'IT'
                        );
                      $this->db->insert('setting',$data2);
                    break;
                    case 5:
                     $sql="insert into admin_permissions(permission_id,admin_id)
                        values('5','$id')";
                      $this->db->query($sql);
                      $sql1="insert into admin_permissions(permission_id,admin_id)
                        values('10','$id')";
                      $this->db->query($sql1);
                      $sql2="insert into admin_permissions(permission_id,admin_id)
                        values('11','$id')";
                      $this->db->query($sql2);
                      $sql3="insert into admin_permissions(permission_id,admin_id)
                        values('8','$id')";
                      $this->db->query($sql3);
                       $dataf=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('four_lanes',$dataf);
                      $this->db->insert('four_lanes_double',$dataf);
                      $data=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('tournament',$data);

                      $data1=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('scroll_news',$data1);
                       $data2=array(
                        'user_id' => $id,
                           't_interval' => 20,
                        'setting_value' => "ITS"
                        );
                      $this->db->insert('setting',$data2);
                     
                      //updating so that scorng_cat_id will be seleected for 5&6 package
                      $status_user=array(
                            'scoring_cat_id' => $this->input->post("selectscoring")
                        );
                        $update_user=$this->db->update('user',$status_user,array('id' => $id));
                      
                    break;
                    case 6:
                     $sql="insert into admin_permissions(permission_id,admin_id)
                        values('5','$id')";
                      $this->db->query($sql);
                      $sql1="insert into admin_permissions(permission_id,admin_id)
                        values('10','$id')";
                      $this->db->query($sql1);
                      $sql2="insert into admin_permissions(permission_id,admin_id)
                        values('11','$id')";
                      $this->db->query($sql2);
                      $sql3="insert into admin_permissions(permission_id,admin_id)
                        values('9','$id')";
                      $this->db->query($sql3);
                       $dataf=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('six_lane',$dataf);
                      $this->db->insert('six_lane_double',$dataf);
                      $data=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('tournament',$data);

                      $data1=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('scroll_news',$data1);
                       $data2=array(
                        'user_id' => $id,
                           't_interval' => 20,
                        'setting_value' => "ITS"
                        );
                      $this->db->insert('setting',$data2);
                      
                      
                      //updating so that scorng_cat_id will be seleected for 5&6 package
                      $status_user=array(
                            'scoring_cat_id' => $this->input->post("selectscoring")
                        );
                        $update_user=$this->db->update('user',$status_user,array('id' => $id));
                      
                    break;
                 }
                    }	        
                                                        
                                               
                                                        
                                                        
	                       	
                                    if (!empty($old_image_name[0]['profile_image'])) {  
                                    // Remove old images 
                                    delete_image('admin_profile', $old_image_name[0]['profile_image']);
                                    }
                                    sf('success_message', 'Admministrator account has been updated.');
	                       
	                       redirect('admin/user/edit_admin/'.$id);
                                } }
                       
               }else{
               		 $this->gen_contents['form_validation_error'] = validation_errors();
               }
        
        }	
        

        if(empty($results)) redirect('admin/user/admins');
        $this->gen_contents['admin_permissions_master'] = $this->common_model->get_data('admin_permissions_master', '*');
        $this->gen_contents['admin_permissions'] = $this->common_model->get_data('admin_permissions', 'permission_id', array('admin_id' => $id));
        $this->gen_contents['results'] = $results[0];
        $this->gen_contents['script_load_page'] = 'users';
        $this->gen_contents['js_files'] = array('global/plugins/jquery-inputmask/jquery.inputmask.bundle.min.js', 'global/plugins/datatables/media/js/jquery.dataTables.min.js', 
        'global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js',
        'global/plugins/jquery-validation/js/jquery.validate.min.js', 'global/scripts/datatable.js', 'admin/layout/scripts/admins.js');
        $this->template->set_template('admin');
        $this->gen_contents['page_heading'] = 'Administrators';
        $this->gen_contents['packages_list'] = $this->common_model->get_data('packages', '*',array('package_status'=>1 ));
        if(($current_package ==1) || ($current_package ==3) || ($current_package ==5)){
            $this->gen_contents['design_list'] = $this->common_model->get_data('design', '*', array('lane_type' => 4));
        }else{
            $this->gen_contents['design_list'] = $this->common_model->get_data('design', '*', array('lane_type' => 6));
        }
         $this->gen_contents['tournament_list'] = $this->common_model->get_data('tournament_category', '*');
         $this->gen_contents['category_list'] = $this->common_model->get_data('scoring_category', '*');
        $this->gen_contents['active_main_menu'] = array('users', 'admins');
        $this->gen_contents['page_breadcrumb'] = array(array('link' => 'user/admins', 'label' => 'Administrators'), array('link' => '#', 'label' => 'Edit Administrator'));
        $this->gen_contents['js_script_initial'] = "Admins.init();";
        $this->template->write_view('content', 'admin/admins/edit_admin', $this->gen_contents);
        $this->template->render();
    }
    
    function email_validate($email){
    	$id = $this->input->post('txtHiddenId', true);
    	$where = array('email' => $email);
    	if(!empty($id)) $where['id !='] = $id;
    	$email_exists = $this->common_model->get_data('user', 'email', $where);
   		if (!empty($email_exists)) {
            	$this->form_validation->set_message('email_validate', 'Already admministrator with same email exists.');
            	return FALSE;
            }
            else {
                return TRUE;
            }
    }
     function domain_validate($domain){
      $id = $this->input->post('txtHiddenId', true);
      $where = array('domian' => $domain);
      if(!empty($id)) $where['id !='] = $id;
      $email_exists = $this->common_model->get_data('user', 'domian', $where);
      if (!empty($email_exists)) {
              $this->form_validation->set_message('domain_validate', 'Already domain exists.');
              return FALSE;
            }
            else {
                return TRUE;
            }
    }
	function username_validate($username){
    	$id = $this->input->post('txtHiddenId', true);
    	$where = array('username' => $username);
    	if(!empty($id)) $where['admin_id !='] = $id;
    	$email_exists = $this->common_model->get_data('admin_user_details', 'username', $where);
   		if (!empty($email_exists)) {
            	$this->form_validation->set_message('username_validate', 'Already admministrator with same username exists.');
            	return FALSE;
            }
            else {
                return TRUE;
            }
    }
    
    function select_design(){
        
        $package_id=$_POST["package_id"];
        if(($package_id==1) || ($package_id==3) || ($package_id==5))
        {
            $lane_type=array('lane_type' => 4);
            //$lane_type=4;
        }else{
            $lane_type=array('lane_type' => 6);
            //$lane_type=6;
        }
        
        
        $query = $this->common_model->get_data('design', '*', $lane_type);
      // print_r($query);
       if(!empty($query)){
           echo '<option value="">--Select Design--</option>';
           foreach($query as $a){
               echo '<option value="'.$a['design_id'].'">'.$a['name_design'].'</option>';
           }
       }
        
    
}
    
    
    
    function admin_reset_password(){
    // First check user is logged 
        
        if (!$this->authentication->check_logged_in("admin", false) || !(admin_has_permission(3))) {
            $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'login_error', 'content' => 'Please login to do this action.'))));
            return;
        }
		$user_id = $this->input->post('txtAdmId', true);
        if (empty($user_id) || $user_id == '1') { // 1 is super admin
            $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'This is invalid request.'))));
            return;
        }
        $this->form_validation->set_rules('txtnew_password', 'password', 'required|trim|max_length[20]');
               $this->form_validation->set_rules('txtnew_password_confirm', 'confirm password', 'required|trim|max_length[20]|callback_reset_admin_pass');
               
               if ($this->form_validation->run() == TRUE) {  //form validation
         			//$encrypt_time = strtotime(get_cur_date_time());
	                  $password     = sha1(trim($this->input->post("txtnew_password", true)));
	                 // $password     = create_secure_password($password.$encrypt_time);
                  
	                  $data = array(
                        
                       'password'        => $password
                      // 'encrypt_time'    => $encrypt_time,
                       //'updated_date'    => get_cur_date_time(),
                       
                       );
           			$sts = $this->db->update('user', $data, array('id' => $user_id));
           			header("Content-Type: application/json");
           			$this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'success', 'content' => 'Password has been updated successfully.' ))));
            		return;
               }else{
               		header("Content-Type: application/json");
               		$this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => validation_errors() ))));
            		return;
               }
                           
    }
    
	function reset_admin_pass($conf_pwd) {
        $new_pwd = $this->input->post("txtnew_password", true);

            if ($new_pwd != $conf_pwd) {
            	$this->form_validation->set_message('reset_admin_pass', 'Password and confirm password does not match');
            	return FALSE;
            }
            else {
                return TRUE;
            }
    }
}
/* End of file welcome.php */
/* Location: ./application/controllers/Welcome.php */
