<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Function to Compress admin Javascript
 */

function load_frontend_js_files_direct($js_files = array()) {
    $ci = &get_instance();
    array_unshift($js_files, 'global/plugins/jquery.min.js', 
    'global/plugins/jquery-migrate.min.js', 
    'global/plugins/bootstrap/js/bootstrap.min.js', 
    'global/plugins/jquery-validation/js/jquery.validate.min.js', 
    'frontend/layout/scripts/back-to-top.js', 
    'global/plugins/jquery-slimscroll/jquery.slimscroll.min.js', 
    'global/plugins/jquery.blockui.min.js', 
    'global/plugins/jquery.cokie.min.js', 
    'global/plugins/uniform/jquery.uniform.min.js', 
    'global/plugins/bootstrap-switch/js/bootstrap-switch.min.js', 
    'global/plugins/bootbox/bootbox.min.js'
    );
    $js_files = array_unique($js_files);

    $act_filename = '';
    foreach ($js_files as $files) {
        if (!empty($files))
            $act_filename .= '<script type="text/javascript" src="' . c("theme_assets_url") . $files . '?v=' . c("release-version") . '"></script>' . "\n";
    }
    return $act_filename;
}

function load_frontend_css_files_direct($css_files = array()) {
    $ci = &get_instance();
    array_unshift($css_files, 'global/plugins/font-awesome/css/font-awesome.min.css', 
    'global/plugins/bootstrap/css/bootstrap.min.css', 
    'global/css/components.css', 'global/css/plugins.css', 
    'frontend/layout/css/style.css', 'frontend/pages/css/style-shop.css',
    'frontend/pages/css/style-revolution-slider.css', 'frontend/pages/css/style-layer-slider.css', 
    'frontend/layout/css/style-responsive.css',
    'frontend/layout/css/themes/blue.css',
    'frontend/layout/css/custom.css',
    'global/plugins/select2/select2.css',
    'css/style.css',
    'css/animate.min.css' 
    );
    $css_files = array_unique($css_files);
    $act_filename = '';
    foreach ($css_files as $files) {
        $act_filename .= '<link href="' . c("theme_assets_url") . $files . '?v=' . c("release-version") . '" rel="stylesheet" type="text/css">' . "\n";
    }
    return $act_filename;
}

function load_js_files_direct($js_files = array()) {
    $ci = &get_instance();
    array_unshift($js_files, 'global/plugins/jquery.min.js', 'global/plugins/jquery-migrate.min.js', 'global/plugins/jquery-ui/jquery-ui.min.js', 'global/plugins/bootstrap/js/bootstrap.min.js', 'global/plugins/bootstrap-hover-dropdown/bootstrap-hover-dropdown.min.js', 'global/plugins/jquery-slimscroll/jquery.slimscroll.min.js', 'global/plugins/jquery.blockui.min.js', 'global/plugins/jquery.cokie.min.js', 'global/plugins/uniform/jquery.uniform.min.js', 'global/plugins/bootstrap-switch/js/bootstrap-switch.min.js', 'global/plugins/bootbox/bootbox.min.js'
    );
    $js_files = array_unique($js_files);

    $act_filename = '';
    foreach ($js_files as $files) {
        if (!empty($files))
            $act_filename .= '<script type="text/javascript" src="' . c("theme_assets_url") . $files . '?v=' . c("release-version") . '"></script>' . "\n";
    }
    return $act_filename;
}

function load_css_files_direct($css_files = array()) {
    $ci = &get_instance();
    array_unshift($js_files, 'jquery-1.7.2.js', 'jquery-validation/lib/jquery.metadata.js', 'jquery-validation/jquery.validate.js', 'jquery.alerts.js', 'common.js', 'instant_search.js', 'jquery-ui.min.js', 'jquery.cookie.js', 'common_loader.js');
    $js_files = array_unique($js_files);
    $act_filename = '';
    foreach ($js_files as $files) {
        $act_filename .= '<script type="text/javascript" src="' . c("js_path_url") . $files . '?v=' . c("release-version") . '"></script>' . "\n";
    }
    return $act_filename;
}


function clear_cache() {
    $CI = &get_instance();
    $CI->output->set_header("Cache-Control: no-store, no-cache, must-revalidate, no-transform, max-age=0, post-check=0, pre-check=0");
    $CI->output->set_header("Pragma: no-cache");
}

/**
 * This function will return date & time 
 *  */
function get_cur_date_time($time=true) {
    //return ($time ==  true) ? date('Y-m-d H:i:s') : date('Y-m-d');
    if ($time)
        return date('Y-m-d H:i:s', (mktime(gmdate('H') - 7, gmdate('i'), gmdate('s'), gmdate('m'), gmdate('d'), gmdate('Y'))));
    else
        return date('Y-m-d', (mktime(gmdate('H') - 7, gmdate('i'), gmdate('s'), gmdate('m'), gmdate('d'), gmdate('Y'))));
}

if (!function_exists('admin_url')) {
    function admin_url($uri = '', $protocol = NULL) {
        return get_instance()->config->base_url($uri, $protocol) . 'admin/';
    }
}

function assets_url() {
    return get_instance()->config->item('theme_assets_url');
}

// creating password using 
function create_secure_password($pass) {
    $pass = '365Pass' . $pass;
    $hash = hash('sha256', $pass);
    return $hash;
}

/**
 * to access config settings easily
 * 
 */
function c($setting_name) {
    return get_instance()->config->item($setting_name);
}

/**
 * to access content from session easily
 * 
 */
function s($item_name) {
    return get_instance()->session->userdata($item_name);
}

/**
 * to access content from flash session easily
 * 
 */
function f($item_name) {
    return get_instance()->session->flashdata($item_name);
}

/**
 * SET SESSION - to set an item to session easily
 * 
 */
function ss($item_name, $item_value) {
    return get_instance()->session->set_userdata($item_name, $item_value);
}

/**
 * SET FLASH DATA - to set an item to session easily
 * 
 */
function sf($item_name, $item_value) {
    return get_instance()->session->set_flashdata($item_name, $item_value);
}

/**
 * KEEP FLASH DATA - to keep an item to session easily
 * 
 */
function kf($item_name) {
    return get_instance()->session->keep_flashdata($item_name);
}

/**
 * UNSET SESSION - to unset an item from session easily
 * 
 */
function us($item_name) {
    return get_instance()->session->unset_userdata($item_name);
}

/**
 * print_r() ;
 * 
 */
function p($str, $exit = false) {
    print "<pre>";
    print_r($str);
    print "</pre>";
    if ($exit)
        exit();
}

function lq(){
	echo  get_instance()->db->last_query();
}
if (!function_exists('force_ssl')) {
    function force_ssl() {
        $CI = & get_instance();
        $CI->config->config['base_url'] = str_replace('http://', 'https://', $CI->config->config['base_url']);
        $CI->config->config['site_baseurl'] = str_replace('http://', 'https://', $CI->config->config['site_baseurl']);
        $CI->config->config['js_url_path'] = str_replace('http://', 'https://', $CI->config->config['js_url_path']);
        $CI->config->config['js_path_url'] = str_replace('http://', 'https://', $CI->config->config['js_path_url']);
        $CI->config->config['css_url_path'] = str_replace('http://', 'https://', $CI->config->config['css_url_path']);
        $CI->config->config['image_url'] = str_replace('http://', 'https://', $CI->config->config['image_url']);
        if ($_SERVER['SERVER_PORT'] != 443) {
            redirect($CI->uri->uri_string());
        }
    }

}

function remove_ssl() {
    $CI = & get_instance();
    $CI->config->config['base_url'] = str_replace('https://', 'http://', $CI->config->config['base_url']);
    $CI->config->config['site_baseurl'] = str_replace('https://', 'http://', $CI->config->config['site_baseurl']);
    $CI->config->config['js_url_path'] = str_replace('https://', 'http://', $CI->config->config['js_url_path']);
    $CI->config->config['js_path_url'] = str_replace('https://', 'http://', $CI->config->config['js_path_url']);
    $CI->config->config['css_url_path'] = str_replace('https://', 'http://', $CI->config->config['css_url_path']);
    $CI->config->config['image_url'] = str_replace('https://', 'http://', $CI->config->config['image_url']);
    if ($_SERVER['SERVER_PORT'] != 80) {
        kf('success_message');
        kf('error_message');
        redirect($CI->uri->uri_string());
    }
}

function get_body_content_from_mobile() {
    $raw = "";
    // Try param
    if (isset($_POST))
    //$raw = getRequestParam("json_data");
        $raw = $_POST;

    // Try globals array
    if (!$raw && isset($_GLOBALS) && isset($_GLOBALS["HTTP_RAW_POST_DATA"]))
        $raw = $_GLOBALS["HTTP_RAW_POST_DATA"];

    // Try globals variable
    if (!$raw && isset($HTTP_RAW_POST_DATA))
        $raw = $HTTP_RAW_POST_DATA;

    // Try stream
    if (!$raw) {
        if (!function_exists('file_get_contents')) {
            $fp = fopen("php://input", "r");
            if ($fp) {
                $raw = "";
                while (!feof($fp))
                    $raw = fread($fp, 1024);
                fclose($fp);
            }
        } else
            $raw = "" . file_get_contents("php://input");
    }
    //file_put_contents('mylog.log', "\r\n >>>" . serialize($raw) . "\r\n<<<" .date('Y-m-d H:i:s') . " -RC", FILE_APPEND);

    return $raw;
}

/* Printing the gal dat on workouts section
 * 
  function print_goal_activity_json(){
  $CI =& get_instance();
  $data = $CI->db->query("SELECT id, parent_id, name FROM goals_activity WHERE parent_id != 0 AND status = 'A' ORDER BY parent_id, name ASC");
  return $data->result_array();
  }
 */

function date_readable_format($date) {
    return date('D d, M Y h:i A', strtotime($date));
}

function date_readable_format_mobile($date) {
    return date('D d M', strtotime($date));
}

function format_date_for_calendar($date, $time='', $hrs = 0) {
    if (!empty($hrs))
        $hrs = ' - ' . $hrs . ' hours';
    if (!empty($time)) {
        // $end_time = ' - '.strtotime("$time +$hrs hour");
        return date('F, d', strtotime($date)) . ' @ ' . date('h:i A', strtotime($time)).' '.c('time_zone_code').' '. $hrs;
    } else {
        return date('F, d', strtotime($date)) . $hrs;
    }
}

function make_dir($path) {
    mkdir($path, 0777);
}

function inbox_date_time($date) {
    $curr_date = get_cur_date_time(false);
    if (strtotime($curr_date) == strtotime(date('Y-m-d', strtotime($date)))) {
        return date('h:i a', strtotime($date));
        //Y-m-d H:i:s
    } else if (strtotime(date('Y', strtotime($curr_date))) == strtotime(date('Y', strtotime($date)))) {
        return date('M Y', strtotime($date));
    } else {
        return date('d/m/y', strtotime($date));
    }
}

function time_passed($timestamp) {
    //type cast, current time, difference in timestamps
    $timestamp = (int) $timestamp;
    $current_time = strtotime(get_cur_date_time()); //time();
    $diff = $current_time - $timestamp;

    //intervals in seconds
    $intervals = array(
        'year' => 31556926, 'month' => 2629744, 'week' => 604800, 'day' => 86400, 'hour' => 3600, 'minute' => 60
    );

    //now we just find the difference
    if ($diff == 0) {
        return 'just now';
    }

    if ($diff < 60) {
        return $diff == 1 ? $diff . ' second ago' : $diff . ' seconds ago';
    }

    if ($diff >= 60 && $diff < $intervals['hour']) {
        $diff = floor($diff / $intervals['minute']);
        return $diff == 1 ? $diff . ' minute ago' : $diff . ' minutes ago';
    }

    if ($diff >= $intervals['hour'] && $diff < $intervals['day']) {
        $diff = floor($diff / $intervals['hour']);
        return $diff == 1 ? $diff . ' hour ago' : $diff . ' hours ago';
    }

    if ($diff >= $intervals['day'] && $diff < $intervals['week']) {
        $diff = floor($diff / $intervals['day']);
        return $diff == 1 ? $diff . ' day ago' : $diff . ' days ago';
    }

    if ($diff >= $intervals['week'] && $diff < $intervals['month']) {
        $diff = floor($diff / $intervals['week']);
        return $diff == 1 ? $diff . ' week ago' : $diff . ' weeks ago';
    }

    if ($diff >= $intervals['month'] && $diff < $intervals['year']) {
        $diff = floor($diff / $intervals['month']);
        return $diff == 1 ? $diff . ' month ago' : $diff . ' months ago';
    }

    if ($diff >= $intervals['year']) {
        $diff = floor($diff / $intervals['year']);
        return $diff == 1 ? $diff . ' year ago' : $diff . ' years ago';
    }
}

function print_rating($rating){ 
    $rating = roundDownToHalf($rating);
    $total_star = 5;
    $ratings = explode('.', $rating);
    $html = '';
    for($i = 1; $i <= $ratings[0]; $i++){
        $html .= '<i class="fa fa-star" data-prev-rating-class="fa fa-star"></i>';
        $total_star -= 1;
    }
    if(!empty($ratings[1])){
        $html .= '<i class="fa fa-star-half-full" data-prev-rating-class="fa fa-star-half-full"></i>';
        $total_star -= 1;
    }
    for($i = (5-$total_star)+1; $i <= 5; $i++){
        $html .= '<i data-prev-rating-class="fa fa-star-o" class="fa fa-star-o"></i>';
    }
    return $html;
}

function roundDownToHalf($number) {
    
     $remainder = ($number * 10) % 10;
     $half = $remainder >= 5 ? 0.5 : 0;
     $value = floatval(intval($number) + $half);
     if($half > 0){
        return number_format($value, 1, '.', '');
     }else{
         return $value;
     }
}

 
 function is_start_date_over($from_date){
     $curr_date = get_cur_date_time();
     if(strtotime($curr_date) > strtotime($from_date)){
         return true;
     }else{
         return false;
     }
     
 }
 
 //This function transforms the php.ini notation for numbers (like '2M') to an integer (2*1024*1024 in this case)  
function convertPHPSizeToBytes($sSize)  
{  
    if ( is_numeric( $sSize) ) {
       return $sSize;
    }
    $sSuffix = substr($sSize, -1);  
    $iValue = substr($sSize, 0, -1);  
    switch(strtoupper($sSuffix)){  
    case 'P':  
        $iValue *= 1024;  
    case 'T':  
        $iValue *= 1024;  
    case 'G':  
        $iValue *= 1024;  
    case 'M':  
        $iValue *= 1024;  
    case 'K':  
        $iValue *= 1024;  
        break;  
    }  
    return $iValue;  
}  

function getMaximumFileUploadSize()  
{  
    return min(convertPHPSizeToBytes(ini_get('post_max_size')), convertPHPSizeToBytes(ini_get('upload_max_filesize')));  
}  

function formatBytes($size, $precision = 2)
{
    $base = log($size, 1024);
    $suffixes = array('B', 'Kb', 'MB', 'GB', 'TB', 'PB');   
    return round(pow(1024, $base - floor($base)), $precision) . $suffixes[floor($base)];
}

function fncEncrypt_data($array){
    $array = str_replace( array("&#39;", "&quot;"),array("'", '"'), $array);
    $encoded = serialize($array);
    $encoded = base64_encode($encoded);
    $encoded = urlencode($encoded);
    return $encoded;
}

function fncDecrypt_data($encrypted){
    if (!empty($encrypted)){  
        ///$encrypted = str_replace(array("'", '"'), array("&#39;", "&quot;"), $encrypted);
        $uncrypted = urldecode($encrypted);
        $uncrypted = base64_decode($uncrypted);
        $uncrypted = unserialize($uncrypted);
        //$uncrypted = str_replace(array("'", '"'), array("&#39;", "&quot;"), $uncrypted);
        return $uncrypted;
    }
    return $encrypted;
}    

function encrypt_url_string($string){
	return fncEncrypt_data(time().'-'.$string);
}
function decrypt_url_string($string){
    die("test");
	if(empty($string)) return '';
	$original	= '';
	list(, $original) = explode('-', fncDecrypt_data($string));
	 
	return $original;
}
function nl2comma($str){
    $str = nl2br($str);
    $str = str_replace('<br />', ',', $str); 
    return substr(trim($str), 0, -1);
}

function remove_temp_images(){
    $files = glob(c('file_upload_path').'temp_crop/*');
    $now   = time();

    foreach ($files as $file){
        if (is_file($file)){
            if ($now - filemtime($file) >= 60*60*24*5) // 2 days 
            {
                unlink($file);
            }
        }
    }
}

function get_admin_image($image_name, $category = 0, $thumb_type = ''){
    $workout_img_path = c('file_upload_path') . 'admin/';
    $workout_img_url = c('file_upload_url') . 'admin/';
    if(!empty($image_name) && file_exists($workout_img_path.$thumb_type.$image_name)){
        return $workout_img_url.$image_name;
    }
   $default_images = $workout_img_url.'default.jpg';
   if(isset($default_images[$category]))
   return assets_url().'default/'.$thumb_type.@$default_images[$category];
   //else return assets_url().'default/'.$thumb_type.$category;
    
}

function print_permissions($items, $parentId, $selected_ids = array()){
    foreach($items as $item){
        if($item['parent_id']==$parentId){
        	$select = (in_array($item['id'], $selected_ids)) ? 'checked' : '';
            print '<li> <input '.$select.' type="checkbox" class="form-control" value="'.$item['id'].'" name="chkPermissions[]" id="chkPermissions'.$item['id'].'">';
            print $item['label']; //or whatever you want about the current node
            print '<ul>';
            print_permissions($items, $item['id'], $selected_ids);
            print '</ul></li>';
        }
    }
}

function admin_has_permission($permission_id){
	$CI = & get_instance();
	return $CI->authentication->admin_has_permission($permission_id);
}

	function get_material_description($id){
      $CI = & get_instance();
        $data = $CI->db->query("SELECT description FROM material WHERE id = $id");
        return $data->result_array();
    }
    
    function get_all_bonus_parts($part_id){
    	$CI = & get_instance();
    	$data = $CI->db->query("SELECT * FROM bonus_part WHERE part_id = '$part_id'");
    	return $data->result_array();
    }
    
    function load_state($selected = ''){
    	$CI = & get_instance();
        $data = $CI->db->query("SELECT state_code, state_name FROM state ");
        $state_list = $data->result_array();
        /*
        $state_list = array (
             'AK' => 'Alaska','AL' => 'Alabama', 'AR' => 'Arkansas' ,'AZ' => 'Arizona' ,'CA' => 'California',   
         	 'CO' => 'Colorado' ,'CT' => 'Connecticut' ,'DC' => 'DC' ,'DE' => 'Delaware' ,'FL' => 'Florida',   
         	 'GA' => 'Georgia' ,'HI' => 'Hawaii','IA' => 'Iowa' ,'ID' => 'Idaho' ,'IL' => 'Illinois' ,'IN' => 'Indiana',   
         	 'KS' => 'Kansas' ,'KY' => 'Kentucky' ,'LA' => 'Louisiana' ,'MA' => 'Massachusetts'  ,'MD' => 'Maryland' ,'ME' => 'Maine'
         	 ,'MI' => 'Michigan'  ,'MN' => 'Minnesota' 
             ,'MO' => 'Missouri'   ,'MS' => 'Mississippi' 
             ,'MT' => 'Montana'  ,'NC' => 'North Carolina'
             ,'ND' => 'North Dakota'  ,'NE' => 'Nebraska'
             ,'NH' => 'New Hampshire'  ,'NJ' => 'New Jersey' ,'NM' => 'New Mexico'  ,'NV' => 'Nevada'  ,'NY' => 'New York' ,'OH' => 'Ohio' ,'OK' => 'Oklahoma' 
             ,'OR' => 'Oregon' ,'PA' => 'Pennsylvania' ,'PR' => 'Puerto Rico' ,'RI' => 'Rhode Island'
             ,'SC' => 'South Carolina' 
             ,'SD' => 'South Dakota' 
             ,'TN' => 'Tennessee'
             ,'TX' => 'Texas'  
             ,'UT' => 'Utah'  
             ,'VA' => 'Virginia'  
             ,'VT' => 'Vermont'  
             ,'WA' => 'Washington'  
             ,'WI' => 'Wisconsin'  
             ,'WV' => 'West Virginia' 
             ,'WY' => 'Wyoming'  );
             */
             $select = '';
             //foreach($state_list as $k => $v){
             foreach($state_list as $state){
             	$sel = ($selected == $state['state_code']) ? 'selected' : '';
             	$select .= '<option '.$sel.' value="'.$state['state_code'].'">'.$state['state_name'].'</option>';
             }
             
             return $select;
    }
    
    function select_shipping($sel = ''){
    	$shppings = array('0.00' => 'Pickup ($0.00)', '6.95' => '3-5 Day ($6.95)', '16.95' => '2 Day ($16.95)', '37.95' => 'Next Day ($37.95)'  );
    	echo "<select class='form-control' name=\"shipping\" id=\"shipping\" >";
    	
                     foreach($shppings as $k => $v){
                     	
                     		$selected = ($sel == $k) ? 'selected' : '';
                     	
                     	echo '<option '.$selected.' value="'.$k.'">'.$v.'</option>';
                     }
                    echo "</select>";
    }
    
     
    
    function get_fdm_materials(){
    	$CI = & get_instance();
    	//$data = $CI->db->query("SELECT id, description FROM material WHERE process = '1' AND active = '1'");
    	$data = $CI->db->query("SELECT id, description FROM material WHERE category_id = '1' AND active = '1'");
    	$data = $data->result_array();
    	foreach($data as $dt){
    		echo '<option value="'.$dt['id'].'">'.$dt['description'].'</option>';
    	}
    	 
    }
    
    function get_polyjet_materials(){
    	$CI = & get_instance();
    	//$data = $CI->db->query("SELECT id, description FROM material WHERE process = '2' AND active = '1'");
    	$data = $CI->db->query("SELECT id, description FROM material WHERE category_id = '2' AND active = '1'");
    	$data = $data->result_array();
    	foreach($data as $dt){
    		echo '<option value="'.$dt['id'].'">'.$dt['description'].'</option>';
    	}
    	
    }
    
    function get_user_commission($user_id){
    	$CI = & get_instance();
    	$data = $CI->db->query("SELECT commission_rate FROM user WHERE id = '$user_id' ");
    	$data = $data->result_array();
    	return @$data[0]['commission_rate']; 
    }
    
    function get_bonus_parts_count($part_id){
    	$CI = & get_instance();
    	$data = $CI->db->query("SELECT COUNT(part_id) AS cnt  FROM bonus_part WHERE part_id = '$part_id'");
    	$data = $data->result_array();
    	return $data[0]['cnt'];
    }
    
    function get_promo($code, $status =''){
    	$where = '';
    	if(!empty($status)){
    		if($status == 'A' || $status == 'D'){
    			$where = " AND status = 'A' ";
    		}
    	}
    	$CI =& get_instance();
    	$query = "SELECT * FROM promo WHERE code = '{$code}' $where LIMIT 1";
    	$data = $CI->db->query($query);
    	return $data->result_array();
        
    }
    function is_promo_used($quote_id)
    {
        $CI = & get_instance();
        $query = "SELECT COUNT(*) as cnt FROM promo_user WHERE quote_id = '$quote_id'";
        $data = $CI->db->query($query);
        $data = $data->result_array();
    	return $data[0]['cnt'];
    }
    
    function delete_empty_part($part_id){
    	$CI = & get_instance();
        $query = "DELETE FROM part WHERE id = '$part_id'";
        $data = $CI->db->query($query);
    }
    
    function addDayswithdate($date, $days = 30){

	    $date = strtotime("+".$days." days", strtotime($date));
	    return  date("Y-m-d H:i:s", $date);

	}
	
	function lessDayswithdate($date, $days = 30){

	    $date = strtotime("-".$days." days", strtotime($date));
	    return  date("Y-m-d H:i:s", $date);

	}
	
	function canvas_to_image($data, $file_name){
        $upload_path = c('file_upload_path').'STL/images';
        $data = str_replace('data:image/png;base64,', '', $data);
        $data = str_replace('data:octet-stream;base64,', '', $data);
	 	$data = str_replace(' ', '+', $data);
		$data =  base64_decode( $data);	 
        @file_put_contents($upload_path.'/'.$file_name,  $data);
        
        return true;
    }
    
    function get_stl_image_url($image){
    	if(empty($image)) return '';
    	$upload_path = c('file_upload_path').'STL/images/';
    	
    	if(strtolower( substr(trim($image), 0, 7)) == 'http://' || strtolower( substr(trim($image), 0, 8)) == 'https://'){
			return $image;	 
		}
    	
    	if(file_exists($upload_path.$image)){
    		return   c('file_upload_url').'STL/images/'.$image;
    	}

    	return '';
    	
    }
    
    function get_all_admins() {
	  	$CI = & get_instance();
		$query = "SELECT id, fname, lname, email FROM user WHERE admin > '0'";
		$data = $CI->db->query($query);
        $data = $data->result_array();
        
        $select = '<select name="txtOnBehalfOf" id="txtOnBehalfOf" class="form-control">';
        if(!empty($data)){
        	for($i= 0; $i < count($data); $i++ ){
        		 $name = $data[$i]['fname'].' '.$data[$i]['lname'].' ('.$data[$i]['email'].')';
        		 $select .= '<option value="'.$data[$i]['id'].'">'.$name.'</option>';
        	}
        } 
        $select .= '</select>';
        
        return $select;
	} 
    
	function set_null($val, $default = ''){
    
	    return empty($val) ? $default : $val;
	}
	
	function print_progress_bar($width = 0){
		return ' 
		<div class="progress">
		  <div class="progress-bar progress-bar-success" role="progressbar" aria-valuenow="'.$width.'" aria-valuemin="0" aria-valuemax="100" style="width: '.$width.'%;">
		    '.$width.'%
		  </div>
		</div> '; 
		 
	}
	function get_billing_shipping_address($quote_id)
    {
    	$CI = & get_instance();	
		$data = $CI->db->query("SELECT * FROM shipping_billing_address WHERE quote_id = '{$quote_id}' LIMIT 1");
        return $data->result_array();
    }
	function format_shipping_billing($billing_shipping, $user_details){
		
		if(empty($billing_shipping) && empty($user_details)){
			$data = array(
				'b_name' => '',
				'b_company_name' => '', 
				'b_address' => '', 
				'b_address2' => '',
				'b_city' => '',
				'b_state' => '',
				'b_country' => '',
				'b_phone' => '',
				'b_pin' => '',	
			
				's_name' => '',
				's_company_name' => '', 
				's_address' => '', 
				's_address2' => '',
				's_city' => '',
				's_state' => '',
				's_country' => '',
				's_phone' => '',
				's_pin' => '',  
			); 
			return $data;
		}
		 
		$data = array();
		if(empty($billing_shipping)){
			$data = array(
				'user_id' => $user_details['id'], 
				'b_name' => $user_details['fname'].' '.$user_details['lname'],
				'b_company_name' => $user_details['company_name'], 
				'b_address' => $user_details['address'], 
				'b_address2' => $user_details['address2'],
				'b_city' => $user_details['city'],
				'b_state' => $user_details['state'],
				'b_country' => $user_details['country'],
				'b_phone' => $user_details['phone'],
				'b_pin' => $user_details['zip'],	
			
				's_name' => $user_details['fname'].' '.$user_details['lname'],
				's_company_name' => $user_details['company_name'], 
				's_address' => $user_details['address'], 
				's_address2' => $user_details['address2'],
				's_city' => $user_details['city'],
				's_state' => $user_details['state'],
				's_country' => $user_details['country'],
				's_phone' => $user_details['phone'],
				's_pin' => $user_details['zip']  
			); 
		}else{
			$data = array(
				'user_id' => $billing_shipping['user_id'],
				'b_name' => $billing_shipping['billing_name'],
				'b_company_name' => '', 
				'b_address' => $billing_shipping['billing_address'], 
				'b_address2' => $billing_shipping['billing_address1'],
				'b_city' => $billing_shipping['billing_city'],
				'b_state' => $billing_shipping['billing_state'],
				'b_country' => $billing_shipping['billing_country'],
				'b_phone' => $billing_shipping['billing_phone'],
				'b_pin' => $billing_shipping['billing_zipcode'],	
			
				's_name' => $billing_shipping['shipping_name'],
				's_company_name' => '', 
				's_address' => $billing_shipping['shipping_address'], 
				's_address2' => $billing_shipping['shipping_address2'],
				's_city' => $billing_shipping['shipping_city'],
				's_state' => $billing_shipping['shipping_state'],
				's_country' => $billing_shipping['shipping_country'],
				's_phone' => $billing_shipping['shipping_phone'],
				's_pin' => $billing_shipping['shipping_zipcode']  
			); 
		}
		
		return $data;
	}
	function get_user_profile_image($image_name, $type ){
		
		if(!empty($image_name) && file_exists(c('file_upload_path').$type.$image_name)){
			return c('file_upload_url').$type.$image_name;	
		}else{
			return assets_url().'images/default-avatar.png';
		}
	}
	
	function get_shopping_cart_items($user_id){
		$CI = & get_instance();
		$CI->load->model('admin/orders_model');
		$where = array('q.payment_received !=' => '1', 'q.user_id =' => $user_id); //, 'is_in_shopping_cart' => 'Y'
        $like_search = array();
        return $CI->orders_model->list_orders(0, 1, $where, $like_search, false);
        
		//$data = $CI->db->query("SELECT id, FROM quote WHERE payment_received =! '1' AND is_in_shopping_cart = 'Y' AND user_id = '{$user_id}' LIMIT 1");
        //return $data->result_array();
	}
	function is_customer_has_tax_exception($customer_id){
		$CI = & get_instance();	
		$data = $CI->db->query("SELECT tax_exception FROM user WHERE id = '{$customer_id}' ");
        $data = $data->result_array();
        return @$data[0]['tax_exception'];
	}
	function calculate_customer_tax($state,  $price = 0, $tax_exception = 'N', $tax_percentage = '0'){
 
		$tax = '0.00';
		if($tax_percentage > 0){ // THIS MEANS ADMIN HAS EDITED TAX PERCENTAGE FOR THIS ORDER
			$state_tax = $tax_percentage;
			$tax = $price * ($state_tax / 100);
			return $tax;
		} 
		
 		if($tax_exception == 'Y'){
        	return $tax;
        }
        
        $CI = & get_instance();	
		$data = $CI->db->query("SELECT tax FROM state WHERE state_code = '$state' ");
        $data = $data->result_array();
        
        if($data[0]['tax'] > 0){
        	$state_tax = $data[0]['tax'];
        	$tax = $price * ($state_tax / 100);
        	return $tax;
        }
        
        return $tax;
        /*
		if(strtoupper($state) == 'UT')
		{
			//$tax = $price * .0675;
			 $tax = $price * ($state_tax / 100);
		}
		return $tax; 
		*/
 	}
	
	function delete_part_stl_file($part_id){
		$CI = & get_instance();	
		$data = $CI->db->query("SELECT file_location FROM part WHERE id = '$part_id' ");
        $data = $data->result_array();
        $file = @$data[0]['file_location'];
        $uploaddir = c('file_upload_path').'STL/';
      //  exit($uploaddir.$file);
        if(!empty($file)){
        	@unlink($uploaddir.$file);
        }
	}
	
	function get_custom_tax_percentage($quote_id){
		$CI =& get_instance();	
		$data = $CI->db->query("SELECT tax_percentage FROM quote WHERE id = '$quote_id' ");
        $data = $data->result_array();
        return @$data[0]['tax_percentage'];
 
	}
	function get_state_tax_percentage($state){
		$CI = & get_instance();	
		$data = $CI->db->query("SELECT tax FROM state WHERE state_code = '$state' ");
        $data = $data->result_array();
        return $data[0]['tax'];
	}
	
	function get_material_config(){
		$CI = & get_instance();	
		$data = $CI->db->query("SELECT * FROM material WHERE active = '1' ");
        $data = $data->result_array();
         
        $json_data = '';
         $nl = "";
        foreach($data as $details){
        	
			if(!empty($details['sm'])){
				$json_data .= "if(material_id == ".$details['id']."){".$nl;
				$sm = json_decode  (fncDecrypt_data( $details['sm'] ));
				 
				$json_data .= 'var s_m = '.$sm[0]->sm .';'.$nl;
				$json_data .= ' if(support_multiplier <='.$sm[0]->sm_start .') {s_m = '.$sm[0]->sm_start_price .';} '.$nl;
				 
				for($i=1; $i<count($sm); $i++){
					if(!empty($sm[$i]->sm_val)){
						$json_data .= " if((support_multiplier > ".$sm[$i]->sm_con_1.") && (support_multiplier <=".$sm[$i]->sm_con_2.")) {s_m = ".$sm[$i]->sm_val.";} ".$nl;
					}
				}
				
				$json_data .= " if(support_multiplier > ".$sm[0]->sm_end."){s_m = ".$sm[0]->sm_end_price."};".$nl;
				
				$json_data .= " return s_m; }".$nl;
			}
			 
        }
        return $json_data;
       // p($json_data);
    	//return json_encode($json_data);     
	}
	function get_material_price (){
		$CI = & get_instance();	
		$data = $CI->db->query("SELECT * FROM material WHERE active = '1' ");
        $data = $data->result_array();
         
        $json_data = '';
        $nl = "";
        foreach($data as $details){
        	
			if(!empty($details['price']) ){
				$json_data .= "if(material_id == ".$details['id']."){".$nl;
				$sm = json_decode  (fncDecrypt_data( $details['price'] ));
				 
				$json_data .= "var price = ".$sm[0]->price_start.";".$nl;
				$json_data .=  " if (volume < ".$sm[0]->price_start.") {price = ".$sm[0]->price_start_price.";} ".$nl;
				 
				for($i=1; $i<count($sm); $i++){
					if(!empty($sm[$i]->price_val)){
						$json_data .= " if ((volume >= ".$sm[$i]->price_con_1.") && (volume <". $sm[$i]->price_con_2.")) {price = ".$sm[$i]->price_val.";}  ".$nl;	
					}
					
				}
				
				$json_data .= " if (volume >= ".$sm[0]->price_end.") {price = ".$sm[0]->price_end_price."} ".$nl;
				
				$json_data .= "  return price; }".$nl;
			}
			 
        }
        return $json_data;
       // p($json_data);
    	//return json_encode($json_data);     
	}
	
	function get_material_category(){
		$CI = & get_instance();	
		$data = $CI->db->query("SELECT id, category_id FROM material WHERE active = '1' ");
		$data = $data->result_array();
		$json_data = array();
		 foreach($data as $m){
		 	$json_data[$m['id']] = $m['category_id'];
		 }
		 return json_encode($json_data);
	}