<?php 
if(!function_exists('upload_image1')){
    /**
     * Function for upload all type of image
     * Function first check image allowed type, size and dimestion , if any error return error,
     * other wise it call image resizing function and last it return image name
     * @param $file_name Sring input type file name
     * @param $type String type of image
     * @param $master_dim String resize with propotional width or height
     * @return image name or error
     *		 
     */
    function upload_image1($type, $file_name, $id,$master_dim = 'width', $user_id = '', $crop_image = array(),$id){
        $user_id = empty($user_id) ? s('USER_ID') : $user_id;
        $CI 						= &get_instance();
        $master_dim					= ('height' == $master_dim) ? 'height': 'width';
        $upload_path = c('file_upload_path');
        if('admin_profile' == $type){
                $image_path				= $upload_path.'admin/';
                $thumb_image_size			= c('admin_profile_image_thumb_dimension');
        }else if('user_profile' == $type){
                $image_path				= $upload_path.'user';
                $thumb_image_size			= c('user_profile_image_thumb_dimension');
        }else if('workouts' == $type){
                $image_path				= $upload_path.'workouts';
                $thumb_image_size			= c('workout_image_thumb_dimension');
        }else if('gallery' == $type){
                $image_path				= $upload_path.'gallery/'.$user_id;
                if(!file_exists($image_path)){ make_dir($image_path); }
                $thumb_image_size			= c('gallery_image_thumb_dimension');
        }else{
            return false;
        }
        
        $config['upload_path'] 		= $image_path;
        $config['allowed_types'] 	= 'jpg|jpeg|png|JPG|JPEG|PNG|gif';
        $config['max_size'] 		= '4096';
        $config['max_width'] 		= '380';
        $config['max_height'] 		= '250';

        if(!empty($crop_image['min_width'])){
            $config['min_width'] 		= $crop_image['min_width'];
        }
        
        if(!empty($crop_image['min_height'])){
            $config['min_height'] 		= $crop_image['min_height'];
        }
        
        $config['encrypt_name'] 	= true;
        $config['max_filename'] 	= 255;

        $CI->load->library('upload', $config);
        $upload_error = array();
        if (!$CI->upload->do_upload($file_name)){
           // echo "test";
           // sf('error_message', 'Logo is too big. Please upload, maximum resolution allowed 380x135.');
            //if(s('package')==1){
            //redirect('admin/four_lane/view_image/?cid='.$id);
        //}if(s('package')==2){
          //  redirect('admin/six_lane/view_image/?cid='.$id);
        //}
           // 
           $upload_error['upload_error'] = $CI->upload->display_errors();
           echo '<pre>';
           print_r($upload_error);
            die("image");
        }else{
            $upload_image_data = $CI->upload->data();
            
            if(!empty($crop_image)){
              //  p($crop_image);
                $CI->load->library('image_lib');
                $config_crop['source_image'] = $upload_image_data['full_path'];
                $config_crop['x_axis'] = $crop_image['x'];
                $config_crop['y_axis'] = $crop_image['y'];
                $config_crop['width'] =  $crop_image['w'];
                $config_crop['height'] = $crop_image['h'];
                $config_crop['maintain_ratio'] = FALSE;
                $CI->image_lib->initialize($config_crop);

                if ( ! $CI->image_lib->crop())
                {
                   // echo $CI->image_lib->display_errors();exit;
                }
            }
            
            $create_thumbnail  =  (!create_thumbnails($upload_image_data['full_path'], $upload_image_data['file_path'], $upload_image_data['file_name'], $thumb_image_size, $master_dim));
            if(!empty($create_thumbnail['thumbanail_create_error'])){
                $upload_error['upload_error'] = $create_thumbnail['thumbanail_create_error'];
                return $upload_error;
            }
            
            $upload_error['file_name'] = $upload_image_data['file_name'];
            return $upload_error;
        }
    }
    }