<?php 
    
     if(!function_exists('upload_fourlane_design')){
    /**
     * Function for upload all type of image
     * Function first check image allowed type, size and dimestion , if any error return error,
     * other wise it call image resizing function and last it return image name
     * @param $file_name Sring input type file name
     * @param $type String type of image
     * @param $master_dim String resize with propotional width or height
     * @return image name or error
     *		 
     */
    function upload_fourlane_design($type, $file_name, $id,$master_dim = 'width', $user_id = '', $crop_image = array(),$id){
        
        $user_id = 6;
        
        $CI 						= &get_instance();
        $master_dim					= ('height' == $master_dim) ? 'height': 'width';
        $upload_path = c('file_upload_path');
        if('admin_profile' == $type){
                $image_path				= $upload_path.'fourlane_design/';
                $thumb_image_size			= c('admin_profile_image_thumb_dimension');
        }else if('user_profile' == $type){
                $image_path				= $upload_path.'user';
                $thumb_image_size			= c('user_profile_image_thumb_dimension');
        }else if('workouts' == $type){
                $image_path				= $upload_path.'workouts';
                $thumb_image_size			= c('workout_image_thumb_dimension');
        }else if('gallery' == $type){
                $image_path				= $upload_path.'gallery/'.$user_id;
                if(!file_exists($image_path)){ make_dir($image_path); }
                $thumb_image_size			= c('gallery_image_thumb_dimension');
        }else{
            return false;
        }
        
        $config['upload_path'] 		= $image_path;
        $config['allowed_types'] 	= 'jpg|jpeg|png|JPG|JPEG|PNG|gif';
        $config['max_size'] 		= '50000';
        $config['max_width'] 		= '480';
        $config['max_height'] 		= '1080';

        if(!empty($crop_image['min_width'])){
            $config['min_width'] 		= $crop_image['min_width'];
        }
        
        if(!empty($crop_image['min_height'])){
            $config['min_height'] 		= $crop_image['min_height'];
        }
        
        $config['encrypt_name'] 	= true;
        $config['max_filename'] 	= 255;
        //echo '<pre>';
        //print_r($config);
        //die("test");
        $CI->load->library('upload', $config);
        //$CI->upload->initialize($config);
        $upload_error = array();
        //die("test12334");
        if (!$CI->upload->do_upload($file_name)){
           // echo "test";
            $upload_error['upload_error'] = $CI->upload->display_errors();
           //echo '<pre>';
           //print_r($upload_error);
            //die("image");
           sf('error_message', 'Logo is too big. Please upload, maximum resolution allowed.');
            redirect('admin/four_lane/design');
        }else{
            //die("reached destination");
            $upload_fourlane_design = $CI->upload->data();
            
            if(!empty($crop_image)){
              //  p($crop_image);
                $CI->load->library('image_lib');
                $config_crop['source_image'] = $upload_fourlane_design['full_path'];
                $config_crop['x_axis'] = $crop_image['x'];
                $config_crop['y_axis'] = $crop_image['y'];
                $config_crop['width'] =  $crop_image['w'];
                $config_crop['height'] = $crop_image['h'];
                $config_crop['maintain_ratio'] = FALSE;
                $CI->image_lib->initialize($config_crop);

                if ( ! $CI->image_lib->crop())
                {
                   // echo $CI->image_lib->display_errors();exit;
                }
            }
            
            $create_thumbnail  =  (!create_thumbnails($upload_fourlane_design['full_path'], $upload_fourlane_design['file_path'], $upload_fourlane_design['file_name'], $thumb_image_size, $master_dim));
            if(!empty($create_thumbnail['thumbanail_create_error'])){
                $upload_error['upload_error'] = $create_thumbnail['thumbanail_create_error'];
                return $upload_error;
            }
            
            $upload_error['file_name'] = $upload_fourlane_design['file_name'];
            return $upload_error;
        }
    }
    }

    if(!function_exists('create_thumbnails')){
        /**
         * Function to create thumbnail image
         *
         * @param string $source_full_path full path of the source file
         * @param array $arr_thumb_image_size thumbnail image dimension
         * @param string $destination
         * @param string $file_name
         * @param string $master_dim
         * @return boolean
         */
        function create_thumbnails($source_full_path, $destination, $file_name, $arr_thumb_image_size, $master_dim='width'){

            $img_size	=	getimagesize($source_full_path);
            
            $img_width	=	explode(" ",$img_size[3]);
            $get_width	=	explode("=",$img_width[0]);
            $img_original_width	=	str_replace('"',"",$get_width[1]);


            $CI 	= &get_instance();
            $config['image_library'] 	= 'gd2';
            $config['source_image'] 	= $source_full_path;
            $config['create_thumb'] 	= TRUE;
            $config['maintain_ratio'] 	= TRUE;
            $config['master_dim'] 		= $master_dim;
            $config['thumb_marker'] 	= '';
            $CI->load->library('image_lib');
            
            foreach ($arr_thumb_image_size as $key => $thumb_image_size){
                    $config['width'] 		= $thumb_image_size['width'];
                    $config['height'] 		= $thumb_image_size['height'];
                    $config['new_image'] 	= $destination.'thumb_'.$key.'_'.$file_name;

                    if( $thumb_image_size['width'] > $img_original_width) {
                            $config['width'] 		= $img_original_width;					
                            $config['new_image'] 	= $destination.'thumb_'.$key.'_'.$file_name;

                    }
                 
                    $CI->image_lib->initialize($config);
                    if(!$CI->image_lib->resize()){
                        $upload_error['thumbanail_create_error'] = $CI->image_lib->display_errors();
                        return $upload_error;
                    }
            }
           // @unlink($destination.$file_name); // Unlink the original file uploaded after making thumbnails
            return TRUE;
        }
    }

    if(!function_exists('delete_image')){
        /**
         * Fucntion to delete image of any type
         * @param String $type
         * @param String $image_name
         * @return Null
         */
        function delete_image($type, $image_name, $user_id = ''){
            $user_id = empty($user_id) ? s('USER_ID') : $user_id;
            if('' != $image_name){
                $CI = &get_instance();
                $upload_path = c('file_upload_path');
                if('admin_profile' == $type){
                        $image_path				= $upload_path.'admin/';
                        $thumb_image_size			= c('admin_profile_image_thumb_dimension');
                }else if('user_profile' == $type){
                        $image_path				= $upload_path.'user';
                        $thumb_image_size			= c('user_profile_image_thumb_dimension');
                }else if('workouts' == $type){
                        $image_path				= $upload_path.'workouts';
                        $thumb_image_size			= c('workout_image_thumb_dimension');
                }else if('gallery' == $type){
                    $image_path                                 = $upload_path.'gallery/'.$user_id.'/';
                    $thumb_image_size                           = c('gallery_image_thumb_dimension');
                }else{
                    return false;
                }
                
                $arr_thumb_image_size = $thumb_image_size;
                foreach ($arr_thumb_image_size as $key => $thumb_image_size){ 
                    @unlink($image_path.'thumb_'.$key.'_'.$image_name);
                }
                @unlink($image_path.$image_name);
            }
        }
    }
    
    function create_image_from_data($type, $file_name,  $data, $user_id =''){
        $user_id = empty($user_id) ? s('USER_ID') : $user_id; 
       $upload_path = c('file_upload_path');
        if('admin_profile' == $type){
                $image_path				= $upload_path.'admin/';
                $thumb_image_size			= c('admin_profile_image_thumb_dimension');
        }else if('user_profile' == $type){
                $image_path				= $upload_path.'user';
                $thumb_image_size			= c('user_profile_image_thumb_dimension');
        }else if('workouts' == $type){
                $image_path				= $upload_path.'workouts';
                $thumb_image_size			= c('workout_image_thumb_dimension');
        }else if('gallery' == $type){
                $image_path				= $upload_path.'gallery/'.$user_id;
                if(!file_exists($image_path)){ make_dir($image_path); }
                $thumb_image_size			= c('gallery_image_thumb_dimension');
        }else{
            return false;
        }
       // header("Type: image/png");
        
        
        @file_put_contents($image_path.'/'.$file_name, base64_decode($data));
        
        create_thumbnails($image_path.'/'.$file_name, $image_path.'/', $file_name, $thumb_image_size, 'width');
        return true;
    }
    
    function base64_encode_image ($filename) {
        $path= $filename;
        $type = pathinfo($path, PATHINFO_EXTENSION);
        $data = file_get_contents($path);
        $base64 = base64_encode($data);
        return $base64;
    }
    
    function create_thumbs_from_file($type, $source, $file_name, $move_original = false ,$user_id =''){
       $user_id = empty($user_id) ? s('USER_ID') : $user_id; 
       $upload_path = c('file_upload_path');
        if('admin_profile' == $type){
                $image_path				= $upload_path.'admin/';
                $thumb_image_size			= c('admin_profile_image_thumb_dimension');
        }else if('user_profile' == $type){
                $image_path				= $upload_path.'user';
                $thumb_image_size			= c('user_profile_image_thumb_dimension');
        }else if('workouts' == $type){
                $image_path				= $upload_path.'workouts';
                $thumb_image_size			= c('workout_image_thumb_dimension');
        }else if('gallery' == $type){
                $image_path				= $upload_path.'gallery/'.$user_id;
                if(!file_exists($image_path)){ make_dir($image_path); }
                $thumb_image_size			= c('gallery_image_thumb_dimension');
        }else{
            return false;
        }
        
        create_thumbnails($source, $image_path.'/', $file_name, $thumb_image_size, 'width');
        if($move_original){
            @rename($source, $image_path.'/'.$file_name);
        }
        return true;
    }

