<?php

class Common_model extends CI_Model {

    public function __construct() {
        // Call the CI_Model constructor
        parent::__construct();
    }

    function prepare_select_box_data($table, $fields, $where = array(), $insert_null = false, $order_by = '', $other_array = array()) {

        list($key, $val) = explode(',', $fields);
        $key = trim($key);
        $val = trim($val);
        $order_by = $order_by ? $order_by : $val;
        $input_array = $this->get_data($table, $fields, $where, $order_by);

        $select_box_array = array();
        $total_records = count($input_array);
        if ($insert_null) {
            $select_box_array[''] = $insert_null === true ? '' : $insert_null;
        }
        for ($i = 0; $i < $total_records; $i++) {
            $select_box_array[$input_array[$i][$key]] = $input_array[$i][$val];
        }
        if (is_array($other_array) and count($other_array) > 0) { 
            foreach ($other_array as $key => $val) {
                $select_box_array[$key] = $val;
            }
        }
        return $select_box_array;
    }

    function get_data($table, $fields = '*', $where = array(), $order_by = '') {

        if ((is_array($where) && count($where) > 0) or (!is_array($where) && trim($where) != ''))
            $this->db->where($where);
        if ($order_by)
            $this->db->order_by($order_by);
        $this->db->select($fields);
        $query = $this->db->get($table); //echo $this->db->last_query(); exit;
        return $query->result_array();
    }
	
	function get_user_paid_quotes($user_id)
    {
         
        $query = $this->db->query("SELECT * FROM quote WHERE payment_received = '1' AND user_id = '$user_id' ORDER by date_created ASC");
         return $query->result_array();
        
    }
    
    function get_materials($process = '', $status = '', $id = '', $where = array()){
    	 
    	$this->db->select('m.*, c.category, color.color');
    	$this->db->join('material_category AS c', 'c.id = m.category_id');
    	$this->db->join('material_color AS color', 'color.id = m.color_id', 'left');
    	if(!empty($status)) $this->db->where('m.active', $status);
    	if(!empty($process)) $this->db->where('m.process', $process);
    	if(!empty($id)) $this->db->where('m.id', $id);
    	if(!empty($where)) $this->db->where($where); 
    	$this->db->order_by('process ASC, active DESC');
    	$query = $this->db->get('material  AS m');
    	return $query->result_array();
    }
}
