<?php

class User_model extends CI_Model {

    public function __construct() {
        // Call the CI_Model constructor
        parent::__construct();
    }
    //registration email check
    public function email_validate($email,$id='') {
        if (empty($email))
            return false; 
        else{   $this->db->select('id');
                //$this->db->where("'active' != '4'");
                $this->db->where('email', $email);
                if(!empty($id))
                $this->db->where('id !=', $id);
                $query = $this->db->get('user'); 
                if ($query->num_rows() > 0) { 
                    return true;
                }
                else {
                    return false;
                }
                
            } 
    }
    //registration email check
    public function phone_validate($phone,$id='') {
        if (empty($phone))
            return false; 
        else{   $this->db->select('id');
               // $this->db->where("'status' != '4'");
                $this->db->where('phone', $phone);
                if(!empty($id))
                $this->db->where('id !=', $id);
                $query = $this->db->get('user'); 
                if ($query->num_rows() > 0) { 
                    return true;
                }
                else {
                    return false;
                }
                
            } 
    }
    //Email checking for forgot password section
    public function forgot_email_check($email) {
        if (empty($email))
            return false; 
        else{   
            $this->db->select('fname, email, forgot_pwd_code,  active, activation_code');
            //$this->db->where(" 'status' != '4' "); 
            $this->db->where('email', $email);
            $query = $this->db->get('user'); 
            return $query->result_array();
        } 
    }
    
    public function get_forgot_code($forgot_code) {
        if (empty($forgot_code))
            return false;
        else{ 
             $query = $this->db->get_where('user', array('forgot_pwd_code' => $forgot_code)); 
             $row = $query->row();
             return $row->forgot_pwd_code;
       }
    }
    
    //forgot password update
    public function update_fgt_password($data = array())
    {
        if(empty($data)) return false;
        else{
            $password = sha1(trim($data['password'])); 
            $activation_code = $data['forgot_pwd_code'];
            $encrypt_time = strtotime(get_cur_date_time());
            
           // $password = create_secure_password($password.$encrypt_time);
            return $this->db->update('user', array('password' => $password,   'forgot_pwd_code' => NULL), array('forgot_pwd_code' => $activation_code));
           // echo $this->db->last_query(); exit;
        }
    }   
    
    /**
     * @desc insert user details to user_details table
     * @param type $data array having field values
     * @return insert query  
     */
    public function insert_user_details($data = array()) {
        if (empty($data))
           {return false;}
           return $this->db->insert('user', $data); 
    }
    
    
    /**
     * @desc used to retrieve a single value
     * @param type $activation_code
     * @return activation_code
     */
    public function get_activation_code($activation_code) {
        if (empty($activation_code))
            return false;
        $this->db->select('fname, email, phone');
        $this->db->where('activation_code', $activation_code);
        $query = $this->db->get('user'); 
        $query = $query->result_array();
        if(!empty($query)){
        	$this->db->query("UPDATE user set active = '1' WHERE activation_code = '$activation_code' ");
        }
        return $query;
        
    }
    /**
     * @desc update for activation account to NULL value after successfull activation
     * @param type $activation_code
     * @return update query 
     */
     
    public function activate_account($activation_code){
        if (empty($activation_code))
            return false;
        return $this->db->update('user', array('activation_code' => NULL), array('activation_code' => $activation_code));
    }
    
    public function get_user_detail($data = array()) {
        if (empty($data)) return false;
        $query = $this->db->where($data);
        $query = $this->db->get('user');
        $row = $query->row();
        return $row;
    }
    
    public function update_user_password($curr_password, $new_password, $user_id)
    {   
        if(empty($curr_password) || empty($new_password) || empty($user_id)) return false;
        $password ='365Pass'.$curr_password;
        $this->db->select('id');
        $this->db->where ("password = (SELECT SHA2(CONCAT('$password', `encrypt_time`), 256))", NULL, false );
        $this->db->where ('id', $user_id);
        $query = $this->db->get('user'); 
        if ($query->num_rows() == 1)
        { 
            $encrypt_time = strtotime(get_cur_date_time());
            $password = create_secure_password($new_password.$encrypt_time);
            $this->db->update('user', array('password' => $password, 'encrypt_time' => $encrypt_time), array('id' => $user_id));
            return 'updated';
           
        }else{ 
            return 'invalid_old_password';
        }
    }  
    
    public function update_user_profile($data = array(), $user_id)
    {   
        if(empty($data) || empty($user_id)) return false;
        return $this->db->update('user', $data, array('id' => $user_id)); 
    }
    
    public function insert_gallery($data = array())
    {   
        if(empty($data)) return false;
        $this->db->insert('gallery', $data); 
        return $this->db->insert_id();  
    }
    
    function get_state_city_zip_details($zip, $state_code = '', $city_id = ''){
        $where = '';
        $state_code = $this->db->escape_str($state_code);
        $city_id = $this->db->escape_str($city_id);
        if(!empty($state_code)) $where .= " AND S.state_code = '$state_code' " ;
        if(!empty($city_id)) $where .= " AND C.city_id = '$city_id' " ;
            
        $query = $this->db->query("SELECT Z.zipcode, Z.longitude, Z.lattitude, S.state, S.state_id, C.city, C.city_id, S.state_code FROM `zipcode` AS Z 
                        JOIN city AS C on Z.city_id = C.city_id 
                        JOIN state AS S on S.state_code = C.state_code 
                        WHERE Z.city_type = 'D' AND  Z.zipcode = '$zip' $where ");
        return $query->result_array();
    }
    
    //forgot password update
    public function update_user_fgt_code($data = array())
    {
        if(empty($data)) return false;
        return $this->db->update('user', array('forgot_pwd_code'=> $data['forgot_pwd_code']), array('email' => $data['email'])); 
    }
    
    public function invite_agent($data = array()) {
        if (empty($data))
           {return false;}
           $this->db->insert('user', $data); 
           return $this->db->insert_id();  
    }
    
//registration email check
    public function email_exists_validate($email, $id='') {
        if (empty($email))
            return false; 
        else{   
        	$this->db->select('id');
                $this->db->where('email', $email);
                $this->db->where('unsubscribe', '0');
                if(!empty($id)) $this->db->where('id !=', $id);
                $query = $this->db->get('newsletter'); 
                if ($query->num_rows() > 0) { 
                    return true;
                }
                else {
                    return false;
                }
                
            } 
    }
}