var SearchOrders = function () {
	
	var initPickers = function () {
        //init date pickers
    	if( $().datepicker){
	        $('.date-picker').datepicker({
	            rtl: Metronic.isRTL(),
	            autoclose: true,
	            todayHighlight : true
	        });
    	}
    }
	 var handleRecords = function () {
		 initPickers();
		 $("#datatable_ajax input").unbind( "keyup" );
		    $("#datatable_ajax input").keyup( function (e) {
		        if (e.keyCode == 13) {

		            $('.filter-submit').trigger('click');
		        }
		    } );
		    
		 
	        var grid = new Datatable();
	        
	        grid.init({
	            src: $("#datatable_ajax"),
	            onSuccess: function (grid) {
	                // execute some code after table records loaded
	                $('.activate_this_account').on('click', function (e) {
	                    alert($(this).data('id'));
	                });
	            },
	            onError: function (grid) {
	                // execute some code on network or other general error  
	            },
	            onDataLoad: function(grid) {
	                // execute some code on ajax data load
	            },
	            loadingMessage: 'Loading...',
	            dataTable: { // here you can define a typical datatable settings from http://datatables.net/usage/options 

	                // Uncomment below line("dom" parameter) to fix the dropdown overflow issue in the datatable cells. The default datatable layout
	                // setup uses scrollable div(table-scrollable) with overflow:auto to enable vertical scroll(see: assets/global/scripts/datatable.js). 
	                // So when dropdowns used the scrollable div should be removed. 
	                //"dom": "<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'<'table-group-actions pull-right'>>r>t<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'>>",
	                
	                "bStateSave": true, // save datatable state(pagination, sort, etc) in cookie.

	                "lengthMenu": [
	                    [10, 20, 50, 100, 150, -1],
	                    [10, 20, 50, 100, 150, "All"] // change per page values here
	                ],
	                "pageLength": 10, // default record count per page
	                "ajax": {
	                    "url": base_url+"admin/orders/search_orders_list/"+$('#txtOrderListType').val()+"/"+$('#txtMyComissions').val() // ajax source
	                },
	                "order": [
	                    [1, "asc"]
	                ]// set first column as a default sort by asc
	            }
	        });

	        // handle group actionsubmit button click
	        grid.getTableWrapper().on('click', '.table-group-action-submit', function (e) {
	            e.preventDefault();
	            var action = $(".table-group-action-input", grid.getTableWrapper());
	            if (action.val() != "" && grid.getSelectedRowsCount() > 0) {
	                grid.setAjaxParam("customActionType", "group_action");
	                grid.setAjaxParam("customActionName", action.val());
	                grid.setAjaxParam("id", grid.getSelectedRows());
	                grid.getDataTable().ajax.reload();
	                grid.clearAjaxParams();
	            } else if (action.val() == "") {
	                Metronic.alert({
	                    type: 'danger',
	                    icon: 'warning',
	                    message: 'Please select an action',
	                    container: grid.getTableWrapper(),
	                    place: 'prepend'
	                });
	            } else if (grid.getSelectedRowsCount() === 0) {
	                Metronic.alert({
	                    type: 'danger',
	                    icon: 'warning',
	                    message: 'No record selected',
	                    container: grid.getTableWrapper(),
	                    place: 'prepend'
	                });
	            }
	        });
	    }
	 
	return {

        //main function to initiate the module
        init: function () {
        	handleRecords();
        	$('#btnCreateOrderNext').on('click', function(e){
        		
        		
        		if($('#cmbCustomer').val() !=''){
            		window.location = base_url+'admin/orders/create_new_order/?cid='+$('#cmbCustomer').val();
            	}
	
        	});
        	
        	$('#shipping').on('change', function(e){
        		add_shipping();
        	});  
        	add_shipping();
        }
	}
}();

function add_shipping()
{   
	$('#print-quote-link').attr("href", base_url+'admin/orders/print_quote/?cid='+$('#txtCustomerId').val()+'&qid='+$('#txtQuoteId').val()+'&shipping='+$('#shipping').val() );
	var total = ($('#final_sub_total').val() * 1) + ($('#shipping').val() * 1) +  ($('#final_tax').val() * 1);
    var result = CommaFormatted(CurrencyFormatted(total)); 
    $("#tdTotalAmount").html("$" + result);
    return total;
}


function CurrencyFormatted(amount)
{
	var i = parseFloat(amount);
	if(isNaN(i)) { i = 0.00; }
	var minus = '';
	if(i < 0) { minus = '-'; }
	i = Math.abs(i);
	i = parseInt((i + .005) * 100);
	i = i / 100;
	s = new String(i);
	if(s.indexOf('.') < 0) { s += '.00'; }
	if(s.indexOf('.') == (s.length - 2)) { s += '0'; }
	s = minus + s;
	return s;
}
function CommaFormatted(amount)
{
	var delimiter = ","; // replace comma if desired
	var a = amount.split('.',2)
	var d = a[1];
	var i = parseInt(a[0]);
	if(isNaN(i)) { return ''; }
	var minus = '';
	if(i < 0) { minus = '-'; }
	i = Math.abs(i);
	var n = new String(i);
	var a = [];
	while(n.length > 3)
	{
		var nn = n.substr(n.length-3);
		a.unshift(nn);
		n = n.substr(0,n.length-3);
	}
	if(n.length > 0) { a.unshift(n); }
	n = a.join(delimiter);
	if(d.length < 1) { amount = n; }
	else { amount = n + '.' + d; }
	amount = minus + amount;
	
        
        
    
return amount;
}
function cancel_admin_page(p){
	window.location = base_url+'admin/orders/'+p
}

$('.inline-editable-button').on('click', function(){
	var p_id = $(this).data('part-id');
	$('#inline-editable_'+p_id).show();
	$('#inline-editable-content_'+p_id).hide();
});

$('.inline-editable-cancel').on('click', function(){
	var p_id = $(this).data('part-id');
	$('#inline-editable_'+p_id).hide();
	$('#inline-editable-content_'+p_id).show();
});

$('.inline-editable-save').on('click', function(e){
	e.preventDefault();
	var p_id = $(this).data('part-id');
	var content = $('#txtinline-editable_'+p_id).val();
	$('#inline-editable-label_'+p_id).html(content);
	$('#inline-editable_'+p_id).hide();
	$('#inline-editable-content_'+p_id).show();
	 
	$.ajax({
        type: "POST",
        url: base_url+'ajax/update_additional_description',
        data: "part_id="+p_id+"&notes="+content ,
        dataType:"json",
        success: function(resp){				
            if(resp.login_error){
                window.location = base_url+'admin';
            }else if(resp.status == 'success'){
            	//var dt = resp.details;
                 //window.location = base_url + 'admin/orders/create_new_order/?cid='+dt.customer_id+'&qid='+dt.quote_id;
            }else if(resp.status == 'error'){
                alert( resp.message);
                 
            }
        }
    });
});

 