
var User = function () {
    // advance validation
    var handleChangePassword = function() {

            var form3 = $('#frmChangePassword');
            var error3 = $('.alert-danger', form3);
            var success3 = $('.alert-success', form3);

            form3.validate({
                errorElement: 'span', //default input error message container
                errorClass: 'help-block help-block-error', // default input error message class
                focusInvalid: false, // do not focus the last invalid input
                ignore: "", // validate all fields including form hidden input
                rules: {
                    current_password: {
                        required: true
                    },
                    new_password: {
                        minlength: 6,
                        maxlength: 20,
                        required: true
                    },  
                    new_password_confirm: {
                        minlength: 6,
                        maxlength: 20,
                        equalTo: "#new_password",
                        required: true
                    }
                },

                messages: { // custom messages for radio buttons and checkboxes
                   new_password_confirm:{
                       equalTo: "New Password and Re-enter password should match"
                   }
                },

                errorPlacement: function (error, element) { // render error placement for each input type
                   error.insertAfter(element); // for other inputs, just perform default behavior
                },

                invalidHandler: function (event, validator) { //display error alert on form submit   
                    success3.hide();
                    error3.html('<button data-close="alert" class="close"></button> You have some form errors. Please check below.');
                    error3.show();
                    Metronic.scrollTo(error3, -200);
                },

                highlight: function (element) { // hightlight error inputs
                   $(element)
                        .closest('.form-group').addClass('has-error'); // set error class to the control group
                },

                unhighlight: function (element) { // revert the change done by hightlight
                    $(element)
                        .closest('.form-group').removeClass('has-error'); // set error class to the control group
                },

                success: function (label) {
                    label
                        .closest('.form-group').removeClass('has-error'); // set success class to the control groerror3.show()up
                },

                submitHandler: function (form) {
                   // success3.show();
                    error3.hide();
                    //form[0].submit(); // submit the form
                    
                    $.ajax({
                        type: "POST",
                        url: base_url+'admin/change_password',
                        data: $("#frmChangePassword").serialize(),
                        dataType:"json",
                        success: function(resp){
                            if(resp.login_error){
                                window.location = base_url+'admin'
                            }else if(resp.status == 'success'){
                                success3.html('<button data-close="alert" class="close"></button> '+ resp.message);
                                success3.show();
                                error3.hide();
                            }else if(resp.status == 'error'){
                                error3.html('<button data-close="alert" class="close"></button> '+ resp.message);
                                error3.show();
                                success3.hide();
                            }
                        }
                    });
                }

            });

    }
    
     // advance validation
    var handleUpdateProfile = function() {

            var form3 = $('#frmUpdateProfile');
            var error3 = $('.alert-danger', form3);
            var success3 = $('.alert-success', form3);

            form3.validate({
                errorElement: 'span', //default input error message container
                errorClass: 'help-block help-block-error', // default input error message class
                focusInvalid: false, // do not focus the last invalid input
                ignore: "", // validate all fields including form hidden input
                rules: {
                    txtFirstName: {
                        required: true
                    },
                    txtLastName: {
                        minlength: 2,
                        maxlength: 20,
                        required: true
                    },
                    txtEmail: {
                        required: true,
                        email: true
                    }
                },

                messages: { // custom messages for radio buttons and checkboxes

                },

                errorPlacement: function (error, element) { // render error placement for each input type
                   error.insertAfter(element); // for other inputs, just perform default behavior
                },

                invalidHandler: function (event, validator) { //display error alert on form submit   
                    success3.hide();
                    error3.html('<button data-close="alert" class="close"></button> You have some form errors. Please check below.');
                    error3.show();
                    Metronic.scrollTo(error3, -200);
                },

                highlight: function (element) { // hightlight error inputs
                   $(element)
                        .closest('.form-group').addClass('has-error'); // set error class to the control group
                },

                unhighlight: function (element) { // revert the change done by hightlight
                    $(element)
                        .closest('.form-group').removeClass('has-error'); // set error class to the control group
                },

                success: function (label) {
                    label
                        .closest('.form-group').removeClass('has-error'); // set success class to the control group
                },

                submitHandler: function (form) {
                    success3.show();
                    error3.hide();
                    form[0].submit(); // submit the form
                }

            });

    }
    
  
    var cancel = function(){
        $('#btnCancel').on('click', function(){
           cancel_admin_page(); 
        });
    }
    
    return {
        //main function to initiate the module
        init: function () {
            handleChangePassword();
            handleUpdateProfile();
            cancel();
        }

    };
}();

function cancel_admin_page(){
	window.location = base_url+'admin/dashboard'
}