<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Settings extends CI_Controller {
	 var $gen_contents = array();
	 
	 function sitepages(){
	 	(!$this->authentication->check_logged_in("admin", false)) ? redirect('admin') : '';
	 	if(!admin_has_permission(17)){
	 		sf('error_message', 'Sorry. You have no enough permission to access this page.');
	 		redirect('admin/profile');
	 	}
	 	$this->gen_contents['page_heading'] = 'Site Pages';
	 	$this->gen_contents['active_main_menu'] = array('settings', 'sitepages');
        $this->gen_contents['page_breadcrumb'] = array(array('link' => '#', 'label' => 'Settings'), array('link' => 'settings/sitepages', 'label' => $this->gen_contents['page_heading']));
        $this->gen_contents['js_script_initial'] = '';"User.init();";
	 	$this->gen_contents['js_files'] = array('global/plugins/jquery-validation/js/jquery.validate.min.js', 'admin/layout/scripts/settings.js');
	 	$this->template->set_template('admin');
	 	$this->gen_contents['details'] = $this->common_model->get_data('sitepages', '*');
	 	$this->template->write_view('content', 'admin/settings/sitepage_list', $this->gen_contents);
        $this->template->render();
	 }
	 
	 function edit_page($id = ''){
	 	(!$this->authentication->check_logged_in("admin", false)) ? redirect('admin') : '';
	 	if(!admin_has_permission(17)){
	 		sf('error_message', 'Sorry. You have no enough permission to access this page.');
	 		redirect('admin/profile');
	 	}
	 	if(!empty($_POST)){
	 		$data = array(
	 		'title' => $this->input->post('txtTitle'),
	 		'short_description' => $this->input->post('txtShortDescription'),
	 		'description' => $this->input->post('summernote'), 
	 		'updated_date' => get_cur_date_time()
	 		);
	 		$this->db->update('sitepages', $data, array('id' =>$id));
	 		sf('success_message', 'Page content has been updated.');
	 		redirect('admin/settings/edit_page/'.$id);
	 	}
	 	
	 	$this->gen_contents['details'] = $this->common_model->get_data('sitepages', '*', array('id' =>$id));
	 	$this->gen_contents['details'] = @$this->gen_contents['details'][0];
	 	if(empty($this->gen_contents['details'])){
	 		redirect('admin/settings/sitepages');
	 	}
	 	
	 	$this->gen_contents['page_heading'] = 'Edit Site Pages';
	 	$this->gen_contents['active_main_menu'] = array('settings', 'sitepages');
        $this->gen_contents['page_breadcrumb'] = array(array('link' => '#', 'label' => 'Settings'), array('link' => 'settings/sitepages', 'label' => $this->gen_contents['page_heading']));
        $this->gen_contents['js_script_initial'] = 'ComponentsEditors.init();';
	 	$this->gen_contents['js_files'] = array('global/plugins/jquery-validation/js/jquery.validate.min.js', 
	 	'admin/layout/scripts/settings.js',
	 	'global/plugins/bootstrap-wysihtml5/wysihtml5-0.3.0.js',
	 	'global/plugins/bootstrap-wysihtml5/bootstrap-wysihtml5.js',
	 	'global/plugins/bootstrap-summernote/summernote.min.js', 'admin/pages/scripts/components-editors.js'
	 	);
	 	$this->template->set_template('admin');
	 	$this->gen_contents['load_editor_css'] = true;
	 	$this->template->write_view('content', 'admin/settings/sitepage_edit', $this->gen_contents);
        $this->template->render();
	 }
	 
	 function tax_setting(){
	 	(!$this->authentication->check_logged_in("admin", false)) ? redirect('admin') : '';
	 	if(s('ADMIN_TYPE') != 'Y'){
	 		sf('error_message', 'Sorry. You have no enough permission to access this page.');
	 		redirect('admin/profile');
 	 	}
 	 	
 	 	if(!empty($_POST)){
 	 		$txtTaxRate = $this->input->post('txtTaxRate');
 	 		 
 	 		foreach ($txtTaxRate as $k => $v){
 	 			 $sql = "UPDATE state SET tax = '$v' WHERE id ='$k' ";
 	 			 //echo $sql."\n";
 	 			 $this->db->query($sql);
 	 		}
 	 		sf('success_message', 'Tax rates has been updated.');
 	 		redirect('admin/settings/tax_setting');
 	 		//p($txtTaxRate);exit;
 	 	}
 	 	
 	 	$this->gen_contents['details'] = $this->common_model->get_data('state', '*', array(), 'tax DESC' );
 	 	
 	 	$this->gen_contents['page_heading'] = 'Tax Setting';
	 	$this->gen_contents['active_main_menu'] = array('settings', 'tax_setting');
        $this->gen_contents['page_breadcrumb'] = array(array('link' => '#', 'label' => 'Settings'), array('link' => 'settings/tax_setting', 'label' => $this->gen_contents['page_heading']));
	 	$this->template->set_template('admin');
	 	$this->gen_contents['js_files'] = array('global/plugins/jquery-validation/js/jquery.validate.min.js'); 
	 	$this->template->write_view('content', 'admin/settings/tax_setting', $this->gen_contents);
        $this->template->render();
	 }
	 
	 function promocodes(){
	 	(!$this->authentication->check_logged_in("admin", false)) ? redirect('admin') : '';
	 	if(s('ADMIN_TYPE') != 'Y'){
	 		sf('error_message', 'Sorry. You have no enough permission to access this page.');
	 		redirect('admin/profile');
 	 	}
 	 	$this->gen_contents['details'] = $this->common_model->get_data('promo', '*', array(), 'date_created DESC' );
 	 	
 	 	$this->gen_contents['page_heading'] = 'Promo Codes';
	 	$this->gen_contents['active_main_menu'] = array('settings', 'promocodes');
        $this->gen_contents['page_breadcrumb'] = array(array('link' => '#', 'label' => 'Settings'), array('link' => 'settings/promocodes', 'label' => $this->gen_contents['page_heading']));
	 	$this->template->set_template('admin');
	 	$this->gen_contents['js_script_initial'] = "PromoCodes.init();";
	 	$this->gen_contents['js_files'] = array('global/plugins/jquery-validation/js/jquery.validate.min.js', 'js/promo.js'); 
	 	$this->template->write_view('content', 'admin/settings/promocodes', $this->gen_contents);
        $this->template->render();
	 }
	 
	 function edit_promo($id = ''){
	 	(!$this->authentication->check_logged_in("admin", false)) ? redirect('admin') : '';
	 	if(s('ADMIN_TYPE') != 'Y'){
	 		sf('error_message', 'Sorry. You have no enough permission to access this page.');
	 		redirect('admin/profile');
 	 	}
 	 	
 	 	if(!empty($_POST)){
 	 		$this->form_validation->set_rules('txtPromoCode', 'Promo Code', 'required|trim|max_length[50]|callback_promo_exist');
			$this->form_validation->set_rules('txtAmount', 'Amount', 'required|trim');
			$this->form_validation->set_rules('cmbType', 'Type', 'required|trim');
			$this->form_validation->set_rules('txtDescription', 'Description', 'required|trim');
			$this->form_validation->set_rules('cmbStatus', 'status', 'required|trim');
			 if ($this->form_validation->run() == TRUE) {
			 	 
			 	$amount = $this->input->post('txtAmount' ,true);
			 	if($this->input->post('cmbType', true) == '2'){
			 		$amount = ($amount / 100);
			 	} 
			 	$data = array(
			 		'code' => $this->input->post('txtPromoCode' ,true),
				 	'promo' => $this->input->post('cmbType' ,true),
				 	'amount' => $amount,
				 	'description' => $this->input->post('txtDescription' ,true),
				 	'status' => $this->input->post('cmbStatus' ,true),
			 		'admin_user' => s('ADMIN_USERID') 
			 	);
			 	if(!empty($id)){ // EDIT
			 		$this->db->update('promo', $data, array('id' => $id));
			 		sf('success_message', 'Promo code details has been updated.');
			 		redirect('admin/settings/edit_promo/'.$id);
			 	} else{ // INERT
			 		$data['date_created'] = get_cur_date_time();
			 		$this->db->insert('promo', $data);
			 		sf('success_message', 'Promo code has been created.');
			 		redirect('admin/settings/edit_promo/');
			 	}
			 } else{
			 	 $this->gen_contents['form_validation_error'] = validation_errors();
			 }
 	 	}
 	 	
 	 	if(!empty($id)){
 	 		$this->gen_contents['page_heading'] = 'Edit Promo Code ';
 	 		$this->gen_contents['details'] = $this->common_model->get_data('promo', '*', array('id' => $id), 'date_created DESC' );
 	 	}else{
 	 		$this->gen_contents['page_heading'] = 'Add Promo Code ';
 	 	}
 	 	
	 	$this->gen_contents['active_main_menu'] = array('settings', 'promocodes');
        $this->gen_contents['page_breadcrumb'] = array(array('link' => '#', 'label' => 'Settings'), array('link' => 'settings/edit_promo/'.$id, 'label' => $this->gen_contents['page_heading']));
	 	$this->template->set_template('admin');
	 	$this->gen_contents['js_script_initial'] = "PromoCodes.init();";
	 	$this->gen_contents['js_files'] = array('global/plugins/jquery-validation/js/jquery.validate.min.js', 'js/promo.js'); 
	 	$this->template->write_view('content', 'admin/settings/edit_promo', $this->gen_contents);
        $this->template->render();
	 }
	 function promo_exist($code) {
	 	$id = $this->input->post('txtId', true);
		$data = $this->common_model->get_data('promo', 'code', array('code' => $code, 'id !=' => $id));
		if (!empty($data)) {
			$this->form_validation->set_message('promo_exist', 'This promo code already exists. Please enter new one.');
			return FALSE;
		} else {
			return TRUE;
		}
    }
	 function delete_promocode($id = ''){
	 	(!$this->authentication->check_logged_in("admin", false)) ? redirect('admin') : '';
	 	if(s('ADMIN_TYPE') != 'Y'){
	 		sf('error_message', 'Sorry. You have no enough permission to access this page.');
	 		redirect('admin/profile');
 	 	}
 	 	if(!empty($id)){
 	 		$this->db->delete('promo', array('id' => $id));
 	 		sf('success_message', 'Promo code details has been deleted.');
 	 	}
 	 	redirect('admin/settings/promocodes/');
	 }
	 
	 /* Material Category management*/
	 
	function material_category(){
	  	(!$this->authentication->check_logged_in("admin", false)) ? redirect('admin') : '';
	 	if(s('ADMIN_TYPE') != 'Y'){
	 		sf('error_message', 'Sorry. You have no enough permission to access this page.');
	 		redirect('admin/profile');
 	 	}
 	 	$this->gen_contents['page_heading'] = 'Material Category';
 	 	
 	 	//$this->gen_contents['categories'] = $this->common_model->get_materials('material_category', '*');
 	 	$this->gen_contents['details'] = $this->common_model->get_data('material_category', '*');
 	 	 
 	 	$this->gen_contents['active_main_menu'] = array('settings', 'material_category');
        $this->gen_contents['page_breadcrumb'] = array(array('link' => '#', 'label' => 'Settings'), array('link' => 'settings/material_category/', 'label' => $this->gen_contents['page_heading']));
	 	$this->template->set_template('admin');
	 	$this->gen_contents['js_script_initial'] = "PromoCodes.init();";
	 	$this->gen_contents['js_files'] = array('global/plugins/jquery-validation/js/jquery.validate.min.js', 'js/promo.js'); 
	 	$this->template->write_view('content', 'admin/settings/material_category', $this->gen_contents);
        $this->template->render();
	  }
	 
	function edit_material_category($id = ''){
	  	(!$this->authentication->check_logged_in("admin", false)) ? redirect('admin') : '';
	 	if(s('ADMIN_TYPE') != 'Y'){
	 		sf('error_message', 'Sorry. You have no enough permission to access this page.');
	 		redirect('admin/profile');
 	 	}
 	 	if(!empty($_POST) && $this->input->post('txtCategory', true)){
 	 		$data = array('category' => $this->input->post('txtCategory', true));
 	 		if(!empty($id)){ // Update
 	 			$this->db->update('material_category', $data, array('id' => $id));
 	 			$this->_update_material_details(array('category_id' => $id));
 	 			sf('success_message', 'Category has been updated successfully');
 	 		}else{ // Insert
 	 			$this->db->insert('material_category', $data );
 	 			sf('success_message', 'Category has been created successfully');
 	 		}
 	 		
	 		redirect('admin/settings/edit_material_category');
 	 	}
 	 	if(!empty($id)){
 	 		$this->gen_contents['page_heading'] = 'Edit Material Category';
 	 		$this->gen_contents['details'] = $this->common_model->get_data('material_category', '*', array('id' => $id));
 	 	}else{
 	 		$this->gen_contents['page_heading'] = 'Add Material Category';
 	 	}
 	 	 
 	 	$this->gen_contents['active_main_menu'] = array('settings', 'material_category');
        $this->gen_contents['page_breadcrumb'] = array(array('link' => '#', 'label' => 'Settings'), array('link' => 'settings/material_category/', 'label' => $this->gen_contents['page_heading']));
	 	$this->template->set_template('admin');
	 	$this->gen_contents['js_script_initial'] = "PromoCodes.init();";
	 	$this->gen_contents['js_files'] = array('global/plugins/jquery-validation/js/jquery.validate.min.js', 'js/promo.js'); 
	 	$this->template->write_view('content', 'admin/settings/edit_material_category', $this->gen_contents);
        $this->template->render();
	  }
	  
	  function delete_material_category($id = ''){
	  	if(!empty($id)){
	  		
	  		$is_exists = $this->common_model->get_data('material', 'category_id', array('category_id' => $id));
	  		if(empty($is_exists)){
	  			$this->db->delete('material_category', array('id' => $id));
		  		sf('success_message', 'Category has been deleted successfully.');
		  		redirect('admin/settings/material_category');	
	  		}else{
	  			sf('error_message', 'Sorry! This category can\'t be deleted since this has been mapped to '.count($is_exists).' material'. (count($is_exists) > 0 ? 's.' :'.' ) );
	  			redirect('admin/settings/material_category');
	  		}
	  		 
	  	}
	  	redirect('admin/settings/material_category');
	  }
	  
	/* Material Color management*/
	 
	function material_color(){
	  	(!$this->authentication->check_logged_in("admin", false)) ? redirect('admin') : '';
	 	if(s('ADMIN_TYPE') != 'Y'){
	 		sf('error_message', 'Sorry. You have no enough permission to access this page.');
	 		redirect('admin/profile');
 	 	}
 	 	$this->gen_contents['page_heading'] = 'Material Color';
 	 	
 	 	//$this->gen_contents['categories'] = $this->common_model->get_materials('material_category', '*');
 	 	$this->gen_contents['details'] = $this->common_model->get_data('material_color', '*');
 	 	 
 	 	$this->gen_contents['active_main_menu'] = array('settings', 'material_color');
        $this->gen_contents['page_breadcrumb'] = array(array('link' => '#', 'label' => 'Settings'), array('link' => 'settings/material_color/', 'label' => $this->gen_contents['page_heading']));
	 	$this->template->set_template('admin');
	 	$this->gen_contents['js_script_initial'] = "PromoCodes.init();";
	 	$this->gen_contents['js_files'] = array('global/plugins/jquery-validation/js/jquery.validate.min.js', 'js/promo.js'); 
	 	$this->template->write_view('content', 'admin/settings/material_color', $this->gen_contents);
        $this->template->render();
	  }
	 
	function edit_material_color($id = ''){
	  	(!$this->authentication->check_logged_in("admin", false)) ? redirect('admin') : '';
	 	if(s('ADMIN_TYPE') != 'Y'){
	 		sf('error_message', 'Sorry. You have no enough permission to access this page.');
	 		redirect('admin/profile');
 	 	}
 	 	if(!empty($_POST) && $this->input->post('txtColor', true)){
 	 		$data = array('color' => $this->input->post('txtColor', true));
 	 		if(!empty($id)){ // Update
 	 			$this->db->update('material_color', $data, array('id' => $id));
 	 			$this->_update_material_details(array('color_id' => $id));
 	 			sf('success_message', 'Material color has been updated successfully');
 	 		}else{ // Insert
 	 			$this->db->insert('material_color', $data );
 	 			sf('success_message', 'Material color has been created successfully');
 	 		}
 	 		
	 		redirect('admin/settings/edit_material_color');
 	 	}
 	 	if(!empty($id)){
 	 		$this->gen_contents['page_heading'] = 'Edit Material color';
 	 		$this->gen_contents['details'] = $this->common_model->get_data('material_color', '*', array('id' => $id));
 	 	}else{
 	 		$this->gen_contents['page_heading'] = 'Add Material color';
 	 	}
 	 	 
 	 	$this->gen_contents['active_main_menu'] = array('settings', 'material_color');
        $this->gen_contents['page_breadcrumb'] = array(array('link' => '#', 'label' => 'Settings'), array('link' => 'settings/material_color/', 'label' => $this->gen_contents['page_heading']));
	 	$this->template->set_template('admin');
	 	$this->gen_contents['js_script_initial'] = "PromoCodes.init();";
	 	$this->gen_contents['js_files'] = array('global/plugins/jquery-validation/js/jquery.validate.min.js', 'js/promo.js'); 
	 	$this->template->write_view('content', 'admin/settings/edit_material_color', $this->gen_contents);
        $this->template->render();
	  }
	  
	  function delete_material_color($id = ''){
	  	if(!empty($id)){
	  		
	  		$is_exists = $this->common_model->get_data('material', 'color_id', array('color_id' => $id));
	  		if(empty($is_exists)){
	  			$this->db->delete('material_color', array('id' => $id));
		  		sf('success_message', 'Material Color has been deleted successfully.');
		  		redirect('admin/settings/material_color');	
	  		}else{
	  			sf('error_message', 'Sorry! This Material Color can\'t be deleted since this has been mapped to '.count($is_exists).' material'. (count($is_exists) > 0 ? 's.' :'.' ) );
	  			redirect('admin/settings/material_color');
	  		}
	  		 
	  	}
	  	redirect('admin/settings/material_color');
	  }
	  /* Materials */
	  function materials(){
	  	(!$this->authentication->check_logged_in("admin", false)) ? redirect('admin') : '';
	 	if(s('ADMIN_TYPE') != 'Y'){
	 		sf('error_message', 'Sorry. You have no enough permission to access this page.');
	 		redirect('admin/profile');
 	 	}
 	 	$this->gen_contents['page_heading'] = 'Materials';
 	 	
 	 	//$this->gen_contents['categories'] = $this->common_model->get_materials('material_category', '*');
 	 	$this->gen_contents['details'] = $this->common_model->get_materials();
 	 	 
 	 	$this->gen_contents['active_main_menu'] = array('settings', 'materials');
        $this->gen_contents['page_breadcrumb'] = array(array('link' => '#', 'label' => 'Settings'), array('link' => 'settings/materials/', 'label' => $this->gen_contents['page_heading']));
	 	$this->template->set_template('admin');
	 	$this->gen_contents['js_script_initial'] = "PromoCodes.init();";
	 	$this->gen_contents['js_files'] = array('global/plugins/jquery-validation/js/jquery.validate.min.js', 'js/promo.js'); 
	 	$this->template->write_view('content', 'admin/settings/materials', $this->gen_contents);
        $this->template->render();
	  }
	  
 	function edit_material($id = ''){
	  	(!$this->authentication->check_logged_in("admin", false)) ? redirect('admin') : '';
	 	if(s('ADMIN_TYPE') != 'Y'){
	 		sf('error_message', 'Sorry. You have no enough permission to access this page.');
	 		redirect('admin/profile');
 	 	}
 	 	
 	 	if(!empty($_POST)){
 	 		 
 	 		 $txtSmCond_1 = $this->input->post('txtSmCond_1', true );
 	 		 $txtSmCond_2 = $this->input->post('txtSmCond_2', true );
 	 		 $txtSmPrice = $this->input->post('txtSmPrice', true );
 	 		 
 	 		 $sm_details = array();
 	 		 $sm_details[] = array(
 	 		 	'sm' => $this->input->post('txtSupportMultiplier', true ),
 	 		 	'sm_start' => $this->input->post('txtSmStart', true ),
 	 		 	'sm_start_price' => $this->input->post('txtSmStartPrice', true ),
 	 		 	'sm_end' => $this->input->post('txtSmEnd', true ),
 	 		 	'sm_end_price' => $this->input->post('txtSmEndPrice', true ),
 	 		 );
 	 		 for($i=0; $i < count($txtSmCond_1); $i++){
 	 		 	if(!empty($txtSmCond_1[$i]) && !empty($txtSmCond_2[$i]) ){ 
	 	 		 	$sm_details[] = array(
	 	 		 		'sm_con_1' => $txtSmCond_1[$i],
	 	 		 		'sm_con_2' => @$txtSmCond_2[$i],
	 	 		 		'sm_val' => $txtSmPrice[$i] 
	 	 		 	);
 	 		 	}
 	 		 }
 	 		// p($sm_details);
 	 		// p(json_encode($sm_details));
 	 		
 	 	 	 $txtPrCond_1 = $this->input->post('txtPrCond_1', true );
 	 		 $txtPrCond_2 = $this->input->post('txtPrCond_2', true );
 	 		 $txtPrPrice = $this->input->post('txtPrPrice', true );
 	 		 
 	 		 $price_details = array();
 	 		 $price_details[] = array(
 	 		 	'price' => $this->input->post('txtPrice', true ),
 	 		 	'price_start' => $this->input->post('txtPrStart', true ),
 	 		 	'price_start_price' => $this->input->post('txtPrStartPrice', true ),
 	 		 	'price_end' => $this->input->post('txtPrEnd', true ),
 	 		 	'price_end_price' => $this->input->post('txtPrEndPrice', true ),
 	 		 );
 	 		 for($i=0; $i < count($txtSmCond_1); $i++){
 	 		 	if(!empty($txtSmCond_1[$i]) && !empty($txtPrCond_2[$i])){
	 	 		 	$price_details[] = array(
	 	 		 		'price_con_1' => $txtPrCond_1[$i],
	 	 		 		'price_con_2' => @$txtPrCond_2[$i],
	 	 		 		'price_val' => $txtPrPrice[$i] 
	 	 		 	);
 	 		 	}
 	 		 }
 	 		 
 	 		 
 	 			if(  $this->input->post('cmbCategory', true) && $this->input->post('txtMaterial', true) && $this->input->post('txtPrice', true) 
				 &&  $this->input->post('cmbCategoryName', true)  
 	 			){
 	 			 
 	 			$description = $this->input->post('cmbCategoryName', true).' - '.$this->input->post('txtMaterial', true). ' - '.$this->input->post('cmbColorName', true);
 	 			
 	 			$data = array(
 	 				'category_id' 	=> $this->input->post('cmbCategory', true),
 	 				'color_id' 		=> $this->input->post('cmbColor', true) ? $this->input->post('cmbColor', true) : '0',
 	 				'material' 		=> $this->input->post('txtMaterial', true),
 	 				'active' 		=> ($this->input->post('cmbStatus', true) == '1') ? '1' : '0',
 	 				'description'	=> $description,
 	 				'price'			=> fncEncrypt_data( json_encode($price_details)),//$this->input->post('txtPrice', true),
 	 				'sm'			=> fncEncrypt_data(json_encode($sm_details)),
 	 			 
 	 			);
 	 			 
 	 			if(!empty($id)){
	 	 			$this->db->update('material', $data, array('id' => $id));
	 	 			sf('success_message', 'Material has been created successfully');
	 	 		}else{
	 	 			$this->db->insert('material', $data );
	 	 			sf('success_message', 'Material details has been updated successfully');
	 	 		}
	 	 		redirect('admin/settings/materials');
 	 		}else{
	 	 		$this->gen_contents['form_validation_error'] = 'Please make sure that you have entered all mandatory fields.';
 	 		}
 	 	}
 	 	
 	 	if(!empty($id)){
 	 		$this->gen_contents['page_heading'] = 'Edit Material';
 	 		$this->gen_contents['details'] = $this->common_model->get_materials('', '', $id);
 	 	}else{
 	 		$this->gen_contents['page_heading'] = 'Add Material';
 	 	}
 	 	
 	 	$this->gen_contents['categories'] = $this->common_model->get_data('material_category', '*');
 	 	$this->gen_contents['colors'] = $this->common_model->get_data('material_color', '*');
 	 	 
 	 	$this->gen_contents['active_main_menu'] = array('settings', 'materials');
        $this->gen_contents['page_breadcrumb'] = array(array('link' => '#', 'label' => 'Settings'), array('link' => 'settings/materials/', 'label' => $this->gen_contents['page_heading']));
	 	$this->template->set_template('admin');
	 	$this->gen_contents['js_script_initial'] = "PromoCodes.init();";
	 	$this->gen_contents['js_files'] = array('global/plugins/jquery-validation/js/jquery.validate.min.js', 'js/promo.js'); 
	 	$this->template->write_view('content', 'admin/settings/edit_material', $this->gen_contents);
        $this->template->render();
	  }
	  
	  function _update_material_details($where){
	  	$materials = $this->common_model->get_materials('', '', '', $where);
	  	//p($materials);
	  	for($i=0; $i < count($materials); $i++){
	  		$data = array(
	  			'description' => $materials[$i]['category'].' - '.$materials[$i]['material'].' - '.$materials[$i]['color'] 
	  		);
	  		$this->db->update('material', $data, array('id' => $materials[$i]['id']));
	  	}
	  	//exit;
	  }
}