<?php
/**
 * CodeIgniter
 *
 * An open source application development framework for PHP
 *
 * This content is released under the MIT License (MIT)
 *
 * Copyright (c) 2014 - 2015, British Columbia Institute of Technology
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * @package CodeIgniter
 * @author  EllisLab Dev Team
 * @copyright Copyright (c) 2008 - 2014, EllisLab, Inc. (http://ellislab.com/)
 * @copyright Copyright (c) 2014 - 2015, British Columbia Institute of Technology (http://bcit.ca/)
 * @license http://opensource.org/licenses/MIT  MIT License
 * @link  http://codeigniter.com
 * @since Version 1.0.0
 * @filesource
 */
defined('BASEPATH') OR exit('No direct script access allowed');
class Six_lane extends CI_Controller {
  var $gen_contents = array();
   
   function index(){
        $this->customers();

   }
   
   public function sixlane_list() {

      (!$this->authentication->check_logged_in("admin", false)) ? redirect('admin/sales/my_customers') : '';
    if(!admin_has_permission(9)){

      redirect('admin/dashboard');
    }

     $id=s('ADMIN_USERID');
            $where=array(
                'user_id' =>$id,
                'status' =>1
                );
            $this->gen_contents['sixlane'] = $this->common_model->get_data('six_lane', '*', $where);

        $cid = @$this->gen_contents['sixlane'][0]['lane_id'];
            redirect('admin/six_lane/edit_sixlane/?cid='.$cid);


     $id = $this->input->get('cid', true);
        if($id != ''){
            $this->db->where('lane_id', $id);
            $sts=$this->db->delete('six_lane'); 
            if($sts){
                        $first_groupname_1      = $this->input->post("txtg11", true); 
                     
                       
                          sf('success_message', "Six lane has been deleted.");
                       }else{
                          sf('error_message', 'Error! There is an issue with deletion. Please try again later.');
                       }
                       redirect('admin/six_lane/sixlane_list');
           
        }
    $this->gen_contents['script_load_page'] = 'users';
        $this->gen_contents['js_files'] = array('global/plugins/datatables/media/js/jquery.dataTables.min.js', 
        'global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js',
        'global/plugins/jquery-validation/js/jquery.validate.min.js', 'global/scripts/datatable.js',
    'global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js',
        'admin/layout/scripts/six_lane.js');
        $this->template->set_template('admin');
        
    $lnk = 'Six lane/create Six lane';
    $lbl = 'Six lane';
    $this->gen_contents['active_main_menu'] = array('Manage Six lane', 'customers');
    
        $this->gen_contents['page_heading'] = 'Manage Six lane - '.$lbl;
        //$this->gen_contents['sales_type'] = '2';
        $this->gen_contents['page_breadcrumb'] = array(array('link' => '#', 'label' => 'Manage Six lane'), array('link' => $lnk, 'label' => $lbl));
        $this->gen_contents['js_script_initial'] = "Six_lane.init();";
        //$this->gen_contents['customers_list'] = $this->common_model->get_data('packages','package_id','package_code','package_name','package_registered_time','1package_last_updated_time', array('package_status' => '1' ));
        $this->template->write_view('content', 'admin/six_lane/six_lane_list', $this->gen_contents);
        $this->template->render();
   }



   
   function list_sixlane($type = 1){ // 1 = my customers 
        //die("test");

  
    if (!$this->authentication->check_logged_in("admin", false) ) { // If there is no login exists just return the error

            $iTotalRecords = 1;
            $iDisplayLength = 1;
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = 0;
            $sEcho = 0;

            $records = array();
            $records["data"] = array();

            $end = 1;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;

            $status_list = array(
                array("success" => "Pending"),
                array("info" => "Closed"),
                array("danger" => "On Hold"),
                array("warning" => "Fraud")
            );

            for ($i = $iDisplayStart; $i < $end; $i++) {
                $status = $status_list[rand(0, 2)];
                $id = ($i + 1);
                $records["data"][] = array(
                    '<script>window.location=\'' . admin_url() . 'login\'</script>',
                    '', '', '', '', '', '', '', '',
                );
            }

            if ($this->input->post('customActionType') && $this->input->post('customActionType') == 'group_action') {
                $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
                $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
            }

            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;
            $this->load->view('ajax_view', array('ajax_response' => json_encode($records)));
            return;
        }
        else {
            
            $this->load->model('admin/sixlane_model');
            $list_six_lane = array();
            $like_search = array();
            $where = array();
      
      
      
      if($this->input->post('txtg11', true)){
        $like_search['f.first_groupname_1'] = $this->db->escape_like_str($this->input->post('txtg11', true));
      }
          if($this->input->post('txtg12', true)){
        $like_search['f.first_groupname_2'] = $this->db->escape_like_str($this->input->post('txtg12', true));
      }
          if($this->input->post('txtg21', true)){
        $like_search['f.second_groupname_1'] = $this->db->escape_like_str($this->input->post('txtg21', true));
      }
          if($this->input->post('txtg22', true)){
        $like_search['f.second_groupname_2'] = $this->db->escape_like_str($this->input->post('txtg22', true));
      }
          if($this->input->post('txtg31', true)){
         $like_search['f.third_groupname_1'] = $this->db->escape_like_str($this->input->post('txtg31', true));
      }
                if($this->input->post('txtg32', true)){
                $like_search['f.third_groupname_2'] = $this->db->escape_like_str($this->input->post('txtg32', true));
            }
            if($this->input->post('txtg41', true)){
                $like_search['f.fourth_groupname_1'] = $this->db->escape_like_str($this->input->post('txtg41', true));
            }
            if($this->input->post('txtg42', true)){
                $like_search['f.fourth_groupname_2'] = $this->db->escape_like_str($this->input->post('txtg42', true));
            }
             if($this->input->post('txtg51', true)){
         $like_search['f.fifth_groupname_1'] = $this->db->escape_like_str($this->input->post('txtg51', true));
      }
                if($this->input->post('txtg52', true)){
                $like_search['f.fifth_groupname_2'] = $this->db->escape_like_str($this->input->post('txtg52', true));
            }
            if($this->input->post('txtg61', true)){
                $like_search['f.sixth_groupname_1'] = $this->db->escape_like_str($this->input->post('txtg61', true));
            }
            if($this->input->post('txtg62', true)){
                $like_search['f.sixth_groupname_2'] = $this->db->escape_like_str($this->input->post('txtg62', true));
            }
            if($this->input->post('time1', true)){
                $like_search['f.created_time'] = $this->db->escape_like_str($this->input->post('time1', true));
            }
            if($this->input->post('time2', true)){
                 $like_search['f.last_updated_time'] = $this->db->escape_like_str($this->input->post('time2', true));
            }
          $domain_id = s('ADMIN_USERID');
      $where = array('f.user_id' => $domain_id );
      
           
            $iTotalRecords = $this->sixlane_model->list_sixlane_count($where, $like_search);
            //$iTotalRecords = 6;
            $iDisplayLength = intval($this->input->post('length'));
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = intval($this->input->post('start'));
            $sEcho = intval($this->input->post('draw'));

            $records = array();
            $records["data"] = array();

            $end = $iDisplayStart + $iDisplayLength;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;
            //die("test");
      if($iTotalRecords > 0){

              $list_sixlane = $this->sixlane_model->list_sixlane($iDisplayStart, $end, $where, $like_search);
             // echo "<pre>";
              //print_r($list_sixlane);
              //die();


      }
            $id = $iDisplayStart;

            for ($i = 0; $i < count($list_sixlane); $i++) {

                $id++;
                $status = '';
                $status_css = '';
                $q_id = $list_sixlane[$i]['lane_id'];
                //die($q_id);
                $actn_buttons = '';
          
        //$actn_buttons .= '<a href="' . admin_url() . 'sales/view_order/?quote_id=' . $q_id . '" title="View Customer" class="btn btn-icon-only green margin-bottom-5"><i class="glyphicon glyphicon-eye-open"></i></a>' ;
        $actn_buttons .= '<a href="' . admin_url() . 'six_lane/edit_sixlane/?cid='.$q_id.'" title="Edit six lane" class="btn btn-icon-only green margin-bottom-5"><i class="glyphicon glyphicon-edit"></i></a>' ;
        
          $actn_buttons .= '<a href="' . admin_url() . 'six_lane/sixlane_list/?cid='.$q_id.'" title="delete six lane" class="btn btn-icon-only red margin-bottom-5"><i class="fa fa-times"></i></span>';
         
        
        //$actn_buttons .= '<span class="btn btn-icon-only blue margin-bottom-5 customer-settings" id="cus-cid'.$list_packages[$i]['id'].'" data-cid="'.$list_packages[$i]['id'].'" data-sales-rep="'. ($list_packages[$i]['sales_rep']).'" data-id="' . $q_id . '" title="Settings" data-toggle="modal" data-cus-info="<b>'.$list_packages[$i]['fname'].' '.$list_packages[$i]['lname']. '</b><br>'.$list_packages[$i]['email'].'<br>'.$list_packages[$i]['company_name'] .'"  data-target="#MdlCustomerSettings"><i class="icon-key"></i></span>';
        $list_array =  array(
                    $id, 
                   // $list_users[$i]['id'],
                     $list_sixlane[$i]['first_groupname_1'],
                    $list_sixlane[$i]['first_groupname_2'],
                    $list_sixlane[$i]['second_groupname_1'],
                    $list_sixlane[$i]['second_groupname_2'],
                    $list_sixlane[$i]['third_groupname_1'],
                    $list_sixlane[$i]['third_groupname_2'],
                    $list_sixlane[$i]['fourth_groupname_1'],
                    $list_sixlane[$i]['fourth_groupname_2'],
                    $list_sixlane[$i]['fifth_groupname_1'],
                    $list_sixlane[$i]['fifth_groupname_2'],
                    $list_sixlane[$i]['sixth_groupname_1'],
                    $list_sixlane[$i]['sixth_groupname_2'],
                    $list_sixlane[$i]['created_time'],
                    $list_sixlane[$i]['last_updated_time'],
                    $actn_buttons
                );
        
                $records["data"][] = $list_array;
            }
            if ($this->input->post('customActionType') && $this->input->post('customActionType') == 'group_action') {
                $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
                $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
            }

            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;

            $this->load->view('ajax_view', array('ajax_response' => json_encode($records)));
            return;
      }
   }
   
  function my_customers(){
    (!$this->authentication->check_logged_in("admin", false)) ? redirect('admin') : '';
    if(!admin_has_permission(11)){
      redirect('admin/dashboard');
    }
    $this->gen_contents['script_load_page'] = 'users';
        $this->gen_contents['js_files'] = array('global/plugins/datatables/media/js/jquery.dataTables.min.js', 
        'global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js',
        'global/plugins/jquery-validation/js/jquery.validate.min.js', 'global/scripts/datatable.js',
    'global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js',
        'admin/layout/scripts/sales.js');
        $this->template->set_template('admin');
        
    $lnk = 'sales/my_customers';
    $lbl = 'My Customers';
    $this->gen_contents['active_main_menu'] = array('sales_department', 'my_customers');
    
         $this->gen_contents['page_heading'] = 'Order Management - '.$lbl;
          $this->gen_contents['sales_type'] = '1';
        $this->gen_contents['page_breadcrumb'] = array(array('link' => '#', 'label' => 'Sales Department'), array('link' => $lnk, 'label' => $lbl));
        $this->gen_contents['js_script_initial'] = "Sales.init();";
        $this->template->write_view('content', 'admin/sales/customers_list', $this->gen_contents);
        $this->template->render();
   }
   
   function add_sixlane(){

        //$a=s();
        //print_r($a);
        //die("test");

    (!$this->authentication->check_logged_in("admin", false)) ? redirect('admin') : '';
    if(!admin_has_permission(9)){
      redirect('admin/dashboard');
    }
    if (!empty($_POST)) {

      $this->form_validation->set_rules('txtg11', 'Group 1 first name', 'required|trim|max_length[100]');
            $this->form_validation->set_rules('txtg12', 'Group 1 second name', 'required|trim|max_length[100]');
            $this->form_validation->set_rules('txtg21', 'Group 2 first name', 'required|trim|max_length[100]');
            $this->form_validation->set_rules('txtg22', 'Group 2 second name', 'required|trim|max_length[100]');
            $this->form_validation->set_rules('txtg31', 'Group 3 first name', 'required|trim|max_length[100]');
            $this->form_validation->set_rules('txtg32', 'Group 3 second name', 'required|trim|max_length[100]');
            $this->form_validation->set_rules('txtg41', 'Group 4 first name', 'required|trim|max_length[100]');
            $this->form_validation->set_rules('txtg42', 'Group 4 second name', 'required|trim|max_length[100]');
             $this->form_validation->set_rules('txtg51', 'Group 5 first name', 'required|trim|max_length[100]');
              $this->form_validation->set_rules('txtg52', 'Group 5 second name', 'required|trim|max_length[100]');
               $this->form_validation->set_rules('txtg61', 'Group 6 first name', 'required|trim|max_length[100]');
                $this->form_validation->set_rules('txtg62', 'Group 6 second name', 'required|trim|max_length[100]');
            if ($this->form_validation->run() == TRUE) {  //form validation
        $time=$this->input->post("time1", true);
                $time .=''.':'.$this->input->post("time2", true);

                $user_id= s('ADMIN_USERID');

                $data = array(
                    'first_groupname_1'      => $this->input->post("txtg11", true), 
                        'first_groupname_2'       => $this->input->post("txtg12", true),
                        'second_groupname_1'      => $this->input->post("txtg21", true), 
                        'second_groupname_2'       => $this->input->post("txtg22", true),
                        'third_groupname_1'      => $this->input->post("txtg31", true), 
                        'third_groupname_2'       => $this->input->post("txtg32", true),
                        'fourth_groupname_1'      => $this->input->post("txtg41", true), 
                        'fourth_groupname_2'       => $this->input->post("txtg42", true),
                        'fifth_groupname_1'      => $this->input->post("txtg51", true), 
                        'fifth_groupname_2'       => $this->input->post("txtg52", true),
                        'sixth_groupname_1'      => $this->input->post("txtg61", true), 
                        'sixth_groupname_2'       => $this->input->post("txtg62", true),
                        'time'                      =>$time,
                         'user_id'                =>$user_id,
                         'created_time'              =>date('Y-m-d h:i:s'),
                         'last_updated_time'         =>date('Y-m-d h:i:s'),
                         'status'                     => $this->input->post("status", true)
                       );
                        if (!empty($_FILES['imgg11'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg11']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg11');
                                if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g11'] = $upload_status['file_name'];
                        }}
                            }
                        
                        
                         if (!empty($_FILES['imgg12'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg12']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg12');
                                 if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g12'] = $upload_status['file_name'];
                        }
                            }
                        } 
                       


                         if (!empty($_FILES['imgg21'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg21']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg21');
                                if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g21'] = $upload_status['file_name'];
                        }
                            }
                        } 
                        
                         if (!empty($_FILES['imgg22'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg22']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg22');
                                 if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g22'] = $upload_status['file_name'];
                        }
                            }
                        } 
                       
                        


                         if (!empty($_FILES['imgg31'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg31']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg31');
                                if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g31'] = $upload_status['file_name'];
                        }
                            }
                        } 
                        
                         if (!empty($_FILES['imgg32'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg32']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg32');
                                 if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g32'] = $upload_status['file_name'];
                        }
                            }
                        } 
                       


                         if (!empty($_FILES['imgg41'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg41']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg41');
                                if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g41'] = $upload_status['file_name'];
                        }
                            }
                        } 
                        
                         if (!empty($_FILES['imgg42'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg42']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg42');
                                if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g42'] = $upload_status['file_name'];
                        }
                            }
                        } 
                        

                        if (!empty($_FILES['imgg51'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg51']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg51');
                                 if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g51'] = $upload_status['file_name'];
                        }
                            }
                        } 
                       
                         if (!empty($_FILES['imgg52'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg52']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg52');
                                 if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g52'] = $upload_status['file_name'];
                        }
                            }
                        } 
                       


                        if (!empty($_FILES['imgg61'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg61']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg61');
                                if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g61'] = $upload_status['file_name'];
                        }
                            }
                        } 
                        
                         if (!empty($_FILES['imgg62'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg62']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg62');
                                 if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g62'] = $upload_status['file_name'];
                        }
                            }
                        } 
                        if($this->input->post("status", true) ==1){
                        $data_update=array(
                            'status' => 0
                            );
                        $this->db->where('user_id',$user_id);
                         $this->db->update('six_lane', $data_update);
                      }
                       
                        
                        
                        
                       $this->db->insert('six_lane', $data);
                       $insert_id = $this->db->insert_id();
                       
                       if($insert_id > 0){
                        
                          sf('success_message', "Six lane added successfully.");
                       }else{
                          sf('error_message', 'Error! There is an issue with adding Six lane. Please try again later.');
                       }
                       redirect('admin/six_lane/add_sixlane');
               }else{
                 $this->gen_contents['form_validation_error'] = validation_errors();
               }
    }
    
    $this->gen_contents['script_load_page'] = 'users';
        $this->gen_contents['js_files'] = array('global/plugins/datatables/media/js/jquery.dataTables.min.js', 
        'global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js',
        'global/plugins/jquery-validation/js/jquery.validate.min.js', 'global/scripts/datatable.js',
    'global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js',
        'admin/layout/scripts/six_lane.js');
        $this->template->set_template('admin');
        
    $lnk = 'Six lane/create Six lane';
    $lbl = 'Create New Six lane';
    $this->gen_contents['active_main_menu'] = array('Manage Six lane', 'customers');
    
         $this->gen_contents['page_heading'] = 'Manage Six lane - '.$lbl;
        $logo=s('logo');
        if($logo == 1){
                $logo=1;
        }else{
            $logo=0;
        }
         $this->gen_contents['access'] = $logo;
        $this->gen_contents['page_breadcrumb'] = array(array('link' => '#', 'label' => 'Manage Six lane'), array('link' => $lnk, 'label' => $lbl));
        $this->gen_contents['js_script_initial'] = "six_lane.init();";
        $this->template->write_view('content', 'admin/six_lane/add_six_lane', $this->gen_contents);
        $this->template->render();
   }


function delete_img1($id,$field,$name){
            $this->load->helper("image_helper");
            
             $image=c('file_upload_path').'admin/'.$name;
             $image1=c('file_upload_path').'admin/thumb_large_'.$name;
             $image2=c('file_upload_path').'admin/thumb_medium_'.$name;
             $image3=c('file_upload_path').'admin/thumb_thumb_'.$name;

            //die("tes");
            if(file_exists($image)){
            $delete=unlink($image);
            }
            if(file_exists($image1)){
            $delete1=unlink($image1);
            }
            if(file_exists($image2)){
            $delete2=unlink($image2);
            }
            if(file_exists($image3)){
            $delete3=unlink($image3);
            }
              $data_update=array(
                            $field => ''
                            );
                        $this->db->where('lane_id',$id);
                       $update=  $this->db->update('six_lane', $data_update);

if($update){
                        
                            sf('success_message', "Logo deleted successfully.");
                       }else{
                            sf('error_message', 'Error! There is an issue with deleting four lane logo. Please try again later.');
                       }
                   
        //         $this->gen_contents['form_validation_error'] = validation_errors();
               
        redirect('admin/six_lane/view_image/?cid='.$id);
        
        $this->gen_contents['script_load_page'] = 'users';
         $this->gen_contents['script_load_page'] = 'users';
        $this->gen_contents['js_files'] = array('global/plugins/datatables/media/js/jquery.dataTables.min.js', 
        'global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js',
        'global/plugins/jquery-validation/js/jquery.validate.min.js', 'global/scripts/datatable.js',
    'global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js',
        'admin/layout/scripts/six_lane.js');
        $this->template->set_template('admin');
        
    $lnk = 'Manage six lane/six lane';
    $lbl = 'Edit six lane';
    $this->gen_contents['active_main_menu'] = array('Manage six lane', 'customers');
    $logo=s('logo');
        if($logo == 1){
                $logo=1;
        }else{
            $logo=0;
        }
         $this->gen_contents['access'] = $logo;
        $this->gen_contents['page_heading'] = 'Manage Ice Sheet';
        $this->gen_contents['sales_type'] = '2';
        $this->gen_contents['js_script_initial'] = "six.init();";
        $this->template->write_view('content', 'admin/sixlane/view_six_lane', $this->gen_contents);
        $this->template->render();
     }


   
   function edit_sixlane(){
        if(!admin_has_permission(9)){
      redirect('admin/dashboard');
    }
    (!$this->authentication->check_logged_in("admin", false)) ? redirect('admin') : '';
    $id = $this->input->get('cid', true);
        $where = array('lane_id' => $id);
        //print_r($where);
        //die("test");
    if(s('ADMIN_TYPE') != 'Y'){
      //$where['sales_rep'] = s('ADMIN_USERID');
    }
    
    if (!empty($_POST)) {
            $this->form_validation->set_rules('txtg11', 'Group 1 first name', 'required|trim|max_length[100]');
            $this->form_validation->set_rules('txtg12', 'Group 1 second name', 'required|trim|max_length[100]');
            $this->form_validation->set_rules('txtg21', 'Group 2 first name', 'required|trim|max_length[100]');
            $this->form_validation->set_rules('txtg22', 'Group 2 second name', 'required|trim|max_length[100]');
            $this->form_validation->set_rules('txtg31', 'Group 3 first name', 'required|trim|max_length[100]');
            $this->form_validation->set_rules('txtg32', 'Group 3 second name', 'required|trim|max_length[100]');
            $this->form_validation->set_rules('txtg41', 'Group 4 first name', 'required|trim|max_length[100]');
            $this->form_validation->set_rules('txtg42', 'Group 4 second name', 'required|trim|max_length[100]');
             $this->form_validation->set_rules('txtg51', 'Group 5 first name', 'required|trim|max_length[100]');
            $this->form_validation->set_rules('txtg52', 'Group 5 second name', 'required|trim|max_length[100]');
            $this->form_validation->set_rules('txtg61', 'Group 6 first name', 'required|trim|max_length[100]');
            $this->form_validation->set_rules('txtg62', 'Group 6 second name', 'required|trim|max_length[100]');
       if ($this->form_validation->run() == TRUE) {  //form validation
        
                $data = array(
                    
                       'first_groupname_1'      => $this->input->post("txtg11", true), 
                        'first_groupname_2'       => $this->input->post("txtg12", true),
                        'second_groupname_1'      => $this->input->post("txtg21", true), 
                        'second_groupname_2'       => $this->input->post("txtg22", true),
                        'third_groupname_1'      => $this->input->post("txtg31", true), 
                        'third_groupname_2'       => $this->input->post("txtg32", true),
                        'fourth_groupname_1'      => $this->input->post("txtg41", true), 
                        'fourth_groupname_2'       => $this->input->post("txtg42", true),
                        'fifth_groupname_1'      => $this->input->post("txtg51", true), 
                        'fifth_groupname_2'       => $this->input->post("txtg52", true),
                        'sixth_groupname_1'      => $this->input->post("txtg61", true), 
                        'sixth_groupname_2'       => $this->input->post("txtg62", true),
                        'hr'                      =>$this->input->post("time1", true),
                        'min'                      =>$this->input->post("time2", true),
                        'update_status'   =>1,
                        'last_updated_time'         =>date('Y-m-d h:i:s')
                         
                        
                       );
if (!empty($_FILES['imgg11'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg11']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg11');
                                if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g11'] = $upload_status['file_name'];
                        }}
                            }
                        
                        
                         if (!empty($_FILES['imgg12'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg12']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg12');
                                 if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g12'] = $upload_status['file_name'];
                        }
                            }
                        } 
                       


                         if (!empty($_FILES['imgg21'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg21']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg21');
                                if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g21'] = $upload_status['file_name'];
                        }
                            }
                        } 
                        
                         if (!empty($_FILES['imgg22'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg22']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg22');
                                 if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g22'] = $upload_status['file_name'];
                        }
                            }
                        } 
                       
                        


                         if (!empty($_FILES['imgg31'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg31']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg31');
                                if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g31'] = $upload_status['file_name'];
                        }
                            }
                        } 
                        
                         if (!empty($_FILES['imgg32'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg32']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg32');
                                 if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g32'] = $upload_status['file_name'];
                        }
                            }
                        } 
                       


                         if (!empty($_FILES['imgg41'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg41']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg41');
                                if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g41'] = $upload_status['file_name'];
                        }
                            }
                        } 
                        
                         if (!empty($_FILES['imgg42'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg42']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg42');
                                if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g42'] = $upload_status['file_name'];
                        }
                            }
                        } 
                        

                        if (!empty($_FILES['imgg51'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg51']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg51');
                                 if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g51'] = $upload_status['file_name'];
                        }
                            }
                        } 
                       
                         if (!empty($_FILES['imgg52'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg52']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg52');
                                 if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g52'] = $upload_status['file_name'];
                        }
                            }
                        } 
                       


                        if (!empty($_FILES['imgg61'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg61']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg61');
                                if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g61'] = $upload_status['file_name'];
                        }
                            }
                        } 
                        
                         if (!empty($_FILES['imgg62'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg62']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg62');
                                 if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g62'] = $upload_status['file_name'];
                        }
                            }
                        } 
                       
                      $sts = $this->db->update('six_lane', $data, $where);
                      
                       
                       if($sts){
                        $first_groupname_1      = $this->input->post("txtg11", true); 
                     
                       
                          sf('success_message', "Six lane has been updated.");
                       }else{
                          sf('error_message', 'Error! There is an issue with update. Please try again later.');
                       }
                       redirect('admin/six_lane/edit_sixlane/?cid='.$id);
               }else{
                 $this->gen_contents['form_validation_error'] = validation_errors();
               }
    }
    
    
    
    $this->gen_contents['sixlane'] = $this->common_model->get_data('six_lane', '*', $where);

    $this->gen_contents['sixlane'] = @$this->gen_contents['sixlane'][0];
       // echo $this->gen_contents['package'];
        //die("test");
    if(empty($this->gen_contents['sixlane'])){
      sf('error_message', 'Error! Please ensure that you have enough permission to edit such information.');
      redirect('admin/dashboard');
    }
    $this->gen_contents['script_load_page'] = 'users';
        $this->gen_contents['js_files'] = array('global/plugins/datatables/media/js/jquery.dataTables.min.js', 
        'global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js',
        'global/plugins/jquery-validation/js/jquery.validate.min.js', 'global/scripts/datatable.js',
    'global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js',
        'admin/layout/scripts/six_lane.js');
        $this->template->set_template('admin');
        
    $lnk = 'Manage six lane/six lane';
    $lbl = 'Edit six lane';
    $this->gen_contents['active_main_menu'] = array('Manage six lane', 'customers');
    $logo=s('logo');
        if($logo == 1){
                $logo=1;
        }else{
            $logo=0;
        }
         $this->gen_contents['access'] = $logo;
        $this->gen_contents['page_heading'] = 'Manage Ice Sheet';
        $this->gen_contents['sales_type'] = '2';
        $this->gen_contents['js_script_initial'] = "six.init();";
        $this->template->write_view('content', 'admin/six_lane/edit_six_lane', $this->gen_contents);
        $this->template->render();
    
   }
 function view_image(){


         if(!admin_has_permission(9)){
            redirect('admin/dashboard');
        }
            $user_id=s('ADMIN_USERID');

           
       (!$this->authentication->check_logged_in("admin", false)) ? redirect('admin') : '';
        $id = $this->input->get('cid', true);
       
        $where = array(
            'user_id' =>$user_id,
            'status' => 1
            );
        //print_r($where);
        //die("test");

        if (!empty($_POST)) {
       
        //die($id);;
            
                //echo '<pre>';
                //print_r($_FILES);
                //die("test");
                if (!empty($_FILES['imgg11']['name'])) {
                  

                            $this->load->helper('image_helper');

                            if ($_FILES['imgg11']['name'] != '') {
                              $upload_status = upload_image('admin_profile', 'imgg11',$id);
                             // die("sad11sd");
                                
                            }
                            if (!empty($upload_status['file_name'])) {
                            $data['img_g11'] = $upload_status['file_name'];
                        }
                        }
                      //  die("hvs"); 
                         
                        // if //(strlen($_FILES['imgg12']) > 0
                            if(!empty($_FILES['imgg12']['name'])){
                            
                            //die("test1");
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg12']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg12',$id);
                            }
                            if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g12'] = $upload_status['file_name'];
                        }
                        } 
                        


                         if (!empty($_FILES['imgg21']['name'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg21']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg21',$id);
                            }
                             if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g21'] = $upload_status['file_name'];
                        }
                        } 
                       
                         if (!empty($_FILES['imgg22']['name'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg22']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg22',$id);
                            }
                             if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g22'] = $upload_status['file_name'];
                        }
                        } 
                       
                        


                         if (!empty($_FILES['imgg31']['name'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg31']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg31',$id);
                            }
                             if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g31'] = $upload_status['file_name'];
                        }
                        } 
                       
                         if (!empty($_FILES['imgg32']['name'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg32']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg32',$id);
                            }
                             if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g32'] = $upload_status['file_name'];
                        }
                        } 
                       


                         if (!empty($_FILES['imgg41']['name'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg41']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg41',$id);
                            }
                            if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g41'] = $upload_status['file_name'];
                        }
                        } 
                        
                         if (!empty($_FILES['imgg42']['name'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg42']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg42',$id);
                            }
                            if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g42'] = $upload_status['file_name'];
                        }
                        }
                          if (!empty($_FILES['imgg51']['name'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg51']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg51',$id);
                            }
                            if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g51'] = $upload_status['file_name'];
                        }
                        }
                          if (!empty($_FILES['imgg52']['name'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg52']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg52',$id);
                            }
                            if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g52'] = $upload_status['file_name'];
                        }
                        }
                         if (!empty($_FILES['imgg61']['name'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg61']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg61',$id);
                            }
                            if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g61'] = $upload_status['file_name'];
                        }
                        }
                          if (!empty($_FILES['imgg62']['name'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg62']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg62',$id);
                            }
                            if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g62'] = $upload_status['file_name'];
                        }
                        }
                        if (!empty($_FILES['imgg1_large']['name'])) {

                            $this->load->helper('image1_helper');
                            if ($_FILES['imgg1_large']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg1_large',$id);
                            }
                            if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('four_lanes', 'img_g11');
                            $data['img_g1_large'] = $upload_status['file_name'];
                        }
                        }
                        if (!empty($_FILES['imgg2_large']['name'])) {

                            $this->load->helper('image1_helper');
                            if ($_FILES['imgg2_large']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg2_large',$id);
                            }
                            if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('four_lanes', 'img_g11');
                            $data['img_g2_large'] = $upload_status['file_name'];
                        }
                        } 
                        if (!empty($_FILES['imgg3_large']['name'])) {

                            $this->load->helper('image1_helper');
                            if ($_FILES['imgg3_large']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg3_large',$id);
                            }
                            if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('four_lanes', 'img_g11');
                            $data['img_g3_large'] = $upload_status['file_name'];
                        }
                        }
                        if (!empty($_FILES['imgg4_large']['name'])) {

                            $this->load->helper('image1_helper');
                            if ($_FILES['imgg4_large']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg4_large',$id);
                            }
                            if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('four_lanes', 'img_g11');
                            $data['img_g4_large'] = $upload_status['file_name'];
                        }
                        }
                        if (!empty($_FILES['imgg5_large']['name'])) {

                            $this->load->helper('image1_helper');
                            if ($_FILES['imgg5_large']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg5_large',$id);
                            }
                            if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('four_lanes', 'img_g11');
                            $data['img_g5_large'] = $upload_status['file_name'];
                        }
                        }
                        if (!empty($_FILES['imgg6_large']['name'])) {

                            $this->load->helper('image1_helper');
                            if ($_FILES['imgg6_large']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg6_large',$id);
                            }
                            if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('four_lanes', 'img_g11');
                            $data['img_g6_large'] = $upload_status['file_name'];
                        }
                        }
                         
                        //print_r($data);
                        //die("test");
                        
                      $sts = $this->db->update('six_lane', $data, $where);
                      
                       
                       if($sts){
                        $first_groupname_1      = $this->input->post("txtg11", true); 
                     
                       
                            sf('success_message', "Logo has been updated.");
                       }else{
                            sf('error_message', 'Error! There is an issue with update. Please try again later.');
                       }
                       redirect('admin/six_lane/view_image/?cid='.$id);
               
        }
        
        
        $this->gen_contents['sixlane'] = $this->common_model->get_data('six_lane', '*', $where);

        $this->gen_contents['sixlane'] = @$this->gen_contents['sixlane'][0];
       //echo $this->gen_contents['sixlane'];
      
        if(empty($this->gen_contents['sixlane'])){
            sf('error_message', 'Error! Please ensure that you have enough permission to edit such information.');
            redirect('admin/dashboard');
        }
        $this->gen_contents['script_load_page'] = 'users';
        $this->gen_contents['js_files'] = array('global/plugins/datatables/media/js/jquery.dataTables.min.js', 
        'global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js',
        'global/plugins/jquery-validation/js/jquery.validate.min.js', 'global/scripts/datatable.js',
        'global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js',
        'admin/layout/scripts/six_lane.js');
        $this->template->set_template('admin');
        
        $lnk = 'Manage Logo/Logo';
        $lbl = 'Edit lane Logo';
        $this->gen_contents['active_main_menu'] = array('Manage Four lane', 'customers');
        $logo=s('logo');
        if($logo == 1){
                $logo=1;
        }else{
            $logo=0;
        }
         $this->gen_contents['access'] = $logo;
        
        $this->gen_contents['page_heading'] = 'Manage Logo ';
        $this->gen_contents['sales_type'] = '2';
        //$this->gen_contents['page_breadcrumb'] = array(array('link' => '#', 'label' => 'Manage Four lane'), array('link' => $lnk, 'label' => $lbl));
        $this->gen_contents['js_script_initial'] = "six_lane.init();";
        //die("test");
        $this->template->write_view('content', 'admin/six_lane/view_six_lane', $this->gen_contents);
        $this->template->render();
    
        
        
     }
      function scroll_news(){
        if(!admin_has_permission(9)){
            redirect('admin/dashboard');
        }
        $id=s('ADMIN_USERID'); 

        $where = array(
            'user_id' => $id

            );
        $scroll_id = $this->input->get('cid', true);
        $condition = array(
            'scroll_id' => $scroll_id

            );
        
        if ($_POST) {
           $data = array(
                        
                       'news'      => $this->input->post("scroll", true), 
                        'status'   =>1
                         
                        
                       );
               
                        
                      $sts = $this->db->update('scroll_news', $data, $condition);
                      
                       
                       if($sts){
                        
                     
                       
                            sf('success_message', "Scroll News has been updated.");
                       }else{
                            sf('error_message', 'Error! There is an issue with update. Please try again later.');
                       }
                       redirect('admin/six_lane/scroll_news');
               //}else{
                 //$this->gen_contents['form_validation_error'] = validation_errors();
              // }
        }
        
        
        
        $this->gen_contents['scroll_news'] = $this->common_model->get_data('scroll_news', '*', $where);

        $this->gen_contents['scroll_news'] = @$this->gen_contents['scroll_news'][0];
       // echo $this->gen_contents['package'];
        //die("test");
        if(empty($this->gen_contents['scroll_news'])){
            sf('error_message', 'Error! Please ensure that you have enough permission to edit such information.');
            redirect('admin/dashboard');
        }
        $this->gen_contents['script_load_page'] = 'users';
       $this->gen_contents['js_files'] = array('global/plugins/datatables/media/js/jquery.dataTables.min.js', 
        'global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js',
        'global/plugins/jquery-validation/js/jquery.validate.min.js', 'global/scripts/datatable.js',
    'global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js',
        'admin/layout/scripts/six_lane.js');
        $this->template->set_template('admin');
        
    $lnk = 'Manage Scroll News/scroll news';
  
    $this->gen_contents['active_main_menu'] = array('Manage six lane', 'customers');
    $logo=s('logo');
        if($logo == 1){
                $logo=1;
        }else{
            $logo=0;
        }
         $this->gen_contents['access'] = $logo;
        $this->gen_contents['page_heading'] = 'Manage Scroll News ';
        $this->gen_contents['sales_type'] = '2';
        $this->gen_contents['js_script_initial'] = "six.init();";
        $this->template->write_view('content', 'admin/six_lane/scroll_news', $this->gen_contents);
        $this->template->render();
        
     }

    function delete_img($id,$field,$name){
            $this->load->helper("image_helper");
            
             $image=c('file_upload_path').'admin/'.$name;
             $image1=c('file_upload_path').'admin/thumb_large_'.$name;
             $image2=c('file_upload_path').'admin/thumb_medium_'.$name;
             $image3=c('file_upload_path').'admin/thumb_thumb_'.$name;

            //die("tes");
            if(file_exists($image)){
            $delete=unlink($image);
            }
            if(file_exists($image1)){
            $delete1=unlink($image1);
            }
            if(file_exists($image2)){
            $delete2=unlink($image2);
            }
            if(file_exists($image3)){
            $delete3=unlink($image3);
            }
              $data_update=array(
                            $field => ''
                            );
                        $this->db->where('lane_id',$id);
                       $update=  $this->db->update('six_lane', $data_update);

if($update){
                        
                            sf('success_message', "Logo deleted successfully.");
                       }else{
                            sf('error_message', 'Error! There is an issue with deleting four lane logo. Please try again later.');
                       }
                   
        //         $this->gen_contents['form_validation_error'] = validation_errors();
               
        
        redirect('admin/six_lane/edit_sixlane/?cid='.$id);
        $this->gen_contents['script_load_page'] = 'users';
        $this->gen_contents['script_load_page'] = 'users';
        $this->gen_contents['js_files'] = array('global/plugins/datatables/media/js/jquery.dataTables.min.js', 
        'global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js',
        'global/plugins/jquery-validation/js/jquery.validate.min.js', 'global/scripts/datatable.js',
    'global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js',
        'admin/layout/scripts/six_lane.js');
        $this->template->set_template('admin');
        
    $lnk = 'Manage six lane/six lane';
    $lbl = 'Edit six lane';
    $this->gen_contents['active_main_menu'] = array('Manage six lane', 'customers');
    $logo=s('logo');
        if($logo == 1){
                $logo=1;
        }else{
            $logo=0;
        }
         $this->gen_contents['access'] = $logo;
        $this->gen_contents['page_heading'] = 'Manage six lane - '.$lbl;
        $this->gen_contents['sales_type'] = '2';
        $this->gen_contents['js_script_initial'] = "six.init();";
        $this->template->write_view('content', 'admin/six_lane/edit_six_lane', $this->gen_contents);
        $this->template->render();
     }
   

 


}