<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class User extends CI_Controller {

    /**
     * Admin username
     *
     * @var string
     */
    var $username = "";

    /**
     * Admin password
     *
     * @var string
     */
    var $password = "";

    /**
     * Page title
     *
     * @var string
     */
    var $title = '';

    /**
     * General contents
     *
     * @var Array
     */
    var $gen_contents = array();
    var $mcontents;
    var $merror;
    var $msuccess;
    /**
     * Admin constructor
     *
     */

   
    public function index() {
        $this->template->set_template('adminlogin');
        if (s('ADMIN_USERID')) {
            redirect('admin/dashboard');
        }
        else {
            $this->gen_contents['user_id'] = $this->authentication->admin_logged_in();
            if (!empty($_POST)) {
                $this->load->library('form_validation');
                $this->_init_adminlogin_validation_rules(); //server side validation of input values
                if ($this->form_validation->run() == TRUE) {// form validation
                    $this->_init_adminlogin_details();
                    $login_details['username'] = $this->username;
                    $login_details['password'] = $this->password;
                    $msg = $this->authentication->process_admin_login($login_details);
                    if ($msg == 'success'){
                        remove_temp_images(); // We will remove old temp files 
                        redirect("admin/dashboard");
                    }
                    else if ($msg == 'inactive') {
                        sf('error_message', 'Your account has not been activated');
                        redirect("admin");
                    }
                    else {
                        sf('error_message', 'Invalid username or password');
                        redirect("admin");
                    }
                }
                else {
                    sf('error_message', validation_errors());
                    redirect("admin");
                }
            }
            $this->template->render();
        }
    }

    /**
     * validating the form elemnets
     */
    function _init_adminlogin_validation_rules() {
        $this->form_validation->set_rules('admin_username', 'username', 'required|max_length[50]');
        $this->form_validation->set_rules('admin_password', 'password', 'required|max_length[20]');
    }

    /**
     * Initialising the data
     *
     */
    function _init_adminlogin_details() {
        $this->username = $this->input->post("admin_username", true);
        $this->password = $this->input->post("admin_password", true);
    }

    function forgot_password(){
        $this->load->library('form_validation');
        $this->template->set_template('adminlogin');
        if (s('ADMIN_USERID')) {
            redirect('admin/dashboard');
        }
        else { 
            ($this->authentication->check_logged_in("admin", false)) ? redirect('admin/user/dashboard') : '';
            if (!empty($_POST)) { 
                 $this->load->model('admin/admin_model');
                 $this->load->helper('email_helper');
                 $this->load->helper('string_helper');
                 $this->form_validation->set_rules('fgtEmail', 'email', 'required|trim|valid_email|max_length[30]');
                 if($this->form_validation->run() == TRUE) {  
                    $forgot_email = $this->input->post('fgtEmail', true);
                    $forgot_check = $this->common_model->get_data( 'user', 'fname as first_name, email',array('email'=>$forgot_email, 'active'=> '1'));
                    if(!empty($forgot_check)){
                        $data = $forgot_check[0];
                        $data['activation_code'] = random_string('numeric', 6);
                        $status = $this->admin_model->update_admin_fgt_code($data);
                        if($status){
                            process_and_send_mail($data['email'],
                            array('first_name' => $data['first_name'], 
                                  'reset_link' => '<a target="_blank" href="' . base_url() . 'admin/resetpass/' . $data['activation_code'].'" >' . base_url() . 'admin/resetpass/' . $data['activation_code'].'</a>',
                                  'regards_name' => c('regards_name'),
                                  'email_bottom_instruction' => c('email_bottom_instruction'),
                                 ),
                                       'admin_forgot_password', 
                                       array(), 
                                       array(),
                                       '', 
                                       '');
                               sf('success_message', 'Your forgot password link send to you mail.');
                            }else{ 
                                sf('error_message', 'There is a problem in password change');
                            }
                        }else{
                           sf('error_message', 'Email does not exist in our database');
                       }
                       redirect('admin/forgot_password');
                }
            }
            $this->template->render();
        }
    }
    
    function resetpass($forgot_code = ''){
            $this->load->model('admin/admin_model');
            if(!empty($forgot_code)){ 
                $status = $this->admin_model->get_forgot_code($forgot_code);
                if(!empty($status)){
                    //redirect('admin/resetpass');
                }else{
                    sf('error_message', 'Invalid forgot code');
                    redirect('admin');
                }
            }
            if(!empty($_POST)){
                //Server validation
                $this->form_validation->set_rules('resetPass', 'Enter New Password', 'required|trim|max_length[10]');
                $this->form_validation->set_rules('retypePass', 'Enter Retype Password', 'required|trim|max_length[10]|callback_password_match');
                if ($this->form_validation->run() == TRUE) {
                    $data = array(
                            'password' => $this->input->post("resetPass", true),
                            'activation_code'=> $forgot_code
                        ); 
                    $status = $this->admin_model->update_fgt_password($data);
                    if($status){
                        redirect('admin');
                    }else{
                        sf('error_message', 'Password change failed');
                    }  
                    
                }else{
                   $this->gen_contents['form_validation_error'] = validation_errors();
               } 
            }
            $this->template->write_view('content', 'admin/resetpass', $this->gen_contents);
            $this->template->render();
    }
    function change_password(){
        if (!empty($_POST)) {
            if (!$this->authentication->check_logged_in("admin", false)) { // If there is no login exists just return the error
                $this->load->view('ajax_view', array('ajax_response' => json_encode(array('login_error' => 1))));
                return;
            }
            else {
                $this->load->model('admin/admin_model'); 
                /* Code here: loading the validation library */
                $this->load->library('form_validation');
                //Codeigniter form validation for changepassword fields
                $this->form_validation->set_rules('current_password', 'current password', 'required|trim|max_length[20]');
                $this->form_validation->set_rules('new_password', 'new password', 'required|trim|max_length[20]');
                $this->form_validation->set_rules('new_password_confirm', 'confirm password', 'required|trim|max_length[20]|callback_password_match');

                if ($this->form_validation->run() == TRUE) {
                    $status = $this->admin_model->update_admin_password($this->input->post("current_password", true), $this->input->post("new_password", true), s('ADMIN_USERID'));
                    if (!empty($status['invalid_old_password'])) {
                        $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'message' => 'Old password you entered is wrong.'))));
                        return;
                    }
                    else if ($status) {
                        $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'success', 'message' => 'Your password has been updated successfully.'))));
                        return;
                    }
                    else {
                        $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'message' => 'There is a problem with update. Please try later'))));
                        return;
                    }
                }
                else {
                    $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'message' => validation_errors()))));
                    return;
                }
            }
        }
        (!$this->authentication->check_logged_in("admin", false)) ? redirect('admin') : '';
        $this->gen_contents['script_load_page'] = 'users';
        $this->gen_contents['js_files'] = array('global/plugins/jquery-validation/js/jquery.validate.min.js', 'admin/layout/scripts/user.js');
        $this->template->set_template('admin');
        $this->gen_contents['page_heading'] = 'Change Password';
        $this->gen_contents['active_main_menu'] = array('settings', 'change_password');
        $this->gen_contents['page_breadcrumb'] = array(array('link' => '#', 'label' => 'Settings'), array('link' => 'change_password', 'label' => 'Change Password'));
        $this->gen_contents['js_script_initial'] = "User.init();";
        
        $this->template->write_view('content', 'admin/change_password', $this->gen_contents);
        $this->template->render();
    }

    function profile() {
        (!$this->authentication->check_logged_in("admin", false)) ? redirect('admin') : '';
        if (!empty($_POST)) {
            $this->load->model('admin/admin_model');
            $this->load->library('form_validation');

            //Codeigniter validation
            $this->form_validation->set_rules('txtFirstName', 'first name', 'required|trim|max_length[20]');
            $this->form_validation->set_rules('txtLastName', 'last name', 'required|trim|max_length[20]');
            $this->form_validation->set_rules('txtEmail', 'email', 'required|trim|valid_email|max_length[40]|callback_check_email_exists');

            if ($this->form_validation->run() == TRUE) {// form validation
                $data = array(
                    'fname' => $this->input->post("txtFirstName", true),
                    'lname' => $this->input->post("txtLastName", true),
                    'email' => $this->input->post("txtEmail", true)
                );

                if (!empty($_FILES['flProfielImage'])) {
                    $this->load->helper('image_helper');
                    if ($_FILES['flProfielImage']['name'] != '') {
                        $upload_status = upload_image('admin_profile', 'flProfielImage');
                    }
                }
                if (!empty($upload_status['file_name'])) {
                    // Remove the existing image if the file upload is success
                    $old_image_name = $this->common_model->get_data('user', 'profile_image');
                    $data['profile_image'] = $upload_status['file_name'];
                }

                if (!empty($upload_status['upload_error'])) {
                    $this->gen_contents['form_validation_error'] = $upload_status['upload_error'];
                }
                else {
                    $status = $this->admin_model->update_admin_profile($data, s('ADMIN_USERID'));
                    if ($status) {
                        if (!empty($upload_status['file_name']))
                            $this->session->set_userdata(array('ADMIN_PROFILE_IMAGE' => $data['profile_image'], 'ADMIN_NAME' => $data['fname'])); // Just keep this name for printing at the top header
                        if (!empty($old_image_name[0]['profile_image'])) {
                            // Remove old images
                            delete_image('admin_profile', $old_image_name[0]['profile_image']);
                        }
                        sf('success_message', 'Your profile has been updated.');
                    }
                    else {
                        sf('error_message', 'There is a problem with update.');
                    }
                }
            }
            else {
                $this->gen_contents['form_validation_error'] = validation_errors();
            }
        }
        $this->gen_contents['script_load_page'] = 'users';
        $this->gen_contents['js_files'] = array('global/plugins/jquery-validation/js/jquery.validate.min.js', 'admin/layout/scripts/user.js');
        $this->template->set_template('admin');
        $this->gen_contents['page_heading'] = 'Profile';
        $this->gen_contents['profile_data'] = $this->common_model->get_data('user', 'fname as first_name, lname as last_name, email, profile_image',array('id' => s('ADMIN_USERID')));
        $this->gen_contents['active_main_menu'] = array('settings', 'profile');
        $this->gen_contents['page_breadcrumb'] = array(array('link' => '#', 'label' => 'Settings'), array('link' => 'profile', 'label' => 'Profile'));
        $this->gen_contents['js_script_initial'] = "User.init();";
        $this->template->write_view('content', 'admin/profile', $this->gen_contents);
        $this->template->render();
    }
	function check_email_exists($email){
		$this->load->library('form_validation');
        $sts = $this->common_model->get_data('user', 'email', array('id !=' => s('ADMIN_USERID'), 'email' => $email ));
        if(!empty($sts)){
        	$this->form_validation->set_message('check_email_exists', 'Already user with same email exists.');
            return FALSE;
           
         }
            else {
                return TRUE;
            }
	}
    function password_match($conf_pwd) {
        $this->load->library('form_validation');
        $new_pwd = $this->input->post("new_password", true);
        if(!empty($new_pwd)){
            if ($new_pwd != $conf_pwd) {
            $this->form_validation->set_message('password_match', 'New and confirm password does not match');
            return FALSE;
            }
            else {
                return TRUE;
            }
            
        }else{
            $retype_pwd = $this->input->post("resetPass", true);
            if ($retype_pwd != $conf_pwd) {
                $this->form_validation->set_message('password_match', 'Reset and Retype password does not match');
                return FALSE;
            }
            else {
                return TRUE;
            }
        }
        
    }

    function logout() {
        $this->authentication->admin_logout();
        redirect('admin');
    }
    
	function admins() { 
		(!$this->authentication->check_logged_in("admin", false)) ? redirect('admin') : '';
		//if(s('ADMIN_TYPE') != 'Y') redirect('admin');
                     if(!admin_has_permission(1)){ redirect('admin');}
        $this->gen_contents['script_load_page'] = 'users';
        $this->gen_contents['js_files'] = array('global/plugins/datatables/media/js/jquery.dataTables.min.js', 
        'global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js',
        'global/plugins/jquery-validation/js/jquery.validate.min.js', 'global/scripts/datatable.js', 'admin/layout/scripts/admins.js');
        $this->template->set_template('admin');
        $this->gen_contents['page_heading'] = 'Administrators';
        $this->gen_contents['active_main_menu'] = array('users', 'admins');
        $this->gen_contents['page_breadcrumb'] = array(array('link' => '#', 'label' => 'Administrators'));

        $this->gen_contents['js_script_initial'] = "Admins.init();";

        $this->gen_contents['admin_reset_password_form'] = true;
        $this->template->write_view('content', 'admin/admins/admins_list', $this->gen_contents);
        $this->template->render();
    }
    
    function new_admin(){
    	(!$this->authentication->check_logged_in("admin", false) || !(admin_has_permission(2))) ? redirect('admin') : '';
        if (!empty($_POST)) {

        	
        	$this->form_validation->set_rules('txtFirstName', 'first name', 'required|trim|max_length[50]');
               $this->form_validation->set_rules('txtLastName', 'last name', 'required|trim|max_length[50]');
               $this->form_validation->set_rules('txtEmail', 'email', 'required|trim|valid_email|max_length[50]|callback_email_validate');
             //  $this->form_validation->set_rules('txtUsername', 'username', 'required|trim|min_length[5]|max_length[12]|callback_username_validate');
               $this->form_validation->set_rules('new_password', 'new password', 'required|trim|max_length[20]');
                $this->form_validation->set_rules('selectpackage', 'select Package', 'required|trim|max_length[50]');
               $this->form_validation->set_rules('new_password_confirm', 'confirm password', 'required|trim|max_length[20]|callback_password_match_admin');
               $this->form_validation->set_rules('txtdomain', 'Domain name', 'required|trim|max_length[50]|callback_domain_validate');
              
               
               if ($this->form_validation->run() == TRUE) {  //form validation
               		  //$encrypt_time = strtotime(get_cur_date_time());
	                  $password     = sha1(trim($this->input->post("new_password", true)));
	                 // $password     = create_secure_password($password.$encrypt_time);
                    $logo = $this->input->post("logo", true);
                    
                    if($logo ='')
                    {
                      //die("test");
                      $logo=0;
                    }
                  	$this->load->library('user_agent');

	                  $data = array(
                       'fname'      => $this->input->post("txtFirstName", true), 
                       'lname'       => $this->input->post("txtLastName", true),
                       'email'           => $this->input->post("txtEmail", true),
                       'domian'           => $this->input->post("txtdomain", true),
                       'package'           => $this->input->post("selectpackage", true), 
                       'phone'           => $this->input->post("txtPhone", true), 
                       'password'        => $password,
                       'date_created'    => get_cur_date_time(),
                       'active'          => '1',
	                   'logo' => $this->input->post("logo", true),
	                   'admin'	=> '1' 
                     
                       );
                       
                       
                       if (!empty($_FILES['flProfielImage'])) {
		                    $this->load->helper('image_helper');
		                    if ($_FILES['flProfielImage']['name'] != '') {
		                        $upload_status = upload_image('admin_profile', 'flProfielImage');
		                    }
		                } 
		                if (!empty($upload_status['file_name'])) {
		                    // Remove the existing image if the file upload is success
		                    //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
		                    $data['profile_image'] = $upload_status['file_name'];
		                }
						
		                if (!empty($upload_status['upload_error'])) {
		                    $this->gen_contents['form_validation_error'] = $upload_status['upload_error'];
		                }
		                else {
			               $this->db->insert('user', $data);
	                       $id = $this->db->insert_id();
	                       if($id){


	                       	
	                       //$id_array = array();
						        $chkPermissions = $this->input->post('selectpackage', true);

                    switch($chkPermissions){
                      case 1:
                      //$id_array=array(5,8);
                      $sql="insert into admin_permissions(permission_id,admin_id)
                        values('5','$id')";
                      $this->db->query($sql);
                      $sql1="insert into admin_permissions(permission_id,admin_id)
                        values('8','$id')";
                      $this->db->query($sql1);

                      $data=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('four_lanes',$data);
                      $data1=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('scroll_news',$data1);
                    break;
                    case 2:
                    $sql="insert into admin_permissions(permission_id,admin_id)
                        values('5','$id')";
                      $this->db->query($sql);
                      $sql1="insert into admin_permissions(permission_id,admin_id)
                        values('9','$id')";
                      $this->db->query($sql1);
                      $data=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('six_lane',$data);
                        $data1=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('scroll_news',$data1);
                    break;
                    case 3:
                     $sql="insert into admin_permissions(permission_id,admin_id)
                        values('5','$id')";
                      $this->db->query($sql);
                      $sql1="insert into admin_permissions(permission_id,admin_id)
                        values('8','$id')";
                      $this->db->query($sql1);
                      $sql2="insert into admin_permissions(permission_id,admin_id)
                        values('10','$id')";
                      $this->db->query($sql2);
                      $dataf=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('four_lanes',$dataf);
                      $data=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('tournament',$data);
                        $data1=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('scroll_news',$data1);
                       $data2=array(
                        'user_id' => $id,
                        'setting_value' => A
                        );
                      $this->db->insert('setting',$data2);
                    break;
                    case 4:
                     $sql="insert into admin_permissions(permission_id,admin_id)
                        values('5','$id')";
                      $this->db->query($sql);
                      $sql1="insert into admin_permissions(permission_id,admin_id)
                        values('9','$id')";
                      $this->db->query($sql1);
                      $sql2="insert into admin_permissions(permission_id,admin_id)
                        values('10','$id')";
                      $this->db->query($sql2);
                      $dataf=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('six_lane',$dataf);
                      $data=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('tournament',$data);
                        $data1=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('scroll_news',$data1);
                       $data2=array(
                        'user_id' => $id,
                        'setting_value' => A
                        );
                      $this->db->insert('setting',$data2);
                    break;
                    case 5:
                     $sql="insert into admin_permissions(permission_id,admin_id)
                        values('5','$id')";
                      $this->db->query($sql);
                      $sql1="insert into admin_permissions(permission_id,admin_id)
                        values('10','$id')";
                      $this->db->query($sql1);
                      $sql2="insert into admin_permissions(permission_id,admin_id)
                        values('11','$id')";
                      $this->db->query($sql2);
                      $sql3="insert into admin_permissions(permission_id,admin_id)
                        values('8','$id')";
                      $this->db->query($sql3);
                       $dataf=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('four_lanes',$dataf);
                      $data=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('tournament',$data);

                      $data1=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('scroll_news',$data1);
                       $data2=array(
                        'user_id' => $id,
                        'setting_value' => A
                        );
                      $this->db->insert('setting',$data2);
                     
                    break;
                    case 6:
                     $sql="insert into admin_permissions(permission_id,admin_id)
                        values('5','$id')";
                      $this->db->query($sql);
                      $sql1="insert into admin_permissions(permission_id,admin_id)
                        values('10','$id')";
                      $this->db->query($sql1);
                      $sql2="insert into admin_permissions(permission_id,admin_id)
                        values('11','$id')";
                      $this->db->query($sql2);
                      $sql3="insert into admin_permissions(permission_id,admin_id)
                        values('9','$id')";
                      $this->db->query($sql3);
                       $dataf=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('six_lane',$dataf);
                      $data=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('tournament',$data);

                      $data1=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('scroll_news',$data1);
                       $data2=array(
                        'user_id' => $id,
                        'setting_value' => A
                        );
                      $this->db->insert('setting',$data2);
                    break;
                    case 7:
                     $sql="insert into admin_permissions(permission_id,admin_id)
                        values('5','$id')";
                      $this->db->query($sql);
                      $sql2="insert into admin_permissions(permission_id,admin_id)
                        values('11','$id')";
                      $this->db->query($sql2);
                      $sql3="insert into admin_permissions(permission_id,admin_id)
                        values('8','$id')";
                      $this->db->query($sql3);
                       $dataf=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('four_lanes',$dataf);
                      $data1=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('scroll_news',$data1);
                       $data2=array(
                        'user_id' => $id,
                        'setting_value' => A
                        );
                      $this->db->insert('setting',$data2);
                    break;
                    case 8:
                     $sql="insert into admin_permissions(permission_id,admin_id)
                        values('5','$id')";
                      $this->db->query($sql);
                      $sql2="insert into admin_permissions(permission_id,admin_id)
                        values('11','$id')";
                      $this->db->query($sql2);
                      $sql3="insert into admin_permissions(permission_id,admin_id)
                        values('9','$id')";
                      $this->db->query($sql3);
                       $dataf=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('six_lane',$dataf);
                      $data1=array(
                        'user_id' => $id,
                        'status' =>1
                        );
                      $this->db->insert('scroll_news',$data1);
                       $data2=array(
                        'user_id' => $id,
                        'setting_value' => A
                        );
                      $this->db->insert('setting',$data2);
                    break;
                    

                    }



                    
						        //$sql="insert into admin_permissions(permission_id,admin_id)
                    //values('$chkPermissions','$id')";
                    //die($sql);  
                    //$this->db->query($sql);
                 	
	                       	
	                       		sf('success_message', 'New admministrator account has been created.');
	                       }else{
	                       		sf('error_message', 'Sorry, there is a problem to create new administrator. Please try again later.');
	                       }
	                       redirect('admin/user/new_admin');
		                }
                       
               }else{
               		 $this->gen_contents['form_validation_error'] = validation_errors();
               }
        }
        $this->gen_contents['admin_permissions'] = $this->common_model->get_data('admin_permissions_master', '*');
          
        $this->gen_contents['script_load_page'] = 'users';
        $this->gen_contents['js_files'] = array('global/plugins/jquery-inputmask/jquery.inputmask.bundle.min.js', 'global/plugins/datatables/media/js/jquery.dataTables.min.js', 
        'global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js',
        'global/plugins/jquery-validation/js/jquery.validate.min.js', 'global/scripts/datatable.js', 'admin/layout/scripts/admins.js');
        $this->template->set_template('admin');
        $this->gen_contents['page_heading'] = 'Administrators';
        $this->gen_contents['packages_list'] = $this->common_model->get_data('packages', '*');
        $this->gen_contents['active_main_menu'] = array('users', 'admins');
        $this->gen_contents['js_script_initial'] = "Admins.init();";
        $this->template->write_view('content', 'admin/admins/new_admin', $this->gen_contents);
        $this->template->render();
    }
    
	function password_match_admin($conf_pwd) {
        $new_pwd = $this->input->post("new_password", true);

            if ($new_pwd != $conf_pwd) {
            	$this->form_validation->set_message('password_match_admin', 'Password and confirm password does not match');
            	return FALSE;
            }
            else {
                return TRUE;
            }
    }

    function edit_admin($id=''){
        
    	(!$this->authentication->check_logged_in("admin", false) || !(admin_has_permission(3))) ? redirect('admin') : '';
    	if(empty($id)) redirect('admin/user/admins');
        if (!empty($_POST)) {
        	$this->form_validation->set_rules('txtFirstName', 'first name', 'required|trim|max_length[50]');
               $this->form_validation->set_rules('txtLastName', 'last name', 'required|trim|max_length[50]');
               $this->form_validation->set_rules('txtEmail', 'email', 'required|trim|valid_email|max_length[50]|callback_email_validate');
              // $this->form_validation->set_rules('txtUsername', 'username', 'required|trim|min_length[5]|max_length[12]|callback_username_validate');
               
               
               if ($this->form_validation->run() == TRUE) {  //form validation
               	
               	$user_status = array('1', '2');
               		$this->load->library('user_agent');
	                  $data = array(
                       'fname'      => $this->input->post("txtFirstName", true), 
                       'lname'       => $this->input->post("txtLastName", true),
                       'email'           => $this->input->post("txtEmail", true), 
                     //  'username'  		 => $this->input->post("txtUsername", true), 
					   'phone'           => $this->input->post("txtPhone", true), 
                      'package' => $this->input->post("selectpackage", true),
               
                      // 'updated_date'    => get_cur_date_time(),
                     //  'status'          => 'A',
	                 //  'webmaster'		 => 'N',
                      'logo' => $this->input->post("logo", true),
	                  'ip_address' => $this->input->ip_address() ,
	                   'browser' => $this->agent->agent_string(),
	                  'admin'	=> '1' 
                       );
                	       
                       if(in_array($this->input->post("cmbStatus", true), $user_status)){
                       	$data['status'] = $this->input->post("cmbStatus", true);
                       }
                       if (!empty($_FILES['flProfielImage'])) {
		                    $this->load->helper('image_helper');
		                    if ($_FILES['flProfielImage']['name'] != '') {
		                        $upload_status = upload_image('admin_profile', 'flProfielImage');
		                    }
		                } 
		                if (!empty($upload_status['file_name'])) {
		                    // Remove the existing image if the file upload is success
		                    $old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
		                    $data['profile_image'] = $upload_status['file_name'];
		                }
						
		                if (!empty($upload_status['upload_error'])) {
		                    $this->gen_contents['form_validation_error'] = $upload_status['upload_error'];
		                }
		                else {
			               $status = $this->db->update('user', $data, array('id' => $id));
	                       if($status){
	                       	 $batch_array = array();
	                       	   $this->db->delete('admin_permissions', array('admin_id' => $id));
						        $chkPermissions = $this->input->post('chkPermissions', true);
						        if($chkPermissions){
						                       	foreach($chkPermissions as $k => $v){
						                       		$batch_array[] = array('permission_id' => $v, 'admin_id' => $id );
						                       	}
										        if(!empty ($batch_array)){
										            $this->db->insert_batch('admin_permissions', $batch_array); 
										        }
						        }        
	                       	
	                     	  if (!empty($old_image_name[0]['profile_image'])) {  
                            	// Remove old images 
                            	delete_image('admin_profile', $old_image_name[0]['profile_image']);
                        	}
	                       		sf('success_message', 'Admministrator account has been updated.');
	                       }else{
	                       		sf('error_message', 'Sorry, there is a problem to update administrator details. Please try again later.');
	                       }
	                       redirect('admin/user/edit_admin/'.$id);
		                }
                       
               }else{
               		 $this->gen_contents['form_validation_error'] = validation_errors();
               }
        }
		
        $results = $this->common_model->get_data('user', '*', array('id' => $id));
        if(empty($results)) redirect('admin/user/admins');
        $this->gen_contents['admin_permissions_master'] = $this->common_model->get_data('admin_permissions_master', '*');
        $this->gen_contents['admin_permissions'] = $this->common_model->get_data('admin_permissions', 'permission_id', array('admin_id' => $id));
        $this->gen_contents['results'] = $results[0];
        $this->gen_contents['script_load_page'] = 'users';
        $this->gen_contents['js_files'] = array('global/plugins/jquery-inputmask/jquery.inputmask.bundle.min.js', 'global/plugins/datatables/media/js/jquery.dataTables.min.js', 
        'global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js',
        'global/plugins/jquery-validation/js/jquery.validate.min.js', 'global/scripts/datatable.js', 'admin/layout/scripts/admins.js');
        $this->template->set_template('admin');
        $this->gen_contents['page_heading'] = 'Administrators';
        $this->gen_contents['packages_list'] = $this->common_model->get_data('packages', '*');
        $this->gen_contents['active_main_menu'] = array('users', 'admins');
        $this->gen_contents['page_breadcrumb'] = array(array('link' => 'user/admins', 'label' => 'Administrators'), array('link' => '#', 'label' => 'Edit Administrator'));
        $this->gen_contents['js_script_initial'] = "Admins.init();";
        $this->template->write_view('content', 'admin/admins/edit_admin', $this->gen_contents);
        $this->template->render();
    }
    
    function email_validate($email){
    	$id = $this->input->post('txtHiddenId', true);
    	$where = array('email' => $email);
    	if(!empty($id)) $where['id !='] = $id;
    	$email_exists = $this->common_model->get_data('user', 'email', $where);
   		if (!empty($email_exists)) {
            	$this->form_validation->set_message('email_validate', 'Already admministrator with same email exists.');
            	return FALSE;
            }
            else {
                return TRUE;
            }
    }
     function domain_validate($domain){
      $id = $this->input->post('txtHiddenId', true);
      $where = array('domian' => $domain);
      if(!empty($id)) $where['id !='] = $id;
      $email_exists = $this->common_model->get_data('user', 'domian', $where);
      if (!empty($email_exists)) {
              $this->form_validation->set_message('domain_validate', 'Already domain exists.');
              return FALSE;
            }
            else {
                return TRUE;
            }
    }
	function username_validate($username){
    	$id = $this->input->post('txtHiddenId', true);
    	$where = array('username' => $username);
    	if(!empty($id)) $where['admin_id !='] = $id;
    	$email_exists = $this->common_model->get_data('admin_user_details', 'username', $where);
   		if (!empty($email_exists)) {
            	$this->form_validation->set_message('username_validate', 'Already admministrator with same username exists.');
            	return FALSE;
            }
            else {
                return TRUE;
            }
    }
    
    function admin_reset_password(){
    // First check user is logged 
        
        if (!$this->authentication->check_logged_in("admin", false) || !(admin_has_permission(3))) {
            $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'login_error', 'content' => 'Please login to do this action.'))));
            return;
        }
		$user_id = $this->input->post('txtAdmId', true);
        if (empty($user_id) || $user_id == '1') { // 1 is super admin
            $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'This is invalid request.'))));
            return;
        }
        $this->form_validation->set_rules('txtnew_password', 'password', 'required|trim|max_length[20]');
               $this->form_validation->set_rules('txtnew_password_confirm', 'confirm password', 'required|trim|max_length[20]|callback_reset_admin_pass');
               
               if ($this->form_validation->run() == TRUE) {  //form validation
         			//$encrypt_time = strtotime(get_cur_date_time());
	                  $password     = sha1(trim($this->input->post("txtnew_password", true)));
	                 // $password     = create_secure_password($password.$encrypt_time);
                  
	                  $data = array(
                        
                       'password'        => $password
                      // 'encrypt_time'    => $encrypt_time,
                       //'updated_date'    => get_cur_date_time(),
                       
                       );
           			$sts = $this->db->update('user', $data, array('id' => $user_id));
           			header("Content-Type: application/json");
           			$this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'success', 'content' => 'Password has been updated successfully.' ))));
            		return;
               }else{
               		header("Content-Type: application/json");
               		$this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => validation_errors() ))));
            		return;
               }
                           
    }
    
	function reset_admin_pass($conf_pwd) {
        $new_pwd = $this->input->post("txtnew_password", true);

            if ($new_pwd != $conf_pwd) {
            	$this->form_validation->set_message('reset_admin_pass', 'Password and confirm password does not match');
            	return FALSE;
            }
            else {
                return TRUE;
            }
    }
}
/* End of file welcome.php */
/* Location: ./application/controllers/Welcome.php */
