<?php
/**
 * CodeIgniter
 *
 * An open source application development framework for PHP
 *
 * This content is released under the MIT License (MIT)
 *
 * Copyright (c) 2014 - 2015, British Columbia Institute of Technology
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * @package	CodeIgniter
 * @author	EllisLab Dev Team
 * @copyright	Copyright (c) 2008 - 2014, EllisLab, Inc. (http://ellislab.com/)
 * @copyright	Copyright (c) 2014 - 2015, British Columbia Institute of Technology (http://bcit.ca/)
 * @license	http://opensource.org/licenses/MIT	MIT License
 * @link	http://codeigniter.com
 * @since	Version 1.0.0
 * @filesource
 */
defined('BASEPATH') OR exit('No direct script access allowed');

class Welcome extends CI_Controller {
	
	var $gen_contents	=	array(); 
	
	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see http://codeigniter.com/user_guide/general/urls.html
	 */
	public function index()
	{
		//die("tes");
            $this->load->model('admin/admin_model');
            (!$this->authentication->check_logged_in("admin",false)) ? redirect('admin') : '';
            $this->gen_contents['page_heading'] = 'Sportboard News';
            $this->gen_contents['script_load_page'] = 'dashboard';
            $this->gen_contents['js_files'] = array(
            										/*'global/plugins/jqvmap/jqvmap/jquery.vmap.js',
                                                    'global/plugins/jqvmap/jqvmap/maps/jquery.vmap.russia.js',
                                                    'global/plugins/jqvmap/jqvmap/maps/jquery.vmap.world.js',
                                                    'global/plugins/jqvmap/jqvmap/maps/jquery.vmap.europe.js',
                                                    'global/plugins/jqvmap/jqvmap/maps/jquery.vmap.germany.js',
                                                    'global/plugins/jqvmap/jqvmap/maps/jquery.vmap.usa.js',
                                                    'global/plugins/jqvmap/jqvmap/data/jquery.vmap.sampledata.js', */
                                                    'global/plugins/flot/jquery.flot.min.js',
                                                    'global/plugins/flot/jquery.flot.resize.min.js',
                                                    'global/plugins/flot/jquery.flot.categories.min.js',
                                                    'global/plugins/jquery.pulsate.min.js',
            										/*
                                                    'global/plugins/bootstrap-daterangepicker/moment.min.js',
                                                    'global/plugins/bootstrap-daterangepicker/daterangepicker.js',
                                                    'global/plugins/fullcalendar/fullcalendar.min.js',
                                                    'global/plugins/jquery-easypiechart/jquery.easypiechart.min.js',
                                                    'global/plugins/jquery.sparkline.min.js', */
                                                    'admin/layout/scripts/demo.js', 
                                                    'admin/pages/scripts/index.js',
                                                    'admin/pages/scripts/tasks.js'
                    );
            $this->gen_contents['active_main_menu'] = array('dashboard', 'dashboard');
            //$this->gen_contents['page_breadcrumb'] = array( array('link'=>'', 'label' => '') );
            $this->gen_contents['dashborad_statistics_for_admin'] = 0;
            $this->template->set_template('admin');
            $from_date = lessDayswithdate(get_cur_date_time(), 30);
			

			 	$user_id = s('USER_ID');
				
		        
            $this->template->write_view('content', 'admin/dashboard', $this->gen_contents);
            $this->template->render();
		
	}
        
	function page_not_found(){
            header('HTTP/1.0 404 Not Found');
            $this->gen_contents['js_files'] = array( 'js/common.js');
	        $this->gen_contents['css_files'] = array('css/style.css');
            $this->template->write_view('content', 'admin/dashboard', $this->gen_contents);
            
            $this->template->render();
        }
}

/* End of file welcome.php */
/* Location: ./application/controllers/Welcome.php */