<?php
/**
 * CodeIgniter
 *
 * An open source application development framework for PHP
 *
 * This content is released under the MIT License (MIT)
 *
 * Copyright (c) 2014 - 2015, British Columbia Institute of Technology
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * @package	CodeIgniter
 * @author	EllisLab Dev Team
 * @copyright	Copyright (c) 2008 - 2014, EllisLab, Inc. (http://ellislab.com/)
 * @copyright	Copyright (c) 2014 - 2015, British Columbia Institute of Technology (http://bcit.ca/)
 * @license	http://opensource.org/licenses/MIT	MIT License
 * @link	http://codeigniter.com
 * @since	Version 1.0.0
 * @filesource
 */
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	http://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'welcome';

$route['admin']                             = "admin/user/index";
$route['admin/login']                       = "admin/user/index";
$route['admin/change_password']             = "admin/user/change_password";
$route['admin/forgot_password']             = "admin/user/forgot_password";
$route['admin/resetpass']                   = "admin/user/resetpass";
$route['admin/resetpass/(:any)']            = "admin/user/resetpass/$1";
$route['admin/profile']                     = "admin/user/profile";
$route['admin/dashboard']                   = "admin/welcome";
$route['admin/logout']                      = "admin/user/logout";

$route['activate']                = "user/activate";
$route['activate/(:any)']         = "user/activate/$1";
$route['resend_activation']       = "user/resend_activation";
$route['resend_activation/(:any)']= "user/resend_activation/$1";
$route['resend_activation']       = "user/resend_activation"; 
$route['login']                   = "login";
$route['logout']                   = "login/logout";
$route['re-login']                = "login/relogin";
$route['forgot_password']         = "user/forgot_password";
$route['resetpass']               = "user/resetpass";
$route['resetpass/(:any)']        = "user/resetpass/$1";
$route['change_password']         = "user/change_password";
$route['profile']                 = "user/profile";
$route['my_gallery']              = "user/my_gallery";
$route['my_gallery/(:any)']       = "user/my_gallery/$1";
 
$route['dashboard']               = "user/dashboard";
$route['privacy-policy']          = "welcome/privacy_policy";
$route['terms-of-service']        = "welcome/terms";
$route['register']               = "user/register";
$route['contact-us']			=  "welcome/contact_us";
$route['about-us']				= "welcome/about_us";
$route['services']				= "welcome/services";
$route['faq']					= "welcome/faq";

$route['parts-tracking-system']= "welcome/parts_tracking_system";

$route['abs-m-30']				= "welcome/abs_m_30";
$route['pc-abs']				= "welcome/pc_abs";
$route['pc']					= "welcome/pc";
$route['pc-iso']				= "welcome/pc_iso";
$route['ultem']					= "welcome/ultem";
$route['fdm']					= "welcome/fdm";
$route['available-materials'] = 'welcome/available_materials';

$route['polyjet'] 			= 'welcome/polyjet';
$route['digital-materials'] = 'welcome/digital_materials';
$route['tango']				= 'welcome/tango';
$route['vero-white'] 		= 'welcome/vero_white';
$route['vero-clear'] 		= 'welcome/vero_clear';
$route['engineering'] 		= 'welcome/engineering'; 
$route['material-comparison'] 		= 'welcome/material_comparison'; 


$route['404_override'] = 'welcome/page_not_found';
$route['translate_uri_dashes'] = FALSE;
 



/* End of file routes.php */
/* Location: ./application/config/routes.php */