<?php

/**
 * CodeIgniter
 *
 * An open source application development framework for PHP
 *
 * This content is released under the MIT License (MIT)
 *
 * Copyright (c) 2014 - 2015, British Columbia Institute of Technology
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * @package	CodeIgniter
 * @author	EllisLab Dev Team
 * @copyright	Copyright (c) 2008 - 2014, EllisLab, Inc. (http://ellislab.com/)
 * @copyright	Copyright (c) 2014 - 2015, British Columbia Institute of Technology (http://bcit.ca/)
 * @license	http://opensource.org/licenses/MIT	MIT License
 * @link	http://codeigniter.com
 * @since	Version 1.0.0
 * @filesource
 */
defined('BASEPATH') OR exit('No direct script access allowed');

class Ajax extends CI_Controller {

    /**
     * General contents
     *
     * @var Array
     */
    var $gen_contents = array();

    public function users_list($type=0) {
        
        if (!$this->authentication->check_logged_in("admin", false)) { // If there is no login exists just return the error
            $iTotalRecords = 1;
            $iDisplayLength = 1;
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = 0;
            $sEcho = 0;

            $records = array();
            $records["data"] = array();

            $end = 1;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;

            $status_list = array(
                array("success" => "Pending"),
                array("info" => "Closed"),
                array("danger" => "On Hold"),
                array("warning" => "Fraud")
            );

            for ($i = $iDisplayStart; $i < $end; $i++) {
                $status = $status_list[rand(0, 2)];
                $id = ($i + 1);
                $records["data"][] = array(
                    '<script>window.location=\'' . admin_url() . 'login\'</script>',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                );
            }

            if ($this->input->post('customActionType') && $this->input->post('customActionType') == 'group_action') {
                $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
                $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
            }

            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;
            $this->load->view('ajax_view', array('ajax_response' => json_encode($records)));
            return;
        }
        else {
            $this->load->model('admin/admin_model');

            $where = array();
            $like_search = array();

            
            $user_status = array('1', '2');
            if ($this->input->post('user_status') && in_array($this->input->post('user_status'), $user_status)) {
                $where['active'] = $this->input->post('user_status');
            }

            if ($this->input->post('txt_user_first_name')) {
                $like_search['fname'] = $this->db->escape_like_str($this->input->post('txt_user_first_name'));
            }
            if ($this->input->post('txt_user_last_name')) {
                $like_search['lname'] = $this->db->escape_like_str($this->input->post('txt_user_last_name'));
            }
            if ($this->input->post('txt_user_email')) {
                $like_search['email'] = $this->db->escape_like_str($this->input->post('txt_user_email'));
            }
            if ($this->input->post('txt_user_phone')) {
                $like_search['phone'] = $this->db->escape_like_str($this->input->post('txt_user_phone'));
            }
            if ($this->input->post('txt_user_domain')) {
                $like_search['domian'] = $this->db->escape_like_str($this->input->post('txt_user_domain'));
            }
            
            if ($this->input->post('txt_user_package')) {
                $like_search['package'] = $this->db->escape_like_str($this->input->post('txt_user_package'));
            }
            

			 $where['admin > '] = '0';
            $iTotalRecords = $this->admin_model->list_users_count($where, $like_search);
            
           //echo lq();exit;
            //$this->load->view('ajax_view', array('ajax_response' => json_encode( array('a' => $iTotalRecords)))); 
            //return;

            $iDisplayLength = intval($this->input->post('length'));
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = intval($this->input->post('start'));
            $sEcho = intval($this->input->post('draw'));

            $records = array();
            $records["data"] = array();

            $end = $iDisplayStart + $iDisplayLength;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;

            $list_users = $this->admin_model->list_users($iDisplayStart, $end, $where, $like_search);
            $id = $iDisplayStart;
            for ($i = 0; $i < count($list_users); $i++) {
                $id++;
                $status = '';
                $status_css = '';
                $is_blocked_account = '';
                $css_class_for_activate_click = '';
                if ($list_users[$i]['status'] == 'I') {
                    $status_css = 'info';
                    $status = 'Pending Approval';
                    //$css_class_for_activate_click = 'activate_this_account';
                }else if ($list_users[$i]['status'] == 'A') {
                    $status_css = 'success';
                    $status = 'Active';
                    //$css_class_for_activate_click = 'activate_this_account';
                
            	}else if ($list_users[$i]['status'] == 'B') {
                    $status_css = 'danger';
                    $status = 'Blocked';
                   // $css_class_for_activate_click = 'activate_this_account';
                }
                if ($list_users[$i]['status'] != '') {
                   // $is_blocked_account = '<span class="btn btn-icon-only yellow block-this-record margin-bottom-5" title="Block" data-id="' . $list_users[$i]['id'] . '"><i class="fa fa-tag"></i></span>';
                }
                
                $actn_buttons = '';
                if(admin_has_permission(3)){ // Edit
                	$actn_buttons .= '<a href="' . admin_url() . 'user/edit_admin/' . $list_users[$i]['id'] . '" title="Edit" class="btn btn-icon-only green margin-bottom-5"><i class="fa fa-edit"></i></a>' ;
                	$actn_buttons .= '<a data-toggle="modal" data-target="#ajax" data-id="'.$list_users[$i]['id'].'" data-name="'.$list_users[$i]['first_name'].' '.$list_users[$i]['last_name'].'"  title="Reset Password" class="btn btn-icon-only red margin-bottom-5 myModal"><i class="fa fa-key"></i></a>';
                }
                if(admin_has_permission(4)){ // Delete
                	$actn_buttons .= '<span class="btn btn-icon-only red delete-this-record margin-bottom-5" data-id="' . $list_users[$i]['id'] . '" title="Delete"><i class="fa fa-times"></i></span>';
                }
                $records["data"][] = array(
                    $id, // '<input type="checkbox" name="id[]" value="'.$list_users[$i]['id'].'">',
                    $list_users[$i]['first_name'],
                    $list_users[$i]['last_name'],
                    $list_users[$i]['email'],
                    $list_users[$i]['phone'],
                    $list_users[$i]['domian'],
                    $list_users[$i]['package'],
                    date('m-d-Y h:i:s A', strtotime($list_users[$i]['created_date'])),
                    date('m-d-Y h:i:s A', strtotime($list_users[$i]['last_login_date'])),
                    '<span class="label label-sm ' . $css_class_for_activate_click . ' label-' . $status_css . '" data-id="' . $list_users[$i]['id'] . '">' . $status . '</span>',
                    
                    $actn_buttons
                    
                );
            }
            if ($this->input->post('customActionType') && $this->input->post('customActionType') == 'group_action') {
                $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
                $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
            }

            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;

            $this->load->view('ajax_view', array('ajax_response' => json_encode($records)));
            return;
        }
    }
    
    function activate_account() {
        // First check user is logged
        $this->load->helper('email_helper');
        if (!$this->authentication->check_logged_in("admin", false)) {
            $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'login_error', 'content' => 'Please login to do this action.'))));
            return;
        }

        // Checked for user id thriugh uri segment
        $user_id = intval($this->uri->segment(3));
        $type_id = intval($this->uri->segment(4));
        if (empty($user_id) || empty($type_id)) {
            $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'This is invalid request.'))));
            return;
        }
        // Try to update the status of the user
        $status = false;
        if ($type_id == 3) {
            $admin_approved_date = get_cur_date_time();
            $status = $this->db->update('user_details', array('admin_approved' => '2', 'status' => '1', 'admin_approved_date' => $admin_approved_date), array('id' => $user_id));
            if ($status) {
                $email_data = $this->common_model->get_data('user_details', array('email', 'first_name', 'activation_code'), array('id' => $user_id));
                if (!empty($email_data)) {
                    if ($email_data[0]['activation_code'] != NULL) {
                        $send = process_and_send_mail($email_data[0]['email'], array('first_name' => $email_data[0]['first_name'],
                            'activation_link' => '<a target="_blank" href="' . base_url() . 'activate/' . $email_data[0]['activation_code'] . '" >' . base_url() . 'activate/' . $email_data[0]['activation_code'] . '</a>',
                            'regards_name' => c('regards_name'),
                            'email_bottom_instruction' => c('email_bottom_instruction'),
                            'activation_form' => '<a target="_blank" href="' . base_url() . 'activate' . '" >' . 'here' . '</a>',
                            'code' => $email_data[0]['activation_code']
                                ), 'trainer_admin_approved_activate', array(), array(), '', '');
                        if ($send) {
                            $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'success', 'content' => 'Updated successfully. Approval notification mail send', 'type' => 'account_activated'))));
                            return;
                        }
                        else {
                            $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'Approval notification mail sending failed.', 'type' => ''))));
                            return;
                        }
                    }else {
                        $send = process_and_send_mail($email_data[0]['email'], array('first_name' => $email_data[0]['first_name'],
                            'login_link' => '<a target="_blank" href="' . base_url() . 'login' . '" >' . base_url() . 'login' . '</a>',
                            'regards_name' => c('regards_name'),
                            'email_bottom_instruction' => c('email_bottom_instruction'),
                                ), 'trainer_admin_approved', array(), array(), '', '');
                        if ($send) {
                            $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'success', 'content' => 'Updated successfully. Approval notification mail send', 'type' => 'account_activated'))));
                            return;
                        }
                        else {
                            $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'Approval notification mail sending failed.', 'type' => ''))));
                            return;
                        }
                    }
                }
            }
        }
        else {
            $status = $this->db->query("UPDATE `user_details` SET `status` = CASE
                        WHEN `status` =1
                            THEN '2'
                        WHEN `status` =2
                            THEN '1'
                        ELSE `status` END WHERE id ='$user_id'");
        }

        if ($status) {
            $current_status = '';
            if ($type_id == 3) {
                $current_status = 'account_activated';
            }
            else {
                $current_status = $this->common_model->get_data('user_details', 'status', array('id' => $user_id));
                $current_status = $current_status[0]['status'];
            }
            $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'success', 'content' => 'Activated the user.', 'type' => $current_status))));
            return;
        }

        $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'There is a problem to update.'))));
        return;
    }


    function delete_admin_account($user_id = '') {
        // First check user is logged 
        
        if (!$this->authentication->check_logged_in("admin", false) || !(admin_has_permission(4))) {
            $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'login_error', 'content' => 'Please login to do this action.'))));
            return;
        }

        if (empty($user_id) || $user_id == '1') { // 1 is super admin
            $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'This is invalid request.'))));
            return;
        }

        
            $update = $this->db->delete('user', array('id' => $user_id));
            $fourlane = $this->db->delete('four_lanes', array('user_id' => $user_id));
            $sixlane = $this->db->delete('six_lane', array('user_id' => $user_id));
            $tournament = $this->db->delete('tournament', array('user_id' => $user_id));
            $scoring = $this->db->delete('scoring', array('user_id' => $user_id));
            $scrollnews = $this->db->delete('scroll_news', array('user_id' => $user_id));
            $setting = $this->db->delete('setting', array('user_id' => $user_id));
            
            // deleting multiscreens
            $user_screen_details = $this->common_model->get_data('user', '*', array('master_userid' => $user_id));
            foreach($user_screen_details as $each_screen_user){
            $screen_id = $each_screen_user['id'];
            $premission=$this->db->delete('admin_permissions', array('admin_id' => $screen_id));
            $fourlane = $this->db->delete('four_lanes', array('user_id' => $screen_id));
            $sixlane = $this->db->delete('six_lane', array('user_id' => $screen_id));
            $fourlane_double = $this->db->delete('four_lanes_double', array('user_id' => $screen_id));
            $sixlane_double = $this->db->delete('six_lane_double', array('user_id' => $screen_id));
            $tournament = $this->db->delete('tournament', array('user_id' => $screen_id));
            $scoring = $this->db->delete('scoring', array('user_id' => $screen_id));
            $scoring_double = $this->db->delete('scoring_double', array('user_id' => $screen_id));
            $scrollnews = $this->db->delete('scroll_news', array('user_id' => $screen_id));
            $setting = $this->db->delete('setting', array('user_id' => $screen_id));
            }
            if ($update) {
            	$this->db->delete('admin_permissions', array('admin_id' => $user_id));
                 
                $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'success', 'content' => 'Deleted successfully.'))));
                return;
            }
            

        $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'There is a problem to update.'))));
        return;
    }

    function upload_and_crop($type=''){ 
        if(!$this->authentication->check_logged_in("normal", false)){
           $response = array(
            'state'  => 200,
            'message' => 'You login session has been expired. Please re-login.'
            );
            echo json_encode($response);
            return;
        }
        //$crop = $this->load->library('Lib_crop', $_POST['avatar_src'], $_POST['avatar_data'], $_FILES['avatar_file']);
        $this->load->library('Lib_crop');
        
        $crop_dimentions = c('crop_image_size_big'); // Get the crop dimention from config for workout image crop
        if($type == 'workout'){
            $crop_dimentions = $crop_dimentions['workout'];
        }else if($type == 'profile'){
            $crop_dimentions = $crop_dimentions['profile'];
        }else{
            $response = array(
            'state'  => 200,
            'message' => 'Invalid access'
            );
            echo json_encode($response);
            return;
        }
        $this->lib_crop->crop_dimention['width'] = $crop_dimentions['width'];
        $this->lib_crop->crop_dimention['height'] = $crop_dimentions['height'];
        
        $this->lib_crop->construct($_POST['avatar_src'], $_POST['avatar_data'], $_FILES['avatar_file']);
        $img_name = '';
        $file_url = $this->lib_crop->getResult();
        $file_url = explode('/', $file_url);
        $file_url = @$file_url[count($file_url) - 1];
        if(!empty($file_url)) {
            $img_name = $file_url;
            $file_url = c('file_upload_url').'temp_crop/'.$file_url;
        }
        $response = array(
        'state'  => 200,
        'message' => $this->lib_crop->getMsg(),
        'result' => $file_url, 
        'img_name' => $img_name
        );
        $this->lib_crop->unlink_original();
        echo json_encode($response);
    }
    
    
function delete_package($user_id=''){
     if (!$this->authentication->check_logged_in("admin", false) || !(admin_has_permission(4))) {
            $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'login_error', 'content' => 'Please login to do this action.'))));
            return;
        }

        if (empty($user_id) || $user_id == '1') { // 1 is super admin
            $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'This is invalid request.'))));
            return;
        }

        
            $update = $this->db->delete('packages', array('package_id' => $user_id));
            print($update);
            if ($update) {
                //$this->db->delete('admin_permissions', array('admin_id' => $user_id));
                $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'success', 'content' => 'Deleted successfully.'))));
                return;
            }
        

        $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'There is a problem to update.'))));
        return;

    }
    function delete_scoring($user_id=''){
     
            $update = $this->db->delete('scoring', array('scoring_id' => $user_id));
            //print($update);
            if ($update) {
                //$this->db->delete('admin_permissions', array('admin_id' => $user_id));
                $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'success', 'content' => 'Deleted successfully.'))));
                sf('success_message', "scorind deleted successfully.");
                return;
            }
        

        $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'There is a problem to update.'))));
        return;

    }
     function delete_tournament($t_id=''){
     
            $update = $this->db->delete('tournament', array('tournament_id' => $t_id));
            //print($update);
            if ($update) {
                //$this->db->delete('admin_permissions', array('admin_id' => $user_id));
                $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'success', 'content' => 'Deleted successfully.'))));
                sf('success_message', "scorind deleted successfully.");
                return;
            }
        

        $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'There is a problem to update.'))));
        return;

    }
    function delete_scoring_double($user_id=''){
     
            $update = $this->db->delete('scoring_double', array('scoring_id' => $user_id));
            //print($update);
            if ($update) {
                //$this->db->delete('admin_permissions', array('admin_id' => $user_id));
                $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'success', 'content' => 'Deleted successfully.'))));
                sf('success_message', "scorind deleted successfully.");
                return;
            }
        

        $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'There is a problem to update.'))));
        return;

    }
    function delete_fourlane($user_id=''){
            
     
     
            $update = $this->db->delete('four_lanes', array('lane_id' => $user_id));
            $update = $this->db->delete('four_lanes_double', array('dlane_id' => $user_id));
            //print($update);
            if ($update) {
                //$this->db->delete('admin_permissions', array('admin_id' => $user_id));
                $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'success', 'content' => 'Deleted successfully.'))));
                sf('success_message', "Fourlane deleted successfully.");
                return;
            }
        

        $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'There is a problem to update.'))));
        return;

    }
    function delete_sixlane($user_id=''){
            
     
     
            $update = $this->db->delete('six_lane', array('lane_id' => $user_id));
            $update = $this->db->delete('six_lane_double', array('dlane_id' => $user_id));
            //print($update);
            if ($update) {
                //$this->db->delete('admin_permissions', array('admin_id' => $user_id));
                $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'success', 'content' => 'Deleted successfully.'))));
                sf('success_message', "Fourlane deleted successfully.");
                return;
            }
        

        $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'There is a problem to update.'))));
        return;

    }
   
    function delete_eightlane($user_id=''){
            
     
     
            $update = $this->db->delete('eight_lane', array('lane_id' => $user_id));
            if ($update) {
                $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'success', 'content' => 'Deleted successfully.'))));
                sf('success_message', "Fourlane deleted successfully.");
                return;
            }
        

        $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'There is a problem to update.'))));
        return;

    }
    
	function update_customer_password(){
 		if(!$this->authentication->check_logged_in("admin", false)){
           $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'login_error', 'content' => 'Please login to do this action.'))));
            return;
        }
        $customer_id =   ($this->input->post('txtUpdatePasswordCid', true));
        $password = $this->input->post('txtCusPassword', true);
        $password_confirm = $this->input->post('txtCusPasswordConfirm', true);
        if( empty($customer_id)){
         	$this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'There is a proble to update'))));
            return;
        }else if( $password != $password_confirm){
        	$this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'Error! Password and the Confirm password should be same.'))));
            return;
        }
        $this->db->update('user', array('password' => sha1($password)), array('id' => $customer_id ));
        	$this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'success', 'content' => 'Password has been updated successfully' ))));
            return;
 	}
        
        function change_lane_lettering($value,$admin_id){
            $where = array(
            'id' =>$admin_id
            );
            $data = array(
                'icesheet_lettering' => $value
            );
            $sts = $this->db->update('user', $data, $where);
        }
}


