<?php

/**
 * CodeIgniter
 *
 * An open source application development framework for PHP
 *
 * This content is released under the MIT License (MIT)
 *
 * Copyright (c) 2014 - 2015, British Columbia Institute of Technology
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * @package	CodeIgniter
 * @author	EllisLab Dev Team
 * @copyright	Copyright (c) 2008 - 2014, EllisLab, Inc. (http://ellislab.com/)
 * @copyright	Copyright (c) 2014 - 2015, British Columbia Institute of Technology (http://bcit.ca/)
 * @license	http://opensource.org/licenses/MIT	MIT License
 * @link	http://codeigniter.com
 * @since	Version 1.0.0
 * @filesource
 */
defined('BASEPATH') OR exit('No direct script access allowed');

class Ajax_loader extends CI_Controller {

    /**
     * General contents
     *
     * @var Array
     */
    var $gen_contents = array();

       function activate_account() {
        // First check user is logged
        $this->load->helper('email_helper');
        if (!$this->authentication->check_logged_in("normal", false)) {
            $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'login_error', 'content' => 'Please login to do this action.'))));
            return;
        }

        // Checked for user id thriugh uri segment
        $user_id = intval($this->uri->segment(3));
        $type_id = intval($this->uri->segment(4));
        if (empty($user_id) || empty($type_id)) {
            $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'This is invalid request.'))));
            return;
        }
        // Try to update the status of the user
        $status = false;
        if ($type_id == 3) {
            $admin_approved_date = get_cur_date_time();
            $status = $this->db->update('user_details', array('admin_approved' => '2', 'status' => '1', 'admin_approved_date' => $admin_approved_date), array('id' => $user_id));
            if ($status) {
                $email_data = $this->common_model->get_data('user_details', array('email', 'first_name', 'activation_code'), array('id' => $user_id));
                if (!empty($email_data)) {
                    if ($email_data[0]['activation_code'] != NULL) {
                        $send = process_and_send_mail($email_data[0]['email'], array('first_name' => $email_data[0]['first_name'],
                            'activation_link' => '<a target="_blank" href="' . base_url() . 'activate/' . $email_data[0]['activation_code'] . '" >' . base_url() . 'activate/' . $email_data[0]['activation_code'] . '</a>',
                            'regards_name' => c('regards_name'),
                            'email_bottom_instruction' => c('email_bottom_instruction'),
                            'activation_form' => '<a target="_blank" href="' . base_url() . 'activate' . '" >' . 'here' . '</a>',
                            'code' => $email_data[0]['activation_code']
                                ), 'trainer_admin_approved_activate', array(), array(), '', '');
                        if ($send) {
                            $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'success', 'content' => 'Updated successfully. Approval notification mail send', 'type' => 'account_activated'))));
                            return;
                        }
                        else {
                            $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'Approval notification mail sending failed.', 'type' => ''))));
                            return;
                        }
                    }else {
                        $send = process_and_send_mail($email_data[0]['email'], array('first_name' => $email_data[0]['first_name'],
                            'login_link' => '<a target="_blank" href="' . base_url() . 'login' . '" >' . base_url() . 'login' . '</a>',
                            'regards_name' => c('regards_name'),
                            'email_bottom_instruction' => c('email_bottom_instruction'),
                                ), 'trainer_admin_approved', array(), array(), '', '');
                        if ($send) {
                            $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'success', 'content' => 'Updated successfully. Approval notification mail send', 'type' => 'account_activated'))));
                            return;
                        }
                        else {
                            $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'Approval notification mail sending failed.', 'type' => ''))));
                            return;
                        }
                    }
                }
            }
        }
        else {
            $status = $this->db->query("UPDATE `user_details` SET `status` = CASE
                        WHEN `status` =1
                            THEN '2'
                        WHEN `status` =2
                            THEN '1'
                        ELSE `status` END WHERE id ='$user_id'");
        }

        if ($status) {
            $current_status = '';
            if ($type_id == 3) {
                $current_status = 'account_activated';
            }
            else {
                $current_status = $this->common_model->get_data('user_details', 'status', array('id' => $user_id));
                $current_status = $current_status[0]['status'];
            }
            $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'success', 'content' => 'Activated the user.', 'type' => $current_status))));
            return;
        }

        $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'There is a problem to update.'))));
        return;
    }


    function delete_admin_account($user_id = '') {
        // First check user is logged 
        
        if (!$this->authentication->check_logged_in("normal", false) || !(admin_has_permission(4))) {
            $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'login_error', 'content' => 'Please login to do this action.'))));
            return;
        }

        if (empty($user_id) || $user_id == '1') { // 1 is super admin
            $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'This is invalid request.'))));
            return;
        }

        
            $update = $this->db->delete('user', array('id' => $user_id));
            if ($update) {
            	$this->db->delete('admin_permissions', array('admin_id' => $user_id));
                $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'success', 'content' => 'Deleted successfully.'))));
                return;
            }
        

        $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'There is a problem to update.'))));
        return;
    }
    function delete_package($user_id = '') {

        // First check user is logged 
        

        
            $update = $this->db->delete('packages', array('package_id' => $user_id));
            if ($update) {
                $this->db->delete('admin_permissions', array('admin_id' => $user_id));
                $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'success', 'content' => 'Deleted successfully.'))));
                return;
            }
        

        $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'error', 'content' => 'There is a problem to update.'))));
        return;
    }

    function upload_and_crop($type=''){ 
        if(!$this->authentication->check_logged_in("normal", false)){
           $response = array(
            'state'  => 200,
            'message' => 'You login session has been expired. Please re-login.'
            );
            echo json_encode($response);
            return;
        }
        //$crop = $this->load->library('Lib_crop', $_POST['avatar_src'], $_POST['avatar_data'], $_FILES['avatar_file']);
        $this->load->library('Lib_crop');
        
        $crop_dimentions = c('crop_image_size_big'); // Get the crop dimention from config for workout image crop
        if($type == 'workout'){
            $crop_dimentions = $crop_dimentions['workout'];
        }else if($type == 'profile'){
            $crop_dimentions = $crop_dimentions['profile'];
        }else{
            $response = array(
            'state'  => 200,
            'message' => 'Invalid access'
            );
            echo json_encode($response);
            return;
        }
        $this->lib_crop->crop_dimention['width'] = $crop_dimentions['width'];
        $this->lib_crop->crop_dimention['height'] = $crop_dimentions['height'];
        
        $this->lib_crop->construct($_POST['avatar_src'], $_POST['avatar_data'], $_FILES['avatar_file']);
        $img_name = '';
        $file_url = $this->lib_crop->getResult();
        $file_url = explode('/', $file_url);
        $file_url = @$file_url[count($file_url) - 1];
        if(!empty($file_url)) {
            $img_name = $file_url;
            $file_url = c('file_upload_url').'temp_crop/'.$file_url;
        }
        $response = array(
        'state'  => 200,
        'message' => $this->lib_crop->getMsg(),
        'result' => $file_url, 
        'img_name' => $img_name
        );
        $this->lib_crop->unlink_original();
        echo json_encode($response);
    }
    
    
	function email_exists_validate($email){
	////load user model
            $this->load->model('user_model');
            //pass data to model
            $status = $this->user_model->email_exists_validate($email);
            if ($status)
            {
                $this->form_validation->set_message('email_exists_validate', 'You have already subscribed to get our newsletters.');
                return FALSE;
            }else{
                return TRUE;
            }
	}
    
        function cmp($a, $b)
        { 
           // p($a); die("ss");
             $aDateTime = strtotime((new \DateTime($a["time"]))->format('Y-m-d H:i:s'));
             $bDateTime = strtotime((new \DateTime($b["time"]))->format('Y-m-d H:i:s'));
         
            return $aDateTime > $bDateTime ? 1 : -1;
        }
        function add_event(){
        $this->load->helper('url');
        $title = strtoupper($this->input->post('event_title'));
        $desc = $this->input->post('event_desc');
        $time = $this->input->post('event_time');
        $time_end = $this->input->post('event_time_end');
        $color = $this->input->post('color');
        if($color == ""){
            $color="#003366";
        }
        $start = date('Y-m-d',strtotime($this->input->post('apptStartTime')));
        $end = date('Y-m-d',strtotime($this->input->post('apptEndTime'))); 
        $db_data = array(
        	'title' => $title,
        	'date' => $start,
                'color' => $color,
        	'time' => $time,
                'time_end' =>$time_end,
               // 'icon_img' => $icon_img,
        	'user_id' =>  s('ADMIN_USERID')
        	
        );
        
        $this->db->insert('calendar', $db_data);
        
        $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => 'success', 
        'message' => 'Updated successfully.',
        'title' => $title,
        'display_time' => $time.' - '.$time_end,
        'color' => $color,
        'time' => $e_time,
        'start' => $start,
        'end' => $start
        ))));
        return;
        }
        function load_events(){
            $this->load->helper('url');
		//die("asd");
        $calendar = array();
        $events = $this->common_model->event_caledar(0,0, array('calendar.user_id' => s('ADMIN_USERID'),
		'calendar.date >=' => $this->input->get('start'), 'calendar.date <=' => $this->input->get('end')
        )); 
        $other_screens_of_admin = $this->common_model->select_all_screens_of_masteruser(s('ADMIN_USERID'));
        if(!empty($other_screens_of_admin)){
        foreach($other_screens_of_admin as $each_screen){
            $events_screen = $this->common_model->event_caledar(0,0, array('calendar.user_id' => $each_screen['id'],
		'calendar.date >=' => $this->input->get('start'), 'calendar.date <=' => $this->input->get('end')
            )); 
           // p($events_screen);
            if(!empty($events_screen)){
            foreach($events_screen as $each){
            $events[] = $each;
            }
            }
        }
        }
        
        if(s('ADMIN_USERID') != s('primary_userid')){
            $events_main_screen = $this->common_model->event_caledar(0,0, array('calendar.user_id' => s('primary_userid'),
		'calendar.date >=' => $this->input->get('start'), 'calendar.date <=' => $this->input->get('end')
            ));
          //  p($events_main_screen); die("Dgh");
            if(!empty($events_main_screen)){
            foreach($events_main_screen as $each){
            $events[] = $each;
            }
            }
        }
      
        $package = s('package');
        if(($package == "1") || ($package == "3") || ($package == "5")|| ($package == "7")){
        $schedules = $this->common_model->schedule_four(0,0, array('user_id' => s('ADMIN_USERID'),
		'scheduled_date >=' => $this->input->get('start'), 'scheduled_date <=' => $this->input->get('end'), 'sync_calendar' => 1
        )); 
        
        if(!empty($other_screens_of_admin)){
        foreach($other_screens_of_admin as $each_screen){
            $schedules_other_screen = $this->common_model->schedule_four(0,0, array('user_id' => $each_screen['id'],
		'scheduled_date >=' => $this->input->get('start'), 'scheduled_date <=' => $this->input->get('end'), 'sync_calendar' => 1
        )); 
            if(!empty($schedules_other_screen)){
            foreach($schedules_other_screen as $each){
             $schedules[] = $each;
            }
            }
        }
        }
        
        if(s('ADMIN_USERID') != s('primary_userid')){
             $schedules_main = $this->common_model->schedule_four(0,0, array('user_id' => s('primary_userid'),
		'scheduled_date >=' => $this->input->get('start'), 'scheduled_date <=' => $this->input->get('end'), 'sync_calendar' => 1
        )); 
            if(!empty($schedules_main)){
            foreach($schedules_main as $each){
             $schedules[] = $each;
            }
            }
        }
        
        }elseif(($package == "9") || ($package == "10") || ($package == "11")|| ($package == "12")){
        $schedules = $this->common_model->schedule_eight(0,0, array('user_id' => s('ADMIN_USERID'),
		'scheduled_date >=' => $this->input->get('start'), 'scheduled_date <=' => $this->input->get('end'), 'sync_calendar' => 1
        )); 
        
        if(!empty($other_screens_of_admin)){
        foreach($other_screens_of_admin as $each_screen){
            $schedules_other_screen = $this->common_model->schedule_eight(0,0, array('user_id' => $each_screen['id'],
		'scheduled_date >=' => $this->input->get('start'), 'scheduled_date <=' => $this->input->get('end'), 'sync_calendar' => 1
        )); 
            if(!empty($schedules_other_screen)){
            foreach($schedules_other_screen as $each){
             $schedules[] = $each;
            }
            }
        }
        }
        
        if(s('ADMIN_USERID') != s('primary_userid')){
             $schedules_main = $this->common_model->schedule_eight(0,0, array('user_id' => s('primary_userid'),
		'scheduled_date >=' => $this->input->get('start'), 'scheduled_date <=' => $this->input->get('end'), 'sync_calendar' => 1
        )); 
            if(!empty($schedules_main)){
            foreach($schedules_main as $each){
             $schedules[] = $each;
            }
            }
        }
        
        }else{
            $schedules = $this->common_model->schedule_six(0,0, array('user_id' => s('ADMIN_USERID'),
		'scheduled_date >=' => $this->input->get('start'), 'scheduled_date <=' => $this->input->get('end'),  'sync_calendar' => 1 ));
            
            if(!empty($other_screens_of_admin)){
            foreach($other_screens_of_admin as $each_screen){
            $schedules_other_screen = $this->common_model->schedule_six(0,0, array('user_id' => $each_screen['id'],
		'scheduled_date >=' => $this->input->get('start'), 'scheduled_date <=' => $this->input->get('end'), 'sync_calendar' => 1
            )); 
            if(!empty($schedules_other_screen)){
            foreach($schedules_other_screen as $each){
             $schedules[] = $each;
            }
            }
        }
        }
        
        if(s('ADMIN_USERID') != s('primary_userid')){
             $schedules_main = $this->common_model->schedule_six(0,0, array('user_id' => s('primary_userid'),
		'scheduled_date >=' => $this->input->get('start'), 'scheduled_date <=' => $this->input->get('end'), 'sync_calendar' => 1
        )); 
            if(!empty($schedules_main)){
            foreach($schedules_main as $each){
             $schedules[] = $each;
            }
            }
        }
        
        }
        if(!empty($schedules)){
        foreach ( $schedules as $k=>$v )
        {
        $schedules[$k] ['title'] = $schedules[$k] ['lane_name'];
        $schedules[$k] ['date'] = $schedules[$k] ['scheduled_date'];
        $schedules[$k] ['time'] = date("h:i A", strtotime($schedules[$k] ['scheduled_time']));
        unset($schedules[$k]['lane_name']);
        unset($schedules[$k]['scheduled_date']);
        unset($schedules[$k]['scheduled_time']);
        }
        $events = array_merge($events,$schedules);
        }
     
        usort($events, function($a, $b) {
         
   return (strtotime($a['time']) > strtotime($b['time']));
});
     
        for($i=0; $i < count($events); $i++){
             if($events[$i]['time_end'] != ""){
            $time = $events[$i]['time'].' - '.$events[$i]['time_end'];
        }else{
             $time = $events[$i]['time'];
        }
                $calendar[] = array(
	                    'title' => $events[$i]['title'],
                            'display_time' => $time,
	                    'time' => strtotime($events[$i]['time']),
                            'color' => $events[$i]['color'],
	                    'allday' => 'false', 
                            //'imageurl' =>base_url().'uploads/ic.png',
	                    'start' => $events[$i]['date'],
	                    'end' => $events[$i]['date']
	                );
        }
        
        $this->load->view('ajax_view', array('ajax_response' => json_encode($calendar)));
        return;
	}
        function load_events_ajax(){
		
        $calendar = array();
        $events = $this->common_model->event_caledar(0,0, array('user_id' => s('ADMIN_USERID'),
		'date >=' => $this->input->get('start'), 'date <=' => $this->input->get('end')
        )); 
        
        for($i=0; $i < count($events); $i++){
            
	        $calendar[] = array(
	                    'title' => $events[$i]['title']."\n ".$events[$i]['time'].' - '.$events[$i]['time_end'],
	                    'time' => $events[$i]['time'],
                            'color' => $events[$i]['color'],
	                    'allday' => 'false', 
	                    'start' => $events[$i]['date'],
	                    'end' => $events[$i]['date']
	                );
        }
       
        $this->load->view('admin/fourlane/calendar_ajax_full',$data);
        return;
	}
        function events_by_date($date){
        $events = $this->common_model->event_caledar_date( array('user_id' => s('ADMIN_USERID'),
		'date' =>$date
        )); 
        $data['content']=$events;
        $this->load->view('admin/fourlane/calendar_ajax',$data);
        return;
        }
        function delete_event($id){
           $date =$_POST['cur'];
           
        $delete_event = $this->common_model->delete_caledar_date($id); 
        $events = $this->common_model->event_caledar_date( array('user_id' => s('ADMIN_USERID'),
		'date' =>$date
        ));
        $data['content']=$events;
        $this->load->view('admin/fourlane/calendar_ajax',$data);
        return;
        
        }
        function edit_event($id){
           $date =$_POST['cur'];
            
        $events = $this->common_model->event_caledar__by_id($id);
        $data['content']=$events;
        $this->load->view('admin/fourlane/calendar_edit_ajax',$data);
        return;
        }
        function update($id){
           
            $title=$_POST['event_title'];
            $time=$_POST['event_time'];
            $time_end=$_POST['event_time_end'];
            $color = $_POST['color'];
            $up_array=array(
                'title' => $title,
                'time' =>$time,
                'color' =>$color,
                'time_end' => $time_end
            );
            $where = array('calendar_id' => $id);
            $update = $this->db->update('calendar', $up_array, $where);
            
        redirect('admin/four_lane/calendar');
       
        }
        function load_events_front($user_id){
            $this->load->helper('url');
		
        $calendar = array();
        $events = $this->common_model->event_caledar(0,0, array('user_id' => $user_id,
		'date >=' => $this->input->get('start'), 'date <=' => $this->input->get('end')
        )); 
        $other_screens_of_admin = $this->common_model->select_all_screens_of_masteruser($user_id);
         if(!empty($other_screens_of_admin)){
        foreach($other_screens_of_admin as $each_screen){
            $events_screen = $this->common_model->event_caledar(0,0, array('user_id' => $each_screen['id'],
		'date >=' => $this->input->get('start'), 'date <=' => $this->input->get('end')
            )); 
            if(!empty($events_screen)){
            foreach($events_screen as $each){
            $events[] = $each;
            }
            }
        }
        }
        //p($user_id); die("sf");
        $details = $this->common_model->get_data('user','*', array('id' => $user_id ));
        $master_user_id = $details[0]['master_userid'];
        if($master_user_id != 0){
            $events_main_screen = $this->common_model->event_caledar(0,0, array('user_id' => $master_user_id,
		'date >=' => $this->input->get('start'), 'date <=' => $this->input->get('end')
            ));
            if(!empty($events_main_screen)){
            foreach($events_main_screen as $each){
            $events[] = $each;
            }
            }
        }
        $package = $details[0]['package'];
        if(($package == "1") || ($package == "3") || ($package == "5") || ($package == "7")){
        $schedules = $this->common_model->schedule_four(0,0, array('user_id' => $user_id,
		'scheduled_date >=' => $this->input->get('start'), 'scheduled_date <=' => $this->input->get('end'), 'sync_calendar' => 1
        )); 
        
         if(!empty($other_screens_of_admin)){
        foreach($other_screens_of_admin as $each_screen){
            $schedules_other_screen = $this->common_model->schedule_four(0,0, array('user_id' => $each_screen['id'],
		'scheduled_date >=' => $this->input->get('start'), 'scheduled_date <=' => $this->input->get('end'), 'sync_calendar' => 1
        )); 
            if(!empty($schedules_other_screen)){
             foreach($schedules_other_screen as $each){
             $schedules[] = $each;
            }
            }
        }
        }
        
        if($master_user_id != 0){
             $schedules_main = $this->common_model->schedule_four(0,0, array('user_id' => $master_user_id,
		'scheduled_date >=' => $this->input->get('start'), 'scheduled_date <=' => $this->input->get('end'), 'sync_calendar' => 1
        )); 
            if(!empty($schedules_main)){
            foreach($schedules_main as $each){
             $schedules[] = $each;
            }
            }
        }
        
        }elseif(($package == "9") || ($package == "10") || ($package == "11") || ($package == "12")){
            
             $schedules = $this->common_model->schedule_eight(0,0, array('user_id' => $user_id,
		'scheduled_date >=' => $this->input->get('start'), 'scheduled_date <=' => $this->input->get('end'), 'sync_calendar' => 1
        )); 
        
         if(!empty($other_screens_of_admin)){
        foreach($other_screens_of_admin as $each_screen){
            $schedules_other_screen = $this->common_model->schedule_eight(0,0, array('user_id' => $each_screen['id'],
		'scheduled_date >=' => $this->input->get('start'), 'scheduled_date <=' => $this->input->get('end'), 'sync_calendar' => 1
        )); 
            if(!empty($schedules_other_screen)){
             foreach($schedules_other_screen as $each){
             $schedules[] = $each;
            }
            }
        }
        }
        
        if($master_user_id != 0){
             $schedules_main = $this->common_model->schedule_eight(0,0, array('user_id' => $master_user_id,
		'scheduled_date >=' => $this->input->get('start'), 'scheduled_date <=' => $this->input->get('end'), 'sync_calendar' => 1
        )); 
            if(!empty($schedules_main)){
            foreach($schedules_main as $each){
             $schedules[] = $each;
            }
            }
        }
         
            
        }else{ 
            $schedules = $this->common_model->schedule_six(0,0, array('user_id' => $user_id,
		'scheduled_date >=' => $this->input->get('start'), 'scheduled_date <=' => $this->input->get('end'),  'sync_calendar' => 1 ));
             if(!empty($other_screens_of_admin)){
            foreach($other_screens_of_admin as $each_screen){
            $schedules_other_screen = $this->common_model->schedule_six(0,0, array('user_id' => $each_screen['id'],
		'scheduled_date >=' => $this->input->get('start'), 'scheduled_date <=' => $this->input->get('end'), 'sync_calendar' => 1
            )); 
            if(!empty($schedules_other_screen)){
            $schedules[] = $schedules_other_screen[0];
            }
        }
        }
        if($master_user_id != 0){ 
             $schedules_main = $this->common_model->schedule_six(0,0, array('user_id' => $master_user_id,
		'scheduled_date >=' => $this->input->get('start'), 'scheduled_date <=' => $this->input->get('end'), 'sync_calendar' => 1
        )); 
            if(!empty($schedules_main)){
            foreach($schedules_main as $each){
             $schedules[] = $each;
            }
            }
        }
        };
        if(!empty($schedules)){
        foreach ( $schedules as $k=>$v )
        {
        $schedules[$k] ['title'] = $schedules[$k] ['lane_name'];
        $schedules[$k] ['date'] = $schedules[$k] ['scheduled_date'];
        $schedules[$k] ['time'] = date("h:i A", strtotime($schedules[$k] ['scheduled_time']));
        unset($schedules[$k]['lane_name']);
        unset($schedules[$k]['scheduled_date']);
        unset($schedules[$k]['scheduled_time']);
        }
        $events = array_merge($events,$schedules);
        usort($events, function($a, $b) {
         
            return (strtotime($a['time']) > strtotime($b['time']));
         });
        } 
        for($i=0; $i < count($events); $i++){
              if($events[$i]['time_end'] != ""){
            $time = $events[$i]['time'].' - '.$events[$i]['time_end'];
        }else{
             $time = $events[$i]['time'];
        }
                $calendar[] = array(
	                    'title' => $events[$i]['title'],
                            'display_time' => $time,
	                    'time' => strtotime($events[$i]['time']),
                            'color' => $events[$i]['color'],
	                    'allday' => 'false', 
                            //'imageurl' =>base_url().'uploads/ic.png',
	                    'start' => $events[$i]['date'],
	                    'end' => $events[$i]['date']
	                );
        }
        
        $this->load->view('ajax_view', array('ajax_response' => json_encode($calendar)));
        return;
	}
        function load_events_ajax_front($user_id){
		
        $calendar = array();
        $events = $this->common_model->event_caledar(0,0, array('user_id' => $user_id,
		'date >=' => $this->input->get('start'), 'date <=' => $this->input->get('end')
        )); 
        
        for($i=0; $i < count($events); $i++){
            
	        $calendar[] = array(
	                    'title' => $events[$i]['title']."\n ".$events[$i]['time'].' - '.$events[$i]['time_end'],
	                    'time' => strtotime($events[$i]['time']),
                            'color' => $events[$i]['color'],
	                    'allday' => 'false', 
	                    'start' => $events[$i]['date'],
	                    'end' => $events[$i]['date']
	                );
        }
        $this->load->view('admin/fourlane/calendar_ajax_full',$data);
        return;
	}
        function game_by_userid($date="")
        {
           
         $package = s('package');
        $u_id=s('ADMIN_USERID');
        if($date==""){
            $where= array(
            'user_id' => $u_id
        );
            $data['source']="all";
        }else{
        $where= array(
            'scheduled_date' => $date,
            'user_id' => $u_id
        );
        $data['source']="scheduled";
        }
        if(($package == "1") || ($package == "3") || ($package == "5") || ($package == "7")){
            
            $games = $this->common_model->select_fourlane($where); 
        }elseif(($package == "9") || ($package == "10") || ($package == "11") || ($package == "12")){
             $games = $this->common_model->select_eightlane($where);
        }else{
            $games = $this->common_model->select_sixlane($where);
        }
        //print_r($games); die();
        $data['content']=$games;
        $this->load->view('admin/fourlane/schedule_ajax',$data);
        return;  
        }
        
        function add_schedule(){
        $this->load->helper('url');
        $PostData = $this->input->post();
       // p($PostData); die("s");
        $recurring_status = $this->input->post('recurring');
        $time = $this->input->post('event_time');
        $times = strtotime($this->input->post("event_time", true));
        $time1= date("H",$times);
        $time2= date("i",$times);
        $name = strtoupper($this->input->post('name_ice'));
        $start = date('Y-m-d',strtotime($this->input->post('apptStartTime')));
        $end = date('Y-m-d',strtotime($this->input->post('apptEndTime'))); 
        $user_id= s('ADMIN_USERID');
        $package = s('package');
        $color = $this->input->post('color');
        if($color == ""){
            $color="#003366";
        }
        $status_msg="success";
        
        if(($package == "1") || ($package == "3") || ($package == "5") || ($package == "7")){
           $older_lane_details =$this->common_model->select_fourlane_olderlane_details_by_userid($user_id);
        }elseif(($package == "9") || ($package == "10") || ($package == "11") || ($package == "12")){
            $older_lane_details =$this->common_model->select_eightlane_olderlane_details_by_userid($user_id);
        }else{
            $older_lane_details =$this->common_model->select_sixlane_olderlane_details_by_userid($user_id);
        }
        $older_lane_details = $older_lane_details[0];
        $img_g11 = "";
        $img_g12 = "";
        $img_g21 = "";
        $img_g22 = "";
        $img_g31 = "";
        $img_g32 = "";
        $img_g41 = "";
        $img_g42 = "";
        $img_g51 = "";
        $img_g52 = "";
        $img_g61 = "";
        $img_g62 = "";
        $img_g71 = "";
        $img_g72 = "";
        $img_g81 = "";
        $img_g82 = "";
        $img_g1_large = "";
        $img_g2_large = "";
        $img_g3_large = "";
        $img_g4_large = "";
        $img_g5_large = "";
        $img_g6_large = "";
        $img_g7_large = "";
        $img_g8_large = "";
        if(!empty($older_lane_details)){
            $img_g11 = $older_lane_details['img_g11'];
            $img_g12 = $older_lane_details['img_g12'];
            $img_g21 = $older_lane_details['img_g21'];
            $img_g22 = $older_lane_details['img_g22'];
            $img_g31 = $older_lane_details['img_g31'];
            $img_g32 = $older_lane_details['img_g32'];
            $img_g41 = $older_lane_details['img_g41'];
            $img_g42 = $older_lane_details['img_g42'];
            $img_g51 = $older_lane_details['img_g51'];
            $img_g52 = $older_lane_details['img_g52'];
            $img_g61 = $older_lane_details['img_g61'];
            $img_g62 = $older_lane_details['img_g62'];
            $img_g71 = $older_lane_details['img_g71'];
            $img_g72 = $older_lane_details['img_g72'];
            $img_g81 = $older_lane_details['img_g81'];
            $img_g82 = $older_lane_details['img_g82'];
            $img_g1_large = $older_lane_details['img_g1_large'];
            $img_g2_large = $older_lane_details['img_g2_large'];
            $img_g3_large = $older_lane_details['img_g3_large'];
            $img_g4_large = $older_lane_details['img_g4_large'];
            $img_g5_large = $older_lane_details['img_g5_large'];
            $img_g6_large = $older_lane_details['img_g6_large'];
            $img_g7_large = $older_lane_details['img_g7_large'];
            $img_g8_large = $older_lane_details['img_g8_large'];
            
        }
        $day_number = 0;
        $Start_daterange = '';
        $End_daterange = '';
         if($recurring_status == 1){
            $day_number = $this->input->post('week_day');
            $date_range = $this->input->post('recurring_daterange');
            $explode_daterange = explode(" - ",$date_range);
            $Start_daterange=  date('Y-m-d',strtotime($explode_daterange[0]));
            $End_daterange=  date('Y-m-d',strtotime($explode_daterange[1]));
        }
         if(($package == "1") || ($package == "3") || ($package == "5") || ($package == "7")){
           $db_data = array(
                'lane_name' => $name,
                'user_id'  => $user_id,
        	'scheduled_date' => $start,
                'scheduled_time' => $time,
                'img_g11' => $img_g11,
                'img_g12' => $img_g12,
                'img_g21' => $img_g21,
                'img_g22' => $img_g22,
                'img_g31' => $img_g31,
                'img_g32' => $img_g32,
                'img_g41' => $img_g41,
                'img_g42' => $img_g42,
                'img_g1_large' => $img_g1_large,
                'img_g2_large' => $img_g2_large,
                'img_g3_large' => $img_g3_large,
                'img_g4_large' => $img_g4_large,
                'recurring_day' => $day_number,
                'recurring_start_date' => $Start_daterange,
                'recurring_end_date' => $End_daterange,
                'hr' => $time1,
                'min' => $time2,
                'color' => $color
           );
        }elseif(($package == "9") || ($package == "10") || ($package == "11") || ($package == "12")){
             $db_data = array(
                'lane_name' => $name,
                'user_id'  => $user_id,
        	'scheduled_date' => $start,
                'scheduled_time' => $time,
                'img_g11' => $img_g11,
                'img_g12' => $img_g12,
                'img_g21' => $img_g21,
                'img_g22' => $img_g22,
                'img_g31' => $img_g31,
                'img_g32' => $img_g32,
                'img_g41' => $img_g41,
                'img_g42' => $img_g42,
                'img_g51' => $img_g51,
                'img_g52' => $img_g52,
                'img_g61' => $img_g61,
                'img_g62' => $img_g62,
                'img_g71' => $img_g71,
                'img_g72' => $img_g72,
                'img_g81' => $img_g81,
                'img_g82' => $img_g82,
                'img_g1_large' => $img_g1_large,
                'img_g2_large' => $img_g2_large,
                'img_g3_large' => $img_g3_large,
                'img_g4_large' => $img_g4_large,
                'img_g5_large' => $img_g5_large,
                'img_g6_large' => $img_g6_large,
                'img_g7_large' => $img_g7_large,
                'img_g8_large' => $img_g8_large,
                'hr' => $time1,
                'min' => $time2,
                'recurring_day' => $day_number,
                'recurring_start_date' => $Start_daterange,
                'recurring_end_date' => $End_daterange,
                'color' => $color
           );
        }else{
            $db_data = array(
                'lane_name' => $name,
                'user_id'  => $user_id,
        	'scheduled_date' => $start,
                'scheduled_time' => $time,
                'img_g11' => $img_g11,
                'img_g12' => $img_g12,
                'img_g21' => $img_g21,
                'img_g22' => $img_g22,
                'img_g31' => $img_g31,
                'img_g32' => $img_g32,
                'img_g41' => $img_g41,
                'img_g42' => $img_g42,
                'img_g51' => $img_g51,
                'img_g52' => $img_g52,
                'img_g61' => $img_g61,
                'img_g62' => $img_g62,
                'img_g1_large' => $img_g1_large,
                'img_g2_large' => $img_g2_large,
                'img_g3_large' => $img_g3_large,
                'img_g4_large' => $img_g4_large,
                'img_g5_large' => $img_g5_large,
                'img_g6_large' => $img_g6_large,
                'hr' => $time1,
                'min' => $time2,
                'recurring_day' => $day_number,
                'recurring_start_date' => $Start_daterange,
                'recurring_end_date' => $End_daterange,
                'color' => $color
           );
        }
        
        $db_data_double = array(
                'lane_name' => $name,
                'user_id'  => $user_id,
                'scheduled_date' => $start,
                'scheduled_time' => $time
        	
           );
        $where_data = array(
        	'lane_id' => $this->input->post('lane_id')
           );
        
        if(($package == "1") || ($package == "3") || ($package == "5") || ($package == "7")){
            //$this->db->insert('four_lanes_double',$db_data_double);
           $this->db->insert('four_lanes', $db_data);
            $insert_lane_id = $this->db->insert_id();
        }elseif(($package == "9") || ($package == "10") || ($package == "11") || ($package == "12")){
            $this->db->insert('eight_lane', $db_data);
             $insert_lane_id = $this->db->insert_id();
        }else{
            //$this->db->insert('six_lane_double', $db_data_double);
            $this->db->insert('six_lane', $db_data);
             $insert_lane_id = $this->db->insert_id();
        }
        if($recurring_status == 1){
        $this->add_recurring_schedule($PostData,$insert_lane_id);
        $status_msg="multisuccess";
        }
        
        $this->load->view('ajax_view', array('ajax_response' => json_encode(array('status' => $status_msg, 
        'message' => 'Updated successfully.',
        'title' => $name,
        'display_time' => $time,
        'color' => $color,
        'time' => $e_time,
        'start' => $start,
        'end' => $start
        ))));
        return;
        }
        
        function add_recurring_schedule($PostData,$lane_id){
            $day_number = $this->input->post('week_day');
           $date_range = $this->input->post('recurring_daterange');
           $explode_daterange = explode(" - ",$date_range);
           $Start_daterange=  date('Y-m-d',strtotime($explode_daterange[0]));
           $End_daterange=  date('Y-m-d',strtotime($explode_daterange[1]));
           $All_schedule_days = $this->getDateForSpecificDayBetweenDates($Start_daterange,$End_daterange,$day_number);
             
           
           
           //
        if(!empty($All_schedule_days)){
        foreach($All_schedule_days as $eachday){
        $time = $this->input->post('event_time');
        $times = strtotime($this->input->post("event_time", true));
        $time1= date("H",$times);
        $time2= date("i",$times);
        $name = strtoupper($this->input->post('name_ice'));
        $start = $eachday;
        $end = $eachday; 
        $user_id= s('ADMIN_USERID');
        $package = s('package');
        $color = $this->input->post('color');
        if($color == ""){
            $color="#003366";
        }
        
        if(($package == "1") || ($package == "3") || ($package == "5") || ($package == "7")){
           $older_lane_details =$this->common_model->select_fourlane_olderlane_details_by_userid($user_id);
        }elseif(($package == "9") || ($package == "10") || ($package == "11") || ($package == "12")){
            $older_lane_details =$this->common_model->select_eightlane_olderlane_details_by_userid($user_id);
        }else{
            $older_lane_details =$this->common_model->select_sixlane_olderlane_details_by_userid($user_id);
        }
        $older_lane_details = $older_lane_details[0];
        $img_g11 = "";
        $img_g12 = "";
        $img_g21 = "";
        $img_g22 = "";
        $img_g31 = "";
        $img_g32 = "";
        $img_g41 = "";
        $img_g42 = "";
        $img_g51 = "";
        $img_g52 = "";
        $img_g61 = "";
        $img_g62 = "";
        $img_g71 = "";
        $img_g72 = "";
        $img_g81 = "";
        $img_g82 = "";
        $img_g1_large = "";
        $img_g2_large = "";
        $img_g3_large = "";
        $img_g4_large = "";
        $img_g5_large = "";
        $img_g6_large = "";
        $img_g7_large = "";
        $img_g8_large = "";
        if(!empty($older_lane_details)){
            $img_g11 = $older_lane_details['img_g11'];
            $img_g12 = $older_lane_details['img_g12'];
            $img_g21 = $older_lane_details['img_g21'];
            $img_g22 = $older_lane_details['img_g22'];
            $img_g31 = $older_lane_details['img_g31'];
            $img_g32 = $older_lane_details['img_g32'];
            $img_g41 = $older_lane_details['img_g41'];
            $img_g42 = $older_lane_details['img_g42'];
            $img_g51 = $older_lane_details['img_g51'];
            $img_g52 = $older_lane_details['img_g52'];
            $img_g61 = $older_lane_details['img_g61'];
            $img_g62 = $older_lane_details['img_g62'];
            $img_g71 = $older_lane_details['img_g71'];
            $img_g72 = $older_lane_details['img_g72'];
            $img_g81 = $older_lane_details['img_g81'];
            $img_g82 = $older_lane_details['img_g82'];
            $img_g1_large = $older_lane_details['img_g1_large'];
            $img_g2_large = $older_lane_details['img_g2_large'];
            $img_g3_large = $older_lane_details['img_g3_large'];
            $img_g4_large = $older_lane_details['img_g4_large'];
            $img_g5_large = $older_lane_details['img_g5_large'];
            $img_g6_large = $older_lane_details['img_g6_large'];
            $img_g7_large = $older_lane_details['img_g7_large'];
            $img_g8_large = $older_lane_details['img_g8_large'];
            
        }
         if(($package == "1") || ($package == "3") || ($package == "5") || ($package == "7")){
           $db_data = array(
                'lane_name' => $name,
                'user_id'  => $user_id,
        	'scheduled_date' => $start,
                'scheduled_time' => $time,
                'img_g11' => $img_g11,
                'img_g12' => $img_g12,
                'img_g21' => $img_g21,
                'img_g22' => $img_g22,
                'img_g31' => $img_g31,
                'img_g32' => $img_g32,
                'img_g41' => $img_g41,
                'img_g42' => $img_g42,
                'img_g1_large' => $img_g1_large,
                'img_g2_large' => $img_g2_large,
                'img_g3_large' => $img_g3_large,
                'img_g4_large' => $img_g4_large,
               'recurring_master_id' => $lane_id,
                'hr' => $time1,
                'min' => $time2,
                'color' => $color
           );
        }elseif(($package == "9") || ($package == "10") || ($package == "11") || ($package == "12")){
             $db_data = array(
                'lane_name' => $name,
                'user_id'  => $user_id,
        	'scheduled_date' => $start,
                'scheduled_time' => $time,
                'img_g11' => $img_g11,
                'img_g12' => $img_g12,
                'img_g21' => $img_g21,
                'img_g22' => $img_g22,
                'img_g31' => $img_g31,
                'img_g32' => $img_g32,
                'img_g41' => $img_g41,
                'img_g42' => $img_g42,
                'img_g51' => $img_g51,
                'img_g52' => $img_g52,
                'img_g61' => $img_g61,
                'img_g62' => $img_g62,
                'img_g71' => $img_g71,
                'img_g72' => $img_g72,
                'img_g81' => $img_g81,
                'img_g82' => $img_g82,
                'img_g1_large' => $img_g1_large,
                'img_g2_large' => $img_g2_large,
                'img_g3_large' => $img_g3_large,
                'img_g4_large' => $img_g4_large,
                'img_g5_large' => $img_g5_large,
                'img_g6_large' => $img_g6_large,
                 'img_g7_large' => $img_g7_large,
                 'img_g8_large' => $img_g8_large,
                 'recurring_master_id' => $lane_id,
                'hr' => $time1,
                'min' => $time2,
                'color' => $color
           );
        }else{
            $db_data = array(
                'lane_name' => $name,
                'user_id'  => $user_id,
        	'scheduled_date' => $start,
                'scheduled_time' => $time,
                'img_g11' => $img_g11,
                'img_g12' => $img_g12,
                'img_g21' => $img_g21,
                'img_g22' => $img_g22,
                'img_g31' => $img_g31,
                'img_g32' => $img_g32,
                'img_g41' => $img_g41,
                'img_g42' => $img_g42,
                'img_g51' => $img_g51,
                'img_g52' => $img_g52,
                'img_g61' => $img_g61,
                'img_g62' => $img_g62,
                'img_g1_large' => $img_g1_large,
                'img_g2_large' => $img_g2_large,
                'img_g3_large' => $img_g3_large,
                'img_g4_large' => $img_g4_large,
                'img_g5_large' => $img_g5_large,
                'img_g6_large' => $img_g6_large,
                'recurring_master_id' => $lane_id,
                'hr' => $time1,
                'min' => $time2,
                'color' => $color
           );
        }
        
        $db_data_double = array(
                'lane_name' => $name,
                'user_id'  => $user_id,
                'scheduled_date' => $start,
                'scheduled_time' => $time
        	
           );
        $where_data = array(
        	'lane_id' => $this->input->post('lane_id')
           );
        
        if(($package == "1") || ($package == "3") || ($package == "5") || ($package == "7")){
           // $this->db->insert('four_lanes_double',$db_data_double);
           $this->db->insert('four_lanes', $db_data);
        }elseif(($package == "9") || ($package == "10") || ($package == "11") || ($package == "12")){
            $this->db->insert('eight_lane', $db_data);
        }else{
           // $this->db->insert('six_lane_double', $db_data_double);
            $this->db->insert('six_lane', $db_data);
        }
        }
        }
           
        return;   
           
        }
       
        
        function getDateForSpecificDayBetweenDates($startDate,$endDate,$day_number){
        $startDate = date('Y-m-d', strtotime($startDate . ' +1 day'));
        $endDate = strtotime($endDate);
        $days=array('1'=>'Monday','2' => 'Tuesday','3' => 'Wednesday','4'=>'Thursday','5' =>'Friday','6' => 'Saturday','7'=>'Sunday');
        for($i = strtotime($days[$day_number], strtotime($startDate)); $i <= $endDate; $i = strtotime('+1 week', $i))
        $date_array[]=date('Y-m-d',$i);

        return $date_array;
         }
        
         
         
         function load_schedules(){
            $this->load->helper('url');
		
        $calendar = array();
         $package = s('package');
        if(($package == "1") || ($package == "3") || ($package == "5") || ($package == "7")){
        $events = $this->common_model->schedule_four(0,0, array('user_id' => s('ADMIN_USERID'),
		'scheduled_date >=' => $this->input->get('start'), 'scheduled_date <=' => $this->input->get('end')
        )); 
        }elseif(($package == "9") || ($package == "10") || ($package == "11") || ($package == "12")){
            $events = $this->common_model->schedule_eight(0,0, array('user_id' => s('ADMIN_USERID'),
		'scheduled_date >=' => $this->input->get('start'), 'scheduled_date <=' => $this->input->get('end')
        ));
        }else{
            $events = $this->common_model->schedule_six(0,0, array('user_id' => s('ADMIN_USERID'),
		'scheduled_date >=' => $this->input->get('start'), 'scheduled_date <=' => $this->input->get('end') ));
        }
        
        for($i=0; $i < count($events); $i++){
            $today = date('Y-m-d');
            if($events[$i]['scheduled_date'] < $today){
               $color= "#666666"; 
            }else{
                $color= $events[$i]['color']; 
            }
            $schedule_time = date("h:i:A",strtotime($events[$i]['scheduled_time']));
                $calendar[] = array(
	                    'title' => $events[$i]['lane_name'],
                            'display_time' => $schedule_time,
	                    'allday' => 'false',
                            'color' => $color,
                            'start' => $events[$i]['scheduled_date'],
	                    'end' => $events[$i]['scheduled_date']
	                );
        }
        $this->load->view('ajax_view', array('ajax_response' => json_encode($calendar)));
        return;
	}
       
}


