<?php
/**
 * CodeIgniter
 *
 * An open source application development framework for PHP
 *
 * This content is released under the MIT License (MIT)
 *
 * Copyright (c) 2014 - 2015, British Columbia Institute of Technology
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * @package	CodeIgniter
 * @author	EllisLab Dev Team
 * @copyright	Copyright (c) 2008 - 2014, EllisLab, Inc. (http://ellislab.com/)
 * @copyright	Copyright (c) 2014 - 2015, British Columbia Institute of Technology (http://bcit.ca/)
 * @license	http://opensource.org/licenses/MIT	MIT License
 * @link	http://codeigniter.com
 * @since	Version 1.0.0
 * @filesource
 */
defined('BASEPATH') OR exit('No direct script access allowed');

class User extends CI_Controller {
	
	 /**
         * User username
         *
         * @var string
         */
        var $username = "";

        /**
         * User password
         *
         * @var string
         */
        var $password = "";

        /**
         * Page title
         *
         * @var string
         */
        var $title			=	'';


        /**
         * General contents
         *
         * @var Array
         */
        var $gen_contents	=   array();

        var $mcontents;
        var $merror;	
        var $msuccess;
        var $zipcode_details    =   array();
        /**
         * User constructor
         *
         */
	
	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see http://codeigniter.com/user_guide/general/urls.html
	 */
	function register(){
            if (s('USER_ID')){
                redirect('dashboard');
            }
            
            $this->gen_contents['is_banner_page'] = true;
			  
            if(!empty($_POST)) {
               $this->load->model('user_model');
               $this->load->helper('email_helper');
               $this->load->helper('string_helper');
               //Codeigniter validation
                $this->form_validation->set_rules('txtFirstName', 'first name', 'required|trim|max_length[50]');
               $this->form_validation->set_rules('txtLastName', 'last name', 'required|trim|max_length[50]');
               $this->form_validation->set_rules('txtEmail', 'email', 'required|trim|valid_email|max_length[200]|callback_email_validate');
               $this->form_validation->set_rules('txtPassword', 'password', 'required|trim|max_length[20]');
              // if($this->input->post("UserOption", true) == 1){
                 //  $this->form_validation->set_rules('txtPhone', 'phone', 'required|trim|max_length[20]');
              // }
              $this->load->library('user_agent');
               if ($this->form_validation->run() == TRUE) {  //form validation
                //  $encrypt_time = strtotime(get_cur_date_time());
                  $password     = sha1(trim($this->input->post("txtPassword", true)));
                 /// $password     = create_secure_password($password.$encrypt_time);
                 
                  $txtPhone     = $this->input->post("txtPhone", true);
                  
                  $activation_code = random_string('numeric', 6);
                  $activation_code_check = $this->common_model->get_data( 'user', 'activation_code', array('activation_code' => $activation_code));
                  while(!empty($activation_code_check)){
                      $activation_code = random_string('numeric', 6);
                      $activation_code_check = $this->common_model->get_data( 'user', 'activation_code', array('activation_code' => $activation_code));
                  }
                  
                   $data = array(
	                    'fname' => $this->input->post("txtFirstName", true),
	                    'lname' => $this->input->post("txtLastName", true),
	                    'email' => $this->input->post("txtEmail", true),
 	                	'phone' => $this->input->post("txtPhone", true),
		              	'activation_code' => $activation_code, 
	                	'country' => $this->input->post("txtCountry", true), 
		                'state' => $this->input->post("cmbState", true),
		                'city' => $this->input->post("txtCity", true) ,
	                	'pin' => $this->input->post("zipCode", true) ,
                   		'password' => $password,
                   		'date_created' => get_cur_date_time(),
                   		'ip_address' => $this->input->ip_address(),
                   		//'webmaster'		 => 'N',
	                  	'ip_address' => $this->input->ip_address() ,
	                    'browser' => $this->agent->agent_string()
	                );
                       
                       $status = $this->user_model->insert_user_details( $data);
                       if($status){
                           /* Send activation email */
                            process_and_send_mail($data['email'],
                            array('first_name' => $data['fname'], 
                            'activation_link' => '<a target="_blank" href="' . base_url() . 'activate/' . $activation_code.'" >' . base_url() . 'activate/' . $activation_code.'</a>',
                            'regards_name' => c('regards_name'),
                            'email_bottom_instruction' => c('email_bottom_instruction'),
                            'activation_form' => '<a target="_blank" href="' . base_url() . 'activate'. '" >' .'here'. '</a>',
                            'code' => $activation_code
                            ),
                                   'user_registration',
                                   array(), 
                                   array(), 
                                   '', 
                                   '');
                           sf('success_message', 'Your profile has been added. Please check your mail for activation.');
                       }else{
                           sf('error_message', 'There is a problem with update.');
                       }
                       redirect('register');
               }else{
                   $this->gen_contents['form_validation_error'] = validation_errors();
               }
            }
            $this->gen_contents['js_files'] = array( 'global/plugins/jquery-validation/js/jquery.validate.min.js', 'js/user_validation.js');
            $this->gen_contents['css_files'] = array('css/style.css');
            $this->gen_contents['additional_scripts'] = 'User_validation.init();';
            $this->gen_contents['breadcrumb_name'] = 'Register';
            $this->template->set_template('default');
            $this->template->write_view('content', 'user/register', $this->gen_contents);
            $this->template->render();
        }
        
        
        function email_validate($email){   
            ////load user model
            $this->load->model('user_model');
            //pass data to model
            $status = $this->user_model->email_validate($email);
            if ($status)
            {
                $this->form_validation->set_message('email_validate', 'Already user with same email exists.');
                return FALSE;
            }else{
                return TRUE;
            }
        }
         
        
        function forgot_password() {
            if (s('USER_ID')){
                redirect('dashboard');
            }
            else{
 				 
                ($this->authentication->check_logged_in("normal", false)) ? redirect('dashboard') : '';
                if(!empty($_POST )) { 
                    $this->load->model('user_model');
                    $this->load->helper('email_helper');
                    $this->load->helper('string_helper');
                    //Server Validation for the input field
                    $this->form_validation->set_rules('fgtEmail', 'email', 'required|trim|valid_email|max_length[50]');
                    if($this->form_validation->run() == TRUE) {  //form validation 
                      $forgot_email = $this->input->post('fgtEmail', true); 
                      $forgot_check = $this->user_model->forgot_email_check($forgot_email);
                      if(!empty($forgot_check)){
                            $data = $forgot_check[0];
                            
                                if ( ($data['active'] == 1 &&   $data['activation_code'] == NULL)) {
                                    $data['forgot_pwd_code'] = random_string('numeric', 6);
                                    $status = $this->user_model->update_user_fgt_code($data);
                                    if($status){ 
                                        process_and_send_mail($data['email'],
                                        array('first_name' => $data['fname'], 
                                              'reset_link' => '<a target="_blank" href="' . base_url() . 'resetpass/' . $data['forgot_pwd_code'].'" >' . base_url() . 'resetpass/' . $data['forgot_pwd_code'].'</a>',
                                              'regards_name' => c('regards_name'),
                                              'email_bottom_instruction' => c('email_bottom_instruction')
                                             ),
                                                   'user_forgot_password', 
                                                   array(), 
                                                   array(),
                                                   '', 
                                                   '');
                                           $this->gen_contents['form_validation_success'] = 'An email with reset password instruction has been sent to your email.';
                                        }else{
                                          $this->gen_contents['form_validation_error'] = 'There is a problem with sending email.';
                                        }
                                } else if ( $data['active'] != 1 ) {
                                    $this->gen_contents['form_validation_error'] = 'Your account is not activated.';
                                
                                } else {
                                    $this->gen_contents['form_validation_error'] = 'Your account is not active.'; 
                                }
                            }else{
                                //Error message for email not existing in db
                                $this->gen_contents['form_validation_error'] = 'Email doesn\'t exist.';
                            }
                           //redirect('forgot_password');
                      }else{
                           $this->gen_contents['form_validation_error'] = validation_errors();
                      }    
                }
            }
             $this->gen_contents['js_files'] = array( 'global/plugins/jquery-validation/js/jquery.validate.min.js', 'js/user_validation.js');
            $this->gen_contents['css_files'] = array('css/style.css');
            $this->gen_contents['additional_scripts'] = 'User_validation.init();';
 			$this->gen_contents['breadcrumb_name'] = 'Forgot Password';
            $this->template->write_view('content', 'user/forgot_password', $this->gen_contents);
            $this->template->render();
        }
        
        function resetpass($forgot_code = ''){
            $this->load->model('user_model');
           
                $status = $this->user_model->get_forgot_code($forgot_code);
                if( empty($status)){
                	sf('error_message', 'Invalid forgot code');
                    redirect('login');
                     //$this->template->write_view('content', "user/resetpass/$forgot_code", $this->gen_contents);
                } 
            if(!empty($_POST)){
                //Server validation
                $this->form_validation->set_rules('resetPwd', 'Enter New Password', 'required|trim|max_length[20]');
                $this->form_validation->set_rules('retypePwd', 'Enter Retype Password', 'required|trim|max_length[20]|callback_password_match');
                if ($this->form_validation->run() == TRUE) {
                    $data = array(
                            'password' => $this->input->post("resetPwd", true),
                            'forgot_pwd_code'=> $forgot_code
                        ); 
                    $status = $this->user_model->update_fgt_password($data);
                    if($status){
                        redirect('login');
                    }else{
                        sf('error_message', 'Password change failed');
                    }  
                    
                }else{
                   $this->gen_contents['form_validation_error'] = validation_errors();
               } 
            }
             $this->gen_contents['js_files'] = array( 'global/plugins/jquery-validation/js/jquery.validate.min.js', 'js/user_validation.js');
            $this->gen_contents['css_files'] = array('css/style.css');
            $this->gen_contents['additional_scripts'] = 'User_validation.init();';
            $this->gen_contents['breadcrumb_name'] = 'Register';
            $this->template->write_view('content', 'user/resetpass', $this->gen_contents);
            $this->template->render();
        }
           
        
        function activate($activation_code = ''){
            $this->load->model('user_model');
            if(!empty($activation_code)){ // If this variable is not empty we will try to activate this account if the code exists.
                $status = $this->user_model->get_activation_code($activation_code);
                if(!empty($status)){
                    $this->user_model->activate_account($activation_code);
                    $this->_send_welcome_email($status);
                    redirect('dashboard');
                }else{
                    sf('error_message', 'Invalid activation code');
                }
                
            }
            
            if(!empty($_POST)){
                $this->load->model('user_model');
                //Server validation
                $this->form_validation->set_rules('txtActivationCode', 'Activation Code', 'required|trim|max_length[15]');
                if ($this->form_validation->run() == TRUE) {
                    $activation_code = $this->input->post('txtActivationCode', true);
                    $status = $this->user_model->get_activation_code($activation_code);
                    if(!empty($status)){
                        $this->user_model->activate_account($activation_code);
                        $this->_send_welcome_email($status);
                        redirect('dashboard');
                    }else{
                        $this->gen_contents['form_validation_error'] = 'Invalid activation code';
                    }  
                    
                }else{
                   $this->gen_contents['form_validation_error'] = validation_errors();
               } 
                
            }
            $this->gen_contents['js_files'] = array( 'global/plugins/jquery-validation/js/jquery.validate.min.js', 'js/user_validation.js');
            $this->gen_contents['css_files'] = array('css/style.css');
            $this->gen_contents['additional_scripts'] = 'User_validation.init();';
            $this->template->write_view('content', 'user/activate', $this->gen_contents);
            $this->template->render();
            /* Here we need to load the activation form with an input field */
            
        }
        
        function resend_activation(){
            $this->load->model('user_model');
            $this->load->helper('email_helper');
            if(!empty($_POST)){ 
            	 
                 $this->form_validation->set_rules('txtEmail', 'email', 'required|trim|valid_email|max_length[50]'); 
                 
                  if ($this->form_validation->run() == TRUE) {  //form validation
                    $email  = $this->input->post("txtEmail", true);
                     $data = $this->common_model->get_data('user','fname, email, activation_code',array('email'=>$email));
                    
                    if(!empty($data) && !empty($data[0]['activation_code'])){ 
                        $send = process_and_send_mail($data[0]['email'],
                            array('first_name' => @$data[0]['fname'], 
                            'activation_link' => '<a target="_blank" href="' . base_url() . 'activate/' . @$data[0]['activation_code'].'" >' . base_url() . 'activate/' . @$data[0]['activation_code'].'</a>',
                            'regards_name' => c('regards_name'),
                            'email_bottom_instruction' => c('email_bottom_instruction'),
                            'activation_form' => '<a target="_blank" href="' . base_url() . 'activate'. '" >' .'here'. '</a>',
                            'code' => @$data[0]['activation_code']
                            ),
                                   'user_registration',
                                   array(), 
                                   array(), 
                                   '', 
                                   '');
                                  
                        if($send){ 
                            $this->gen_contents['form_validation_error']= 'Activation link send, please check your mail.';
                        }
                        else{
                            $this->gen_contents['form_validation_error'] = 'Activation link sending failed.';
                        }
                    }else{
                       $this->gen_contents['form_validation_error'] = 'No such email exists in our database.';
                    }
                  
                  }else{
                  	 
                   $this->gen_contents['form_validation_error'] = validation_errors();
               } 
            }
            $this->gen_contents['js_files'] = array( 'global/plugins/jquery-validation/js/jquery.validate.min.js', 'js/user_validation.js');
            $this->gen_contents['css_files'] = array('css/style.css');
            $this->gen_contents['additional_scripts'] = 'User_validation.init();';
            $this->template->write_view('content', 'user/resend_activation', $this->gen_contents);
            
            $this->template->render();
            
        }
        
        function _send_welcome_email($user_details = array()){
            $this->load->helper('email_helper');
            process_and_send_mail($user_details[0]['email'],
                            array('first_name' => $user_details[0]['fname'], 
                            'login_link' => '<a target="_blank" href="' . base_url(). 'login'.'" >'.base_url().'login'.'</a>',
                            'regards_name' => c('regards_name'),
                            'email_bottom_instruction' => c('email_bottom_instruction')
                            ),
                                   'send_welcome_email', 
                                   array(), 
                                   array(), 
                                   '', 
                                   '');
        }
    
        function dashboard(){
           (!$this->authentication->check_logged_in("normal", false)) ? redirect('login') : '';
           
         	$this->gen_contents['js_files'] = array('frontend/common.js');
          	$this->gen_contents['css_files'] = array('frontend/common.css');
            $this->gen_contents['settings_which_page'] = 'dashboard';
            $where = array('q.payment_received' => '1',   'q.user_id =' => s('USER_ID'));
	        $like_search = array();
	        $this->load->model('admin/orders_model');
	        $this->gen_contents['quotes'] = $this->orders_model->list_orders(0, 10, $where, $like_search, true);
        
           	$this->template->set_template('default');
	 		$this->template->write_view('content', 'user/settings', $this->gen_contents);
	        $this->template->render();
         
          
           
        }
        
        function change_password(){
        	(!$this->authentication->check_logged_in("normal",false)) ? redirect('login') : '';
	        if (!empty($_POST)) {
	            
	                $this->load->model('admin/admin_model'); 
	                /* Code here: loading the validation library */
	                $this->load->library('form_validation');
	                //Codeigniter form validation for changepassword fields
	                $this->form_validation->set_rules('current_password', 'current password', 'required|trim|max_length[20]');
	                $this->form_validation->set_rules('new_password', 'new password', 'required|trim|max_length[20]');
	                $this->form_validation->set_rules('new_password_confirm', 'confirm password', 'required|trim|max_length[20]|callback_password_match');
	
	                if ($this->form_validation->run() == TRUE) {
	                    $status = $this->admin_model->update_admin_password($this->input->post("current_password", true), $this->input->post("new_password", true), s('USER_ID'));
	                    if (!empty($status['invalid_old_password'])) {
	                        sf( 'error_message', 'Old password you entered is wrong.' );
	                        redirect('change_password');
	                    }
	                    else if ($status) {
	                    	sf( 'success_message', 'Your password has been updated successfully.' );
	                        redirect('change_password');
	                        
	                    }
	                    else {
	                    	sf( 'error_message', 'There is a problem with update. Please try later.' );
	                        redirect('change_password');
	                       
	                    }
	                }
	                else {
	                	sf( 'error_message', validation_errors() );
	                        redirect('change_password');
	                    
	                }
	            }
	       $this->gen_contents['js_files'] = array( 'global/plugins/jquery-validation/js/jquery.validate.min.js', 'js/user_validation.js');
            $this->gen_contents['css_files'] = array('css/style.css');
            $this->gen_contents['additional_scripts'] = 'User_validation.init();';
             $this->gen_contents['settings_which_page'] = 'change_password';
            $this->template->write_view('content', 'user/settings', $this->gen_contents);
            //$this->template->write_view('content', 'user/user_changePassword', $this->gen_contents);
            $this->template->render();
        }
        
        function password_match($conf_pwd)
        {   
            $this->load->library('form_validation');
            $new_pwd = $this->input->post("new_password", true);
            if(!empty($new_pwd)){
                if ($new_pwd != $conf_pwd) {
                $this->form_validation->set_message('password_match', 'New and confirm password does not match');
                return FALSE;
                }
                else {
                    return TRUE;
                }

            }else{
                $retype_pwd = $this->input->post("retypePwd", true);
                if ($retype_pwd != $conf_pwd) {
                    $this->form_validation->set_message('password_match', 'Reset and Retype password does not match');
                    return FALSE;
                }
                else {
                    return TRUE;
                }
            }
        }
        
     function profile() {
            
        (!$this->authentication->check_logged_in("normal", false)) ? redirect('login') : '';
        if (!empty($_POST)) {
            $this->load->model('admin/admin_model');
            $this->load->library('form_validation');

            //Codeigniter validation
            $this->form_validation->set_rules('txtFirstName', 'first name', 'required|trim|max_length[20]');
            $this->form_validation->set_rules('txtLastName', 'last name', 'required|trim|max_length[20]');
            $this->form_validation->set_rules('txtEmail', 'email', 'required|trim|valid_email|max_length[200]|callback_check_email_exists');

	            if ($this->form_validation->run() == TRUE) {// form validation
	                $data = array(
	                    'fname' => $this->input->post("txtFirstName", true),
	                    'lname' => $this->input->post("txtLastName", true),
	                    'email' => $this->input->post("txtEmail", true),
	                	'company_name' => $this->input->post("txtCompanyName", true),
	                	'phone' => $this->input->post("phone", true),
		                'address' => $this->input->post("txtAddress", true),
		                'address2' => $this->input->post("txtAddress2", true),
	                	'country' => $this->input->post("txtCountry", true), 
		                'state' => $this->input->post("cmbState", true),
		                'city' => $this->input->post("txtCity", true) ,
	                	'pin' => $this->input->post("zipCode", true) 
	                );
	
	                if (!empty($_FILES['flProfielImage'])) {
	                    $this->load->helper('image_helper');
	                    if ($_FILES['flProfielImage']['name'] != '') {
	                        $upload_status = upload_image('admin_profile', 'flProfielImage');
	                    }
	                }
	                if (!empty($upload_status['file_name'])) {
	                    // Remove the existing image if the file upload is success
	                    $old_image_name = $this->common_model->get_data('user', 'profile_image');
	                    $data['profile_image'] = $upload_status['file_name'];
	                }
	
	                if (!empty($upload_status['upload_error'])) {
	                    $this->gen_contents['form_validation_error'] = $upload_status['upload_error'];
	                }
	                else {
	                    $status = $this->admin_model->update_admin_profile($data, s('USER_ID'));
	                    if ($status) {
	                        if (!empty($upload_status['file_name']))
	                            $this->session->set_userdata(array('USER_PROFILE_IMAGE' => $data['profile_image'], 'USER_NAME' => $data['fname'])); // Just keep this name for printing at the top header
	                        if (!empty($old_image_name[0]['profile_image'])) {
	                            // Remove old images
	                            delete_image('admin_profile', $old_image_name[0]['profile_image']);
	                        }
	                        sf('success_message', 'Your profile has been updated.');
	                        redirect('profile');
	                    }
	                    else {
	                        sf('error_message', 'There is a problem with update.');
	                        redirect('profile');
	                    }
	                }
	            }
	            else {
	                $this->gen_contents['form_validation_error'] = validation_errors();
	            }
	        }
            $this->gen_contents['profile_data'] = $this->common_model->get_data('user','*',array('id' => s('USER_ID')));
            
            $this->gen_contents['js_files'] = array( 'global/plugins/jquery-validation/js/jquery.validate.min.js', 'js/user_validation.js');
            $this->gen_contents['css_files'] = array('css/style.css');
            $this->gen_contents['additional_scripts'] = 'User_validation.init();';
            $this->gen_contents['settings_which_page'] = 'profile';
            
            $this->template->write_view('content', 'user/settings', $this->gen_contents);
            //$this->template->write_view('content', 'user/profile', $this->gen_contents);
            $this->template->render();
    }
    
    function check_email_exists($email){
		$this->load->library('form_validation');
        $sts = $this->common_model->get_data('user', 'email', array('id !=' => s('USER_ID'), 'email' => $email ));
        if(!empty($sts)){
        	$this->form_validation->set_message('check_email_exists', 'Already user with same email exists.');
            return FALSE;
           
         }
            else {
                return TRUE;
            }
	}
    
    
    function zip_validate($zipcode){  
        $this->load->model('user_model');
        $city_id = $this->input->post("city", true);
        $state_code = $this->input->post("state", true);
        $this->zipcode_details = $this->user_model->get_state_city_zip_details($zipcode, $state_code, $city_id);
        if (empty($this->zipcode_details))
        {
            $this->form_validation->set_message('zip_validate', 'Please enter valid zipcode');
            return FALSE;
        }
        else
        {
            return TRUE;
        }
    }
    
    function my_gallery(){
        (!$this->authentication->check_logged_in("normal", false)) ? redirect('login') : '';
        if(($this->session->userdata('USER_TYPE') != 1)){
            redirect('profile');
        }
        $this->gen_contents['my_gallery'] = $this->common_model->get_data('gallery', '*', array('user_id' => s('USER_ID')));
        $this->gen_contents['settings_which_page'] = 'gallery';
        $this->template->write_view('content', 'user/settings', $this->gen_contents);
        //$this->template->write_view('content', 'user/my_gallery', $this->gen_contents);
        $this->template->render();
    }
    
    function delete_gallery_image($img_id = 0){
        if(empty ($img_id)){
            redirect('my_gallery');
        }
        $this->load->helper('image');
        $image_name = $this->common_model->get_data('gallery', 'file_name', array('id' => $img_id, 'user_id' => s('USER_ID')));
        $image_name = @$image_name[0]['file_name'];
       
        $this->db->delete('gallery', array('id' => $img_id, 'user_id' => s('USER_ID')));
        if(!empty($image_name)) delete_image('gallery', $image_name, s('USER_ID')); 
        sf('success_message', 'Gallery image has been remvoved.');
        redirect('my_gallery');
    }
	
 
   
   function settings(){
       
       (!$this->authentication->check_logged_in("normal", false)) ? redirect('login') : '';
       if(($this->session->userdata('USER_TYPE') != 1)){
            $this->profile();
            return;
       }
       $this->load->model('admin/admin_model');
       $rating = $this->common_model->get_data( 'user', 'rating', array('id' =>s('USER_ID')));
       $rating = roundDownToHalf($rating[0]['rating']);
       $this->gen_contents['dashboard_statitics'] = array(
                                                        'total_comments' => $this->common_model->user_feedback_count(s('USER_ID')),
                                                        'my_rating' => $rating,
                                                       // 'total_trainees' => $this->admin_model->list_users_count(array('user_type' => 2, 'status' => 1)),
                                                        'total_workouts' => $this->admin_model->get_workouts_count(array('w.status' => 1, 'w.user_id' => s('USER_ID'), 'u.status' => 1)),
                                                        'total_revenue' => rand(1,5000)
                                                        );
       $this->gen_contents['settings_which_page'] = 'settings';
       $this->template->write_view('content', 'user/settings', $this->gen_contents);
       $this->template->render();
   }
   
    
   function feedback(){
       (!$this->authentication->check_logged_in("normal", false)) ? redirect('login') : '';
      // if((s('USER_TYPE') != 1))  redirect(); 
      
       if (!empty($_POST)){
            //Codeigniter validation
            $this->form_validation->set_rules('txtFeedback', 'Feeback', 'required|trim|max_length[500]');
            if ($this->form_validation->run() == TRUE){// form validation
                 $data_array = array(
                    'user_id'       => s('USER_ID'),
                    'comment'       => $this->input->post("txtFeedback", true),
                    'comment_date'  => get_cur_date_time(),
                    'ip'            => $this->input->ip_address()
                    );

                $id = $this->common_model->contact_request($data_array);
                if($id > 0){
                    $this->load->helper('email_helper');
                    $admin_details = $this->common_model->get_admin_details();
                    $admin_details= $admin_details[0];
                    /* Send activation email */
                        process_and_send_mail($admin_details['email'],
                        array(
                        'comment' => $data_array['comment'], 
                        'user_name' => s('USER_NAME'),
                        'admin_name' => $admin_details['fname'].' '.$admin_details['lname'],
                        'regards_name' => c('regards_name'),
                        'email_bottom_instruction' => c('email_bottom_instruction'),
                        'activation_form' => '<a target="_blank" href="' . base_url() . 'activate'. '" >' .'here'. '</a>',
                        'code' => $activation_code
                        ),
                       'feedback_email_to_admin',
                       array(), 
                       array(), 
                       '', 
                       '');
                    
                    sf('success_message', 'Thank you for sending us your feeback.');
                    redirect('feedback');
                }else{
                    sf('error_message', 'Sorry. There is a problem to process your request.');
                    redirect('feedback');
                }
            }else{
               $this->gen_contents['form_validation_error'] = validation_errors(' ',' ');
            }
       }
       
       $this->gen_contents['settings_which_page'] = 'feedback';
       $this->template->write_view('content', 'user/settings', $this->gen_contents);
       $this->template->render();
   }
   
   function paypal_config(){
       (!$this->authentication->check_logged_in("normal", false)) ? redirect('login') : '';
       if((s('USER_TYPE') != 1))  redirect(); 
        if (!empty($_POST)){
            $this->form_validation->set_rules('txtPaypalEmail', 'email', 'required|trim|valid_email|max_length[50]');
            if ($this->form_validation->run() == TRUE) {
                $paypal_email = $this->input->post('txtPaypalEmail', true);
                $this->db->update('user_details', array('paypal_email' => $paypal_email), array('id' => s('USER_ID')));
                $this->gen_contents['success_message'] = 'You paypal email has been updated.';
            }else{
                $this->gen_contents['error_message'] = validation_errors();
            }
        }
       
       $this->gen_contents['paypal_email'] = $this->common_model->get_data('user_details', 'paypal_email', array('id' => s('USER_ID')));
       $this->gen_contents['settings_which_page'] = 'paypal_config';
       $this->template->write_view('content', 'user/settings', $this->gen_contents);
       $this->template->render();
   }
   
    
    
    
}

/* End of file welcome.php */
/* Location: ./application/controllers/Welcome.php */