<?php
/**
 * CodeIgniter
 *
 * An open source application development framework for PHP
 *
 * This content is released under the MIT License (MIT)
 *
 * Copyright (c) 2014 - 2015, British Columbia Institute of Technology
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * @package	CodeIgniter
 * @author	EllisLab Dev Team
 * @copyright	Copyright (c) 2008 - 2014, EllisLab, Inc. (http://ellislab.com/)
 * @copyright	Copyright (c) 2014 - 2015, British Columbia Institute of Technology (http://bcit.ca/)
 * @license	http://opensource.org/licenses/MIT	MIT License
 * @link	http://codeigniter.com
 * @since	Version 1.0.0
 * @filesource
 */
defined('BASEPATH') OR exit('No direct script access allowed');

class Welcome extends CI_Controller {

	
	var $gen_contents	=	array(); 
	
	
	function index(){  
    
        $domain= array_shift((explode(".",$_SERVER['HTTP_HOST'])));
        //$domain='dev'; //finaltournament
        $this->gen_contents['details'] = $this->common_model->get_data('user','package, id, fourlane_double_status, sixlane_double_status,scoring_double_status,scoring_cat_id,tournament_cat_id', array('domian' => $domain ));
//device detection
        $this->load->library('user_agent');

        if ($this->agent->is_browser())
        {
        $agent = $this->agent->browser();
        $this->gen_contents['browser'] = $agent;
        }else{
        $this->gen_contents['browser'] = "";    
        }
       
        
        if($this->gen_contents['details'][0]['package']==1){

           $user= $this->gen_contents['details'][0]['id'];
           $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
           $this->gen_contents['scroll_news'] = $this->common_model->get_data('scroll_news','*', array('user_id' => $user));
           //$interval=$this->gen_contents['list_all'][0]['interval'];
           $this->gen_contents['interval'] = 0;
           $this->gen_contents['user_id'] = $user;
           $all_settings = $this->common_model->get_data('setting','*', array('user_id' => $user));
            $all_settings=$all_settings[0];
          
           
        $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
        if($double_lane_status == 0){
            $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
            $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
              $design_id=$this->gen_contents['user_details'][0]['design_id'];
              $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
            $this->load->view('fourlane/fourlane_header', $this->gen_contents);
            $this->load->view('fourlane/fourlane_middle', $this->gen_contents);
            $this->load->view('fourlane/fourlane_footer', $this->gen_contents);
        }else{
            $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
            $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
              $design_id=$this->gen_contents['user_details'][0]['design_id'];
              $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
            $this->load->view('fourlane/fourlane_header', $this->gen_contents);
            $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);
            $this->load->view('fourlane/fourlane_footer', $this->gen_contents);
        }    
            
    }
    elseif($this->gen_contents['details'][0]['package']==2){

           $user= $this->gen_contents['details'][0]['id'];
           
           $this->gen_contents['scroll_news'] = $this->common_model->get_data('scroll_news','*', array('user_id' => $user));
           $this->gen_contents['user_id'] = $user;
           $this->gen_contents['interval'] = 0;

            //checking whether user opted double lane insteda of single lane
              $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
              
             // echo $double_lane_status; die();
            if($double_lane_status ==0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_header', $this->gen_contents);
                $this->load->view('sixlane/sixlane_middle', $this->gen_contents);
                $this->load->view('sixlane/sixlane_footer', $this->gen_contents);
            }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_header', $this->gen_contents);
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);
                $this->load->view('sixlane/sixlane_footer', $this->gen_contents);
            }
    }

      elseif($this->gen_contents['details'][0]['package']==3){

          $user= $this->gen_contents['details'][0]['id'];
          $this->gen_contents['setting'] = $this->common_model->get_data('setting','*', array('user_id' => $user ));
          $setting_value=$this->gen_contents['setting'][0]['setting_value'];
          $interval=$this->gen_contents['setting'][0]['t_interval'];
          $this->gen_contents['interval'] = $interval;
         // $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
          $this->gen_contents['scroll_news'] = $this->common_model->get_data('scroll_news','*', array('user_id' => $user));
          $this->gen_contents['user_id'] = $user;
          $all_settings = $this->common_model->get_data('setting','*', array('user_id' => $user));
            $all_settings=$all_settings[0];
          if($setting_value=="I"){
              $this->gen_contents['title']="Ice Sheet";
              $this->gen_contents['page_name']="I";
              $this->gen_contents['package_type']="3";
              
              $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
              if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                 $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('fourlane/fourlane_middle', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
              }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);  
              }

          }elseif(($setting_value=="T") ||($setting_value=="IT")){
        if($this->gen_contents['details'][0]['tournament_cat_id'] ==1 ){
              $this->gen_contents['title']="Tournament";
              $this->gen_contents['page_name']="T";
              $this->gen_contents['package_type']="3";
              $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
              $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('tournament/tournament_middle', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents);
          }
          }elseif($setting_value==""){
               if($all_settings['url_status']== '1'  && $all_settings['calendar_status']== '1' ){
                
                if($_POST['calendar']=="1"){
                  $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="3";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/website_display', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
                
                }else{
                     $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="3";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/calendar', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
                
                
           } }elseif($all_settings['url_status']== '1'  && $all_settings['calendar_status']== '0' ){
                
                if($website=="yes"){
                   $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="3";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/website_display', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
                }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="3";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/website_display', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
           } }elseif($all_settings['url_status']== '0'  && $all_settings['calendar_status']== '1' ){
                
                if($_POST['calendar']=="1"){
                   $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="3";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/calendar', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
                }else{
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="3";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/calendar', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
           } }
           }

    }elseif($this->gen_contents['details'][0]['package']==4){

          $user= $this->gen_contents['details'][0]['id'];
          $this->gen_contents['setting'] = $this->common_model->get_data('setting','*', array('user_id' => $user ));
          $setting_value=$this->gen_contents['setting'][0]['setting_value'];
          $interval=$this->gen_contents['setting'][0]['t_interval'];
          $this->gen_contents['interval'] = $interval;
         // $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
          $this->gen_contents['scroll_news'] = $this->common_model->get_data('scroll_news','*', array('user_id' => $user));
          $this->gen_contents['user_id'] = $user;
          $all_settings = $this->common_model->get_data('setting','*', array('user_id' => $user));
        $all_settings=$all_settings[0];
          if($setting_value=="I"){
              $this->gen_contents['title']="Ice Sheet";
              $this->gen_contents['page_name']="I";
              $this->gen_contents['package_type']="4";
              
              //checking whether user opted double lane insteda of single lane
              $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
              
             // echo $double_lane_status; die();
            if($double_lane_status ==0){
              
              
              $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
              $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
              $design_id=$this->gen_contents['user_details'][0]['design_id'];
              $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('sixlane/sixlane_middle', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents);
              
            }else{
                
              $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
              $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
              $design_id=$this->gen_contents['user_details'][0]['design_id'];
              $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents);  
                
            }  

          }elseif(($setting_value=="T") ||($setting_value=="IT")){
if($this->gen_contents['details'][0]['tournament_cat_id'] ==1 ){
              $this->gen_contents['title']="Tournament";
              $this->gen_contents['page_name']="T";
              $this->gen_contents['package_type']="4";
              $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
              $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('tournament/tournament_middle', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents); 
                }
          }elseif($setting_value==""){
               if($all_settings['url_status']== '1'  && $all_settings['calendar_status']== '1' ){
                
                if($_POST['calendar']=="1"){
                  $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="4";
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/website_display', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
                }else{
                     $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="4";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/calendar', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
                
           } }elseif($all_settings['url_status']== '1'  && $all_settings['calendar_status']== '0' ){
                
                if($website=="yes"){
                   $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="4";
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/website_display', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
                }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="4";
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/website_display', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
           } }elseif($all_settings['url_status']== '0'  && $all_settings['calendar_status']== '1' ){
                
                if($_POST['calendar']=="1"){
                   $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="4";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/calendar', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
                }else{
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="4";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/calendar', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
           } }
           }
}elseif($this->gen_contents['details'][0]['package']==5){

          $user= $this->gen_contents['details'][0]['id'];
          $this->gen_contents['setting'] = $this->common_model->get_data('setting','*', array('user_id' => $user ));
          $setting_value=$this->gen_contents['setting'][0]['setting_value'];
          $interval=$this->gen_contents['setting'][0]['t_interval'];
          $this->gen_contents['interval'] = $interval;
          $all_settings = $this->common_model->get_data('setting','*', array('user_id' => $user));
         $all_settings=$all_settings[0];
         // $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
          $this->gen_contents['scroll_news'] = $this->common_model->get_data('scroll_news','*', array('user_id' => $user));
          $this->gen_contents['user_id'] = $user;
          
          //p($this->gen_contents); die("test");
          if(($setting_value=="I") || ($setting_value=='IT')){
              $this->gen_contents['title']="Ice Sheet";
              $this->gen_contents['page_name']="I";
              $this->gen_contents['package_type']="5";
              
              //checking whether user opted double lane insteda of single lane
              
              $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
              
              if($double_lane_status == 0 ){ //means single lane
              $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
              $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
              $design_id=$this->gen_contents['user_details'][0]['design_id'];
              $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('fourlane/fourlane_middle', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents);
              
              }else{
              
              $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
              $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
              $design_id=$this->gen_contents['user_details'][0]['design_id'];
              $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents);   
                  
              }

          }elseif(($setting_value=="T")){
if($this->gen_contents['details'][0]['tournament_cat_id'] ==1 ){
              $this->gen_contents['title']="Tournament";
              $this->gen_contents['page_name']="T";
              $this->gen_contents['package_type']="5";
              $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
              $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('tournament/tournament_middle', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents);
                }
              
            }elseif(($setting_value=="S") || ($setting_value=="ITS") || ($setting_value=="IS") || ($setting_value=="TS")){
              
              $this->gen_contents['title']="scoring";
              $this->gen_contents['page_name']="S";
              $this->gen_contents['package_type']="5";
              $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
              if($this->gen_contents['details'][0]['scoring_cat_id']==1){
              if($scoring_double_lane_status == 0){
              $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
              $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('scoring/scoring_middle', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents);
              }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
              $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents);
              }
              }
              
          }elseif($setting_value==""){
               if($all_settings['url_status']== '1'  && $all_settings['calendar_status']== '1' ){
                
                if($_POST['calendar']=="1"){
                  $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/website_display', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
                }else{
                     $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/calendar', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
                
           } }elseif($all_settings['url_status']== '1'  && $all_settings['calendar_status']== '0' ){
                
                if($website=="yes"){
                   $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/website_display', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
                }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/website_display', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
           } }elseif($all_settings['url_status']== "0"  && $all_settings['calendar_status']== "1" ){
                
                if($_POST['calendar']=="1"){
                   $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/calendar', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
                }else{
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/calendar', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
           } }
           }
}elseif($this->gen_contents['details'][0]['package']==6){

          $user= $this->gen_contents['details'][0]['id'];
          $this->gen_contents['setting'] = $this->common_model->get_data('setting','*', array('user_id' => $user ));
          $setting_value=$this->gen_contents['setting'][0]['setting_value'];
          $interval=$this->gen_contents['setting'][0]['t_interval'];
          $this->gen_contents['interval'] = $interval;
          $all_settings = $this->common_model->get_data('setting','*', array('user_id' => $user));
        $all_settings=$all_settings[0];
         // $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
          $this->gen_contents['scroll_news'] = $this->common_model->get_data('scroll_news','*', array('user_id' => $user));
          $this->gen_contents['user_id'] = $user;
          if($setting_value=="I"){
              $this->gen_contents['title']="Ice Sheet";
              $this->gen_contents['page_name']="I";
              $this->gen_contents['package_type']="6";
              
              //checking whether user opted double lane insteda of single lane
              $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
              
             // echo $double_lane_status; die();
              if($double_lane_status ==0){
                  
              $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
              $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
              $design_id=$this->gen_contents['user_details'][0]['design_id'];
              $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('sixlane/sixlane_middle', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents);
              
              
              }else{
               
              $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
              $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
              $design_id=$this->gen_contents['user_details'][0]['design_id'];
              $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents);    
                  
              }

          }elseif(($setting_value=="T")|| ($setting_value=="IT")){
            if($this->gen_contents['details'][0]['tournament_cat_id'] ==1 ){
              $this->gen_contents['title']="Tournament";
              $this->gen_contents['page_name']="T";
              $this->gen_contents['package_type']="6";
              $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
              $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('tournament/tournament_middle', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents);
            } }elseif(($setting_value=="S") ||($setting_value=="ITS")|| ($setting_value=="IS") || ($setting_value=="TS")){

              $this->gen_contents['title']="scoring";
              $this->gen_contents['page_name']="S";
              $this->gen_contents['package_type']="6";
              $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
              if($this->gen_contents['details'][0]['scoring_cat_id']==1){
              if($scoring_double_lane_status == 0){
              $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
              $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('scoring/scoring_middle', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents);
              }else{
                 $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                 $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents); 
              }
              }
          }elseif($setting_value==""){
               if($all_settings['url_status']== '1'  && $all_settings['calendar_status']== '1' ){
                
                if($_POST['calendar']=="1"){
                  $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/website_display', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
                }else{
                     $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/calendar', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
                
           } }elseif($all_settings['url_status']== '1'  && $all_settings['calendar_status']== '0' ){
                
                if($website=="yes"){
                   $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/website_display', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
                }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/website_display', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
           } }elseif($all_settings['url_status']== '0'  && $all_settings['calendar_status']== '1' ){
                
                if($_POST['calendar']=="1"){
                   $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/calendar', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
                }else{
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/calendar', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
           } }
           }
}elseif($this->gen_contents['details'][0]['package']==7){

          $user= $this->gen_contents['details'][0]['id'];
          $this->gen_contents['setting'] = $this->common_model->get_data('setting','*', array('user_id' => $user ));
          $setting_value=$this->gen_contents['setting'][0]['setting_value'];
          $interval=$this->gen_contents['setting'][0]['t_interval'];
          $this->gen_contents['interval'] = $interval;
          $all_settings = $this->common_model->get_data('setting','*', array('user_id' => $user));
         $all_settings=$all_settings[0];
         // $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
          $this->gen_contents['scroll_news'] = $this->common_model->get_data('scroll_news','*', array('user_id' => $user));
          $this->gen_contents['user_id'] = $user;
          
          //p($this->gen_contents); die("test");
          if(($setting_value=="I") || ($setting_value=='IT')){
              $this->gen_contents['title']="Ice Sheet";
              $this->gen_contents['page_name']="I";
              $this->gen_contents['package_type']="7";
              
              //checking whether user opted double lane insteda of single lane
              
              $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
              
              if($double_lane_status == 0 ){ //means single lane
              $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
              $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
              $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
              $design_id=$this->gen_contents['user_details'][0]['design_id'];
              $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('fourlane/fourlane_adv_middle', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents);
              
              }else{
              
              $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
              $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
              $design_id=$this->gen_contents['user_details'][0]['design_id'];
              $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents);   
                  
              }

          }elseif(($setting_value=="T")){
            if($this->gen_contents['details'][0]['tournament_cat_id'] ==1 ){
              $this->gen_contents['title']="Tournament";
              $this->gen_contents['page_name']="T";
              $this->gen_contents['package_type']="7";
              $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
              $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('tournament/tournament_middle', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents);
                }
              
            }elseif(($setting_value=="S") || ($setting_value=="ITS") || ($setting_value=="IS") || ($setting_value=="TS")){
              
              $this->gen_contents['title']="scoring";
              $this->gen_contents['page_name']="S";
              $this->gen_contents['package_type']="7";
              $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
              if($this->gen_contents['details'][0]['scoring_cat_id']==1){
              if($scoring_double_lane_status == 0){
              $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
              $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('scoring/scoring_middle', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents);
              }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
              $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents);
              }
              }
              
          }elseif($setting_value==""){
               if($all_settings['url_status']== '1'  && $all_settings['calendar_status']== '1' ){
                
                if($_POST['calendar']=="1"){
                  $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/website_display', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
                }else{
                     $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/calendar', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
                
           } }elseif($all_settings['url_status']== '1'  && $all_settings['calendar_status']== '0' ){
                
                if($website=="yes"){
                   $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/website_display', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
                }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/website_display', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
           } }elseif($all_settings['url_status']== "0"  && $all_settings['calendar_status']== "1" ){
                
                if($_POST['calendar']=="1"){
                   $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/calendar', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
                }else{
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/calendar', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
           } }
           }
}elseif($this->gen_contents['details'][0]['package']==8){

          $user= $this->gen_contents['details'][0]['id'];
          $this->gen_contents['setting'] = $this->common_model->get_data('setting','*', array('user_id' => $user ));
          $setting_value=$this->gen_contents['setting'][0]['setting_value'];
          $interval=$this->gen_contents['setting'][0]['t_interval'];
          $this->gen_contents['interval'] = $interval;
          $all_settings = $this->common_model->get_data('setting','*', array('user_id' => $user));
        $all_settings=$all_settings[0];
         // $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
          $this->gen_contents['scroll_news'] = $this->common_model->get_data('scroll_news','*', array('user_id' => $user));
          $this->gen_contents['user_id'] = $user;
          if($setting_value=="I"){
              $this->gen_contents['title']="Ice Sheet";
              $this->gen_contents['page_name']="I";
              $this->gen_contents['package_type']="8";
              
              //checking whether user opted double lane insteda of single lane
              $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
              
             // echo $double_lane_status; die();
              if($double_lane_status ==0){
                  
              $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
              $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
              $design_id=$this->gen_contents['user_details'][0]['design_id'];
              $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
              $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('sixlane/sixlane_adv_middle', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents);
              
              
              }else{
               
              $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
              $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
              $design_id=$this->gen_contents['user_details'][0]['design_id'];
              $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents);    
                  
              }

          }elseif(($setting_value=="T")|| ($setting_value=="IT")){
            if($this->gen_contents['details'][0]['tournament_cat_id'] ==1 ){
              $this->gen_contents['title']="Tournament";
              $this->gen_contents['page_name']="T";
              $this->gen_contents['package_type']="8";
              $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
              $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('tournament/tournament_middle', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents);
            } }elseif(($setting_value=="S") ||($setting_value=="ITS")|| ($setting_value=="IS") || ($setting_value=="TS")){

              $this->gen_contents['title']="scoring";
              $this->gen_contents['page_name']="S";
              $this->gen_contents['package_type']="8";
              $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
              if($this->gen_contents['details'][0]['scoring_cat_id']==1){
              if($scoring_double_lane_status == 0){
              $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
              $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('scoring/scoring_middle', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents);
              }else{
                 $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                 $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents); 
              }
              }
          }elseif($setting_value==""){
               if($all_settings['url_status']== '1'  && $all_settings['calendar_status']== '1' ){
                
                if($_POST['calendar']=="1"){
                  $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/website_display', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
                }else{
                     $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/calendar', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
                
           } }elseif($all_settings['url_status']== '1'  && $all_settings['calendar_status']== '0' ){
                
                if($website=="yes"){
                   $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/website_display', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
                }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/website_display', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
           } }elseif($all_settings['url_status']== '0'  && $all_settings['calendar_status']== '1' ){
                
                if($_POST['calendar']=="1"){
                   $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/calendar', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
                }else{
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/calendar', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
           } }
           }
}elseif($this->gen_contents['details'][0]['package']==9){

           $user= $this->gen_contents['details'][0]['id'];
           
           $this->gen_contents['scroll_news'] = $this->common_model->get_data('scroll_news','*', array('user_id' => $user));
           $this->gen_contents['user_id'] = $user;
           $this->gen_contents['interval'] = 0;

            $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
            $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
            $design_id=$this->gen_contents['user_details'][0]['design_id'];
            $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
            $this->load->view('eightlane/eightlane_header', $this->gen_contents);
            $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
            $this->load->view('eightlane/eightlane_footer', $this->gen_contents);
           
    }elseif($this->gen_contents['details'][0]['package']==10){

          $user= $this->gen_contents['details'][0]['id'];
          $this->gen_contents['setting'] = $this->common_model->get_data('setting','*', array('user_id' => $user ));
          $setting_value=$this->gen_contents['setting'][0]['setting_value'];
          $interval=$this->gen_contents['setting'][0]['t_interval'];
          $this->gen_contents['interval'] = $interval;
         // $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
          $this->gen_contents['scroll_news'] = $this->common_model->get_data('scroll_news','*', array('user_id' => $user));
          $this->gen_contents['user_id'] = $user;
          $all_settings = $this->common_model->get_data('setting','*', array('user_id' => $user));
        $all_settings=$all_settings[0];
          if($setting_value=="I"){
              $this->gen_contents['title']="Ice Sheet";
              $this->gen_contents['page_name']="I";
              $this->gen_contents['package_type']="10";
              
              
              $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
              $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
              $design_id=$this->gen_contents['user_details'][0]['design_id'];
              $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents);
             

          }elseif(($setting_value=="T") ||($setting_value=="IT")){
if($this->gen_contents['details'][0]['tournament_cat_id'] ==1 ){
              $this->gen_contents['title']="Tournament";
              $this->gen_contents['page_name']="T";
              $this->gen_contents['package_type']="10";
              $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
              $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('tournament/tournament_middle', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents); 
                }
          }elseif($setting_value==""){
               if($all_settings['url_status']== '1'  && $all_settings['calendar_status']== '1' ){
                
                if($_POST['calendar']=="1"){
                  $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="10";
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/website_display', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
                }else{
                     $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="10";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/calendar', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
                
           } }elseif($all_settings['url_status']== '1'  && $all_settings['calendar_status']== '0' ){
                
                if($website=="yes"){
                   $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="10";
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/website_display', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
                }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="10";
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/website_display', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
           } }elseif($all_settings['url_status']== '0'  && $all_settings['calendar_status']== '1' ){
                
                if($_POST['calendar']=="1"){
                   $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="10";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/calendar', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
                }else{
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="10";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/calendar', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
           } }
           }
}elseif($this->gen_contents['details'][0]['package']==11){

          $user= $this->gen_contents['details'][0]['id'];
          $this->gen_contents['setting'] = $this->common_model->get_data('setting','*', array('user_id' => $user ));
          $setting_value=$this->gen_contents['setting'][0]['setting_value'];
          $interval=$this->gen_contents['setting'][0]['t_interval'];
          $this->gen_contents['interval'] = $interval;
          $all_settings = $this->common_model->get_data('setting','*', array('user_id' => $user));
        $all_settings=$all_settings[0];
         // $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
          $this->gen_contents['scroll_news'] = $this->common_model->get_data('scroll_news','*', array('user_id' => $user));
          $this->gen_contents['user_id'] = $user;
          if($setting_value=="I"){
              $this->gen_contents['title']="Ice Sheet";
              $this->gen_contents['page_name']="I";
              $this->gen_contents['package_type']="11";
              
              
                  
              $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
              $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
              $design_id=$this->gen_contents['user_details'][0]['design_id'];
              $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents);
              
              

          }elseif(($setting_value=="T")|| ($setting_value=="IT")){
            if($this->gen_contents['details'][0]['tournament_cat_id'] ==1 ){
              $this->gen_contents['title']="Tournament";
              $this->gen_contents['page_name']="T";
              $this->gen_contents['package_type']="11";
              $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
              $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('tournament/tournament_middle', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents);
            } }elseif(($setting_value=="S") ||($setting_value=="ITS")|| ($setting_value=="IS") || ($setting_value=="TS")){

              $this->gen_contents['title']="scoring";
              $this->gen_contents['page_name']="S";
              $this->gen_contents['package_type']="11";
              $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
              if($this->gen_contents['details'][0]['scoring_cat_id']==1){
              if($scoring_double_lane_status == 0){
              $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
              $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('scoring/scoring_middle', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents);
              }else{
                 $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                 $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents); 
              }
              }
          }elseif($setting_value==""){
               if($all_settings['url_status']== '1'  && $all_settings['calendar_status']== '1' ){
                
                if($_POST['calendar']=="1"){
                  $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/website_display', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
                }else{
                     $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/calendar', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
                
           } }elseif($all_settings['url_status']== '1'  && $all_settings['calendar_status']== '0' ){
                
                if($website=="yes"){
                   $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/website_display', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
                }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/website_display', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
           } }elseif($all_settings['url_status']== '0'  && $all_settings['calendar_status']== '1' ){
                
                if($_POST['calendar']=="1"){
                   $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/calendar', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
                }else{
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/calendar', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
           } }
           }
}elseif($this->gen_contents['details'][0]['package']==12){

          $user= $this->gen_contents['details'][0]['id'];
          $this->gen_contents['setting'] = $this->common_model->get_data('setting','*', array('user_id' => $user ));
          $setting_value=$this->gen_contents['setting'][0]['setting_value'];
          $interval=$this->gen_contents['setting'][0]['t_interval'];
          $this->gen_contents['interval'] = $interval;
          $all_settings = $this->common_model->get_data('setting','*', array('user_id' => $user));
        $all_settings=$all_settings[0];
         // $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
          $this->gen_contents['scroll_news'] = $this->common_model->get_data('scroll_news','*', array('user_id' => $user));
          $this->gen_contents['user_id'] = $user;
          if($setting_value=="I"){
              $this->gen_contents['title']="Ice Sheet";
              $this->gen_contents['page_name']="I";
              $this->gen_contents['package_type']="12";
              
             
                  
              $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
              $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
              $design_id=$this->gen_contents['user_details'][0]['design_id'];
              $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
              $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('eightlane/eightlane_adv_middle', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents);
              
              

          }elseif(($setting_value=="T")|| ($setting_value=="IT")){
            if($this->gen_contents['details'][0]['tournament_cat_id'] ==1 ){
              $this->gen_contents['title']="Tournament";
              $this->gen_contents['page_name']="T";
              $this->gen_contents['package_type']="12";
              $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
              $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('tournament/tournament_middle', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents);
            } }elseif(($setting_value=="S") ||($setting_value=="ITS")|| ($setting_value=="IS") || ($setting_value=="TS")){

              $this->gen_contents['title']="scoring";
              $this->gen_contents['page_name']="S";
              $this->gen_contents['package_type']="12";
              $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
              if($this->gen_contents['details'][0]['scoring_cat_id']==1){
              if($scoring_double_lane_status == 0){
              $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
              $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('scoring/scoring_middle', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents);
              }else{
                 $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                 $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents); 
              }
              }
          }elseif($setting_value==""){
               if($all_settings['url_status']== '1'  && $all_settings['calendar_status']== '1' ){
                
                if($_POST['calendar']=="1"){
                  $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/website_display', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
                }else{
                     $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/calendar', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
                
           } }elseif($all_settings['url_status']== '1'  && $all_settings['calendar_status']== '0' ){
                
                if($website=="yes"){
                   $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/website_display', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
                }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/website_display', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
           } }elseif($all_settings['url_status']== '0'  && $all_settings['calendar_status']== '1' ){
                
                if($_POST['calendar']=="1"){
                   $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/calendar', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
                }else{
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/tournament_header', $this->gen_contents);
                $this->load->view('tournament/calendar', $this->gen_contents);
                $this->load->view('tournament/tournament_footer', $this->gen_contents);
           } }
           }
}
/*elseif($this->gen_contents['details'][0]['package']==7){
  

          $user= $this->gen_contents['details'][0]['id'];
          $this->gen_contents['setting'] = $this->common_model->get_data('setting','*', array('user_id' => $user ));
          $setting_value=$this->gen_contents['setting'][0]['setting_value'];
          $interval=$this->gen_contents['setting'][0]['t_interval'];
          $this->gen_contents['interval'] = $interval;
         // $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
          $this->gen_contents['scroll_news'] = $this->common_model->get_data('scroll_news','*', array('user_id' => $user));
          $this->gen_contents['user_id'] = $user;
          if($setting_value=="I"){
              $this->gen_contents['title']="Ice Sheet";
              $this->gen_contents['page_name']="I";
              $this->gen_contents['package_type']="7";
              
            $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
            if($double_lane_status == 0){
              $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('fourlane/fourlane_middle', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents);
            }else{
              $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents);  
            }  

          }elseif(($setting_value=="S") ||($setting_value=="A")){

              $this->gen_contents['title']="scoring";
              $this->gen_contents['page_name']="S";
              $this->gen_contents['package_type']="7";
              
              $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
              if($scoring_double_lane_status == 0){
              $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('scoring/scoring_middle', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents);
              }else{
                 $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents); 
              }
          }
}
elseif($this->gen_contents['details'][0]['package']==8){
  

          $user= $this->gen_contents['details'][0]['id'];
          $this->gen_contents['setting'] = $this->common_model->get_data('setting','*', array('user_id' => $user ));
          $setting_value=$this->gen_contents['setting'][0]['setting_value'];
          $interval=$this->gen_contents['setting'][0]['t_interval'];
          $this->gen_contents['interval'] = $interval;
         // $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
          $this->gen_contents['scroll_news'] = $this->common_model->get_data('scroll_news','*', array('user_id' => $user));
          $this->gen_contents['user_id'] = $user;
          if($setting_value=="I"){
              $this->gen_contents['title']="Ice Sheet";
              $this->gen_contents['page_name']="I";
              $this->gen_contents['package_type']="8";
              $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('sixlane/sixlane_middle', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents);

          }elseif(($setting_value=="S") ||($setting_value=="A")){

              $this->gen_contents['title']="scoring";
              $this->gen_contents['page_name']="S";
              $this->gen_contents['package_type']="8";
              $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
              $this->load->view('tournament/tournament_header', $this->gen_contents);
              $this->load->view('scoring/scoring_middle', $this->gen_contents);
              $this->load->view('tournament/tournament_footer', $this->gen_contents);
          }
}*/

    }


    function update_ajax(){

        //device detection
        $this->load->library('user_agent');

        if ($this->agent->is_browser())
        {
        $agent = $this->agent->browser();
        $this->gen_contents['browser'] = $agent;
        }else{
        $this->gen_contents['browser'] = "";    
        }
        
       $user=$_POST['userid'];
       $this->gen_contents['user_id'] = $user;
       
       $interval=$this->gen_contents['list_all'][0]['interval'];
       $this->gen_contents['interval'] = $interval;
       $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
        $design_id=$this->gen_contents['user_details'][0]['design_id'];
      
       $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];    
        $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
       if($double_lane_status == 0){
          //  $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
        $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1));   
        $this->load->view('fourlane/fourlane_ajax', $this->gen_contents);
       }else{
           
        $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1));   
        $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);   
       }
    }

    function update_six_ajax(){

        //device detection
        $this->load->library('user_agent');

        if ($this->agent->is_browser())
        {
        $agent = $this->agent->browser();
        $this->gen_contents['browser'] = $agent;
        }else{
        $this->gen_contents['browser'] = "";    
        }
        
        
        $user=$_POST['userid'];
       $this->gen_contents['user_id'] = $user;
       
       $this->gen_contents['details'] = $this->common_model->get_data('user','*', array('id' => $user));
       $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
        $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
        $design_id=$this->gen_contents['user_details'][0]['design_id'];
      
       $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
        if($double_lane_status == 0){
            
            $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1));
            $this->load->view('sixlane/sixlane_ajax', $this->gen_contents);
        }else{
            $this->gen_contents['list_all'] = $this->common_model->get_data('six_lanedouble','*', array('user_id' => $user,'status'=>1));
            $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);
        }     
     
    }
    
    function update_eight_ajax(){

        //device detection
        $this->load->library('user_agent');

        if ($this->agent->is_browser())
        {
        $agent = $this->agent->browser();
        $this->gen_contents['browser'] = $agent;
        }else{
        $this->gen_contents['browser'] = "";    
        }
        
        
        $user=$_POST['userid'];
       $this->gen_contents['user_id'] = $user;
       
       $this->gen_contents['details'] = $this->common_model->get_data('user','*', array('id' => $user));
        $design_id=$this->gen_contents['details'][0]['design_id'];
      
       $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
        $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1));
        $this->load->view('eightlane/eightlane_ajax', $this->gen_contents);
            
     
    }
    
    function update_tournament_ajax(){
       
    //device detection
        $this->load->library('user_agent');

        if ($this->agent->is_browser())
        {
        $agent = $this->agent->browser();
        $this->gen_contents['browser'] = $agent;
        }else{
        $this->gen_contents['browser'] = "";    
        }
         
         
        $user=$_POST['userid'];
        $page_name=$_POST['page_name'];
        $package_type=$_POST['package_type'];
        $website=$_POST['website'];
        $this->gen_contents['setting'] = $this->common_model->get_data('setting','*', array('user_id' => $user ));
        $setting_value=$this->gen_contents['setting'][0]['setting_value'];
        $interval=$this->gen_contents['setting'][0]['t_interval'];
        $this->gen_contents['interval'] = $interval;
        $this->gen_contents['details'] = $this->common_model->get_data('user','*', array('id' => $user));
        
        
        if($package_type==3){ //tournament + icesheeet 4 lane
            $all_settings = $this->common_model->get_data('setting','*', array('user_id' => $user));
            $all_settings=$all_settings[0];
            if($setting_value==""){
               if($all_settings['url_status']== '1'  && $all_settings['calendar_status']== '1' ){
                
                if($_POST['calendar']=="1"){
                  $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
                }else{
                     $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="3";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
           } }elseif($all_settings['url_status']== '1'  && $all_settings['calendar_status']== '0' ){
                
                if($website=="yes"){
                   $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="3";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
                }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="3";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
           } }elseif($all_settings['url_status']== '0'  && $all_settings['calendar_status']== '1' ){
                
                if($_POST['calendar']=="1"){
                   $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="3";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                }else{
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="3";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
           } }
           }else{
            if($setting_value=="IT"){ // showing all available pages in rotation if settings is A
             if($page_name=="I"){
                  if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="3";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="3";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="3";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="3";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="3";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="3";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="3";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents); 
            }
            }else if($page_name=="T"){
                 if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
              $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="3";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                } 
            }else{
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="3";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="3";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                } 
            }
            }else{
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="3";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="3";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                } 
            }else{
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="3";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="3";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                }  
            } }
            }else if($setting_value=="I"){ //if setting is I then show only icesheet
                  if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
              $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="3";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                } 
            }else{
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="3";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="3";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                } 
            }
            }else{
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="3";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="3";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                }  
            }else{
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="3";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="3";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                }    
                }
            }else if($setting_value == "T"){ // if setting is T show only tournament page alone
                  if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
              $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="3";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="3";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="3";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }
            }else{
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="3";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="3";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents); 
            }else{
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="3";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="3";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
              }
            }   
            }
      }

       if($package_type==4){ //tournament + icesheeet 6 lane
           $all_settings = $this->common_model->get_data('setting','*', array('user_id' => $user));
            $all_settings=$all_settings[0];
            if($setting_value==""){
               if($all_settings['url_status']== '1'  && $all_settings['calendar_status']== '1' ){
                
                if($_POST['calendar']=="1"){
                  $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="4";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
                }else{
                     $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="4";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
           } }elseif($all_settings['url_status']== '1'  && $all_settings['calendar_status']== '0' ){
                
                if($website=="yes"){
                   $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="4";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
                }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="4";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
           } }elseif($all_settings['url_status']== '0'  && $all_settings['calendar_status']== '1' ){
                
                if($_POST['calendar']=="1"){
                   $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="4";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                }else{
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="4";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
           } }
           }else{
            if($setting_value=="IT"){ // showing all available pages in rotation if settings is A
               if($page_name=="I"){
                  if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="4";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="4";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="4";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="4";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="4";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="4";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="4";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents); 
            }
            }else if($page_name=="T"){
                  if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="4";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
                }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="4";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="4";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
                }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="4";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="4";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
                }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="4";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="4";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middle', $this->gen_contents);
            }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
            }
            } }
            }else if($setting_value=="I"){ //if setting is I then show only icesheet
                if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="4";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
                }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="4";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="4";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
                }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="4";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="4";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
                }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="4";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="4";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
                }  
                }
            }else if($setting_value == "T"){ // if setting is T show only tournament page alone
                 if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="4";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="4";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="4";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="4";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="4";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="4";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="4";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
              }
                
            }
       }
      }
      
      
       if($package_type==10){ //tournament + icesheeet 8 lane
           $all_settings = $this->common_model->get_data('setting','*', array('user_id' => $user));
            $all_settings=$all_settings[0];
            if($setting_value==""){
               if($all_settings['url_status']== '1'  && $all_settings['calendar_status']== '1' ){
                
                if($_POST['calendar']=="1"){
                  $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="10";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
                }else{
                     $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="10";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
           } }elseif($all_settings['url_status']== '1'  && $all_settings['calendar_status']== '0' ){
                
                if($website=="yes"){
                   $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="10";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
                }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="10";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
           } }elseif($all_settings['url_status']== '0'  && $all_settings['calendar_status']== '1' ){
                
                if($_POST['calendar']=="1"){
                   $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="10";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                }else{
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="10";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
           } }
           }else{
            if($setting_value=="IT"){ // showing all available pages in rotation if settings is A
               if($page_name=="I"){
                  if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="10";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="10";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="10";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="10";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="10";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="10";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="10";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents); 
            }
            }else if($page_name=="T"){
                  if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="10";
                 $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
                
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="10";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="10";
               
                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
                
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="10";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="10";
               
                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
                
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="10";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="10";
                
                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
            
            } }
            }else if($setting_value=="I"){ //if setting is I then show only icesheet
                if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="10";
                
                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
                
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="10";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="10";
               
                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
                
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="10";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="10";
                
                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
               
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="10";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="10";
                
                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
                 
                }
            }else if($setting_value == "T"){ // if setting is T show only tournament page alone
                 if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="10";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="10";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="10";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="10";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="10";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="10";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="10";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
              }
                
            }
       }
      }
      //sanoj
      if($package_type==5){ //scoring + tournament + icesheeet 4 lane
         // die("sds");
             $all_settings = $this->common_model->get_data('setting','*', array('user_id' => $user));
            $all_settings=$all_settings[0];
           if($setting_value==""){
               if($all_settings['url_status']== '1'  && $all_settings['calendar_status']== '1' ){
                
                if($_POST['calendar']=="1"){
                  $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
                }else{
                     $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
           } }elseif($all_settings['url_status']== '1'  && $all_settings['calendar_status']== '0' ){
                
                if($website=="yes"){
                   $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
                }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
           } }elseif($all_settings['url_status']== '0'  && $all_settings['calendar_status']== '1' ){
                
                if($_POST['calendar']=="1"){
                   $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                }else{
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
           } }
           }else{
            if($setting_value=="ITS"){ // showing all available pages in rotation if settings is A
                if($page_name=="I"){
                if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
                // displaying website
                if($all_settings['url_status']== '1'){
                if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
            if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);  
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="5";;
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }
            }else if($page_name=="T"){
                
            if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
            if($all_settings['calendar_status']== '1'){
            // checking calendar status and showing it
            if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="5";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
            if($this->gen_contents['details'][0]['scoring_cat_id']==1){
            if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="5";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
            if($this->gen_contents['details'][0]['scoring_cat_id']==1){
            if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            } 
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="5";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
            if($this->gen_contents['details'][0]['scoring_cat_id']==1){
            if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="5";
                  
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
                }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
                }
                }
                }
            }else if($page_name=="S"){
                //checking for website and calendar
            if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                    //die("success");
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="5";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                } 
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="5";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                } 
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                    //die("success");
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="5";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                } 
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }
            else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="5";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                }  
                }
            }
            
    // checking setting value
            }else if($setting_value=="I"){ //if setting is I then show only icesheet
            if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                    //die("success");
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="5";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                }  
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="5";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                }  
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                    //die("success");
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="5";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                }   
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }
            else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="5";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                }    
                }
                
    // checking setting value            
            }else if($setting_value == "T"){ // if setting is T show only tournament page alone
                if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents); 
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents); 
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);   
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
              }
    // checking the setting value
            }else if($setting_value == "S"){ // if setting is S show only scoring page alone
                 if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="5";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            } 
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="5";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="5";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }  
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="5";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }   
            }
            
// checking the setiing value            
            }else if($setting_value == "IT"){
            if($page_name=="I"){
            if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents); 
            }
            }else if($page_name=="T"|| ($page_name=="S")){
                if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="5";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                } 
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="5";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                } 
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="5";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                } 
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="5";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                }  
            } }
            }else if($setting_value == "IS"){
            if($page_name=="I" ){
            if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="5";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="5";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="5";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="5";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
                }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }   
            }
            }elseif(($page_name == "S") || ($page_name=="T") ){
                if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="5";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                } 
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="5";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                } 
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="5";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                } 
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="5";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                }  
            }
            }
          
    // checking setting value        
            }else if($setting_value == "TS"){
                if($page_name=="T" ){
                     if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="5";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
                }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="5";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
                }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="5";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
                }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="5";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
                }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
        }
        }
        } 
        } else if(($page_name == "S") || ($page_name == "I")){
                  if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="5";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents); 
        }
        }
        }
      }
      }
      
      
    // package is six
      
        if($package_type==6){ //scoring + tournament + icesheeet 6 lane
          $all_settings = $this->common_model->get_data('setting','*', array('user_id' => $user));
            $all_settings=$all_settings[0];
           if($setting_value==""){
               if($all_settings['url_status']== '1'  && $all_settings['calendar_status']== '1' ){
                
                if($_POST['calendar']=="1"){
                  $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
                }else{
                     $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
           } }elseif($all_settings['url_status']== '1'  && $all_settings['calendar_status']== '0' ){
                
                if($website=="yes"){
                   $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
                }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
           } }elseif($all_settings['url_status']== '0'  && $all_settings['calendar_status']== '1' ){
                
                if($_POST['calendar']=="1"){
                   $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                }else{
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
           } }
           }else{
        if($setting_value=="ITS"){ // showing all available pages in rotation if settings is A
            if($page_name=="I"){
                if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
                // displaying website
                if($all_settings['url_status']== '1'){
                if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
            if($_POST['calendar']=="1"){
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents); 
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }
            }else if($page_name=="T"){
                 if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
            if($all_settings['calendar_status']== '1'){
            // checking calendar status and showing it
            if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="6";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
            if($this->gen_contents['details'][0]['scoring_cat_id']==1){
            if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="6";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
            if($this->gen_contents['details'][0]['scoring_cat_id']==1){
            if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="6";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
            if($this->gen_contents['details'][0]['scoring_cat_id']==1){
            if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="6";
                  
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
                }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
                }
                }
                }
            }else if($page_name=="S"){
                 //checking for website and calendar
            if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                    //die("success");
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="6";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middle', $this->gen_contents);
            }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="6";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middle', $this->gen_contents);
            }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="6";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middle', $this->gen_contents);
            }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
            } 
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }
           else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="6";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middle', $this->gen_contents);
            }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
                } 
                }
            }
            
    // checking setting value
            }else if($setting_value=="I"){ //if setting is I then show only icesheet
                  if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="6";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
                } 
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="6";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
                } 
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="6";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
                } 
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="6";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
                }  
                }
                
    // checking setting value            
            }else if($setting_value == "T"){ // if setting is T show only tournament page alone
                  if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);  
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
              }
    // checking the setting value
            }else if($setting_value == "S"){ // if setting is S show only scoring page alone
                 if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="6";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="6";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="6";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }  
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="6";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }   
            }
            
// checking the setiing value            
            }else if($setting_value == "IT"){
                if($page_name=="I"){
                    if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents); 
            }
            }else if($page_name=="T"|| ($page_name=="S")){
                 if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="6";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
                }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="6";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
                }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="6";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
                }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="6";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middle', $this->gen_contents);
            }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
            }
            } }
            }else if($setting_value == "IS"){
                if($page_name=="I" ){
                    if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                  $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="6";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="6";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="6";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="6";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
                }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }   
            }
            }elseif(($page_name == "S") || ($page_name=="T") ){
                if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="6";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="6";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="6";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="6";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                  $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middle', $this->gen_contents);
            }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                  $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
            }
            }
            }
          
    // checking setting value        
            }else if($setting_value == "TS"){
                if($page_name=="T" ){
                        if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="6";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
                }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="6";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
                }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="6";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
                }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="6";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
                }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
        }
        }
        } 
        } else if(($page_name == "S") || ($page_name == "I")){
              if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
              $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="6";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents); 
        }
        }
        }
      }
        }
        
//        if($package_type==11){ //scoring + tournament + icesheeet 8 lane
//          $all_settings = $this->common_model->get_data('setting','*', array('user_id' => $user));
//            $all_settings=$all_settings[0];
//           if($setting_value==""){
//               if($all_settings['url_status']== '1'  && $all_settings['calendar_status']== '1' ){
//                
//                if($_POST['calendar']=="1"){
//                  $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Tournament";
//                $this->gen_contents['page_name']="T";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/website_display', $this->gen_contents);
//                }else{
//                     $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Tournament";
//                $this->gen_contents['page_name']="T";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
//                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/calendar', $this->gen_contents);
//                
//           } }elseif($all_settings['url_status']== '1'  && $all_settings['calendar_status']== '0' ){
//                
//                if($website=="yes"){
//                   $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Tournament";
//                $this->gen_contents['page_name']="T";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/website_display', $this->gen_contents);
//                }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Tournament";
//                $this->gen_contents['page_name']="T";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/website_display', $this->gen_contents);
//           } }elseif($all_settings['url_status']== '0'  && $all_settings['calendar_status']== '1' ){
//                
//                if($_POST['calendar']=="1"){
//                   $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Tournament";
//                $this->gen_contents['page_name']="T";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
//                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/calendar', $this->gen_contents);
//                }else{
//                 $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Tournament";
//                $this->gen_contents['page_name']="T";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
//                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/calendar', $this->gen_contents);
//           } }
//           }else{
//        if($setting_value=="ITS"){ // showing all available pages in rotation if settings is A
//            if($page_name=="I"){
//                if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
//                // displaying website
//                if($all_settings['url_status']== '1'){
//                if($website=="yes"){
//                if($all_settings['calendar_status']== '1'){
//                // checking calendar status and showing it
//            if($_POST['calendar']=="1"){
//                 $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Tournament";
//                $this->gen_contents['page_name']="T";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('tournament/tournament_middle', $this->gen_contents);
//            }else{
//               $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Tournament";
//                $this->gen_contents['page_name']="T";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
//                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/calendar', $this->gen_contents);
//                
//            }}else{
//                 $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Tournament";
//                $this->gen_contents['page_name']="T";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('tournament/tournament_middle', $this->gen_contents); 
//            }
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Tournament";
//                $this->gen_contents['page_name']="T";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/website_display', $this->gen_contents);
//            }}elseif($all_settings['calendar_status']== '1'){
//                // checking calendar status and showing it
//                if($_POST['calendar']=="1"){
//                 $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Tournament";
//                $this->gen_contents['page_name']="T";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('tournament/tournament_middle', $this->gen_contents);
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Tournament";
//                $this->gen_contents['page_name']="T";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
//                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/calendar', $this->gen_contents);
//                
//            }}
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Tournament";
//                $this->gen_contents['page_name']="T";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('tournament/tournament_middle', $this->gen_contents);
//            }
//            }else if($page_name=="T"){
//                 if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
//            // displaying website
//            if($all_settings['url_status']== '1'){
//            if($website=="yes"){
//            if($all_settings['calendar_status']== '1'){
//            // checking calendar status and showing it
//            if($_POST['calendar']=="1"){
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Scoring";
//                $this->gen_contents['page_name']="S";
//                $this->gen_contents['package_type']="11";
//                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
//            if($this->gen_contents['details'][0]['scoring_cat_id']==1){
//            if($scoring_double_lane_status == 0){
//                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('scoring/scoring_middle', $this->gen_contents);
//            }else{ 
//                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
//            }
//            }
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Tournament";
//                $this->gen_contents['page_name']="T";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
//                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/calendar', $this->gen_contents);
//                
//            }}else{
//               $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Scoring";
//                $this->gen_contents['page_name']="S";
//                $this->gen_contents['package_type']="11";
//                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
//            if($this->gen_contents['details'][0]['scoring_cat_id']==1){
//            if($scoring_double_lane_status == 0){
//                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('scoring/scoring_middle', $this->gen_contents);
//            }else{ 
//                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
//            }
//            }
//            }
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Tournament";
//                $this->gen_contents['page_name']="T";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/website_display', $this->gen_contents);
//            }}elseif($all_settings['calendar_status']== '1'){
//                // checking calendar status and showing it
//                if($_POST['calendar']=="1"){
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Scoring";
//                $this->gen_contents['page_name']="S";
//                $this->gen_contents['package_type']="11";
//                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
//            if($this->gen_contents['details'][0]['scoring_cat_id']==1){
//            if($scoring_double_lane_status == 0){
//                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('scoring/scoring_middle', $this->gen_contents);
//            }else{ 
//                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
//            }
//            }
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Tournament";
//                $this->gen_contents['page_name']="T";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
//                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/calendar', $this->gen_contents);
//                
//            }}
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Scoring";
//                $this->gen_contents['page_name']="S";
//                $this->gen_contents['package_type']="11";
//                  
//                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
//                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
//                if($scoring_double_lane_status == 0){
//                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('scoring/scoring_middle', $this->gen_contents);
//                }else{ 
//                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
//                }
//                }
//                }
//            }else if($page_name=="S"){
//                 //checking for website and calendar
//            if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
//            // displaying website
//            if($all_settings['url_status']== '1'){
//            if($website=="yes"){
//                if($all_settings['calendar_status']== '1'){
//                // checking calendar status and showing it
//                if($_POST['calendar']=="1"){
//                    //die("success");
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Icesheets";
//                $this->gen_contents['page_name']="I";
//                $this->gen_contents['package_type']="11";
//                
//                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
//                $design_id=$this->gen_contents['user_details'][0]['design_id'];
//                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
//                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
//           
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Scoring";
//                $this->gen_contents['page_name']="S";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
//                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/calendar', $this->gen_contents);
//                
//            }}else{
//               $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Icesheets";
//                $this->gen_contents['page_name']="I";
//                $this->gen_contents['package_type']="11";
//                
//                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
//                $design_id=$this->gen_contents['user_details'][0]['design_id'];
//                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
//                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
//
//            }
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Scoring";
//                $this->gen_contents['page_name']="S";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/website_display', $this->gen_contents);
//            }}elseif($all_settings['calendar_status']== '1'){
//                // checking calendar status and showing it
//                if($_POST['calendar']=="1"){
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Icesheets";
//                $this->gen_contents['page_name']="I";
//                $this->gen_contents['package_type']="11";
//                
//                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
//                $design_id=$this->gen_contents['user_details'][0]['design_id'];
//                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
//                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
//            
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Scoring";
//                $this->gen_contents['page_name']="S";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
//                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/calendar', $this->gen_contents);
//                
//            }}
//            }
//           else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Icesheets";
//                $this->gen_contents['page_name']="I";
//                $this->gen_contents['package_type']="11";
//                
//                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
//                $design_id=$this->gen_contents['user_details'][0]['design_id'];
//                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
//                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
//            
//                }
//            }
//            
//    // checking setting value
//            }else if($setting_value=="I"){ //if setting is I then show only icesheet
//                  if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
//            // displaying website
//            if($all_settings['url_status']== '1'){
//            if($website=="yes"){
//                if($all_settings['calendar_status']== '1'){
//                // checking calendar status and showing it
//                if($_POST['calendar']=="1"){
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Ice sheet";
//                $this->gen_contents['page_name']="I";
//                $this->gen_contents['package_type']="11";
//                
//                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
//                $design_id=$this->gen_contents['user_details'][0]['design_id'];
//                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
//                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
//                 
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Ice sheet";
//                $this->gen_contents['page_name']="I";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
//                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/calendar', $this->gen_contents);
//                
//            }}else{
//               $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Ice sheet";
//                $this->gen_contents['page_name']="I";
//                $this->gen_contents['package_type']="11";
//                
//                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
//                $design_id=$this->gen_contents['user_details'][0]['design_id'];
//                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
//                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
//                
//            }
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Ice sheet";
//                $this->gen_contents['page_name']="I";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/website_display', $this->gen_contents);
//            }}elseif($all_settings['calendar_status']== '1'){
//                // checking calendar status and showing it
//                if($_POST['calendar']=="1"){
//               $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Ice sheet";
//                $this->gen_contents['page_name']="I";
//                $this->gen_contents['package_type']="11";
//               
//                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
//                $design_id=$this->gen_contents['user_details'][0]['design_id'];
//                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
//                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
//                 
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Ice sheet";
//                $this->gen_contents['page_name']="I";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
//                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/calendar', $this->gen_contents);
//                
//            }}
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Ice sheet";
//                $this->gen_contents['page_name']="I";
//                $this->gen_contents['package_type']="11";
//                
//                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
//                $design_id=$this->gen_contents['user_details'][0]['design_id'];
//                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
//                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
//                  
//                }
//                
//    // checking setting value            
//            }else if($setting_value == "T"){ // if setting is T show only tournament page alone
//                  if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
//            // displaying website
//            if($all_settings['url_status']== '1'){
//            if($website=="yes"){
//                if($all_settings['calendar_status']== '1'){
//                // checking calendar status and showing it
//                if($_POST['calendar']=="1"){
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Tournament";
//                $this->gen_contents['page_name']="T";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('tournament/tournament_middle', $this->gen_contents);
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Tournament";
//                $this->gen_contents['page_name']="T";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
//                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/calendar', $this->gen_contents);
//                
//            }}else{
//               $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Tournament";
//                $this->gen_contents['page_name']="T";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('tournament/tournament_middle', $this->gen_contents);
//            }
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Tournament";
//                $this->gen_contents['page_name']="T";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/website_display', $this->gen_contents);
//            }}elseif($all_settings['calendar_status']== '1'){
//                // checking calendar status and showing it
//                if($_POST['calendar']=="1"){
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Tournament";
//                $this->gen_contents['page_name']="T";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('tournament/tournament_middle', $this->gen_contents);  
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Tournament";
//                $this->gen_contents['page_name']="T";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
//                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/calendar', $this->gen_contents);
//                
//            }}
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Tournament";
//                $this->gen_contents['page_name']="T";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('tournament/tournament_middle', $this->gen_contents);
//              }
//    // checking the setting value
//            }else if($setting_value == "S"){ // if setting is S show only scoring page alone
//                 if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
//            // displaying website
//            if($all_settings['url_status']== '1'){
//            if($website=="yes"){
//                if($all_settings['calendar_status']== '1'){
//                // checking calendar status and showing it
//                if($_POST['calendar']=="1"){
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Scoring";
//                $this->gen_contents['page_name']="S";
//                $this->gen_contents['package_type']="11";
//                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
//                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
//                if($scoring_double_lane_status == 0){
//                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('scoring/scoring_middle', $this->gen_contents);
//            }else{ 
//                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
//            }
//            }
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Scoring";
//                $this->gen_contents['page_name']="S";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
//                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/calendar', $this->gen_contents);
//                
//            }}else{
//               $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Scoring";
//                $this->gen_contents['page_name']="S";
//                $this->gen_contents['package_type']="11";
//                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
//                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
//                if($scoring_double_lane_status == 0){
//                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('scoring/scoring_middle', $this->gen_contents);
//            }else{ 
//                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
//            }
//            }
//            }
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Scoring";
//                $this->gen_contents['page_name']="S";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/website_display', $this->gen_contents);
//            }}elseif($all_settings['calendar_status']== '1'){
//                // checking calendar status and showing it
//                if($_POST['calendar']=="1"){
//               $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Scoring";
//                $this->gen_contents['page_name']="S";
//                $this->gen_contents['package_type']="11";
//                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
//                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
//                if($scoring_double_lane_status == 0){
//                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('scoring/scoring_middle', $this->gen_contents);
//            }else{ 
//                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
//            }
//            }  
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Scoring";
//                $this->gen_contents['page_name']="S";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
//                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/calendar', $this->gen_contents);
//                
//            }}
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Scoring";
//                $this->gen_contents['page_name']="S";
//                $this->gen_contents['package_type']="11";
//                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
//                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
//                if($scoring_double_lane_status == 0){
//                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('scoring/scoring_middle', $this->gen_contents);
//            }else{ 
//                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
//            }
//            }   
//            }
//            
//// checking the setiing value            
//            }else if($setting_value == "IT"){
//                if($page_name=="I"){
//                    if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
//            // displaying website
//            if($all_settings['url_status']== '1'){
//            if($website=="yes"){
//                if($all_settings['calendar_status']== '1'){
//                // checking calendar status and showing it
//                if($_POST['calendar']=="1"){
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Tournament";
//                $this->gen_contents['page_name']="T";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('tournament/tournament_middle', $this->gen_contents);
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Icesheets";
//                $this->gen_contents['page_name']="I";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
//                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/calendar', $this->gen_contents);
//                
//            }}else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Tournament";
//                $this->gen_contents['page_name']="T";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('tournament/tournament_middle', $this->gen_contents);
//            }
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Icesheets";
//                $this->gen_contents['page_name']="I";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/website_display', $this->gen_contents);
//            }}elseif($all_settings['calendar_status']== '1'){
//                // checking calendar status and showing it
//                if($_POST['calendar']=="1"){
//               $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Tournament";
//                $this->gen_contents['page_name']="T";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('tournament/tournament_middle', $this->gen_contents);
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Icesheets";
//                $this->gen_contents['page_name']="I";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
//                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/calendar', $this->gen_contents);
//                
//            }}
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Tournament";
//                $this->gen_contents['page_name']="T";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('tournament/tournament_middle', $this->gen_contents); 
//            }
//            }else if($page_name=="T"|| ($page_name=="S")){
//                 if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
//            // displaying website
//            if($all_settings['url_status']== '1'){
//            if($website=="yes"){
//                if($all_settings['calendar_status']== '1'){
//                // checking calendar status and showing it
//                if($_POST['calendar']=="1"){
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Icesheets";
//                $this->gen_contents['page_name']="I";
//                $this->gen_contents['package_type']="11";
//                
//                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
//                $design_id=$this->gen_contents['user_details'][0]['design_id'];
//                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
//                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
//               
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Tournament";
//                $this->gen_contents['page_name']="T";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
//                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/calendar', $this->gen_contents);
//                
//            }}else{
//               $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Icesheets";
//                $this->gen_contents['page_name']="I";
//                $this->gen_contents['package_type']="11";
//
//                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
//                $design_id=$this->gen_contents['user_details'][0]['design_id'];
//                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
//                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
//              
//            }
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Tournament";
//                $this->gen_contents['page_name']="T";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/website_display', $this->gen_contents);
//            }}elseif($all_settings['calendar_status']== '1'){
//                // checking calendar status and showing it
//                if($_POST['calendar']=="1"){
//               $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Icesheets";
//                $this->gen_contents['page_name']="I";
//                $this->gen_contents['package_type']="11";
//                
//                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
//                $design_id=$this->gen_contents['user_details'][0]['design_id'];
//                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
//                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
//               
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Tournament";
//                $this->gen_contents['page_name']="T";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
//                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/calendar', $this->gen_contents);
//                
//            }}
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Icesheets";
//                $this->gen_contents['page_name']="I";
//                $this->gen_contents['package_type']="11";
//                
//                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
//                $design_id=$this->gen_contents['user_details'][0]['design_id'];
//                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
//                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
//            
//            } }
//            }else if($setting_value == "IS"){
//                if($page_name=="I" ){
//                    if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
//            // displaying website
//            if($all_settings['url_status']== '1'){
//            if($website=="yes"){
//                if($all_settings['calendar_status']== '1'){
//                // checking calendar status and showing it
//                if($_POST['calendar']=="1"){
//                  $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Scoring";
//                $this->gen_contents['page_name']="S";
//                $this->gen_contents['package_type']="11";
//                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
//                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
//                if($scoring_double_lane_status == 0){
//                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('scoring/scoring_middle', $this->gen_contents);
//            }else{ 
//                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
//            }
//            }
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Icesheets";
//                $this->gen_contents['page_name']="I";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
//                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/calendar', $this->gen_contents);
//                
//            }}else{
//                 $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Scoring";
//                $this->gen_contents['page_name']="S";
//                $this->gen_contents['package_type']="11";
//                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
//                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
//                if($scoring_double_lane_status == 0){
//                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('scoring/scoring_middle', $this->gen_contents);
//            }else{ 
//                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
//            }
//            }
//            }
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Icesheets";
//                $this->gen_contents['page_name']="I";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/website_display', $this->gen_contents);
//            }}elseif($all_settings['calendar_status']== '1'){
//                // checking calendar status and showing it
//                if($_POST['calendar']=="1"){
//                 $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Scoring";
//                $this->gen_contents['page_name']="S";
//                $this->gen_contents['package_type']="11";
//                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
//                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
//                if($scoring_double_lane_status == 0){
//                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('scoring/scoring_middle', $this->gen_contents);
//            }else{ 
//                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
//            }
//            }
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Icesheets";
//                $this->gen_contents['page_name']="I";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
//                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/calendar', $this->gen_contents);
//                
//            }}
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Scoring";
//                $this->gen_contents['page_name']="S";
//                $this->gen_contents['package_type']="11";
//                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
//                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
//                if($scoring_double_lane_status == 0){
//                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('scoring/scoring_middle', $this->gen_contents);
//                }else{ 
//                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
//            }
//            }   
//            }
//            }elseif(($page_name == "S") || ($page_name=="T") ){
//                if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
//            // displaying website
//            if($all_settings['url_status']== '1'){
//            if($website=="yes"){
//                if($all_settings['calendar_status']== '1'){
//                // checking calendar status and showing it
//                if($_POST['calendar']=="1"){
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Icesheets";
//                $this->gen_contents['page_name']="I";
//                $this->gen_contents['package_type']="11";
//               
//                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
//                $design_id=$this->gen_contents['user_details'][0]['design_id'];
//                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
//                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
//                
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Scoring";
//                $this->gen_contents['page_name']="S";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
//                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/calendar', $this->gen_contents);
//                
//            }}else{
//               $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Icesheets";
//                $this->gen_contents['page_name']="I";
//                $this->gen_contents['package_type']="11";
//                
//                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
//                $design_id=$this->gen_contents['user_details'][0]['design_id'];
//                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
//                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
//                
//            }
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Scoring";
//                $this->gen_contents['page_name']="S";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/website_display', $this->gen_contents);
//            }}elseif($all_settings['calendar_status']== '1'){
//                // checking calendar status and showing it
//                if($_POST['calendar']=="1"){
//               $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Icesheets";
//                $this->gen_contents['page_name']="I";
//                $this->gen_contents['package_type']="11";
//               
//                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
//                $design_id=$this->gen_contents['user_details'][0]['design_id'];
//                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
//                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
//                
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Scoring";
//                $this->gen_contents['page_name']="S";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
//                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/calendar', $this->gen_contents);
//                
//            }}
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Icesheets";
//                $this->gen_contents['page_name']="I";
//                $this->gen_contents['package_type']="11";
//                
//                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
//                  $design_id=$this->gen_contents['user_details'][0]['design_id'];
//                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
//                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
//            
//            }
//            }
//          
//    // checking setting value        
//            }else if($setting_value == "TS"){
//                if($page_name=="T" ){
//                        if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
//            // displaying website
//            if($all_settings['url_status']== '1'){
//            if($website=="yes"){
//                if($all_settings['calendar_status']== '1'){
//                // checking calendar status and showing it
//                if($_POST['calendar']=="1"){
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Scoring";
//                $this->gen_contents['page_name']="S";
//                $this->gen_contents['package_type']="11";
//                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
//                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
//                if($scoring_double_lane_status == 0){
//                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('scoring/scoring_middle', $this->gen_contents);
//                }else{ 
//                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
//            }
//            }
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Tournament";
//                $this->gen_contents['page_name']="T";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
//                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/calendar', $this->gen_contents);
//                
//            }}else{
//               $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Scoring";
//                $this->gen_contents['page_name']="S";
//                $this->gen_contents['package_type']="11";
//                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
//                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
//                if($scoring_double_lane_status == 0){
//                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('scoring/scoring_middle', $this->gen_contents);
//                }else{ 
//                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
//            }
//            }
//            }
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Tournament";
//                $this->gen_contents['page_name']="T";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/website_display', $this->gen_contents);
//            }}elseif($all_settings['calendar_status']== '1'){
//                // checking calendar status and showing it
//                if($_POST['calendar']=="1"){
//               $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Scoring";
//                $this->gen_contents['page_name']="S";
//                $this->gen_contents['package_type']="11";
//                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
//                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
//                if($scoring_double_lane_status == 0){
//                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('scoring/scoring_middle', $this->gen_contents);
//                }else{ 
//                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
//            }
//            }
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Tournament";
//                $this->gen_contents['page_name']="T";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
//                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/calendar', $this->gen_contents);
//                
//            }}
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Scoring";
//                $this->gen_contents['page_name']="S";
//                $this->gen_contents['package_type']="11";
//                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
//                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
//                if($scoring_double_lane_status == 0){
//                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('scoring/scoring_middle', $this->gen_contents);
//                }else{ 
//                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
//        }
//        }
//        } 
//        } else if(($page_name == "S") || ($page_name == "I")){
//              if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
//            // displaying website
//            if($all_settings['url_status']== '1'){
//            if($website=="yes"){
//                if($all_settings['calendar_status']== '1'){
//                // checking calendar status and showing it
//                if($_POST['calendar']=="1"){
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Tournament";
//                $this->gen_contents['page_name']="T";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('tournament/tournament_middle', $this->gen_contents);
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Scoring";
//                $this->gen_contents['page_name']="S";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
//                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/calendar', $this->gen_contents);
//                
//            }}else{
//               $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Tournament";
//                $this->gen_contents['page_name']="T";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('tournament/tournament_middle', $this->gen_contents);
//            }
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Scoring";
//                $this->gen_contents['page_name']="S";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/website_display', $this->gen_contents);
//            }}elseif($all_settings['calendar_status']== '1'){
//                // checking calendar status and showing it
//                if($_POST['calendar']=="1"){
//              $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Tournament";
//                $this->gen_contents['page_name']="T";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('tournament/tournament_middle', $this->gen_contents);
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Scoring";
//                $this->gen_contents['page_name']="S";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
//                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
//                $this->load->view('tournament/calendar', $this->gen_contents);
//                
//            }}
//            }else{
//                $this->gen_contents['user_id'] = $user;
//                $this->gen_contents['title']="Tournament";
//                $this->gen_contents['page_name']="T";
//                $this->gen_contents['package_type']="11";
//                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
//                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
//                $this->load->view('tournament/tournament_middle', $this->gen_contents); 
//        }
//        }
//        }
//      }
//        }
        if($package_type==11){ //scoring + tournament + icesheeet 8 lane
          $all_settings = $this->common_model->get_data('setting','*', array('user_id' => $user));
            $all_settings=$all_settings[0];
           if($setting_value==""){
               if($all_settings['url_status']== '1'  && $all_settings['calendar_status']== '1' ){
                
                if($_POST['calendar']=="1"){
                  $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
                }else{
                     $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
           } }elseif($all_settings['url_status']== '1'  && $all_settings['calendar_status']== '0' ){
                
                if($website=="yes"){
                   $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
                }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
           } }elseif($all_settings['url_status']== '0'  && $all_settings['calendar_status']== '1' ){
                
                if($_POST['calendar']=="1"){
                   $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                }else{
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
           } }
           }else{
        if($setting_value=="ITS"){ // showing all available pages in rotation if settings is A
            if($page_name=="I"){
                if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
                // displaying website
                if($all_settings['url_status']== '1'){
                if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
            if($_POST['calendar']=="1"){
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents); 
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }
            }else if($page_name=="T"){
                 if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
            if($all_settings['calendar_status']== '1'){
            // checking calendar status and showing it
            if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="11";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
            if($this->gen_contents['details'][0]['scoring_cat_id']==1){
            if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="11";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
            if($this->gen_contents['details'][0]['scoring_cat_id']==1){
            if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="11";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
            if($this->gen_contents['details'][0]['scoring_cat_id']==1){
            if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="11";
                  
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
                }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
                }
                }
                }
            }else if($page_name=="S"){
                 //checking for website and calendar
            if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                    //die("success");
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="11";
                
                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
           
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="11";
                
                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);

            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="11";
                
                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
            
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }
           else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="11";
                
                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
            
                }
            }
            
    // checking setting value
            }else if($setting_value=="I"){ //if setting is I then show only icesheet
                  if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="11";
                
                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
                 
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="11";
                
                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
                
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="11";
               
                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
                 
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="11";
                
                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
                  
                }
                
    // checking setting value            
            }else if($setting_value == "T"){ // if setting is T show only tournament page alone
                  if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);  
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
              }
    // checking the setting value
            }else if($setting_value == "S"){ // if setting is S show only scoring page alone
                 if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="11";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="11";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="11";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }  
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="11";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }   
            }
            
// checking the setiing value            
            }else if($setting_value == "IT"){
                if($page_name=="I"){
                    if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents); 
            }
            }else if($page_name=="T"|| ($page_name=="S")){
                 if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="11";
                
                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
               
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="11";

                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
              
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="11";
                
                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
               
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="11";
                
                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
            
            } }
            }else if($setting_value == "IS"){
                if($page_name=="I" ){
                    if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                  $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="11";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="11";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="11";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="11";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
                }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }   
            }
            }elseif(($page_name == "S") || ($page_name=="T") ){
                if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="11";
               
                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
                
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="11";
                
                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
                
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="11";
               
                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
                
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="11";
                
                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                  $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('eightlane/eightlane_middle', $this->gen_contents);
            
            }
            }
          
    // checking setting value        
            }else if($setting_value == "TS"){
                if($page_name=="T" ){
                        if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="11";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
                }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="11";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
                }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="11";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
                }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="11";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
                }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
        }
        }
        } 
        } else if(($page_name == "S") || ($page_name == "I")){
              if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
              $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="11";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents); 
        }
        }
        }
      }
        }
        if($package_type==7){ //scoring + tournament + icesheeet 4 lane - adv
            $all_settings = $this->common_model->get_data('setting','*', array('user_id' => $user));
            $all_settings=$all_settings[0];
            if($setting_value==""){
               if($all_settings['url_status']== '1'  && $all_settings['calendar_status']== '1' ){
                
                if($_POST['calendar']=="1"){
                  $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
                }else{
                     $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
           } }elseif($all_settings['url_status']== '1'  && $all_settings['calendar_status']== '0' ){
                
                if($website=="yes"){
                   $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
                }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
           } }elseif($all_settings['url_status']== '0'  && $all_settings['calendar_status']== '1' ){
                
                if($_POST['calendar']=="1"){
                   $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                }else{
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
           } }
           }else{
            if($setting_value=="ITS"){ // showing all available pages in rotation if settings is A
                if($page_name=="I"){
                if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
                // displaying website
                if($all_settings['url_status']== '1'){
                if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
            if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);  
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="7";;
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }
            }else if($page_name=="T"){
                
            if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
            if($all_settings['calendar_status']== '1'){
            // checking calendar status and showing it
            if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="7";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
            if($this->gen_contents['details'][0]['scoring_cat_id']==1){
            if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="7";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
            if($this->gen_contents['details'][0]['scoring_cat_id']==1){
            if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            } 
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="7";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
            if($this->gen_contents['details'][0]['scoring_cat_id']==1){
            if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="7";
                  
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
                }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
                }
                }
                }
            }else if($page_name=="S"){
                //checking for website and calendar
            if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                    //die("success");
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="7";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('fourlane/fourlane_adv_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                } 
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="7";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('fourlane/fourlane_adv_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                } 
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                    //die("success");
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="7";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('fourlane/fourlane_adv_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                } 
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }
            else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="7";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('fourlane/fourlane_adv_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                }  
                }
            }
            
    // checking setting value
            }else if($setting_value=="I"){ //if setting is I then show only icesheet
            if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                    //die("success");
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="7";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('fourlane/fourlane_adv_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                }  
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="7";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('fourlane/fourlane_adv_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                }  
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                    //die("success");
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="7";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('fourlane/fourlane_adv_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                }   
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }
            else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="7";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('fourlane/fourlane_adv_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                }    
                }
                
    // checking setting value            
            }else if($setting_value == "T"){ // if setting is T show only tournament page alone
                if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents); 
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents); 
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);   
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
              }
    // checking the setting value
            }else if($setting_value == "S"){ // if setting is S show only scoring page alone
                 if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="7";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            } 
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="7";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="7";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }  
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="7";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }   
            }
            
// checking the setiing value            
            }else if($setting_value == "IT"){
            if($page_name=="I"){
            if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents); 
            }
            }else if($page_name=="T"|| ($page_name=="S")){
                if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="7";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('fourlane/fourlane_adv_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                } 
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="7";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('fourlane/fourlane_adv_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                } 
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="7";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('fourlane/fourlane_adv_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                } 
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="7";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('fourlane/fourlane_adv_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                }  
            } }
            }else if($setting_value == "IS"){
            if($page_name=="I" ){
            if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="7";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="7";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="7";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="7";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
                }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }   
            }
            }elseif(($page_name == "S") || ($page_name=="T") ){
                if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="7";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('fourlane/fourlane_adv_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                } 
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="7";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('fourlane/fourlane_adv_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                } 
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="7";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('fourlane/fourlane_adv_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                } 
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="7";
                $double_lane_status = $this->gen_contents['details'][0]['fourlane_double_status'];
                if($double_lane_status == 0){  
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('fourlane/fourlane_adv_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('four_lanes_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('fourlane/fourlane_middledouble', $this->gen_contents);  
                }  
            }
            }
          
    // checking setting value        
            }else if($setting_value == "TS"){
                if($page_name=="T" ){
                     if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="7";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
                }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="7";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
                }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="7";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
                }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="7";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
                }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
        }
        }
        } 
        } else if(($page_name == "S") || ($page_name == "I")){
                  if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="7";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents); 
        }
        }
        }
      }
      }
      
      
    // package is six
      
        if($package_type==8){ //scoring + tournament + icesheeet 6 lane - adv  
          $all_settings = $this->common_model->get_data('setting','*', array('user_id' => $user));
            $all_settings=$all_settings[0];
           if($setting_value==""){
               if($all_settings['url_status']== '1'  && $all_settings['calendar_status']== '1' ){
                
                if($_POST['calendar']=="1"){
                  $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
                }else{
                     $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
           } }elseif($all_settings['url_status']== '1'  && $all_settings['calendar_status']== '0' ){
                
                if($website=="yes"){
                   $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
                }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
           } }elseif($all_settings['url_status']== '0'  && $all_settings['calendar_status']== '1' ){
                
                if($_POST['calendar']=="1"){
                   $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                }else{
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
           } }
           }else{
        if($setting_value=="ITS"){ // showing all available pages in rotation if settings is A
            if($page_name=="I"){
                if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
                // displaying website
                if($all_settings['url_status']== '1'){
                if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
            if($_POST['calendar']=="1"){
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents); 
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }
            }else if($page_name=="T"){
                 if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
            if($all_settings['calendar_status']== '1'){
            // checking calendar status and showing it
            if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="8";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
            if($this->gen_contents['details'][0]['scoring_cat_id']==1){
            if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="8";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
            if($this->gen_contents['details'][0]['scoring_cat_id']==1){
            if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="8";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
            if($this->gen_contents['details'][0]['scoring_cat_id']==1){
            if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="8";
                  
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
                }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
                }
                }
                }
            }else if($page_name=="S"){
                 //checking for website and calendar
            if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                    //die("success");
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="8";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('sixlane/sixlane_adv_middle', $this->gen_contents);
            }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="8";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('sixlane/sixlane_adv_middle', $this->gen_contents);
            }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="8";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('sixlane/sixlane_adv_middle', $this->gen_contents);
            }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
            } 
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }
           else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="8";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('sixlane/sixlane_adv_middle', $this->gen_contents);
            }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
                } 
                }
            }
            
    // checking setting value
            }else if($setting_value=="I"){ //if setting is I then show only icesheet
                  if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="8";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('sixlane/sixlane_adv_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
                } 
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="8";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('sixlane/sixlane_adv_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
                } 
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="8";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('sixlane/sixlane_adv_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
                } 
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="8";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('sixlane/sixlane_adv_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
                }  
                }
                
    // checking setting value            
            }else if($setting_value == "T"){ // if setting is T show only tournament page alone
                  if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);  
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
              }
    // checking the setting value
            }else if($setting_value == "S"){ // if setting is S show only scoring page alone
                 if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="8";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="8";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="8";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }  
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="8";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }   
            }
            
// checking the setiing value            
            }else if($setting_value == "IT"){
                if($page_name=="I"){
                    if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents); 
            }
            }else if($page_name=="T"|| ($page_name=="S")){
                 if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="8";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('sixlane/sixlane_adv_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
                }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="8";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('sixlane/sixlane_adv_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
                }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="8";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('sixlane/sixlane_adv_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
                }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="8";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('sixlane/sixlane_adv_middle', $this->gen_contents);
            }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
            }
            } }
            }else if($setting_value == "IS"){
                if($page_name=="I" ){
                    if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                  $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="8";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="8";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="8";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="8";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
                }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }   
            }
            }elseif(($page_name == "S") || ($page_name=="T") ){
                if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="8";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('sixlane/sixlane_adv_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="8";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('sixlane/sixlane_adv_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="8";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('sixlane/sixlane_adv_middle', $this->gen_contents);
                }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="8";
                $double_lane_status = $this->gen_contents['details'][0]['sixlane_double_status'];
                if($double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                  $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('sixlane/sixlane_adv_middle', $this->gen_contents);
            }else{
                $this->gen_contents['list_all'] = $this->common_model->get_data('six_lane_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                  $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->load->view('sixlane/sixlane_middledouble', $this->gen_contents);  
            }
            }
            }
          
    // checking setting value        
            }else if($setting_value == "TS"){
                if($page_name=="T" ){
                        if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="8";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
                }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="8";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
                }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="8";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
                }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="8";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
                }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
        }
        }
        } 
        } else if(($page_name == "S") || ($page_name == "I")){
              if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
              $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="8";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents); 
        }
        }
        }
      }
        }
      if($package_type==12){ //scoring + tournament + icesheeet 8 lane - adv  
          $all_settings = $this->common_model->get_data('setting','*', array('user_id' => $user));
            $all_settings=$all_settings[0];
           if($setting_value==""){
               if($all_settings['url_status']== '1'  && $all_settings['calendar_status']== '1' ){
                
                if($_POST['calendar']=="1"){
                  $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
                }else{
                     $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
           } }elseif($all_settings['url_status']== '1'  && $all_settings['calendar_status']== '0' ){
                
                if($website=="yes"){
                   $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
                }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
           } }elseif($all_settings['url_status']== '0'  && $all_settings['calendar_status']== '1' ){
                
                if($_POST['calendar']=="1"){
                   $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                }else{
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
           } }
           }else{
        if($setting_value=="ITS"){ // showing all available pages in rotation if settings is A
            if($page_name=="I"){
                if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
                // displaying website
                if($all_settings['url_status']== '1'){
                if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
            if($_POST['calendar']=="1"){
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents); 
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }
            }else if($page_name=="T"){
                 if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
            if($all_settings['calendar_status']== '1'){
            // checking calendar status and showing it
            if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="12";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
            if($this->gen_contents['details'][0]['scoring_cat_id']==1){
            if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="12";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
            if($this->gen_contents['details'][0]['scoring_cat_id']==1){
            if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="12";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
            if($this->gen_contents['details'][0]['scoring_cat_id']==1){
            if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="12";
                  
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
                }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
                }
                }
                }
            }else if($page_name=="S"){
                 //checking for website and calendar
            if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                    //die("success");
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('eightlane/eightlane_adv_middle', $this->gen_contents);
            
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('eightlane/eightlane_adv_middle', $this->gen_contents);
           
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('eightlane/eightlane_adv_middle', $this->gen_contents);
            
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }
           else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('eightlane/eightlane_adv_middle', $this->gen_contents);
           
                }
            }
            
    // checking setting value
            }else if($setting_value=="I"){ //if setting is I then show only icesheet
                  if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('eightlane/eightlane_adv_middle', $this->gen_contents);
               
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('eightlane/eightlane_adv_middle', $this->gen_contents);
                
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('eightlane/eightlane_adv_middle', $this->gen_contents);
                
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Ice sheet";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('eightlane/eightlane_adv_middle', $this->gen_contents);
                 
                }
                
    // checking setting value            
            }else if($setting_value == "T"){ // if setting is T show only tournament page alone
                  if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);  
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
              }
    // checking the setting value
            }else if($setting_value == "S"){ // if setting is S show only scoring page alone
                 if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="12";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="12";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="12";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }  
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="12";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }   
            }
            
// checking the setiing value            
            }else if($setting_value == "IT"){
                if($page_name=="I"){
                    if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents); 
            }
            }else if($page_name=="T"|| ($page_name=="S")){
                 if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('eightlane/eightlane_adv_middle', $this->gen_contents);
                
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('eightlane/eightlane_adv_middle', $this->gen_contents);
                
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('eightlane/eightlane_adv_middle', $this->gen_contents);
                
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('eightlane/eightlane_adv_middle', $this->gen_contents);
            
            } }
            }else if($setting_value == "IS"){
                if($page_name=="I" ){
                    if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                  $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="12";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="12";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                 $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="12";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
            }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="12";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
                }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }   
            }
            }elseif(($page_name == "S") || ($page_name=="T") ){
                if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('eightlane/eightlane_adv_middle', $this->gen_contents);
              
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('eightlane/eightlane_adv_middle', $this->gen_contents);

            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('eightlane/eightlane_adv_middle', $this->gen_contents);
                
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Icesheets";
                $this->gen_contents['page_name']="I";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_data('eight_lane','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['user_details'] = $this->common_model->get_data('user','*', array('id' => $user));
                  $design_id=$this->gen_contents['user_details'][0]['design_id'];
                $this->gen_contents['design_details'] = $this->common_model->get_data('design','*', array('design_id' => $design_id));
                $this->gen_contents['slider_details'] = $this->common_model->get_data('slider','*', array('user_id' => $user));
                $this->load->view('eightlane/eightlane_adv_middle', $this->gen_contents);
            
            }
            }
          
    // checking setting value        
            }else if($setting_value == "TS"){
                if($page_name=="T" ){
                        if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="12";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
                }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="12";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
                }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="12";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
                }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
            }
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="12";
                $scoring_double_lane_status = $this->gen_contents['details'][0]['scoring_double_status'];
                if($this->gen_contents['details'][0]['scoring_cat_id']==1){
                if($scoring_double_lane_status == 0){
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middle', $this->gen_contents);
                }else{ 
                $this->gen_contents['list_all'] = $this->common_model->get_data('scoring_double','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('scoring/scoring_middledouble', $this->gen_contents);
        }
        }
        } 
        } else if(($page_name == "S") || ($page_name == "I")){
              if(($all_settings['url_status']== '1')||($all_settings['calendar_status']== '1')){
            // displaying website
            if($all_settings['url_status']== '1'){
            if($website=="yes"){
                if($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}else{
               $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['website'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/website_display', $this->gen_contents);
            }}elseif($all_settings['calendar_status']== '1'){
                // checking calendar status and showing it
                if($_POST['calendar']=="1"){
              $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents);
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Scoring";
                $this->gen_contents['page_name']="S";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_calendar($user,$this->gen_contents['details'][0]['package']);
                $this->gen_contents['status'] = $this->common_model->get_data('setting','*', array('user_id' => $user));
                $this->load->view('tournament/calendar', $this->gen_contents);
                
            }}
            }else{
                $this->gen_contents['user_id'] = $user;
                $this->gen_contents['title']="Tournament";
                $this->gen_contents['page_name']="T";
                $this->gen_contents['package_type']="12";
                $this->gen_contents['list_all'] = $this->common_model->get_data('tournament','*', array('user_id' => $user,'status'=>1 ));
                $this->gen_contents['all_data']= @$this->gen_contents['list_all'][0]['all_data'];
                $this->load->view('tournament/tournament_middle', $this->gen_contents); 
        }
        }
        }
      }
        }
    
       
      }

    function update_ajax_scroll(){


        $user=$_POST['userid'];
       $this->gen_contents['user_id'] = $user;
       $all_data=array();
      $this->gen_contents['scroll_news'] = $this->common_model->get_data('scroll_news','*', array('user_id' => $user,'status'=>1 ));
      
      
      if(!empty($this->gen_contents['scroll_news'])){

        $user_id=$this->gen_contents['scroll_news'][0]['user_id'];
        $data_update=array(
        'status'=>1
        );
       $this->db->where('user_id',$user_id);
       $this->db->update('scroll_news', $data_update);

       
       if($this->gen_contents['scroll_news'][0]['news'] != ""){
           echo $this->gen_contents['scroll_news'][0]['news'];
       }else{
           echo 1;
       }
       die();
      
       
       }else{

        echo '0';
        die();
      }


         
       //$this->load->view('fourlane/fourlane_ajax_lane', $this->gen_contents);
     
    }
   
    
 
 	function page_not_found(){
            header('HTTP/1.0 404 Not Found');
           $this->load->view('fourlane/fourlane_header', $this->gen_contents);
        $this->load->view('fourlane/fourlane_middle', $this->gen_contents);
        $this->load->view('fourlane/fourlane_footer', $this->gen_contents);
        }
       
         
       
}
