<?php
/**
 * CodeIgniter
 *
 * An open source application development framework for PHP
 *
 * This content is released under the MIT License (MIT)
 *
 * Copyright (c) 2014 - 2015, British Columbia Institute of Technology
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * @package CodeIgniter
 * @author  EllisLab Dev Team
 * @copyright Copyright (c) 2008 - 2014, EllisLab, Inc. (http://ellislab.com/)
 * @copyright Copyright (c) 2014 - 2015, British Columbia Institute of Technology (http://bcit.ca/)
 * @license http://opensource.org/licenses/MIT  MIT License
 * @link  http://codeigniter.com
 * @since Version 1.0.0
 * @filesource
 */
defined('BASEPATH') OR exit('No direct script access allowed');
class Six_lane extends CI_Controller {
  var $gen_contents = array();
   
   function index(){
        $this->customers();

   }
   
   public function sixlane_list() {

      (!$this->authentication->check_logged_in("admin", false)) ? redirect('admin/sales/my_customers') : '';
    if(!admin_has_permission(9)){

      redirect('admin/dashboard');
    }

     $id=s('ADMIN_USERID');
     
     $where_user=array(
                'id' =>$id
        );
        
     $this->gen_contents['get_user_data'] = $this->common_model->get_data('user', '*', $where_user);
     
     /*if($this->gen_contents['get_user_data'][0]['sixlane_double_status'] == 1){
         $where=array(
             'user_id' =>$id,
             'status' =>1
            );
            $this->gen_contents['sixlane'] = $this->common_model->get_data('six_lane_double', '*', $where);
            $cid = @$this->gen_contents['sixlane'][0]['dlane_id'];
            redirect('admin/six_lane/edit_sixlane_double/?cid='.$cid);
         
         
     
     }else{ 
            $where=array(
             'user_id' =>$id,
             'status' =>1
            );
            $this->gen_contents['sixlane'] = $this->common_model->get_data('six_lane', '*', $where);
            
            //p($where); die();
            $cid = @$this->gen_contents['sixlane'][0]['lane_id'];
            redirect('admin/six_lane/edit_sixlane/?cid='.$cid);
            
     }   */     
            
            


     $id = $this->input->get('cid', true);
        if($id != ''){
            $this->db->where('lane_id', $id);
            $sts=$this->db->delete('six_lane'); 
            if($sts){
                        $first_groupname_1      = $this->input->post("txtg11", true); 
                     
                       
                          sf('success_message', "Six lane has been deleted.");
                       }else{
                          sf('error_message', 'Error! There is an issue with deletion. Please try again later.');
                       }
                       redirect('admin/six_lane/sixlane_list');
           
        }
    $this->gen_contents['script_load_page'] = 'users';
        $this->gen_contents['js_files'] = array('global/plugins/datatables/media/js/jquery.dataTables.min.js', 
        'global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js',
        'global/plugins/jquery-validation/js/jquery.validate.min.js', 'global/scripts/datatable.js',
    'global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js',
        'admin/layout/scripts/six_lane.js');
        $this->template->set_template('admin');
        
    $lnk = 'Six lane/create Six lane';
    $lbl = 'Six lane';
    $this->gen_contents['active_main_menu'] = array('Manage Six lane', 'customers');
    
        $this->gen_contents['page_heading'] = 'Icesheets Manager';
        //$this->gen_contents['sales_type'] = '2';
        //$this->gen_contents['page_breadcrumb'] = array(array('link' => '#', 'label' => 'Manage Six lane'), array('link' => $lnk, 'label' => $lbl));
        $this->gen_contents['js_script_initial'] = "Six_lane.init();";
        //$this->gen_contents['customers_list'] = $this->common_model->get_data('packages','package_id','package_code','package_name','package_registered_time','1package_last_updated_time', array('package_status' => '1' ));
        $this->template->write_view('content', 'admin/six_lane/six_lane_list', $this->gen_contents);
        $this->template->render();
   }



   
   function list_sixlane($type = 1){ // 1 = my customers 
        //die("test");

  
    if (!$this->authentication->check_logged_in("admin", false) ) { // If there is no login exists just return the error

            $iTotalRecords = 1;
            $iDisplayLength = 1;
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = 0;
            $sEcho = 0;

            $records = array();
            $records["data"] = array();

            $end = 1;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;

            $status_list = array(
                array("success" => "Pending"),
                array("info" => "Closed"),
                array("danger" => "On Hold"),
                array("warning" => "Fraud")
            );

            for ($i = $iDisplayStart; $i < $end; $i++) {
                $status = $status_list[rand(0, 2)];
                $id = ($i + 1);
                $records["data"][] = array(
                    '<script>window.location=\'' . admin_url() . 'login\'</script>',
                    '', '', '', '', '', '', '', '',
                );
            }

            if ($this->input->post('customActionType') && $this->input->post('customActionType') == 'group_action') {
                $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
                $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
            }

            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;
            $this->load->view('ajax_view', array('ajax_response' => json_encode($records)));
            return;
        }
        else {
            
            $this->load->model('admin/sixlane_model');
            $list_six_lane = array();
            $like_search = array();
            $where = array();
      
      
      
      if($this->input->post('name', true)){
        $like_search['f.lane_name'] = $this->db->escape_like_str($this->input->post('name', true));
      }
      if($this->input->post('scheduled_date', true)){
				$like_search['f.scheduled_date'] = $this->db->escape_like_str($this->input->post('scheduled_date', true));
			}
                        if($this->input->post('scheduled_time', true)){
				$like_search['f.scheduled_time'] = $this->db->escape_like_str($this->input->post('scheduled_time', true));
			}
            
          $domain_id = s('ADMIN_USERID');
      $where = array('f.user_id' => $domain_id );
      
           
            $iTotalRecords = $this->sixlane_model->list_sixlane_count($where, $like_search);
            //$iTotalRecords = 6;
            $iDisplayLength = intval($this->input->post('length'));
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = intval($this->input->post('start'));
            $sEcho = intval($this->input->post('draw'));

            $records = array();
            $records["data"] = array();

            $end = $iDisplayStart + $iDisplayLength;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;
            //die("test");
      if($iTotalRecords > 0){

              $list_sixlane = $this->sixlane_model->list_sixlane($iDisplayStart, $end, $where, $like_search);
             // echo "<pre>";
              //print_r($list_sixlane);
              //die();


      }
            $id = $iDisplayStart;

            for ($i = 0; $i < count($list_sixlane); $i++) {

                $id++;
                $status = '';
                $status_css = '';
                $q_id = $list_sixlane[$i]['lane_id'];
                $time = strtotime($list_sixlane[$i]['scheduled_time']);
                 $time_now=date("g:i A",$time);;
                $actn_buttons = '';
          
        $actn_buttons .= '<a href="' . admin_url() . 'six_lane/edit_sixlane/?cid='.$q_id.'" title="Edit six lane" class="btn btn-icon-only green margin-bottom-5"><i class="glyphicon glyphicon-edit"></i></a>' ;
        //$actn_buttons .= '<a href="' . admin_url() . 'six_lane/sixlane_list/?cid='.$q_id.'" title="delete six lane" class="btn btn-icon-only red margin-bottom-5"><i class="fa fa-times"></i></span>';
        $actn_buttons .= '<span class="btn btn-icon-only red delete-this-record margin-bottom-5" id="delete_six" data-id="' . $q_id . '" title="Delete"><i class="fa fa-times"></i></span>';
        $list_array =  array(
                    $id, 
                   // $list_users[$i]['id'],
                     $list_sixlane[$i]['lane_name'],
                   $list_sixlane[$i]['scheduled_date'],
                    $time_now,
                    $actn_buttons
                );
        
                $records["data"][] = $list_array;
            }
            if ($this->input->post('customActionType') && $this->input->post('customActionType') == 'group_action') {
                $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
                $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
            }

            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;

            $this->load->view('ajax_view', array('ajax_response' => json_encode($records)));
            return;
      }
   }
   
  function my_customers(){
    (!$this->authentication->check_logged_in("admin", false)) ? redirect('admin') : '';
    if(!admin_has_permission(11)){
      redirect('admin/dashboard');
    }
    $this->gen_contents['script_load_page'] = 'users';
        $this->gen_contents['js_files'] = array('global/plugins/datatables/media/js/jquery.dataTables.min.js', 
        'global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js',
        'global/plugins/jquery-validation/js/jquery.validate.min.js', 'global/scripts/datatable.js',
    'global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js',
        'admin/layout/scripts/sales.js');
        $this->template->set_template('admin');
        
    $lnk = 'sales/my_customers';
    $lbl = 'My Customers';
    $this->gen_contents['active_main_menu'] = array('sales_department', 'my_customers');
    
         $this->gen_contents['page_heading'] = 'Order Management - '.$lbl;
          $this->gen_contents['sales_type'] = '1';
        $this->gen_contents['page_breadcrumb'] = array(array('link' => '#', 'label' => 'Sales Department'), array('link' => $lnk, 'label' => $lbl));
        $this->gen_contents['js_script_initial'] = "Sales.init();";
        $this->template->write_view('content', 'admin/sales/customers_list', $this->gen_contents);
        $this->template->render();
   }
   
   function add_sixlane(){

        //$a=s();
        //print_r($a);
        //die("test");

    (!$this->authentication->check_logged_in("admin", false)) ? redirect('admin') : '';
    if(!admin_has_permission(9)){
      redirect('admin/dashboard');
    }
    if (!empty($_POST)) {

                $user_id= s('ADMIN_USERID');

                $data = array(
                    'lane_name'      => $this->input->post("name", true), 
                    'user_id'                =>$user_id
                        
                       );
                        $this->db->insert('six_lane_double', $data);
                       $this->db->insert('six_lane', $data);
                       $insert_id = $this->db->insert_id();
                       
                       if($insert_id > 0){
                        
                          sf('success_message', "Six lane added successfully.");
                       }else{
                          sf('error_message', 'Error! There is an issue with adding Six lane. Please try again later.');
                       }
                       redirect('admin/six_lane/add_sixlane');
               
    }
    
    $this->gen_contents['script_load_page'] = 'users';
        $this->gen_contents['js_files'] = array('global/plugins/datatables/media/js/jquery.dataTables.min.js', 
        'global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js',
        'global/plugins/jquery-validation/js/jquery.validate.min.js', 'global/scripts/datatable.js',
    'global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js',
        'admin/layout/scripts/six_lane.js');
        $this->template->set_template('admin');
        
    $lnk = 'Six lane/create Six lane';
    $lbl = 'Create New Six lane';
    $this->gen_contents['active_main_menu'] = array('Manage Six lane', 'customers');
    
         $this->gen_contents['page_heading'] = 'Manage Six lane - '.$lbl;
        $logo=s('logo');
        if($logo == 1){
                $logo=1;
        }else{
            $logo=0;
        }
         $this->gen_contents['access'] = $logo;
        //$this->gen_contents['page_breadcrumb'] = array(array('link' => '#', 'label' => 'Manage Six lane'), array('link' => $lnk, 'label' => $lbl));
        $this->gen_contents['js_script_initial'] = "six_lane.init();";
        $this->template->write_view('content', 'admin/six_lane/add_six_lane', $this->gen_contents);
        $this->template->render();
   }


function delete_img1($id,$field,$name){
            $this->load->helper("image_helper");
            $user_id=s('ADMIN_USERID');
             $image=c('file_upload_path').'admin/'.$name;
             $image1=c('file_upload_path').'admin/thumb_large_'.$name;
             $image2=c('file_upload_path').'admin/thumb_medium_'.$name;
             $image3=c('file_upload_path').'admin/thumb_thumb_'.$name;

            //die("tes");
            if(file_exists($image)){
            $delete=unlink($image);
            }
            if(file_exists($image1)){
            $delete1=unlink($image1);
            }
            if(file_exists($image2)){
            $delete2=unlink($image2);
            }
            if(file_exists($image3)){
            $delete3=unlink($image3);
            }
              $data_update=array(
                            $field => ''
                            );
            
              
            $this->db->where('user_id',$user_id);
            $update=  $this->db->update('six_lane', $data_update);

            if($update){
                        
                            sf('success_message', "Logo deleted successfully.");
                       }else{
                            sf('error_message', 'Error! There is an issue with deleting four lane logo. Please try again later.');
                       }
                   
        //         $this->gen_contents['form_validation_error'] = validation_errors();
               
        redirect('admin/six_lane/view_image');
  
     }


   
   function edit_sixlane(){
        if(!admin_has_permission(9)){
      redirect('admin/dashboard');
    }
    (!$this->authentication->check_logged_in("admin", false)) ? redirect('admin') : '';
    $id = $this->input->get('cid', true);
    
     
        $where = array('lane_id' => $id);
        
        $userid = s('ADMIN_USERID');
        $where_user=array(
                'id' =>$userid
        );
             
        
         $type=$this->input->get('type', true);
                if($type == 'reset')
                {
                  $data = array(
               		'first_groupname_1'      => '', 
                        'first_groupname_2'      => '',
                        'second_groupname_1'     => '', 
                        'second_groupname_2'     => '',
                        'third_groupname_1'      => '', 
                        'third_groupname_2'      => '',
                        'fourth_groupname_1'     => '', 
                        'fourth_groupname_2'     => '',
                        'fifth_groupname_1'      => '', 
                        'fifth_groupname_2'       => '',
                        'sixth_groupname_1'      => '', 
                        'sixth_groupname_2'       => '',
                        'hr'                      => '',
                        'min'                      =>''
                        
                        
                       );
               
                     $sts = $this->db->update('six_lane', $data, $where);
                      
                       
                       if($sts){
                        $first_groupname_1      = $this->input->post("txtg11", true); 
                     
                       
                          sf('success_message', "Six lane has been updated.");
                       }else{
                          sf('error_message', 'Error! There is an issue with update. Please try again later.');
                       }
                       redirect('admin/six_lane/edit_sixlane/?cid='.$id);
                }
        
        
        if (!empty($_POST)) {
            
            
        $update_type = array(
                    'sixlane_double_status' => $this->input->post('typestatus')
                );
                $this->db->update('user', $update_type, $where_user);      
           $time = strtotime($this->input->post("scheduled_time", true));
             $time_now=date("H:i:s",$time);
             $time = strtotime($this->input->post("scheduled_time", true));
                $time_now=date("H:i:s",$time);
                $time1= date("H",$time);
                $time2= date("i",$time);
                 $recurring_status = $this->input->post("recurring", true);
                 $user_id= s('ADMIN_USERID');
                 $lan_details = $this->common_model->get_data('six_lane', '*', $where);
                if($recurring_status == ''){
                  $day_number = 0;
                   $Start_daterange = '';
                   $End_daterange = '';
                    $this->db->where('recurring_master_id', $id);
                    $this->db->delete('six_lane'); 
                }else{
                //  p($this->input->post()); die("a");
                   $lan_details_recurring_day = $lan_details[0]['recurring_day'];
                   $lan_details_scheduled_time = $lan_details[0]['scheduled_time'];
                   $lan_details_color = $lan_details[0]['color'];
                   $lan_details_recurring_start_date =  date('Y-m-d',strtotime($lan_details[0]['recurring_start_date']));
                   $lan_details_recurring_end_date =  date('Y-m-d',strtotime($lan_details[0]['recurring_end_date']));
                    $day_number = $this->input->post('week_day');
                    $scheduled_time = $this->input->post('scheduled_time');
                    $date_range = $this->input->post('recurring_daterange');
                    $explode_daterange = explode(" - ",$date_range);
                    $Start_daterange=  date('Y-m-d',strtotime($explode_daterange[0]));
                    $End_daterange=  date('Y-m-d',strtotime($explode_daterange[1]));
                    $color_data = array(
                        'color'   => $this->input->post("color", true),
                        'sync_calendar' => $this->input->post("sync_calendar", true)
                       );
                         $this->db->where('recurring_master_id', $id);
                         $this->db->update('six_lane', $color_data);
                    if(($lan_details_recurring_day != $day_number) || ($lan_details_scheduled_time != $scheduled_time)  || ($lan_details_recurring_start_date != $Start_daterange) || ($lan_details_recurring_end_date != $End_daterange)){
                     $this->db->where('recurring_master_id', $id);
                     $this->db->where('scheduled_date <', $Start_daterange);
                    $this->db->delete('six_lane');
                    $this->db->where('recurring_master_id', $id);
                     $this->db->where('scheduled_date >', $End_daterange);
                    $this->db->delete('six_lane');
                    if($lan_details_recurring_day != $day_number){
                          $this->db->where('recurring_master_id', $id);
                            $this->db->delete('six_lane');
                    }
                     if($lan_details_scheduled_time != $scheduled_time){
                       $time_data = array(
                        'hr'                      =>$time1,
                        'min'                      =>$time2,
                          'scheduled_time'          =>$time_now
                       );
                         $this->db->where('recurring_master_id', $id);
                         $this->db->update('six_lane', $time_data);
                    }
                    $insert = $this->add_recurring_schedule($_POST,$id,$lan_details_color);
                    }
                }
                
         $data = array(
                        'lane_name'               =>$this->input->post("Name", true),
                        'scheduled_date'          =>$this->input->post("scheduled_date", true),
                        'scheduled_time'          =>$time_now,
                        'double_status'         => $this->input->post("typestatus", true),
                        'first_groupname_1'      => $this->input->post("txtg11", true), 
                        'first_groupname_2'       => $this->input->post("txtg12", true),
                        'second_groupname_1'      => $this->input->post("txtg21", true), 
                        'second_groupname_2'       => $this->input->post("txtg22", true),
                        'third_groupname_1'      => $this->input->post("txtg31", true), 
                        'third_groupname_2'       => $this->input->post("txtg32", true),
                        'fourth_groupname_1'      => $this->input->post("txtg41", true), 
                        'fourth_groupname_2'       => $this->input->post("txtg42", true),
                        'fifth_groupname_1'      => $this->input->post("txtg51", true), 
                        'fifth_groupname_2'       => $this->input->post("txtg52", true),
                        'sixth_groupname_1'      => $this->input->post("txtg61", true), 
                        'sixth_groupname_2'       => $this->input->post("txtg62", true),
                        'sync_calendar'   => $this->input->post("sync_calendar", true),
                        'color'   => $this->input->post("color", true),
                        'hr'                      =>$time1,
                        'min'                      =>$time2,
                        'recurring_day' => $day_number,
                        'recurring_start_date' => $Start_daterange,
                        'recurring_end_date' => $End_daterange,
                        'update_status'   =>1,
                        'last_updated_time'         =>date('Y-m-d h:i:s')
                        
                         
                        
                       );
         
if (!empty($_FILES['imgg11'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg11']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg11');
                                if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g11'] = $upload_status['file_name'];
                        }}
                            }
                        
                        
                         if (!empty($_FILES['imgg12'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg12']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg12');
                                 if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g12'] = $upload_status['file_name'];
                        }
                            }
                        } 
                       


                         if (!empty($_FILES['imgg21'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg21']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg21');
                                if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g21'] = $upload_status['file_name'];
                        }
                            }
                        } 
                        
                         if (!empty($_FILES['imgg22'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg22']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg22');
                                 if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g22'] = $upload_status['file_name'];
                        }
                            }
                        } 
                       
                        


                         if (!empty($_FILES['imgg31'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg31']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg31');
                                if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g31'] = $upload_status['file_name'];
                        }
                            }
                        } 
                        
                         if (!empty($_FILES['imgg32'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg32']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg32');
                                 if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g32'] = $upload_status['file_name'];
                        }
                            }
                        } 
                       


                         if (!empty($_FILES['imgg41'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg41']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg41');
                                if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g41'] = $upload_status['file_name'];
                        }
                            }
                        } 
                        
                         if (!empty($_FILES['imgg42'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg42']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg42');
                                if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g42'] = $upload_status['file_name'];
                        }
                            }
                        } 
                        

                        if (!empty($_FILES['imgg51'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg51']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg51');
                                 if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g51'] = $upload_status['file_name'];
                        }
                            }
                        } 
                       
                         if (!empty($_FILES['imgg52'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg52']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg52');
                                 if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g52'] = $upload_status['file_name'];
                        }
                            }
                        } 
                       


                        if (!empty($_FILES['imgg61'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg61']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg61');
                                if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g61'] = $upload_status['file_name'];
                        }
                            }
                        } 
                        
                         if (!empty($_FILES['imgg62'])) {
                            $this->load->helper('image_helper');
                            if ($_FILES['imgg62']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg62');
                                 if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g62'] = $upload_status['file_name'];
                        }
                            }
                        } 
                       
                        $data_double = array(
                        'lane_name'               =>$this->input->post("Name", true)
                       );
               $data_double_where = array(
                        'dlane_id'               =>$this->input->post("double_6laneid", true)
                       );
               
                     if($this->input->post("status", true) ==1){
                        $data_update=array(
                            'status' => 0
                            );
                        $this->db->where('user_id',$userid);
                         $this->db->update('six_lane', $data_update);
                      }   
                        
                      $sts = $this->db->update('six_lane', $data, $where);
                      
                        $stss = $this->db->update('six_lane_double', $data_double, $data_double_where);
                       if($sts){
                        $first_groupname_1      = $this->input->post("txtg11", true); 
                     
                       
                          sf('success_message', "Game updated.");
                       }else{
                          sf('error_message', 'Error! There is an issue with update. Please try again later.');
                       }
                       redirect('admin/six_lane/edit_sixlane/?cid='.$id);
               
    }
    
    
    
    $this->gen_contents['sixlane'] = $this->common_model->get_data('six_lane', '*', $where);

    $this->gen_contents['sixlane'] = @$this->gen_contents['sixlane'][0];
       // echo $this->gen_contents['package'];
        //die("test");
    //p($this->gen_contents['sixlane']); die('test');
     $lane_name = @$this->gen_contents['sixlane']['lane_name'];
   // die("cfdadf");
    $where_lane = array(
                    'user_id' => $userid,
                    'lane_name'  => $lane_name
        );
        $this->gen_contents['dsixlane'] = $this->common_model->get_data('six_lane_double', '*', $where_lane);
    
    if(empty($this->gen_contents['sixlane'])){
      sf('error_message', 'Error! Please ensure that you have enough permission to edit such information.');
      redirect('admin/dashboard');
    }
    $this->gen_contents['script_load_page'] = 'users';
        $this->gen_contents['js_files'] = array('global/plugins/datatables/media/js/jquery.dataTables.min.js', 
        'global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js',
        'global/plugins/jquery-validation/js/jquery.validate.min.js', 'global/scripts/datatable.js',
    'global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js',
        'admin/layout/scripts/six_lane.js');
        $this->template->set_template('admin');
        
    $lnk = 'Manage six lane/six lane';
    $lbl = 'Edit six lane';
    $this->gen_contents['active_main_menu'] = array('Manage six lane', 'customers');
    
        $this->gen_contents['page_heading'] = 'Manage Ice Sheet';
        $this->gen_contents['sales_type'] = '2';
        $this->gen_contents['js_script_initial'] = "six.init();";
        $this->template->write_view('content', 'admin/six_lane/edit_six_lane', $this->gen_contents);
        $this->template->render();
    
   }
   function add_recurring_schedule($PostData,$lane_id,$lan_details_color){
            $day_number = $this->input->post('week_day');
           $date_range = $this->input->post('recurring_daterange');
           $explode_daterange = explode(" - ",$date_range);
           $Start_daterange=  date('Y-m-d',strtotime($explode_daterange[0]));
           $End_daterange=  date('Y-m-d',strtotime($explode_daterange[1]));
           $All_schedule_days = $this->getDateForSpecificDayBetweenDates($Start_daterange,$End_daterange,$day_number);
             
           
           
           //
        if(!empty($All_schedule_days)){
        foreach($All_schedule_days as $eachday){
        $time = $this->input->post('scheduled_time');
        $times = strtotime($this->input->post("scheduled_time", true));
        $time1= date("H",$times);
        $time2= date("i",$times);
        $name = strtoupper($this->input->post('Name'));
        $start = $eachday;
        $end = $eachday; 
        $where=array(
                'recurring_master_id' => $lane_id,
            'scheduled_date' => $eachday
        );
        
     $schedule_details = $this->common_model->get_data('six_lane', '*', $where);
     if(empty($schedule_details)){
        $user_id= s('ADMIN_USERID');
        $package = s('package');
        $color = $lan_details_color;
        if($color == ""){
            $color="#003366";
        }
        
        if(($package == "1") || ($package == "3") || ($package == "5") || ($package == "7")){
           $older_lane_details =$this->common_model->select_fourlane_olderlane_details_by_userid($user_id);
        }elseif(($package == "9") || ($package == "10") || ($package == "11") || ($package == "12")){
            $older_lane_details =$this->common_model->select_eightlane_olderlane_details_by_userid($user_id);
        }else{
            $older_lane_details =$this->common_model->select_sixlane_olderlane_details_by_userid($user_id);
        }
        $older_lane_details = $older_lane_details[0];
        $img_g11 = "";
        $img_g12 = "";
        $img_g21 = "";
        $img_g22 = "";
        $img_g31 = "";
        $img_g32 = "";
        $img_g41 = "";
        $img_g42 = "";
        $img_g51 = "";
        $img_g52 = "";
        $img_g61 = "";
        $img_g62 = "";
        $img_g71 = "";
        $img_g72 = "";
        $img_g81 = "";
        $img_g82 = "";
        $img_g1_large = "";
        $img_g2_large = "";
        $img_g3_large = "";
        $img_g4_large = "";
        $img_g5_large = "";
        $img_g6_large = "";
        $img_g7_large = "";
        $img_g8_large = "";
        if(!empty($older_lane_details)){
            $img_g11 = $older_lane_details['img_g11'];
            $img_g12 = $older_lane_details['img_g12'];
            $img_g21 = $older_lane_details['img_g21'];
            $img_g22 = $older_lane_details['img_g22'];
            $img_g31 = $older_lane_details['img_g31'];
            $img_g32 = $older_lane_details['img_g32'];
            $img_g41 = $older_lane_details['img_g41'];
            $img_g42 = $older_lane_details['img_g42'];
            $img_g51 = $older_lane_details['img_g51'];
            $img_g52 = $older_lane_details['img_g52'];
            $img_g61 = $older_lane_details['img_g61'];
            $img_g62 = $older_lane_details['img_g62'];
            $img_g71 = $older_lane_details['img_g71'];
            $img_g72 = $older_lane_details['img_g72'];
            $img_g81 = $older_lane_details['img_g81'];
            $img_g82 = $older_lane_details['img_g82'];
            $img_g1_large = $older_lane_details['img_g1_large'];
            $img_g2_large = $older_lane_details['img_g2_large'];
            $img_g3_large = $older_lane_details['img_g3_large'];
            $img_g4_large = $older_lane_details['img_g4_large'];
            $img_g5_large = $older_lane_details['img_g5_large'];
            $img_g6_large = $older_lane_details['img_g6_large'];
            $img_g7_large = $older_lane_details['img_g7_large'];
            $img_g8_large = $older_lane_details['img_g8_large'];
            
        }
         if(($package == "1") || ($package == "3") || ($package == "5") || ($package == "7")){
           $db_data = array(
                'lane_name' => $name,
                'user_id'  => $user_id,
        	'scheduled_date' => $start,
                'scheduled_time' => $time,
                'img_g11' => $img_g11,
                'img_g12' => $img_g12,
                'img_g21' => $img_g21,
                'img_g22' => $img_g22,
                'img_g31' => $img_g31,
                'img_g32' => $img_g32,
                'img_g41' => $img_g41,
                'img_g42' => $img_g42,
                'img_g1_large' => $img_g1_large,
                'img_g2_large' => $img_g2_large,
                'img_g3_large' => $img_g3_large,
                'img_g4_large' => $img_g4_large,
               'recurring_master_id' => $lane_id,
                'hr' => $time1,
                'min' => $time2,
                'color' => $color
           );
        }elseif(($package == "9") || ($package == "10") || ($package == "11") || ($package == "12")){
             $db_data = array(
                'lane_name' => $name,
                'user_id'  => $user_id,
        	'scheduled_date' => $start,
                'scheduled_time' => $time,
                'img_g11' => $img_g11,
                'img_g12' => $img_g12,
                'img_g21' => $img_g21,
                'img_g22' => $img_g22,
                'img_g31' => $img_g31,
                'img_g32' => $img_g32,
                'img_g41' => $img_g41,
                'img_g42' => $img_g42,
                'img_g51' => $img_g51,
                'img_g52' => $img_g52,
                'img_g61' => $img_g61,
                'img_g62' => $img_g62,
                'img_g71' => $img_g71,
                'img_g72' => $img_g72,
                'img_g81' => $img_g81,
                'img_g82' => $img_g82,
                'img_g1_large' => $img_g1_large,
                'img_g2_large' => $img_g2_large,
                'img_g3_large' => $img_g3_large,
                'img_g4_large' => $img_g4_large,
                'img_g5_large' => $img_g5_large,
                'img_g6_large' => $img_g6_large,
                 'img_g7_large' => $img_g7_large,
                 'img_g8_large' => $img_g8_large,
                 'recurring_master_id' => $lane_id,
                'hr' => $time1,
                'min' => $time2,
                'color' => $color
           );
        }else{
            $db_data = array(
                'lane_name' => $name,
                'user_id'  => $user_id,
        	'scheduled_date' => $start,
                'scheduled_time' => $time,
                'img_g11' => $img_g11,
                'img_g12' => $img_g12,
                'img_g21' => $img_g21,
                'img_g22' => $img_g22,
                'img_g31' => $img_g31,
                'img_g32' => $img_g32,
                'img_g41' => $img_g41,
                'img_g42' => $img_g42,
                'img_g51' => $img_g51,
                'img_g52' => $img_g52,
                'img_g61' => $img_g61,
                'img_g62' => $img_g62,
                'img_g1_large' => $img_g1_large,
                'img_g2_large' => $img_g2_large,
                'img_g3_large' => $img_g3_large,
                'img_g4_large' => $img_g4_large,
                'img_g5_large' => $img_g5_large,
                'img_g6_large' => $img_g6_large,
                'recurring_master_id' => $lane_id,
                'hr' => $time1,
                'min' => $time2,
                'color' => $color
           );
        }
        
        $db_data_double = array(
                'lane_name' => $name,
                'user_id'  => $user_id,
                'scheduled_date' => $start,
                'scheduled_time' => $time
        	
           );
       
        if(($package == "1") || ($package == "3") || ($package == "5") || ($package == "7")){
           // $this->db->insert('four_lanes_double',$db_data_double);
           $this->db->insert('four_lanes', $db_data);
        }elseif(($package == "9") || ($package == "10") || ($package == "11") || ($package == "12")){
            $this->db->insert('eight_lane', $db_data);
        }else{
           // $this->db->insert('six_lane_double', $db_data_double);
            $this->db->insert('six_lane', $db_data);
        }
        }
        }
        }
           
        return;   
           
        }
       
        
        function getDateForSpecificDayBetweenDates($startDate,$endDate,$day_number){
        $startDate = date('Y-m-d', strtotime($startDate . ' +1 day'));
        $endDate = strtotime($endDate);
        $days=array('1'=>'Monday','2' => 'Tuesday','3' => 'Wednesday','4'=>'Thursday','5' =>'Friday','6' => 'Saturday','7'=>'Sunday');
        for($i = strtotime($days[$day_number], strtotime($startDate)); $i <= $endDate; $i = strtotime('+1 week', $i))
        $date_array[]=date('Y-m-d',$i);

        return $date_array;
         }
   
function edit_sixlane_double(){
        if(!admin_has_permission(9)){
      redirect('admin/dashboard');
    }
    (!$this->authentication->check_logged_in("admin", false)) ? redirect('admin') : '';
        $id = $this->input->get('cid', true);
        
        $userid = s('ADMIN_USERID');
         
        $where_user=array(
                'id' =>$userid
        );
        
        $where_lane = array(
            'user_id' => $userid,
            'status' => 1
        );
        
        $this->gen_contents['get_user_data'] = $this->common_model->get_data('user', '*', $where_user);
        $this->gen_contents['users_normal_sixlane_data'] = $this->common_model->get_data('six_lane', '*', $where_lane); 
        
        $where = array('dlane_id' => $id);
         $type=$this->input->get('type', true);
                if($type == 'reset')
                {
                  $data = array(
               		'first_groupname_1'      => '', 
                        'first_groupname_2'      => '',
                        'second_groupname_1'     => '', 
                        'second_groupname_2'     => '',
                        'third_groupname_1'      => '', 
                        'third_groupname_2'      => '',
                        'fourth_groupname_1'     => '', 
                        'fourth_groupname_2'     => '',
                        'fifth_groupname_1'      => '', 
                        'fifth_groupname_2'       => '',
                        'sixth_groupname_1'      => '', 
                        'sixth_groupname_2'       => '',
                        'hr'                      => '',
                        'min'                      =>'',
                        'first_groupname_d1'      => '', 
                        'first_groupname_d2'       => '',
                        'second_groupname_d1'      => '', 
                        'second_groupname_d2'       => '',
                        'third_groupname_d1'      => '', 
                        'third_groupname_d2'       => '',
                        'fourth_groupname_d1'      => '', 
                        'fourth_groupname_d2'       => '',
                        'fifth_groupname_d1'      => '', 
                        'fifth_groupname_d2'       => '',
                        'sixth_groupname_d1'      => '', 
                        'sixth_groupname_d2'       => '',
                        'dhr'                      =>'',
                        'dmin'                      =>'',
                        
                       );
               
                      $sts = $this->db->update('six_lane_double', $data, $where);
                      
                       
                       if($sts){
                        $first_groupname_1      = $this->input->post("txtg11", true); 
                     
                       
                          sf('success_message', "Six double lane  has been updated.");
                       }else{
                          sf('error_message', 'Error! There is an issue with update. Please try again later.');
                       }
                       redirect('admin/six_lane/edit_sixlane_double/?cid='.$id);
                }
    
    if (!empty($_POST)) {
           
       $update_type = array(
                    'sixlane_double_status' => $this->input->post('typestatus')
                );
                $this->db->update('user', $update_type, $where_user);
        
                $data = array(
                        'lane_name'               =>$this->input->post("Name", true),
                        'first_groupname_1'      => $this->input->post("txtg11", true), 
                        'first_groupname_2'       => $this->input->post("txtg12", true),
                        'second_groupname_1'      => $this->input->post("txtg21", true), 
                        'second_groupname_2'       => $this->input->post("txtg22", true),
                        'third_groupname_1'      => $this->input->post("txtg31", true), 
                        'third_groupname_2'       => $this->input->post("txtg32", true),
                        'fourth_groupname_1'      => $this->input->post("txtg41", true), 
                        'fourth_groupname_2'       => $this->input->post("txtg42", true),
                        'fifth_groupname_1'      => $this->input->post("txtg51", true), 
                        'fifth_groupname_2'       => $this->input->post("txtg52", true),
                        'sixth_groupname_1'      => $this->input->post("txtg61", true), 
                        'sixth_groupname_2'       => $this->input->post("txtg62", true),
                        'hr'                      =>$this->input->post("time1", true),
                        'min'                      =>$this->input->post("time2", true),
                        'first_groupname_d1'      => $this->input->post("txtd11", true), 
                        'first_groupname_d2'       => $this->input->post("txtd12", true),
                        'second_groupname_d1'      => $this->input->post("txtd21", true), 
                        'second_groupname_d2'       => $this->input->post("txtd22", true),
                        'third_groupname_d1'      => $this->input->post("txtd31", true), 
                        'third_groupname_d2'       => $this->input->post("txtd32", true),
                        'fourth_groupname_d1'      => $this->input->post("txtd41", true), 
                        'fourth_groupname_d2'       => $this->input->post("txtd42", true),
                        'fifth_groupname_d1'      => $this->input->post("txtd51", true), 
                        'fifth_groupname_d2'       => $this->input->post("txtd52", true),
                        'sixth_groupname_d1'      => $this->input->post("txtd61", true), 
                        'sixth_groupname_d2'       => $this->input->post("txtd62", true),
                        'dhr'                      =>$this->input->post("dtime1", true),
                        'dmin'                      =>$this->input->post("dtime2", true)
                        
                       );

                       $data_four =  array(
               		 'lane_name'               =>$this->input->post("Name", true),
                        'scheduled_date'          =>$this->input->post("scheduled_date", true),
                           'double_status'         => $this->input->post("typestatus", true),
                        'scheduled_time'          =>$this->input->post("scheduled_time", true) 
                        );
                        $where_four =  array(
               		 'lane_id'               =>$this->input->post("normal_sixlane_id", true)
                        
                        ); 
                        
                       if($this->input->post("status", true) ==1){
                        $data_update=array(
                            'status' => 0
                            );
                        $this->db->where('user_id',$userid);
                         $this->db->update('six_lane_double', $data_update);
                      } 
                       
                      $sts = $this->db->update('six_lane_double', $data, $where);
                      $stss = $this->db->update('six_lane', $data_four, $where_four);
                       
                       if($sts){
                        $first_groupname_1      = $this->input->post("txtg11", true); 
                     
                       
                          sf('success_message', "Six double lane  has been updated.");
                       }else{
                          sf('error_message', 'Error! There is an issue with update. Please try again later.');
                       }
                       redirect('admin/six_lane/edit_sixlane_double/?cid='.$id);
               
    }
    
    
    
    $this->gen_contents['dsixlane'] = $this->common_model->get_data('six_lane_double', '*', $where);

    $this->gen_contents['dsixlane'] = @$this->gen_contents['dsixlane'][0];
    $name_lane= @$this->gen_contents['dsixlane']['lane_name'];
    $where_name = array(
            'user_id' => $userid,
            'lane_name' => $name_lane
        );
        
        $this->gen_contents['users_normal_sixlane_data'] = $this->common_model->get_data('six_lane', '*', $where_name);
    if(empty($this->gen_contents['dsixlane'])){
      sf('error_message', 'Error! Please ensure that you have enough permission to edit such information.');
      redirect('admin/dashboard');
    }
    $this->gen_contents['script_load_page'] = 'users';
        $this->gen_contents['js_files'] = array('global/plugins/datatables/media/js/jquery.dataTables.min.js', 
        'global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js',
        'global/plugins/jquery-validation/js/jquery.validate.min.js', 'global/scripts/datatable.js',
    'global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js',
        'admin/layout/scripts/six_lane.js');
        $this->template->set_template('admin');
        
    $lnk = 'Manage six double lane/six double lane';
    $lbl = 'Edit six double lane';
    $this->gen_contents['active_main_menu'] = array('Manage six double lane', 'customers');
    $logo=s('logo');
        if($logo == 1){
                $logo=1;
        }else{
            $logo=0;
        }
         $this->gen_contents['access'] = $logo;
        $this->gen_contents['page_heading'] = 'Manage Ice Sheet';
        $this->gen_contents['sales_type'] = '2';
        $this->gen_contents['js_script_initial'] = "six.init();";
        $this->template->write_view('content', 'admin/six_lane/edit_six_lane_double', $this->gen_contents);
        $this->template->render();
    
   }   
   
   
   
 function view_image(){
$this->load->helper('image_helper');

         if(!admin_has_permission(9)){
            redirect('admin/dashboard');
        }
            $user_id=s('ADMIN_USERID');

           
       (!$this->authentication->check_logged_in("admin", false)) ? redirect('admin') : '';
        $id = $this->input->get('cid', true);
       
        $where = array(
            'user_id' =>$user_id,
            );
        if (!empty($_POST)) {
       
        if (!empty($_FILES['imgg11']['name'])) {
                 if ($_FILES['imgg11']['name'] != '') {
                              $upload_status = upload_image_small('admin_profile', 'imgg11',$id);
                                
                            }
                            if (!empty($upload_status['file_name'])) {
                            $data['img_g11'] = $upload_status['file_name'];
                        }
                        }
                       if(!empty($_FILES['imgg12']['name'])){
                            
                            if ($_FILES['imgg12']['name'] != '') {
                                $upload_status = upload_image_small('admin_profile', 'imgg12',$id);
                            }
                            if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g12'] = $upload_status['file_name'];
                        }
                        } 
                        


                         if (!empty($_FILES['imgg21']['name'])) {
                            if ($_FILES['imgg21']['name'] != '') {
                                $upload_status = upload_image_small('admin_profile', 'imgg21',$id);
                            }
                             if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g21'] = $upload_status['file_name'];
                        }
                        } 
                       
                         if (!empty($_FILES['imgg22']['name'])) {
                            if ($_FILES['imgg22']['name'] != '') {
                                $upload_status = upload_image_small('admin_profile', 'imgg22',$id);
                            }
                             if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g22'] = $upload_status['file_name'];
                        }
                        } 
                       
                        


                         if (!empty($_FILES['imgg31']['name'])) {
                            if ($_FILES['imgg31']['name'] != '') {
                                $upload_status = upload_image_small('admin_profile', 'imgg31',$id);
                            }
                             if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g31'] = $upload_status['file_name'];
                        }
                        } 
                       
                         if (!empty($_FILES['imgg32']['name'])) {
                            if ($_FILES['imgg32']['name'] != '') {
                                $upload_status = upload_image_small('admin_profile', 'imgg32',$id);
                            }
                             if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g32'] = $upload_status['file_name'];
                        }
                        } 
                       


                         if (!empty($_FILES['imgg41']['name'])) {
                            if ($_FILES['imgg41']['name'] != '') {
                                $upload_status = upload_image_small('admin_profile', 'imgg41',$id);
                            }
                            if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g41'] = $upload_status['file_name'];
                        }
                        } 
                        
                         if (!empty($_FILES['imgg42']['name'])) {
                            if ($_FILES['imgg42']['name'] != '') {
                                $upload_status = upload_image_small('admin_profile', 'imgg42',$id);
                            }
                            if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g42'] = $upload_status['file_name'];
                        }
                        }
                          if (!empty($_FILES['imgg51']['name'])) {
                            if ($_FILES['imgg51']['name'] != '') {
                                $upload_status = upload_image_small('admin_profile', 'imgg51',$id);
                            }
                            if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g51'] = $upload_status['file_name'];
                        }
                        }
                          if (!empty($_FILES['imgg52']['name'])) {
                            if ($_FILES['imgg52']['name'] != '') {
                                $upload_status = upload_image_small('admin_profile', 'imgg52',$id);
                            }
                            if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g52'] = $upload_status['file_name'];
                        }
                        }
                         if (!empty($_FILES['imgg61']['name'])) {
                            if ($_FILES['imgg61']['name'] != '') {
                                $upload_status = upload_image_small('admin_profile', 'imgg61',$id);
                            }
                            if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g61'] = $upload_status['file_name'];
                        }
                        }
                          if (!empty($_FILES['imgg62']['name'])) {
                            if ($_FILES['imgg62']['name'] != '') {
                                $upload_status = upload_image_small('admin_profile', 'imgg62',$id);
                            }
                            if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('admin_user_details', 'profile_image');
                            $data['img_g62'] = $upload_status['file_name'];
                        }
                        }
                        if (!empty($_FILES['imgg1_large']['name'])) {

                            if ($_FILES['imgg1_large']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg1_large',$id);
                            }
                            if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('four_lanes', 'img_g11');
                            $data['img_g1_large'] = $upload_status['file_name'];
                        }
                        }
                        if (!empty($_FILES['imgg2_large']['name'])) {

                            if ($_FILES['imgg2_large']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg2_large',$id);
                            }
                            if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('four_lanes', 'img_g11');
                            $data['img_g2_large'] = $upload_status['file_name'];
                        }
                        } 
                        if (!empty($_FILES['imgg3_large']['name'])) {

                            if ($_FILES['imgg3_large']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg3_large',$id);
                            }
                            if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('four_lanes', 'img_g11');
                            $data['img_g3_large'] = $upload_status['file_name'];
                        }
                        }
                        if (!empty($_FILES['imgg4_large']['name'])) {

                            if ($_FILES['imgg4_large']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg4_large',$id);
                            }
                            if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('four_lanes', 'img_g11');
                            $data['img_g4_large'] = $upload_status['file_name'];
                        }
                        }
                        if (!empty($_FILES['imgg5_large']['name'])) {

                            if ($_FILES['imgg5_large']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg5_large',$id);
                            }
                            if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('four_lanes', 'img_g11');
                            $data['img_g5_large'] = $upload_status['file_name'];
                        }
                        }
                        if (!empty($_FILES['imgg6_large']['name'])) {

                            if ($_FILES['imgg6_large']['name'] != '') {
                                $upload_status = upload_image('admin_profile', 'imgg6_large',$id);
                            }
                            if (!empty($upload_status['file_name'])) {
                            // Remove the existing image if the file upload is success
                            //$old_image_name = $this->common_model->get_data('four_lanes', 'img_g11');
                            $data['img_g6_large'] = $upload_status['file_name'];
                        }
                        }
                         
                       $where_update = array(
                        'user_id' =>$user_id
                        );
                       if($data != ""){
                      $sts = $this->db->update('six_lane', $data, $where_update);
                       }else{
                          $sts=1; 
                       }
                       
                       if($sts){
                            sf('success_message', "Logo has been updated.");
                       }else{
                            sf('error_message', 'Error! There is an issue with update. Please try again later.');
                       }
                       redirect('admin/six_lane/view_image');
               
        }
        
        
        $this->gen_contents['sixlane'] = $this->common_model->get_data('six_lane', '*', $where);
        $this->gen_contents['sixlane'] = @$this->gen_contents['sixlane'][0];
       //echo $this->gen_contents['sixlane'];
        if(empty($this->gen_contents['sixlane'])){
            sf('error_message', 'Error! Please ensure that you have enough permission to edit such information.');
            redirect('admin/dashboard');
        }
        $this->gen_contents['script_load_page'] = 'users';
        $this->gen_contents['js_files'] = array('global/plugins/datatables/media/js/jquery.dataTables.min.js', 
        'global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js',
        'global/plugins/jquery-validation/js/jquery.validate.min.js', 'global/scripts/datatable.js',
        'global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js',
        'admin/layout/scripts/six_lane.js');
        $this->template->set_template('admin');
        
        $lnk = 'Manage Logo/Logo';
        $lbl = 'Edit lane Logo';
        $this->gen_contents['active_main_menu'] = array('Manage Four lane', 'customers');
        $logo=s('logo');
        if($logo == 1){
                $logo=1;
        }else{
            $logo=0;
        }
         $this->gen_contents['access'] = $logo;
        
        $this->gen_contents['page_heading'] = 'Logos ';
        $this->gen_contents['sales_type'] = '2';
        //$this->gen_contents['page_breadcrumb'] = array(array('link' => '#', 'label' => 'Manage Four lane'), array('link' => $lnk, 'label' => $lbl));
        $this->gen_contents['js_script_initial'] = "six_lane.init();";
        //die("test");
        $this->template->write_view('content', 'admin/six_lane/view_six_lane', $this->gen_contents);
        $this->template->render();
    
        
        
     }
      function scroll_news(){
        if(!admin_has_permission(9)){
            redirect('admin/dashboard');
        }
        $id=s('ADMIN_USERID'); 

        $where = array(
            'user_id' => $id

            );
        $scroll_id = $this->input->get('cid', true);
        $condition = array(
            'scroll_id' => $scroll_id

            );
        
        if ($_POST) {
           $data = array( 'news'      => $this->input->post("scroll", true), 
                        'status'   => 1
                       );
               
                        
                      $sts = $this->db->update('scroll_news', $data, $condition);
                      
                       
                       if($sts){
                        
                     
                       
                            sf('success_message', "Scroll News has been updated.");
                       }else{
                            sf('error_message', 'Error! There is an issue with update. Please try again later.');
                       }
                       redirect('admin/six_lane/scroll_news');
               //}else{
                 //$this->gen_contents['form_validation_error'] = validation_errors();
              // }
        }
        
        
        
        $this->gen_contents['scroll_news'] = $this->common_model->get_data('scroll_news', '*', $where);

        $this->gen_contents['scroll_news'] = @$this->gen_contents['scroll_news'][0];
       // echo $this->gen_contents['package'];
        //die("test");
        if(empty($this->gen_contents['scroll_news'])){
            sf('error_message', 'Error! Please ensure that you have enough permission to edit such information.');
            redirect('admin/dashboard');
        }
        $this->gen_contents['script_load_page'] = 'users';
       $this->gen_contents['js_files'] = array('global/plugins/datatables/media/js/jquery.dataTables.min.js', 
        'global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js',
        'global/plugins/jquery-validation/js/jquery.validate.min.js', 'global/scripts/datatable.js',
    'global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js',
        'admin/layout/scripts/six_lane.js');
        $this->template->set_template('admin');
        
    $lnk = 'Manage Scroll News/scroll news';
  
    $this->gen_contents['active_main_menu'] = array('Manage six lane', 'customers');
    $logo=s('logo');
        if($logo == 1){
                $logo=1;
        }else{
            $logo=0;
        }
         $this->gen_contents['access'] = $logo;
        $this->gen_contents['page_heading'] = 'Scroll News ';
        $this->gen_contents['sales_type'] = '2';
        $this->gen_contents['js_script_initial'] = "six.init();";
        $this->template->write_view('content', 'admin/six_lane/scroll_news', $this->gen_contents);
        $this->template->render();
        
     }

    function delete_img($id,$field,$name){
            $this->load->helper("image_helper");
            
             $image=c('file_upload_path').'admin/'.$name;
             $image1=c('file_upload_path').'admin/thumb_large_'.$name;
             $image2=c('file_upload_path').'admin/thumb_medium_'.$name;
             $image3=c('file_upload_path').'admin/thumb_thumb_'.$name;

            //die("tes");
            if(file_exists($image)){
            $delete=unlink($image);
            }
            if(file_exists($image1)){
            $delete1=unlink($image1);
            }
            if(file_exists($image2)){
            $delete2=unlink($image2);
            }
            if(file_exists($image3)){
            $delete3=unlink($image3);
            }
              $data_update=array(
                            $field => ''
                            );
                        $this->db->where('lane_id',$id);
                       $update=  $this->db->update('six_lane', $data_update);

if($update){
                        
                            sf('success_message', "Logo deleted successfully.");
                       }else{
                            sf('error_message', 'Error! There is an issue with deleting four lane logo. Please try again later.');
                       }
                   
        //         $this->gen_contents['form_validation_error'] = validation_errors();
               
        
        redirect('admin/six_lane/edit_sixlane/?cid='.$id);
        $this->gen_contents['script_load_page'] = 'users';
        $this->gen_contents['script_load_page'] = 'users';
        $this->gen_contents['js_files'] = array('global/plugins/datatables/media/js/jquery.dataTables.min.js', 
        'global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js',
        'global/plugins/jquery-validation/js/jquery.validate.min.js', 'global/scripts/datatable.js',
    'global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js',
        'admin/layout/scripts/six_lane.js');
        $this->template->set_template('admin');
        
    $lnk = 'Manage six lane/six lane';
    $lbl = 'Edit six lane';
    $this->gen_contents['active_main_menu'] = array('Manage six lane', 'customers');
    $logo=s('logo');
        if($logo == 1){
                $logo=1;
        }else{
            $logo=0;
        }
         $this->gen_contents['access'] = $logo;
        $this->gen_contents['page_heading'] = 'Manage six lane - '.$lbl;
        $this->gen_contents['sales_type'] = '2';
        $this->gen_contents['js_script_initial'] = "six.init();";
        $this->template->write_view('content', 'admin/six_lane/edit_six_lane', $this->gen_contents);
        $this->template->render();
     }
   
  function design(){
        $this->load->helper("imagedesigns_helper");
           
    if(!admin_has_permission(7)){
        
            redirect('admin/dashboard');
        }
        
        
       
    if (!empty($_POST)) {
        
        
        if (!empty($_FILES['img_design']['name'])) {

            if ($_FILES['img_design']['name'] != '') {
            $upload_status = upload_fourlane_design('admin_profile', 'img_design',$id);
        }
        if (!empty($upload_status['file_name'])) {
             $data['img_design'] = $upload_status['file_name'];
        }
        } 
        $data['name_design']= $_POST['name_design'];
        $data['lane_type']= "6";
       
       
                     
            $sts = $this->db->insert('design', $data);
            
            if($sts){
                    sf('success_message', "Design has been updated.");
                   }else{
                    sf('error_message', 'Error! There is an issue with update. Please try again later.');
                   }
                       redirect('admin/six_lane/design');
               
        }
        
        
        $this->gen_contents['packages_list'] = $this->common_model->get_data('design', '*',array('lane_type'=>6 ));
        $this->gen_contents['script_load_page'] = 'users';
        $this->gen_contents['js_files'] = array('global/plugins/datatables/media/js/jquery.dataTables.min.js', 
        'global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js',
        'global/plugins/jquery-validation/js/jquery.validate.min.js', 'global/scripts/datatable.js',
        'global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js',
        'admin/layout/scripts/six_lane.js');
        $this->template->set_template('admin');
        $lnk = 'Manage Design/Design';
        $this->gen_contents['active_main_menu'] = array('Manage Design', 'customers');
        $this->gen_contents['page_heading'] = 'Manage Design ';
        $this->gen_contents['sales_type'] = '2';
        //$this->gen_contents['js_script_initial'] = "six_lane.init();";
        $this->template->write_view('content', 'admin/six_lane/design', $this->gen_contents);
        $this->template->render();

     }
     function delete_design($id,$name){
        $this->load->helper("image_helper");
        $image=c('file_upload_path').'sixlane_design/'.$name;
        $image1=c('file_upload_path').'sixlane_design/thumb_large_'.$name;
        $image2=c('file_upload_path').'sixlane_design/thumb_medium_'.$name;
        $image3=c('file_upload_path').'sixlane_design/thumb_thumb_'.$name;

            if(file_exists($image)){
            $delete=unlink($image);
            }
            if(file_exists($image1)){
            $delete1=unlink($image1);
            }
            if(file_exists($image2)){
            $delete2=unlink($image2);
            }
            if(file_exists($image3)){
            $delete3=unlink($image3);
            }
        
        $this->db->where('design_id',$id);
        $update=  $this->db->delete('design');
$where=array(
            'design_id' => $id
        );
        $data=array(
            'design_id' => 0
        );
        $sts = $this->db->update('user', $data, $where);
    if($update){
                sf('success_message', "Design deleted successfully.");
               }else{
                sf('error_message', 'Error! There is an issue with deleting four lane design. Please try again later.');
               }
        redirect('admin/six_lane/design');
        $this->gen_contents['packages_list'] = $this->common_model->get_data('design', '*',array('lane_type'=>6 ));
        $this->gen_contents['script_load_page'] = 'users';
        $this->gen_contents['js_files'] = array('global/plugins/datatables/media/js/jquery.dataTables.min.js', 
        'global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js',
        'global/plugins/jquery-validation/js/jquery.validate.min.js', 'global/scripts/datatable.js',
        'global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js',
        'admin/layout/scripts/six_lane.js');
        $this->template->set_template('admin');
        $lnk = 'Manage Design/Design';
        $this->gen_contents['active_main_menu'] = array('Manage Design', 'customers');
        $this->gen_contents['page_heading'] = 'Manage Design ';
        $this->gen_contents['sales_type'] = '2';
        $this->gen_contents['js_script_initial'] = "six_lane.init();";
        $this->template->write_view('content', 'admin/six_lane/design', $this->gen_contents);
        $this->template->render();
     }
 


}