<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/**
 * 
 * Project		Fit Benefit
 * @package		CodeIgniter
 * @author		Saji
 * @since		Version 2.0
 * @filesource
 */
// ------------------------------------------------------------------------

class Authentication {

    var $CI = null;

    function Authentication() {
        $this->CI = & get_instance();
        clear_cache();
    }

    /**
     * Process user login 
     *
     * @param unknown_type $login
     * @return unknown
     */
    function process_user_login($login = NULL, $request = '', $set_session = true) { 
        if (!is_array($login) || 0 >= count($login)) {
            return FALSE;
        }
        $emailid = $login['email'];
        $password = $login['password'];
        $this->CI->db->select("id as USERID, fname as NAME, email AS EMAIL, active as STATUS,  profile_image");
        $this->CI->db->where('email', $emailid);
        $password = $this->CI->db->escape_like_str(sha1($password));
       
        $this->CI->db->where("password", $password);
       // $this->CI->db->where("admin != '' ", null, false);
        $select_query = $this->CI->db->get('user');
         
        if (0 < $select_query->num_rows()) {
            $row = $select_query->row();
           // p($row);exit;
            if ($row->STATUS == '1') {
 
                $this->CI->db->where('id', $row->USERID);
                $arr['last_login_date'] = date('Y-m-d H:i:s');
                $arr['rnd'] =  mt_rand(10000, 90000);
                $this->CI->db->update('user', $arr); 
                    $session_data = array(
                        'USER_EMAIL' => $row->EMAIL,
                        'USER_NAME' => $row->NAME,
                        'USER_ID' => $row->USERID,
                         'USER_STATUS' => $row->STATUS,
                        'USER_PROFILE_IMAGE' => $row->profile_image,
                        'last_activity' => time(),
                        'domain' => $row->domian,
                        'scoring_double_status' => $row->scoring_double_status,
                        'logo' => $row->logo
                    );
                    $this->CI->session->set_userdata($session_data);
                return 'success';
            }else
                return 'inactive';
        }
        return false;
    }
   
    function process_admin_login($login = NULL, $request = '', $set_session = true) {
        if (!is_array($login) || 0 >= count($login)) {
            return FALSE;
        }
        $emailid = $login['username'];
        $password = $login['password'];
        $this->CI->db->select("id as USERID, fname as NAME, active as STATUS, webmaster,logo,package,profile_image,scoring_double_status");
        $this->CI->db->where('email', $emailid);
        $password = $this->CI->db->escape_like_str(sha1($password));
       
        $this->CI->db->where("password", $password);
        $this->CI->db->where("admin > 0 ", null, false);
        $select_query = $this->CI->db->get('user');
       // echo $this->CI->db->last_query();exit;
        if (0 < $select_query->num_rows()) {
            $row = $select_query->row();
           // p($row);exit;
            if ($row->STATUS == '1') {
            	
                $this->CI->db->where('id', $row->USERID);
                $arr['last_login_date'] = date('Y-m-d H:i:s');
                $this->CI->db->update('user', $arr); 
                $session_data = array(
                   // 'ADMIN_USERNAME' => $row->USERNAME,
                    'ADMIN_NAME' => $row->NAME,
                    'ADMIN_USERID' => $row->USERID,
                    'ADMIN_TYPE' => $row->webmaster,
                    'ADMIN_STATUS' => $row->STATUS,
                    'ADMIN_PROFILE_IMAGE' => $row->profile_image,
                    'logo' => $row->logo,
                    'scoring_double_status' => $row->scoring_double_status,
                    'package' => $row->package,
                    'primary_userid' => $row->USERID,
                    'domain' => '1'
                   // 'logo' => $row->logo
                  //  'last_activity' => time()
                );
                $this->CI->session->set_userdata($session_data);
                return 'success';
            }else
                return 'inactive';
        }
        return false;
    }

    /**
     * function for logout
     *
     * @package		CodeIgniter
     * @author
     * @return unknown
     */
    function logout() {
        $session_data = array(
            'USER_EMAIL' => '',
            'USER_NAME' => '',
            'USER_ID' => '',
            'USER_TYPE' => '',
            'ADMIN_APPROVE' => '',
            'USER_STATUS' => '',
            'last_activity' => '',
            'fb_data' => null,
            'USER_PROFILE_IMAGE' => ''
        );
        unset(
                $_SESSION['USER_EMAIL'], $_SESSION['USER_PROFILE_IMAGE'], $_SESSION['USER_NAME'], $_SESSION['USER_ID'], $_SESSION['USER_TYPE'], $_SESSION['ADMIN_APPROVE'], $_SESSION['USER_STATUS'], $_SESSION['last_activity'], $_SESSION['fb_data']
        );
        $this->CI->session->unset_userdata($session_data);
        return TRUE;
    }

    /**
     * To avoid the unauthorized access
     * 
     * @package		CodeIgniter
     * @author		
     * @return unknown
     */
    function UserHasAccess($required_role, $status='', $type='') {
        return TRUE;
    }

    /**
     * To checked whether the admin is logged in or not
     *
     * @package		CodeIgniter
     * @author
     * @return unknown
     */
    function admin_logged_in() {
        
        return TRUE;
    }

    /**
     * To checked whether the user is logged in or not
     *
     * @package		CodeIgniter
     * @author
     * @return unknown
     */
    function user_logged_in() {
      
        return TRUE;
    }

    /**
     * To checked whether the user is logged in or not
     *
     * @package		CodeIgniter
     * @author
     * @return unknown
     */
    function check_user_logged_in() {
        ($this->admin_logged_in()) ? redirect('dashboard') : '';
    }

    /**
     * To checked whether the admin is logged out
     *
     * @package		CodeIgniter
     * @author
     * @return unknown
     */
    function admin_logout() {
        $session_data = array(
            'ADMIN_USERNAME' => '',
            'ADMIN_NAME' => '',
            'ADMIN_USERID' => '',
            'ADMIN_STATUS' => ''
        );
        unset(
                $_SESSION['ADMIN_USERNAME'], $_SESSION['ADMIN_NAME'], $_SESSION['ADMIN_USERID'], $_SESSION['ADMIN_STATUS']
        );
        $this->CI->session->unset_userdata($session_data);
        return TRUE;
    }

    function redirect() {
        if (s('USER_REQUEST_URI')) {
            $redirect_to = s('USER_REQUEST_URI');
            $set_session_data = array('USER_REQUEST_URI' => '');
            us($set_session_data);
            redirect($redirect_to);
        }
        else {
            redirect('dashboard');
        }
    }

    /**
     * To checked whether the user is logged out
     *
     * @package		CodeIgniter
     * @author
     * @return unknown
      'USER_EMAIL'          => $row->EMAIL,
      'USER_NAME'           => $row->NAME,
      'USER_ID'             => $row->USERID,
      'USER_TYPE'           => $row->USERTYPE,
      'ADMIN_APPROVE'       => $row->ADMINAPPROVE,
      'USER_STATUS'         => $row->STATUS,
     **/

    /**
     * To checked whether the admin/user is logged in or not
     *
     * @package		CodeIgniter
     * @author
     * @return unknown
     */
    function check_logged_in($user_type = "", $status='', $type='', $step=0, $user_step=0, $check_incomplete_step=1, $redirect=1, $popup=false) {
        switch ($user_type){
            case "normal":
                if (!$this->CI->session->userdata('USER_ID')) {
                    return FALSE;
                }
                // suppose admin has blocked the user after user logged in then
                if (!$this->Checkuserstatus($this->CI->session->userdata('USER_ID'))) {
                    $this->logout();
                    return FALSE;
                }
                if (!$this->UserHasAccess('normal', $status, $type)) {
                    return FALSE;
                }
                return TRUE;
                break;
            case "admin":
                if (!$this->CI->session->userdata('ADMIN_USERID')) {
                    return FALSE;
                }
                else {

                    if (!$this->CheckAdminStatus($this->CI->session->userdata('ADMIN_USERID'))) {
                        $this->admin_logout();
                        return FALSE;
                    }
                    return TRUE;
                }
                break;
            default:
                if ($this->CI->session->userdata('USER_ID') > 0) {
                    return TRUE;
                }
                else {
                    return FALSE;
                }
                break;
        }
    }

    /**
     * To checked whether the admin is Active/Inactive
     *
     * @package		CodeIgniter
     * @author
     * @return unknown
     */
    function CheckAdminStatus($user_id) {
        $status = 'A';
        $this->CI->db->select("active as status");
        $this->CI->db->where('active', '1');
        $this->CI->db->where('id', $user_id);
        $select_query = $this->CI->db->get('user');
        if (0 < $select_query->num_rows()) {
            $row = $select_query->row();
            $session_data['ADMIN_STATUS'] = $row->status;
            
            $permissions = $this->CI->common_model->get_data('admin_permissions', 'permission_id', array('admin_id' => $user_id));
            $session_data['ADMIN_PERMISSIONS'] = implode(',', array_column($permissions, 'permission_id'));
            $this->CI->session->set_userdata($session_data);
            return true;
        }
        else {
            return false;
        }
    }

    function admin_has_permission($permissions_id){
    	
    	if(s('ADMIN_TYPE') == 'Y') return true; // Webmaster
    	$permissions = explode(',', s('ADMIN_PERMISSIONS'));
    	
    	if(in_array($permissions_id, $permissions)){
    		return true;
    	}
    	return false;
    	
    }
    /**
     * To checked whether the user is Active/Inactive
     *
     * @package		CodeIgniter
     * @author
     * @return unknown
     */
    function Checkuserstatus($user_id) {
         $this->CI->db->select("active as status");
        $this->CI->db->where('active', '1');
        $this->CI->db->where('id', $user_id);
        $select_query = $this->CI->db->get('user');
        if (0 < $select_query->num_rows()) {
            $row = $select_query->row();
             $session_data['STATUS'] = $row->status;
            $this->CI->session->set_userdata($session_data);
            return true;
        }
        else {
            return false;
        }
    }

    function userHasPermission($role_type = '') {
        if ($role_type != s('ROLETYPE')) {
            return false;
        }
        else {
            return true;
        }
    }

}

// End of library class
// Location: system/application/libraries/authentication.php