<?php defined('BASEPATH') OR exit('No direct script access allowed');
// Usage: $this->ios->to('DEVICE_ID')->badge(3)->message('Hello world');
class Ios
{
	private $host = 'gateway.sandbox.push.apple.com';
	private $port = 2195;
	private $cert;
	
	private $device = NULL;
	private $message= NULL;
	private $badge  = NULL;
	private $sound  = 'default';
	private $bid    = '';
	private $sw     = '0';
	
	private $_CI;
	
	public function __construct()
	{
		$this->_CI =& get_instance();
		
		$this->_CI->config->load('ios', TRUE);
                
		$config = $this->_CI->config->item('ios');
		
		foreach ($config as $key => $value)
		{
			$this->$key = $value;
		}
	}
	
	public function to($device)
	{
		$this->device = $device;
		
		return $this;
	}
	
	public function message($message)
	{
		$this->message = ($message);
		//$this->message = urlencode($message);
		
		return $this;
	}
	
	public function badge($badge = 1)
	{
		$this->badge = $badge;
		
		return $this;
	}
	
	public function sound($sound = 'default')
	{
		$this->sound = $sound;
		
		return $this;
	}
        
        public function bid($bid = '')
	{
		$this->bid = $bid;
		
		return $this;
	}
        public function sw($sw = '')
	{
		$this->sw = $sw;
		
		return $this;
	}
        
	public function send()
	{
            //http://stackoverflow.com/questions/10058768/php-apple-enhanced-push-notification-read-error-response
		// Build the payload
		$payload['aps'] = array('alert' => $this->message, 'badge' => $this->badge, 'sound' => $this->sound, 'bid' => $this->bid, 'sw'=> $this->sw);
		$payload1['aps'] = array('alert' => $this->message, 'badge' => $this->badge, 'sound' => $this->sound, 'bid' => $this->bid, 'sw'=> $this->sw);
		$payload = json_encode($payload);
		
		$stream_context = stream_context_create();
		stream_context_set_option($stream_context, 'ssl', 'local_cert', $this->cert);
                if(!empty($this->passphrase)){
                    stream_context_set_option($stream_context, 'ssl', 'passphrase', $this->passphrase);
                }
		$apns = stream_socket_client('ssl://' . $this->host . ':' . $this->port, $error, $error_string, 60, STREAM_CLIENT_CONNECT | STREAM_CLIENT_PERSISTENT, $stream_context);
                if (!$apns) {
                    $rtn["code"] = "001";
                    $rtn["msg"] = "Failed to connect ".$error." ".$error_string;
                  //  p($rtn);
                    return $rtn;
                } 
                
		//$message = chr(0) . chr(0) . chr(32) . pack('H*', str_replace(' ', '', $this->device)) . chr(0) . chr(strlen($payload)) . $payload;
                // $message = chr(0) . pack('n', 32) . pack('H*', ''.$this->device.'') . pack('n', strlen($payload)) . $payload; //- See more at: http://iosapplove.com/archive/2013/01/apns-tutorial-how-to-send-pushnotifications-to-my-iphone-ipad-app-part-2/#sthash.aabD4UMX.dpuf
                $apple_identifier =  md5(uniqid(rand(), true));
                $apple_expiry = time() + (2 * 24 * 60 * 60); //Keep push alive (waiting for delivery) for 2 days
                $message = pack("C", 1) . pack("N", $apple_identifier) . pack("N", $apple_expiry) . pack("n", 32) . pack('H*', str_replace(' ', '', $this->device)) . pack("n", strlen($payload)) . $payload; //Enhanced Notification
		$result = fwrite($apns, $message, strlen($message));
               
                if (!$result) {
                    echo 'Undelivered message count: ' . @$item . '<br />';
                } else {
                    echo 'Delivered message count: ' . @$item . '<br />';
                }
                
                // p($booking_data);exit;
                $date_time = "\n".get_cur_date_time()."\n\n\n";
                $data1 = print_r($payload1, true)."\n\n";
                $path = c('file_upload_path').'paypal/response.txt';
                file_put_contents($path, $date_time.$data1, FILE_APPEND);
        
                
		@socket_close($apns);
		@fclose($apns);
		if (!$result) {
            		return false;
		}
                return $result;
	}
}
