<?php

class Common_model extends CI_Model {

    public function __construct() {
        // Call the CI_Model constructor
        parent::__construct();
    }

    function prepare_select_box_data($table, $fields, $where = array(), $insert_null = false, $order_by = '', $other_array = array()) {

        list($key, $val) = explode(',', $fields);
        $key = trim($key);
        $val = trim($val);
        $order_by = $order_by ? $order_by : $val;
        $input_array = $this->get_data($table, $fields, $where, $order_by);

        $select_box_array = array();
        $total_records = count($input_array);
        if ($insert_null) {
            $select_box_array[''] = $insert_null === true ? '' : $insert_null;
        }
        for ($i = 0; $i < $total_records; $i++) {
            $select_box_array[$input_array[$i][$key]] = $input_array[$i][$val];
        }
        if (is_array($other_array) and count($other_array) > 0) { 
            foreach ($other_array as $key => $val) {
                $select_box_array[$key] = $val;
            }
        }
        return $select_box_array;
    }

    function get_data($table, $fields = '*', $where = array(), $order_by = '', $order_by2 = '',$order_des="") {

        if ((is_array($where) && count($where) > 0) or (!is_array($where) && trim($where) != ''))
            $this->db->where($where);
        if ($order_by)
            $this->db->order_by($order_by);
        if ($order_by2)
            $this->db->order_by($order_by2);
        if ($order_des)
            $this->db->order_by($order_des,'desc');
        $this->db->select($fields);
        $query = $this->db->get($table); //echo $this->db->last_query(); exit;
        return $query->result_array();
    }
	

    function event_caledar($start=0, $limit=25, $where = array(), $like_search= array()){
    	if(!empty($where))  $this->db->where ($where);
    	if(!empty($like_search))  $this->db->like ($like_search);
    	$this->db->select('*');
    	$this->db->order_by("STR_TO_DATE(time,'%h:%i %p')");
        $query = $this->db->get('calendar');
        
        return $query->result_array();
    }
     function event_caledar_date($where){
    	$this->db->where ($where);
    	$this->db->select('*');
        $this->db->order_by("STR_TO_DATE(time,'%h:%i %p')");
        
    	$query = $this->db->get('calendar');
    	return $query->result_array();
    }
    function delete_caledar_date($where){
    	
        $this->db->where('calendar_id', $where);
        $this->db->delete('calendar'); 
    }
    function event_caledar__by_id($where){
    	
        $this->db->where('calendar_id', $where);
        $this->db->select('*'); 
        $query = $this->db->get('calendar');
    	return $query->result_array();
    }
    function get_calendar($id,$package){
        $combined_array = array();
        $this->db->where ('user_id',$id);
    	$this->db->select('*');
    	$query = $this->db->get('calendar');
        $main_array = $query->result_array();
        $master_id = $this->get_master_userid($id);
        if($master_id != 0){
            $this->db->where ('user_id',$master_id);
    	$this->db->select('*');
    	$query = $this->db->get('calendar');
        $master_array = $query->result_array();
        
         $combined_array = array_merge($main_array,$master_array);
        }else{
           $combined_array =  $main_array;
        }
        if(($package == "1") || ($package == "3") || ($package == "5")|| ($package == "7")){
            $schedules = $this->schedule_four(0,0, array('user_id' => $id, 'sync_calendar' => 1));
            if(!empty($schedules)){
                 $combined_array = array_merge($combined_array,$schedules);
            }
             if($master_id != 0){
                  $schedules_master = $this->schedule_four(0,0, array('user_id' => $master_id, 'sync_calendar' => 1));
            if(!empty($schedules)){
                 $combined_array = array_merge($combined_array,$schedules_master);
            }
             }
            
        }elseif(($package == "9") || ($package == "10") || ($package == "11") || ($package == "12")){
              $schedules = $this->schedule_eight(0,0, array('user_id' => $id, 'sync_calendar' => 1));
            if(!empty($schedules)){
                 $combined_array = array_merge($combined_array,$schedules);
            }
             if($master_id != 0){
                  $schedules_master = $this->schedule_eight(0,0, array('user_id' => $master_id, 'sync_calendar' => 1));
            if(!empty($schedules)){
                 $combined_array = array_merge($combined_array,$schedules_master);
            }
             }
        }else{
            $schedules = $this->schedule_six(0,0, array('user_id' => $id, 'sync_calendar' => 1));
            if(!empty($schedules)){
                 $combined_array = array_merge($combined_array,$schedules);
            }
             if($master_id != 0){
                  $schedules_master = $this->schedule_six(0,0, array('user_id' => $master_id, 'sync_calendar' => 1));
            if(!empty($schedules_master)){
                 $combined_array = array_merge($combined_array,$schedules_master);
            }
             } 
        }
        return $combined_array;
    }
    
    function select_fourlane($where){
        $this->db->select('*'); 
        $this->db->order_by("scheduled_time");
        $this->db->where($where);
        $query = $this->db->get('four_lanes');
    	return $query->result_array();
    }
    function select_sixlane($where){
    	$this->db->select('*');
        $this->db->order_by("scheduled_time");
        $this->db->where($where);
        $query = $this->db->get('six_lane');
    	return $query->result_array();
    }
    
    function select_eightlane($where){
    	$this->db->select('*');
        $this->db->order_by("scheduled_time");
        $this->db->where($where);
        $query = $this->db->get('eight_lane');
    	return $query->result_array();
    }
    function schedule_four($start=0, $limit=25, $where = array(), $like_search= array()){
        $this->db->select('*');
        $this->db->order_by("scheduled_time");
        if(!empty($where)){  $this->db->where ($where); }
        $query = $this->db->get('four_lanes');
        if(!empty($like_search)) {  $this->db->like ($like_search); }
        
        return $query->result_array();
    }
   function schedule_six($start=0, $limit=25, $where = array(), $like_search= array()){
        $this->db->select('*');
        $this->db->order_by("scheduled_time");
        if(!empty($where)){  $this->db->where ($where); }
        $query = $this->db->get('six_lane');
        if(!empty($like_search))  $this->db->like ($like_search);
    	return $query->result_array();
    }
     function schedule_eight($start=0, $limit=25, $where = array(), $like_search= array()){
        $this->db->select('*');
        $this->db->order_by("scheduled_time");
        if(!empty($where)){  $this->db->where ($where); }
        $query = $this->db->get('eight_lane');
        if(!empty($like_search)) {  $this->db->like ($like_search); }
        
        return $query->result_array();
    }
    function select_fourlane_olderlane_details_by_userid($id){
        $this->db->select('*');
        $this->db->where('user_id',$id);
        $this->db->order_by("lane_id","desc");
        $query = $this->db->get('four_lanes');
        return $query->result_array();
    }
    
    function select_sixlane_olderlane_details_by_userid($id){
        $this->db->select('*');
        $this->db->where('user_id',$id);
        $this->db->order_by("lane_id","desc");
        $query = $this->db->get('six_lane');
        return $query->result_array();
    }
    
    function select_eightlane_olderlane_details_by_userid($id){
        $this->db->select('*');
        $this->db->where('user_id',$id);
        $this->db->order_by("lane_id","desc");
        $query = $this->db->get('eight_lane');
        return $query->result_array();
    }
    
    
    function select_all_screens_of_masteruser($id){
        $this->db->select('id');
        $this->db->where('master_userid',$id);
        $query = $this->db->get('user');
        return $query->result_array();
    }
    
     function get_master_userid($id){
        $this->db->select('master_userid');
        $this->db->where('id',$id);
        $query = $this->db->get('user');
        $result =  $query->result_array();
        return $result[0]['master_userid'];
    }
    
}
