var Admins = function () {
    $("#datatable_ajax input").unbind( "keyup" );
    $("#datatable_ajax input").keyup( function (e) {
        if (e.keyCode == 13) {

            $('.filter-submit').trigger('click');
        }
    } );
    var initPickers = function () {
        //init date pickers
    	if( $().datepicker){
	        $('.date-picker').datepicker({
	            rtl: Metronic.isRTL(),
	            autoclose: true,
	            todayHighlight : true
	        });
    	}
    }

    var handleRecords = function () {
        //die("test");
        var grid = new Datatable();
        
        grid.init({
            src: $("#datatable_ajax"),
            onSuccess: function (grid) {
                // execute some code after table records loaded
                $('.activate_this_account').on('click', function (e) {
                    alert($(this).data('id'));
                });
            },
            onError: function (grid) {
                // execute some code on network or other general error  
            },
            onDataLoad: function(grid) {
                // execute some code on ajax data load
            },
            loadingMessage: 'Loading...',
            dataTable: { // here you can define a typical datatable settings from http://datatables.net/usage/options 

                // Uncomment below line("dom" parameter) to fix the dropdown overflow issue in the datatable cells. The default datatable layout
                // setup uses scrollable div(table-scrollable) with overflow:auto to enable vertical scroll(see: assets/global/scripts/datatable.js). 
                // So when dropdowns used the scrollable div should be removed. 
                //"dom": "<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'<'table-group-actions pull-right'>>r>t<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'>>",
                
                "bStateSave": true, // save datatable state(pagination, sort, etc) in cookie.

                "lengthMenu": [
                    [10, 20, 50, 100, 150, -1],
                    [10, 20, 50, 100, 150, "All"] // change per page values here
                ],
                "pageLength": 10, // default record count per page
                "ajax": {
                    "url": base_url+"ajax/users_list/"+$('#user_status').val() // ajax source
                },
                "order": [
                    [1, "asc"]
                ]// set first column as a default sort by asc
            }
        });

        // handle group actionsubmit button click
        grid.getTableWrapper().on('click', '.table-group-action-submit', function (e) {
            e.preventDefault();
            var action = $(".table-group-action-input", grid.getTableWrapper());
            if (action.val() != "" && grid.getSelectedRowsCount() > 0) {
                grid.setAjaxParam("customActionType", "group_action");
                grid.setAjaxParam("customActionName", action.val());
                grid.setAjaxParam("id", grid.getSelectedRows());
                grid.getDataTable().ajax.reload();
                grid.clearAjaxParams();
            } else if (action.val() == "") {
                Metronic.alert({
                    type: 'danger',
                    icon: 'warning',
                    message: 'Please select an action',
                    container: grid.getTableWrapper(),
                    place: 'prepend'
                });
            } else if (grid.getSelectedRowsCount() === 0) {
                Metronic.alert({
                    type: 'danger',
                    icon: 'warning',
                    message: 'No record selected',
                    container: grid.getTableWrapper(),
                    place: 'prepend'
                });
            }
        });
    }
    
    var cancel = function(){
        $('#btnCancel').on('click', function(){
           cancel_admin_page(); 
        });
    }
    
    // advance validation
    var handleCreateNewAdmin = function() {
    	if($().inputmask){
			$("#txtPhone").inputmask("mask", {
				"mask": "(999) 999-9999"
			}); 
		}
            var form3 = $('#frmCreateAdmin');
            var error3 = $('.alert-danger', form3);
            var success3 = $('.alert-success', form3);

            form3.validate({
                errorElement: 'span', //default input error message container
                errorClass: 'help-block help-block-error', // default input error message class
                focusInvalid: false, // do not focus the last invalid input
                ignore: "", // validate all fields including form hidden input
                rules: {
                    txtFirstName: {
                    	minlength: 2,
                        maxlength: 20,
                        required: true
                    },
                    txtLastName: {
                        minlength: 2,
                        maxlength: 20,
                        required: true
                    },
                    txtEmail: {
                        required: true,
                        email: true
                    },
                    /*
                    txtUsername: {
                        required: true,
                        minlength: 6,
                        maxlength: 12
                    }, */
                    new_password: {
                        minlength: 6,
                        maxlength: 20,
                        required: true
                    },  
                    new_password_confirm: {
                        minlength: 6,
                        maxlength: 20,
                        equalTo: "#new_password",
                        required: true
                    }
                },

                messages: { // custom messages for radio buttons and checkboxes

                },

                errorPlacement: function (error, element) { // render error placement for each input type
                   error.insertAfter(element); // for other inputs, just perform default behavior
                },

                invalidHandler: function (event, validator) { //display error alert on form submit   
                	if($().inputmask){
            			$("#txtPhone").inputmask("mask", {
            				"mask": "(999) 999-9999"
            			}); 
            		}
                    success3.hide();
                    error3.html('<button data-close="alert" class="close"></button> You have some form errors. Please check below.');
                    error3.show();
                    Metronic.scrollTo(error3, -200);
                },

                highlight: function (element) { // hightlight error inputs
                   $(element)
                        .closest('.form-group').addClass('has-error'); // set error class to the control group
                },

                unhighlight: function (element) { // revert the change done by hightlight
                    $(element)
                        .closest('.form-group').removeClass('has-error'); // set error class to the control group
                },

                success: function (label) {
                    label
                        .closest('.form-group').removeClass('has-error'); // set success class to the control group
                },

                submitHandler: function (form) {
                    success3.show();
                    error3.hide();
                    form[0].submit(); // submit the form
                }

            });

    }

    // advance validation
    var handleEditAdmin = function() {
    		if($().inputmask){
    			$("#txtPhone").inputmask("mask", {
    				"mask": "(999) 999-9999"
    			}); 
    		}
            var form3 = $('#frmEditAdmin');
            var error3 = $('.alert-danger', form3);
            var success3 = $('.alert-success', form3);

            form3.validate({
                errorElement: 'span', //default input error message container
                errorClass: 'help-block help-block-error', // default input error message class
                focusInvalid: false, // do not focus the last invalid input
                ignore: "", // validate all fields including form hidden input
                rules: {
                    txtFirstName: {
                    	minlength: 2,
                        maxlength: 20,
                        required: true
                    },
                    txtLastName: {
                        minlength: 2,
                        maxlength: 20,
                        required: true
                    },
                    txtEmail: {
                        required: true,
                        email: true
                    },/*
                    txtUsername: {
                        required: true,
                        minlength: 6,
                        maxlength: 12
                    },*/
                    new_password: {
                        minlength: 6,
                        maxlength: 20,
                        required: true
                    },  
                    new_password_confirm: {
                        minlength: 6,
                        maxlength: 20,
                        equalTo: "#new_password",
                        required: true
                    }
                },

                messages: { // custom messages for radio buttons and checkboxes

                },

                errorPlacement: function (error, element) { // render error placement for each input type
                   error.insertAfter(element); // for other inputs, just perform default behavior
                },

                invalidHandler: function (event, validator) { //display error alert on form submit   
                	if($().inputmask){
            			$("#txtPhone").inputmask("mask", {
            				"mask": "(999) 999-9999"
            			}); 
            		} 
                    success3.hide();
                    error3.html('<button data-close="alert" class="close"></button> You have some form errors. Please check below.');
                    error3.show();
                    Metronic.scrollTo(error3, -200);
                },

                highlight: function (element) { // hightlight error inputs
                   $(element)
                        .closest('.form-group').addClass('has-error'); // set error class to the control group
                },

                unhighlight: function (element) { // revert the change done by hightlight
                    $(element)
                        .closest('.form-group').removeClass('has-error'); // set error class to the control group
                },

                success: function (label) {
                    label
                        .closest('.form-group').removeClass('has-error'); // set success class to the control group
                },

                submitHandler: function (form) {
                    success3.show();
                    error3.hide();
                    form[0].submit(); // submit the form
                }

            });

    }

    // advance validation
    var handleResetPassword = function() {

            var form3 = $('#frmAdminChangePassword');
            var error3 = $('.alert-danger', form3);
            var success3 = $('.alert-success', form3);

            form3.validate({
                errorElement: 'span', //default input error message container
                errorClass: 'help-block help-block-error', // default input error message class
                focusInvalid: false, // do not focus the last invalid input
                ignore: "", // validate all fields including form hidden input
                rules: {
                    txtnew_password: {
                        minlength: 6,
                        maxlength: 20,
                        required: true
                    },  
                    txtnew_password_confirm: {
                        minlength: 6,
                        maxlength: 20,
                        equalTo: "#txtnew_password",
                        required: true
                    }
                },

                messages: { // custom messages for radio buttons and checkboxes
                   new_password_confirm:{
                       equalTo: "New Password and Re-enter password should match"
                   }
                },

                errorPlacement: function (error, element) { // render error placement for each input type
                   error.insertAfter(element); // for other inputs, just perform default behavior
                },

                invalidHandler: function (event, validator) { //display error alert on form submit   
                    success3.hide();
                    error3.html('<button data-close="alert" class="close"></button> You have some form errors. Please check below.');
                    error3.show();
                    Metronic.scrollTo(error3, -200);
                },

                highlight: function (element) { // hightlight error inputs
                   $(element)
                        .closest('.form-group').addClass('has-error'); // set error class to the control group
                },

                unhighlight: function (element) { // revert the change done by hightlight
                    $(element)
                        .closest('.form-group').removeClass('has-error'); // set error class to the control group
                },

                success: function (label) {
                    label
                        .closest('.form-group').removeClass('has-error'); // set success class to the control groerror3.show()up
                },

                submitHandler: function (form) {
                   // success3.show();
                    error3.hide();
                    //form[0].submit(); // submit the form
                    
                    $.ajax({
                        type: "POST",
                        url: base_url+'admin/user/admin_reset_password?'+randString(8),
                        data: $("#frmAdminChangePassword").serialize(),
                        dataType:"json",
                        success: function(resp){
                            if(resp.login_error){
                                window.location = base_url+'admin'
                            }else if(resp.status == 'success'){
                                success3.html('<button data-close="alert" class="close"></button> '+ resp.content);
                                success3.show();
                                error3.hide();
                                $('#txtnew_password, #txtnew_password_confirm').val('');
                            }else if(resp.status == 'error'){
                                error3.html('<button data-close="alert" class="close"></button> '+ resp.content);
                                error3.show();
                                success3.hide();
                            }
                        }
                    });
                }

            });

    }


    return {

        //main function to initiate the module
        init: function () {
        	cancel();
            initPickers();
            handleRecords();
           handleCreateNewAdmin();
           handleResetPassword();
            handleEditAdmin();
            $('.delete-this-record').live('click', function (e) {
                var u_id = $(this).data('id'); 
                var this_selecter_element = $(this); 
                var ppup_content = ppup_content = "<b>Are you sure?</b><br><br>Do you want to delete this account?";
                bootbox.confirm(ppup_content, function(result) {
                      if(result){
                       $.ajax({
                            type: "GET",
                            url: base_url+'ajax/delete_admin_account/'+u_id,
                            dataType:"json",
                            success: function(resp){
                                if(resp.status == 'login_error'){ 
                                    window.location = base_url+'admin'
                                }else if(resp.status == 'success'){
                                    $('.filter-submit').trigger('click');
                                }else if(resp.status == 'error'){
                                    alert( resp.content );
                                }
                            }
                        });
                   }
                });
            });
            
           //Reset Password of admin users
            var a_name = '';
            $('#ajax').off('shown.bs.modal').on('shown.bs.modal', function (e) {
                
             }).off('show.bs.modal').on('show.bs.modal', function (e) {
            	 
            	 $('#txtAdmId').val( $(e.relatedTarget).data('id'));
             	 a_name = $(e.relatedTarget).data('name');
                 $('.modal-title').html( 'Reset login password of administrator <b>'+a_name+'</b>');
             })
             .on('hidden.bs.modal', function () {
                 $('#txtnew_password, #txtnew_password_confirm, #txtAdmId').val('');
                 var form1 = $('#frmAdminChangePassword');
                 $('.alert-danger', form1).hide();
                 $('.alert-success', form1).hide();
                 
             });
        } 
    	
    
    };
   
    
}();



function cancel_admin_page(){
	window.location = base_url+'admin/user/admins'
}