var Sales = function () {
	
	var initPickers = function () {
        //init date pickers
    	if( $().datepicker){
	        $('.date-picker').datepicker({
	            rtl: Metronic.isRTL(),
	            autoclose: true,
	            todayHighlight : true
	        });
    	}
    }
	 var handleRecords = function () {
		 initPickers();
		 $("#datatable_ajax input").unbind( "keyup" );
		    $("#datatable_ajax input").keyup( function (e) {
		        if (e.keyCode == 13) {

		            $('.filter-submit').trigger('click');
		        }
		    } );
		    
		 
	        var grid = new Datatable();
	        
	        grid.init({
	            src: $("#datatable_ajax"),
	            onSuccess: function (grid) {
	                // execute some code after table records loaded
	                $('.activate_this_account').on('click', function (e) {
	                    alert($(this).data('id'));
	                });
	            },
	            onError: function (grid) {
	                // execute some code on network or other general error  
	            },
	            onDataLoad: function(grid) {
	                // execute some code on ajax data load
	            },
	            loadingMessage: 'Loading...',
	            dataTable: { // here you can define a typical datatable settings from http://datatables.net/usage/options 

	                // Uncomment below line("dom" parameter) to fix the dropdown overflow issue in the datatable cells. The default datatable layout
	                // setup uses scrollable div(table-scrollable) with overflow:auto to enable vertical scroll(see: assets/global/scripts/datatable.js). 
	                // So when dropdowns used the scrollable div should be removed. 
	                //"dom": "<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'<'table-group-actions pull-right'>>r>t<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'>>",
	                
	                "bStateSave": true, // save datatable state(pagination, sort, etc) in cookie.

	                "lengthMenu": [
	                    [10, 20, 50, 100, 150, -1],
	                    [10, 20, 50, 100, 150, "All"] // change per page values here
	                ],
	                "pageLength": 10, // default record count per page
	                "ajax": {
	                    "url": base_url+"admin/sales/list_customers/"+$('#txtCutomerType').val() // ajax source
	                },
	                "order": [
	                    [1, "asc"]
	                ]// set first column as a default sort by asc
	            }
	        });

	        // handle group actionsubmit button click
	        grid.getTableWrapper().on('click', '.table-group-action-submit', function (e) {
	            e.preventDefault();
	            var action = $(".table-group-action-input", grid.getTableWrapper());
	            if (action.val() != "" && grid.getSelectedRowsCount() > 0) {
	                grid.setAjaxParam("customActionType", "group_action");
	                grid.setAjaxParam("customActionName", action.val());
	                grid.setAjaxParam("id", grid.getSelectedRows());
	                grid.getDataTable().ajax.reload();
	                grid.clearAjaxParams();
	            } else if (action.val() == "") {
	                Metronic.alert({
	                    type: 'danger',
	                    icon: 'warning',
	                    message: 'Please select an action',
	                    container: grid.getTableWrapper(),
	                    place: 'prepend'
	                });
	            } else if (grid.getSelectedRowsCount() === 0) {
	                Metronic.alert({
	                    type: 'danger',
	                    icon: 'warning',
	                    message: 'No record selected',
	                    container: grid.getTableWrapper(),
	                    place: 'prepend'
	                });
	            }
	        });
	    }
	 var handleCustomerPassword = function(){
		 var form3 = $('#frmUpdateCustomerPassword');
         var error3 = $('.alert-danger', form3);
         var success3 = $('.alert-success', form3);

         form3.validate({
             errorElement: 'span', //default input error message container
             errorClass: 'help-block help-block-error', // default input error message class
             focusInvalid: false, // do not focus the last invalid input
             ignore: "", // validate all fields including form hidden input
             rules: {
            	 txtCusPassword: {
                     minlength: 6,
                     maxlength: 20,
                     required: true
                 },  
                 txtCusPasswordConfirm: {
                     minlength: 6,
                     maxlength: 20,
                     equalTo: "#txtCusPassword",
                     required: true
                 }
             },

             messages: { // custom messages for radio buttons and checkboxes

             },

             errorPlacement: function (error, element) { // render error placement for each input type
                error.insertAfter(element); // for other inputs, just perform default behavior
             },

             invalidHandler: function (event, validator) { //display error alert on form submit   
             	 
                 success3.hide();
                 error3.html('<button data-close="alert" class="close"></button> You have some form errors. Please check below.');
                 error3.show();
                 Metronic.scrollTo(error3, -200);
             },

             highlight: function (element) { // hightlight error inputs
                $(element).closest('.form-group').addClass('has-error'); // set error class to the control group
             },

             unhighlight: function (element) { // revert the change done by hightlight
                 $(element).closest('.form-group').removeClass('has-error'); // set error class to the control group
             },

             success: function (label) {
                 label.closest('.form-group').removeClass('has-error'); // set success class to the control group
             },

             submitHandler: function (form) {
                 success3.show();
                 error3.hide();

                 $.ajax({
                     type: "POST",
                     url: base_url+'ajax/update_customer_password',
                     data: $('#frmUpdateCustomerPassword').serialize(),
                     dataType:"json",
                     success: function(resp){				
                         if(resp.login_error){
                             window.location = base_url+'admin';
                         }else if(resp.status == 'success'){  
                        	 $('#txtCusPassword, #txtCusPasswordConfirm').val( '' );
                          	 alert( resp.content); 
                     	 }else if(resp.status == 'error'){
                             alert( resp.content); 
                         }
                     }
                 });
                // form[0].submit(); // submit the form
             }

         });
	 }
	 
	 var handleUpdateSalesRep = function(){
		 var form3 = $('#frmUpdateSalesRep');
         var error3 = $('.alert-danger', form3);
         var success3 = $('.alert-success', form3);

         form3.validate({
             errorElement: 'span', //default input error message container
             errorClass: 'help-block help-block-error', // default input error message class
             focusInvalid: false, // do not focus the last invalid input
             ignore: "", // validate all fields including form hidden input
             rules: {
            	 cmbCustomer: { 
            		 required: true
                 } 
             },

             messages: {  },

             errorPlacement: function (error, element) { // render error placement for each input type
                error.insertAfter(element); // for other inputs, just perform default behavior
             },

             invalidHandler: function (event, validator) { //display error alert on form submit   
             	 
                 success3.hide();
                 error3.html('<button data-close="alert" class="close"></button> You have some form errors. Please check below.');
                 error3.show();
                 Metronic.scrollTo(error3, -200);
             },

             highlight: function (element) { // hightlight error inputs
                $(element).closest('.form-group').addClass('has-error'); // set error class to the control group
             },

             unhighlight: function (element) { // revert the change done by hightlight
                 $(element).closest('.form-group').removeClass('has-error'); // set error class to the control group
             },

             success: function (label) {
                 label.closest('.form-group').removeClass('has-error'); // set success class to the control group
             },

             submitHandler: function (form) {
                 success3.show();
                 error3.hide();
                 $.ajax({
                     type: "POST",
                     url: base_url+'ajax/update_customer_sales_rep',
                     data: $('#frmUpdateSalesRep').serialize(),
                     dataType:"json",
                     success: function(resp){				
                         if(resp.login_error){
                             window.location = base_url+'admin';
                         }else if(resp.status == 'success'){  
                         	 $('#cus-cid'+resp.cid).attr('data-sales-rep', resp.rep_id); 
                         	 alert( resp.content); 
                     	 }else if(resp.status == 'error'){
                             alert( resp.content); 
                         }
                     }
                 });
                // form[0].submit(); // submit the form
             }

         });
	 }
	 
	// advance validation
	    var handleCreate = function() {
	    	if($().inputmask){
				$("#txtPhone").inputmask("mask", {
					"mask": "(999) 999-9999"
				}); 
			}
	            var form3 = $('#frmCreate');
	            var error3 = $('.alert-danger', form3);
	            var success3 = $('.alert-success', form3);

	            form3.validate({
	                errorElement: 'span', //default input error message container
	                errorClass: 'help-block help-block-error', // default input error message class
	                focusInvalid: false, // do not focus the last invalid input
	                ignore: "", // validate all fields including form hidden input
	                rules: {
	                	txtCompanyName: {
	                    	minlength: 2,
	                        maxlength: 20,
	                        required: true
	                    },
	                    txtEmail: {
	                        required: true,
	                        email: true
	                    },
	                    txtCusPassword: {
	                        minlength: 6,
	                        maxlength: 20,
	                        required: true
	                    },  
	                    txtCusPasswordConfirm: {
	                        minlength: 6,
	                        maxlength: 20,
	                        equalTo: "#txtCusPassword",
	                        required: true
	                    }
	                },

	                messages: {  },

	                errorPlacement: function (error, element) { // render error placement for each input type
	                   error.insertAfter(element); // for other inputs, just perform default behavior
	                },
                	invalidHandler: function (event, validator) { //display error alert on form submit   
	                	if($().inputmask){
	            			$("#txtPhone").inputmask("mask", {
	            				"mask": "(999) 999-9999"
	            			}); 
	            		}
	                    success3.hide();
	                    error3.html('<button data-close="alert" class="close"></button> You have some form errors. Please check below.');
	                    error3.show();
	                    Metronic.scrollTo(error3, -200);
	                },

	                highlight: function (element) { // hightlight error inputs
	                   $(element).closest('.form-group').addClass('has-error'); // set error class to the control group
	                },

	                unhighlight: function (element) { // revert the change done by hightlight
	                    $(element).closest('.form-group').removeClass('has-error'); // set error class to the control group
	                },

	                success: function (label) {
	                    label
	                        .closest('.form-group').removeClass('has-error'); // set success class to the control group
	                },

	                submitHandler: function (form) {
	                    success3.show();
	                    error3.hide();
	                    form[0].submit(); // submit the form
	                }

	            });

	    } 
	return {

        //main function to initiate the module
        init: function () { 
        	handleRecords();
        	handleCreate();
        	handleCustomerPassword();
        	handleUpdateSalesRep();
        	$('#MdlCustomerSettings').off('shown.bs.modal').on('shown.bs.modal', function (e) {
        		var dt = $(e.relatedTarget).data('cus-info');
         		$('#label_customer_info').html(dt);
        		$('#txtUpdatePasswordCid, #txtUpdateSalesRepCid').val($(e.relatedTarget).data('cid'));
        		$("#cmbCustomer option:selected").removeAttr("selected"); 
        	 	$("#cmbCustomer option[value='"+ $(e.relatedTarget).data('sales-rep') +"']").prop('selected', true);  
        	}).off('show.bs.modal').on('show.bs.modal', function (e) {
        		
        	}).on('hidden.bs.modal', function () {
        		//$('.shipping-holder-element input[type="text"]').val('');
        		//$('.billing-holder-element input[type="text"]').val('');
        		$("#cmbCustomer option:selected").removeAttr("selected"); 
        	 	//$("#cmbCustomer option[value='']").prop('selected', true); 
        		$('#label_customer_info').html('');
        		$('#txtUpdatePasswordCid, #txtUpdateSalesRepCid, #txtCusPassword, #txtCusPasswordConfirm').val( '' );
        	 });
        	
        	$('#btnCancel').on('click', function (e){
        		cancel_admin_page();
        	});
        	
        }
	}
}();



function cancel_admin_page(){
	window.location = base_url+'admin/sales/my_customers'
}

