var ContactUs = function () {
	
	var validateContactForm = function (){
 		var form3 = $('#frmContactUs');
        var error3 = $('.alert-danger', form3);
        var success3 = $('.alert-success', form3);

        form3.validate({
            errorElement: 'span', //default input error message container
            errorClass: 'help-block help-block-error', // default input error message class
            focusInvalid: false, // do not focus the last invalid input
            ignore: "", // validate all fields including form hidden input
            rules: {
            	contacts_name: { 
                    required: true
                },  
                contacts_email: {
                	required: true, 
                	email: true
                },  
                contacts_message: {
                	required: true 
                }
            },

            messages: { // custom messages for radio buttons and checkboxes

            },

            errorPlacement: function (error, element) { // render error placement for each input type
               error.insertAfter(element); // for other inputs, just perform default behavior
            },

            invalidHandler: function (event, validator) { //display error alert on form submit   
            	 
                success3.hide();
                error3.html('<button data-close="alert" class="close"></button> You have some form errors. Please check below.');
                error3.show();
               // Metronic.scrollTo(error3, -200);
            },

            highlight: function (element) { // hightlight error inputs
               $(element).closest('.form-group').addClass('has-error'); // set error class to the control group
            },

            unhighlight: function (element) { // revert the change done by hightlight
                $(element).closest('.form-group').removeClass('has-error'); // set error class to the control group
            },

            success: function (label) {
                label.closest('.form-group').removeClass('has-error'); // set success class to the control group
            },

            submitHandler: function (form) {
                success3.show();
                error3.hide(); 
                form.submit(); // submit the form
            }

        });
	}
	
    return {
        //main function to initiate the module
        init: function () {
        	validateContactForm();
			var map;
			$(document).ready(function(){
				 
			  map = new GMaps({
				div: '#map',
	            lat: 40.184725,
				lng: -111.623644,
			  });
			   var marker = map.addMarker({
		            lat: 40.184725,
					lng: -111.623644,
		            title: 'Additive, Inc.',
		            infoWindow: {
		                content: "<b>Additive, Inc.</b><br><br>1278 North 750 West,<br>Suite 300,<br> Springville,<br>UT 84663"
		            }
		        });

			   marker.infoWindow.open(map, marker); 
			});
        }
    };

}();