 
; 
var PaymentForm = function(){
	var PaymentFormValidate = function() {
      
        var form3 = $('#payform');
        var error3 = $('.alert-danger', form3);
        var success3 = $('.alert-success', form3);

        form3.validate({
            errorElement: 'span', //default input error message container
            errorClass: 'help-block help-block-error', // default input error message class
            focusInvalid: false, // do not focus the last invalid input
            ignore: "", // validate all fields including form hidden input
            rules: {
               
            	creditCardType: {
                    required: true 
                },
                cardNumber: {
                    required: true 
                },
                expiryMonth: {
                    required: true 
                },
               
                expiryYear: { 
                    required: true 
                },  
                cvCode: {
                	required: true,
                    minlength: 3,
                    maxlength: 5 
                } 
            },

            messages: { // custom messages for radio buttons and checkboxes
            	expiryMonth:{
            		required : "Please select card expiry month."
            	},
            	expiryYear:{
            		required : "Please select card expiry year."
            	}
            },
            
            errorPlacement: function (error, element) {
             	// render error placement for each input type
               // error.insertAfter(element); // for other inputs, just perform default behavior
            	if(element.closest("#cardNumber").length){ 
                    error.appendTo(element.closest('.form-group'));
                    $(element).closest('.form-group').addClass('has-error');
                }else if(element.closest("#expiryMonth").length){ 
                    error.appendTo(element.closest('.form-group'));
                    $(element).closest('.form-group').addClass('has-error');
                }else if(element.closest("#expiryYear").length){ 
                    error.appendTo(element.closest('.form-group'));
                    $(element).closest('.form-group').addClass('has-error');
                }else{    
                    // render error placement for each input type
                    error.insertAfter(element); // for other inputs, just perform default behavior
                }
                 
            },

            invalidHandler: function (event, validator) { //display error alert on form submit  
                 
                success3.hide();
                error3.html('<button data-close="alert" class="close"></button> You have some form errors. Please check below.');
                error3.show();
            },

            highlight: function (element) { // hightlight error inputs
                $(element)
                .closest('.form-group').addClass('has-error'); // set error class to the control group
            },

            unhighlight: function (element) { // revert the change done by hightlight
                $(element).closest('.form-group').removeClass('has-error'); // set error class to the control group
            },

            success: function (label) {
                label.closest('.form-group').removeClass('has-error'); // set success class to the control groerror3.show()up
            },

            submitHandler: function(form){
                success3.show();
                error3.hide();
                if(!ValidateCreditCard($('#cardNumber').val(), $('#creditCardType').val())){
                 	$('<span id="cardNumber-error" class="help-block help-block-error">Please enter valid card number.</span>').appendTo($('#cardNumber').closest('.form-group'));
                	$('#cardNumber').closest('.form-group').addClass('has-error');
                 	return false;  
                }
                //$('#btn-do-payment').hide();
                $('#btn-do-payment').button('Please wait...');
                 form.submit(); // submit the form
            } 
        }); 
    }
	 return {
        init: function () {
        	PaymentFormValidate();
        }
	 }
}();

var cards = new Array();
cards[0] = { name: "MasterCard", clength: [16], exp: /^5[1-5]/ };
cards[1] = { name: "Visa", clength: [13, 16], exp: /^4/ };
cards[2] = { name: "Amex", clength: [15], exp: /^3(4|7)/ };
cards[3] = { name: "dnr", clength: [14], exp: /^3[0,6,8]\d{12}/ };
cards[4] = { name: "Discover", clength: [16], exp: /^6011\d{4}\d{4}\d{4}/ };

function ValidateCreditCard(cardNumber, cardType) {
    var isValid = false;
    var ccCheckRegExp = /[^\d ]/;
    isValid = !ccCheckRegExp.test(cardNumber);
    if (isValid) {
    	//alert('YES'+cardNumber);
        var cardNumbersOnly = cardNumber.replace(/ /g, ""); //trim spaces
        var cardNumberLength = cardNumbersOnly.length;
        var lengthIsValid = false;
        var prefixIsValid = false;
        var prefixRegExp;
        var card = getCardType(cardType);
        if (card != null) {
            for (i = 0; i < card.clength.length; i++) {
                if (!lengthIsValid) {
                    if (cardNumberLength == card.clength[i]) lengthIsValid = true;
                }
            }
            prefixIsValid = card.exp.test(cardNumbersOnly);
        }
        isValid = prefixIsValid && lengthIsValid;
    }
    if (isValid) {
        var checkSumTotal = 0;
        checkSumTotal = computeChecksum(cardNumbersOnly);
        isValid = (checkSumTotal % 10 == 0);
    }
    /*
    if (settings.onvalidate != null)
        settings.onvalidate(isValid);
    */    
    return isValid;
}
function getCardType(type) {
    var card = null; ;
    for (i = 0; i < cards.length; i++) {
        if (cards[i].name.toLowerCase() == type.toLowerCase()) {
            card = cards[i];
            break;
        }
    }
    return card;
}
function computeChecksum(cardNo) {
    var checksum = 0;
    var factor = 1;
    var temp;
    for (i = cardNo.length - 1; i >= 0; i--) {
        temp = Number(cardNo.charAt(i)) * factor;
        if (temp > 9) {
            checksum += 1;
            temp -= 10;
        }
        checksum += temp;
        factor = (factor == 1 ? 2 : 1);
    }
    return checksum;
}